/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class ODataConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String ODATA_CLASSNAME = "class-name";
    public static final String ODATA_CONNECTION_FACTORY = "org.teiid.resource.adapter.ws.WSManagedConnectionFactory";

    @Override
    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        String security;
        String password;
        String user;
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String url = ODataConnectionInfoProvider.readEndPointProperty(props);
        if (url != null) {
            connectionProps.setProperty("connection:EndPoint", url);
        }
        if ((user = props.getProperty("AuthUserName")) != null) {
            connectionProps.setProperty("connection:AuthUserName", user);
        }
        if ((password = props.getProperty("AuthPassword")) != null) {
            connectionProps.setProperty("connection:AuthPassword", password);
        }
        if ((security = props.getProperty("SecurityType")) == null) {
            security = ICredentialsCommon.SecurityType.None.name();
        }
        connectionProps.setProperty("connection:SecurityType", security);
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "odata");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    @Override
    public String getPasswordPropertyKey() {
        return "AuthPassword";
    }

    @Override
    public String getDataSourcePasswordPropertyKey() {
        return "AuthPassword";
    }

    @Override
    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.WS);
    }

    @Override
    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        String contextFactory;
        String requestTimeout;
        String user;
        String url;
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String password = props.getProperty("AuthPassword");
        if (password != null) {
            connectionProps.setProperty("AuthPassword", password);
        }
        if ((url = ODataConnectionInfoProvider.readEndPointProperty(props)) != null) {
            connectionProps.setProperty("EndPoint", url);
        }
        if ((user = props.getProperty("AuthUserName")) != null) {
            connectionProps.setProperty("AuthUserName", user);
        }
        if ((requestTimeout = props.getProperty("RequestTimeout")) != null) {
            connectionProps.setProperty("RequestTimeout", requestTimeout);
        }
        if ((contextFactory = props.getProperty("SecurityType")) != null) {
            connectionProps.setProperty("SecurityType", contextFactory);
        } else {
            connectionProps.setProperty("SecurityType", ICredentialsCommon.SecurityType.None.name());
        }
        connectionProps.setProperty(ODATA_CLASSNAME, ODATA_CONNECTION_FACTORY);
        return connectionProps;
    }

    @Override
    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        Properties props = connectionProfile.getBaseProperties();
        String contextFactory = props.getProperty("SecurityType");
        return contextFactory != null && !contextFactory.equalsIgnoreCase(ICredentialsCommon.SecurityType.None.name());
    }
}

