/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;

public class LDAPConnection
extends JDBCConnection {
    private InitialLdapContext initCtx;

    public LDAPConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public void open() {
        if (this.mConnection != null) {
            this.close();
        }
        this.mConnection = null;
        this.mConnectException = null;
        try {
            this.initializeLDAPContext(this.getConnectionProfile().getBaseProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object createConnection(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        return this.initializeLDAPContext(props);
    }

    private InitialContext initializeLDAPContext(Properties props) throws NamingException {
        Hashtable<String, String> connenv = new Hashtable<String, String>();
        connenv.put("java.naming.factory.initial", props.getProperty("LdapContextFactory"));
        connenv.put("java.naming.provider.url", props.getProperty("LdapUrl"));
        connenv.put("java.naming.security.principal", props.getProperty("LdapAdminUserDN"));
        connenv.put("java.naming.security.credentials", props.getProperty("LdapAdminUserPassword"));
        InitialLdapContext initContext = new InitialLdapContext(connenv, null);
        return initContext;
    }

    public void close() {
        if (this.initCtx != null) {
            try {
                this.initCtx.close();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

