/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools;

import org.eclipse.datatools.connectivity.IConnectionProfile;

public class JdbcTranslatorHelper {
    public static final String VENDOR_KEY = "org.eclipse.datatools.connectivity.db.vendor";
    public static final String VERSION_KEY = "org.eclipse.datatools.connectivity.db.version";
    public static final String INFORMIX = "informix";
    public static final String SYBASE = "sybase";
    public static final String TEIID = "teiid";
    public static final String POSTGRES = "postgres";
    public static final String POSTGRESQL = "postgresql";
    public static final String ACCESS = "access";
    public static final String HIVE = "hive";
    public static final String HSQL = "hsql";
    public static final String INGRES = "ingres";
    public static final String ORACLE = "oracle";
    public static final String MONGODB = "mongodb";
    public static final String MYSQL5 = "mysql5";
    public static final String JDBC_SIMPLE = "jdbc-simple";
    public static final String JDBC_ANSI = "jdbc-ansi";
    public static final String SQLSERVER = "sqlserver";
    public static final String DB2 = "db2";
    public static final String MYSQL = "mysql";
    public static final String H2 = "h2";
    public static final String DERBY = "derby";
    public static final String MODESHAPE = "modeshape";
    public static final String FILE = "file";
    public static final String LDAP = "ldap";
    public static final String LOOPBACK = "loopback";
    public static final String SALESFORCE = "salesforce";
    public static final String TERADATA = "teradata";
    public static final String WS = "ws";

    public static String getTranslator(IConnectionProfile connectionProfile) {
        String vendor = connectionProfile.getBaseProperties().getProperty(VENDOR_KEY);
        String version = connectionProfile.getBaseProperties().getProperty(VERSION_KEY);
        if (vendor != null) {
            if (vendor.toUpperCase().startsWith(INFORMIX.toUpperCase())) {
                return INFORMIX;
            }
            if (vendor.toUpperCase().startsWith(ORACLE.toUpperCase())) {
                return ORACLE;
            }
            if (vendor.toUpperCase().startsWith("SQL SERVER".toUpperCase())) {
                return SQLSERVER;
            }
            if (vendor.toUpperCase().startsWith(DERBY.toUpperCase())) {
                return DERBY;
            }
            if (vendor.toUpperCase().startsWith(POSTGRES.toUpperCase())) {
                return POSTGRESQL;
            }
            if (vendor.toUpperCase().startsWith(SYBASE.toUpperCase())) {
                return SYBASE;
            }
            if (vendor.toUpperCase().startsWith(TEIID.toUpperCase())) {
                return TEIID;
            }
            if (vendor.toUpperCase().startsWith(DB2.toUpperCase())) {
                return DB2;
            }
            if (vendor.toUpperCase().startsWith(MODESHAPE.toUpperCase())) {
                return MODESHAPE;
            }
            if (vendor.toUpperCase().startsWith(MYSQL.toUpperCase())) {
                if (version != null && version.startsWith("5")) {
                    return MYSQL5;
                }
                return MYSQL;
            }
        }
        return JDBC_SIMPLE;
    }

    public static String getTranslatorFromDriverName(String driverClassName) {
        if (driverClassName == null) {
            return JDBC_SIMPLE;
        }
        if (driverClassName.equals("com.ingres.jdbc.IngresDriver")) {
            return INGRES;
        }
        if (driverClassName.equals("org.apache.hive.jdbc.HiveDriver") || driverClassName.equals("org.apache.hadoop.hive.jdbc.HiveDriver")) {
            return HIVE;
        }
        if (driverClassName.equals("net.sf.mongodb_jdbc_driver.MongoDbDriver")) {
            return MONGODB;
        }
        return JDBC_SIMPLE;
    }

    public static String getModelProcessorType(IConnectionProfile connectionProfile) {
        String vendor = connectionProfile.getBaseProperties().getProperty(VENDOR_KEY);
        if (vendor != null) {
            if (vendor.toUpperCase().startsWith(INFORMIX.toUpperCase())) {
                return INFORMIX;
            }
            if (vendor.toUpperCase().startsWith(ORACLE.toUpperCase())) {
                return ORACLE;
            }
            if (vendor.toUpperCase().startsWith("SQL SERVER".toUpperCase())) {
                return SQLSERVER;
            }
            if (vendor.toUpperCase().startsWith(DERBY.toUpperCase())) {
                return DERBY;
            }
            if (vendor.toUpperCase().startsWith(POSTGRES.toUpperCase())) {
                return POSTGRES;
            }
            if (vendor.toUpperCase().startsWith(SYBASE.toUpperCase())) {
                return SYBASE;
            }
            if (vendor.toUpperCase().startsWith(TEIID.toUpperCase())) {
                return TEIID;
            }
            if (vendor.toUpperCase().startsWith(DB2.toUpperCase())) {
                return DB2;
            }
            if (vendor.toUpperCase().startsWith(MYSQL.toUpperCase())) {
                return MYSQL;
            }
            if (vendor.toUpperCase().startsWith(MODESHAPE.toUpperCase())) {
                return MODESHAPE;
            }
        }
        return JDBC_SIMPLE;
    }
}

