/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAttachmentChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof ResourceAttachmentChange;
    }

    @Override
    protected void accept(Diff diff, boolean rightToLeft) {
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.addInTarget(resourceAttachmentChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.removeFromTarget(resourceAttachmentChange, rightToLeft);
                break;
            }
        }
    }

    @Override
    protected void reject(Diff diff, boolean rightToLeft) {
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.removeFromTarget(resourceAttachmentChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.addInTarget(resourceAttachmentChange, rightToLeft);
                break;
            }
        }
    }

    protected void addInTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        EObject expectedValue;
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        Resource expectedContainer = this.findOrCreateTargetResource(match, rightToLeft);
        if (expectedContainer == null) {
            diff.setState(DifferenceState.UNRESOLVED);
            return;
        }
        EObject sourceValue = rightToLeft ? match.getRight() : match.getLeft();
        if (rightToLeft) {
            if (match.getLeft() != null) {
                expectedValue = match.getLeft();
            } else {
                expectedValue = this.createCopy(sourceValue);
                match.setLeft(expectedValue);
            }
        } else if (match.getRight() != null) {
            expectedValue = match.getRight();
        } else {
            expectedValue = this.createCopy(sourceValue);
            match.setRight(expectedValue);
        }
        Resource initialResource = sourceValue.eResource();
        EList sourceList = initialResource.getContents();
        EList targetList = expectedContainer.getContents();
        int insertionIndex = this.findInsertionIndex(comparison, (List)sourceList, (List)targetList, (Object)expectedValue);
        this.addAt(targetList, expectedValue, insertionIndex);
        if (initialResource instanceof XMIResource && expectedContainer instanceof XMIResource) {
            ((XMIResource)expectedContainer).setID(expectedValue, ((XMIResource)initialResource).getID(sourceValue));
        }
    }

    protected Resource findOrCreateTargetResource(Match match, boolean rightToLeft) {
        Resource target;
        Comparison comparison = match.getComparison();
        Resource sourceRes = rightToLeft ? match.getRight().eResource() : match.getLeft().eResource();
        MatchResource soughtMatch = this.getMatchResource(comparison, sourceRes);
        if (rightToLeft && soughtMatch.getLeft() != null) {
            target = soughtMatch.getLeft();
        } else if (!rightToLeft && soughtMatch.getRight() != null) {
            target = soughtMatch.getRight();
        } else {
            URI targetURI = this.computeTargetURI(match, rightToLeft);
            if (targetURI == null) {
                throw new RuntimeException("Couldn't create a valid target resource for " + sourceRes.getURI());
            }
            EList<MatchResource> matchedResources = comparison.getMatchedResources();
            int size = matchedResources.size();
            ResourceSet targetSet = null;
            int i = 0;
            while (i < size && targetSet == null) {
                MatchResource matchRes = (MatchResource)matchedResources.get(i);
                if (rightToLeft && matchRes.getLeft() != null) {
                    targetSet = matchRes.getLeft().getResourceSet();
                } else if (!rightToLeft && matchRes.getRight() != null) {
                    targetSet = matchRes.getRight().getResourceSet();
                }
                ++i;
            }
            if (targetSet == null) {
                throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingRS", targetURI.lastSegment()));
            }
            if (targetSet.getURIConverter().exists(targetURI, Collections.emptyMap())) {
                throw new RuntimeException("The resource '" + sourceRes.getURI() + "' already exists at that location.");
            }
            target = targetSet.createResource(targetURI);
            if (rightToLeft) {
                soughtMatch.setLeft(target);
                soughtMatch.setLeftURI(target.getURI().toString());
            } else {
                soughtMatch.setRight(target);
                soughtMatch.setRightURI(target.getURI().toString());
            }
        }
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected URI computeTargetURI(Match match, boolean rightToLeft) {
        Resource currentResource;
        EObject targetObject;
        EObject sourceObject;
        if (rightToLeft) {
            sourceObject = match.getRight();
            targetObject = match.getLeft();
        } else {
            sourceObject = match.getLeft();
            targetObject = match.getRight();
        }
        if (targetObject == null) {
            EObject sourceContainer = sourceObject.eContainer();
            if (sourceContainer == null) return null;
            Match containerMatch = match.getComparison().getMatch(sourceContainer);
            currentResource = rightToLeft ? containerMatch.getLeft().eResource() : containerMatch.getRight().eResource();
        } else {
            currentResource = targetObject.eResource();
        }
        Resource sourceResource = sourceObject.eResource();
        MatchResource matchCurrent = this.getMatchResource(match.getComparison(), currentResource);
        Resource currentFromSourceSide = rightToLeft ? matchCurrent.getRight() : matchCurrent.getLeft();
        URI relativeTargetURI = sourceResource.getURI().deresolve(currentFromSourceSide.getURI());
        return relativeTargetURI.resolve(currentResource.getURI());
    }

    protected MatchResource getMatchResource(Comparison comparison, Resource resource) {
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        }
        return soughtMatch;
    }

    protected void removeFromTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        Match valueMatch = diff.getMatch();
        EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        if (expectedValue != null) {
            Resource.Internal resource = ((InternalEObject)expectedValue).eDirectResource();
            resource.getContents().remove((Object)expectedValue);
        }
    }

    protected <E> int findInsertionIndex(Comparison comparison, List<E> source, List<E> target, E newElement) {
        return DiffUtil.findInsertionIndex(comparison, source, target, newElement);
    }
}

