/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.model.impl;

import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.modelgenerator.salesforce.model.DataModel;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceField;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceObject;
import org.teiid.designer.modelgenerator.salesforce.model.impl.RelationshipImpl;
import org.teiid.designer.modelgenerator.salesforce.model.impl.SalesforceFieldImpl;

public class SalesforceObjectImpl
implements SalesforceObject {
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_SORTABLE = "sortable";
    public DataModel dataModel;
    public DescribeSObjectResult objectMetadata;
    private boolean selected;

    public void setObjectMetadata(DescribeSObjectResult objectMetadata, DataModel dataModel) {
        this.objectMetadata = objectMetadata;
        this.dataModel = dataModel;
    }

    @Override
    public boolean isQueryable() {
        return this.objectMetadata.isQueryable();
    }

    @Override
    public String getLabel() {
        return this.objectMetadata.getLabel();
    }

    @Override
    public int getFieldCount() {
        int result = 0;
        if (this.objectMetadata != null && this.objectMetadata.getFields() != null) {
            result = this.objectMetadata.getFields().size();
        }
        return result;
    }

    @Override
    public SalesforceField[] getFields() {
        SalesforceField[] result = this.objectMetadata.getFields() != null ? this.getFields(this.objectMetadata) : new SalesforceField[]{};
        return result;
    }

    private SalesforceField[] getFields(DescribeSObjectResult objectMetadata) {
        List fields = objectMetadata.getFields();
        SalesforceField[] result = new SalesforceField[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            result[i] = new SalesforceFieldImpl((Field)fields.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.objectMetadata.getName();
    }

    @Override
    public List getSelectedRelationships() {
        return this.getRelationships(false);
    }

    @Override
    public List getAllRelationships() {
        return this.getRelationships(true);
    }

    private List getRelationships(boolean includeUnselected) {
        ArrayList<RelationshipImpl> result;
        List children = this.objectMetadata.getChildRelationships();
        if (children != null && children.size() != 0) {
            result = new ArrayList();
            int i = 0;
            while (i < children.size()) {
                ChildRelationship childRelation = (ChildRelationship)children.get(i);
                String childTable = childRelation.getChildSObject();
                if (includeUnselected || this.dataModel.getSalesforceObject(childTable).isSelected()) {
                    RelationshipImpl newRelation = new RelationshipImpl();
                    newRelation.setParentTable(this.objectMetadata.getName());
                    newRelation.setChildTable(childRelation.getChildSObject());
                    newRelation.setForeignKeyField(childRelation.getField());
                    newRelation.setCascadeDelete(childRelation.isCascadeDelete());
                    result.add(newRelation);
                }
                ++i;
            }
        } else {
            result = new ArrayList<RelationshipImpl>();
        }
        return result;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean checked) {
        this.selected = checked;
        if (checked) {
            this.dataModel.incrementSelectionCount();
        } else {
            this.dataModel.decrementSelectionCount();
        }
    }

    @Override
    public boolean isCreateable() {
        return this.objectMetadata.isCreateable();
    }

    @Override
    public boolean isUpdateable() {
        return this.objectMetadata.isUpdateable();
    }

    @Override
    public boolean isDeleteable() {
        return this.objectMetadata.isDeletable();
    }

    @Override
    public boolean isSearchable() {
        return this.objectMetadata.isSearchable();
    }

    @Override
    public boolean isCustom() {
        return this.objectMetadata.isCustom();
    }

    @Override
    public boolean isMergeable() {
        return this.objectMetadata.isMergeable();
    }

    @Override
    public boolean isReplicateable() {
        return this.objectMetadata.isReplicateable();
    }

    @Override
    public boolean isRetrieveable() {
        return this.objectMetadata.isRetrieveable();
    }
}

