/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.navigator.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableView;
import org.fusesource.ide.commons.ui.views.IViewPage;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.fusesource.ide.jmx.karaf.Messages;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundleStateFacade;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesNode;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesTableView;
import org.jboss.tools.jmx.core.tree.Node;

public class BundlesTableSheetPage
extends PropertySourceTableSheetPage {
    public static final String VIEW_ID = BundlesTableSheetPage.class.getName();
    private final BundlesNode bundlesNode;
    private Action startBundleAction;
    private Action stopBundleAction;
    private Action uninstallBundleAction;
    private NotificationListener notificationListener;

    public BundlesTableSheetPage(BundlesNode bundlesNode) {
        super((Node)bundlesNode, VIEW_ID, (PropertySourceTableView)new BundlesTableView(VIEW_ID, bundlesNode));
        this.bundlesNode = bundlesNode;
        this.startBundleAction = new Action(Messages.StartBundleAction, 32){

            public void run() {
                BundlesTableSheetPage.this.startBundles();
            }
        };
        this.startBundleAction.setToolTipText(Messages.StartBundleActionToolTip);
        this.startBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("start_task.gif"));
        this.stopBundleAction = new Action(Messages.StopBundleAction, 32){

            public void run() {
                BundlesTableSheetPage.this.stopBundles();
            }
        };
        this.stopBundleAction.setToolTipText(Messages.StopBundleActionToolTip);
        this.stopBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("stop_task.gif"));
        this.uninstallBundleAction = new Action(Messages.UninstallBundleAction, 32){

            public void run() {
                BundlesTableSheetPage.this.uninstallBundles();
            }
        };
        this.uninstallBundleAction.setToolTipText(Messages.UninstallBundleActionToolTip);
        this.uninstallBundleAction.setImageDescriptor(KarafJMXPlugin.getDefault().getImageDescriptor("delete.gif"));
        this.startBundleAction.setEnabled(false);
        this.stopBundleAction.setEnabled(false);
        this.uninstallBundleAction.setEnabled(false);
        this.notificationListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                BundlesTableSheetPage.this.refresh();
            }
        };
        bundlesNode.getFacade().addBundleStateNotificationListener(this.notificationListener, null, null);
    }

    public void dispose() {
        this.bundlesNode.getFacade().removeBundleStateNotificationListener(this.notificationListener, null, null);
        super.dispose();
    }

    public BundlesNode getNode() {
        return this.bundlesNode;
    }

    public void setView(IViewPage view) {
        super.setView(view);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTableView().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HashSet<String> states = new HashSet<String>(BundlesTableSheetPage.this.getSelectedBundleIDStates().values());
                BundlesTableSheetPage.this.startBundleAction.setEnabled(!states.isEmpty() && !states.contains("ACTIVE"));
                BundlesTableSheetPage.this.stopBundleAction.setEnabled(!states.isEmpty() && states.contains("ACTIVE"));
                BundlesTableSheetPage.this.uninstallBundleAction.setEnabled(!states.isEmpty() && !states.contains("ACTIVE"));
            }
        });
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.startBundleAction);
        menu.add((IAction)this.stopBundleAction);
        menu.add((IAction)this.uninstallBundleAction);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)this.startBundleAction);
            toolBarManager.add((IAction)this.stopBundleAction);
            toolBarManager.add((IAction)this.uninstallBundleAction);
        }
    }

    protected void startBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Start bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTableSheetPage.this.getNode().getFacade().startBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void stopBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Stop bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTableSheetPage.this.getNode().getFacade().stopBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void uninstallBundles() {
        final long[] ids = this.getSelectedBundleIds();
        if (ids.length > 0) {
            String message = Objects.makeString((String)"Uninstall bundles ", (String)", ", (String)"", (long[])ids);
            this.doUpdate(message, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BundlesTableSheetPage.this.getNode().getFacade().uninstallBundles(ids);
                    return true;
                }
            });
        }
    }

    protected void doUpdate(String message, final Callable<Boolean> callable) {
        Jobs.schedule((String)message, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Boolean answer = (Boolean)callable.call();
                if (answer != null && answer.booleanValue()) {
                    BundlesTableSheetPage.this.refresh();
                }
                return answer;
            }
        });
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                Set<Long> selectedBundleIds = BundlesTableSheetPage.this.getSelectedBundleIDStates().keySet();
                BundlesTableSheetPage.this.setPropertySources(BundlesTableSheetPage.this.bundlesNode.getPropertySourceList());
                BundlesTableSheetPage.this.getTableView().refresh();
                BundlesTableSheetPage.this.setSelectedBundleIds(selectedBundleIds);
            }
        });
    }

    protected void setSelectedBundleIds(Set<Long> selectedBundleIds) {
        TableViewer viewer = this.getTableView().getViewer();
        if (viewer != null) {
            List propertySources = this.getPropertySources();
            ArrayList selected = new ArrayList();
            for (Object object : propertySources) {
                BundleStateFacade bundleState;
                Long id;
                if (!(object instanceof IPropertySource) || (id = (bundleState = new BundleStateFacade((IPropertySource)object)).getId()) == null || !selectedBundleIds.contains(id)) continue;
                selected.add(object);
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
            if (selected.size() == 1) {
                Object first = selected.get(0);
                viewer.reveal(first);
            }
        }
    }

    protected long[] getSelectedBundleIds() {
        Set<Long> ids = this.getSelectedBundleIDStates().keySet();
        long[] answer = new long[ids.size()];
        int idx = 0;
        for (Long n : ids) {
            if (n == null) continue;
            answer[idx++] = n;
        }
        return answer;
    }

    protected Map<Long, String> getSelectedBundleIDStates() {
        HashMap<Long, String> answer = new HashMap<Long, String>();
        IStructuredSelection selection = Selections.getStructuredSelection((Viewer)this.getTableView().getViewer());
        if (selection != null) {
            for (Object value : selection) {
                if (!(value instanceof IPropertySource)) continue;
                BundleStateFacade bundleState = new BundleStateFacade((IPropertySource)value);
                Long id = bundleState.getId();
                String state = bundleState.getState();
                if (id == null || state == null) continue;
                answer.put(id, state);
            }
        }
        return answer;
    }
}

