/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.dialog.FileSystemDialog;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.ListContentProvider;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class ImportVdbMainPage
extends WizardDataTransferPage
implements VdbUiConstants {
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final String I18N_PREFIX = "ImportVdbMainPage";
    private static final String SEPARATOR = ".";
    private static final String FILE_IMPORT_MASK = "*.vdb;";
    private static final String STORE_FILE_SYSTEM_SOURCE_NAMES_ID = ImportVdbMainPage.getString("storeFileSystemSourceNamesId");
    private static final String STORE_WORKSPACE_SOURCE_NAMES_ID = ImportVdbMainPage.getString("storeWorkspaceSourceNamesId");
    private static final String PAGE_TITLE = ImportVdbMainPage.getString("pageTitle");
    private static final String SOURCE_EMPTY_MESSAGE = ImportVdbMainPage.getString("sourceEmpty");
    private static final String EMPTY_FOLDER_MESSAGE = ImportVdbMainPage.getString("emptyFolderMessage");
    private static final String INITIAL_MESSAGE = ImportVdbMainPage.getString("initialMessage");
    static final IStatus STATUS_OK = new StatusInfo("org.teiid.designer.vdb.ui");
    static final IStatus STATUS_ERROR = new StatusInfo("org.teiid.designer.vdb.ui", 4, ImportVdbMainPage.getString("validationError"));
    private final String initialContainerFieldValue = this.getDefaultFolder().toString();
    Combo fileSystemSourceNameField;
    private Button fileSystemSourceBrowseButton;
    String fileSystemSourceFile;
    Combo workspaceSourceNameField;
    private Button workspaceSourceBrowseButton;
    String workspaceSourceFile;
    private Button overwriteExistingResourcesCheckbox;
    private Button importFromFileSystemCheckbox;
    private Button importFromWorkspaceCheckbox;
    private Button loadVdbIntoProjectCheckbox;
    Text containerNameField;
    private Button containerBrowseButton;
    private TableViewer projectViewer;
    private Text vdbLocationNameField;
    private Button vdbLocationBrowseButton;
    private IContainer vdbLocation;
    boolean entryChanged = false;
    private boolean initializing = false;
    private final ViewerFilter vdbFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            boolean result = false;
            if (theElement instanceof IContainer) {
                IProject project = ((IContainer)theElement).getProject();
                if (project.isOpen()) {
                    try {
                        if (project.getNature("org.teiid.designer.core.modelNature") != null) {
                            result = true;
                        }
                    }
                    catch (CoreException theException) {
                        VdbUiConstants.Util.log((Throwable)theException);
                    }
                }
            } else if (theElement instanceof IFile) {
                result = ModelUtilities.isVdbFile((IResource)((IFile)theElement));
            } else if (theElement instanceof File) {
                return ((File)theElement).isDirectory() || ((File)theElement).getName().endsWith(".vdb");
            }
            return result;
        }
    };
    private final ISelectionStatusValidator vdbValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length == 1) {
                int i = 0;
                while (i < theSelection.length) {
                    if (!(theSelection[i] instanceof IFile) || !ModelUtilities.isVdbFile((IResource)((IFile)theSelection[i]))) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo("org.teiid.designer.vdb.ui") : new StatusInfo("org.teiid.designer.vdb.ui", 4, ImportVdbMainPage.getString("noVdbSelected"));
            return result;
        }
    };
    private final ViewerFilter vdbLocationFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            boolean result = false;
            if (theElement instanceof IContainer) {
                IProject project = ((IContainer)theElement).getProject();
                if (project.isOpen()) {
                    try {
                        if (project.getNature("org.teiid.designer.core.modelNature") != null) {
                            result = true;
                        }
                    }
                    catch (CoreException theException) {
                        VdbUiConstants.Util.log((Throwable)theException);
                    }
                }
            } else if (theElement instanceof File) {
                return ((File)theElement).isDirectory();
            }
            return result;
        }
    };
    private final ISelectionStatusValidator vdbLocationValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length == 1) {
                File selectedFile;
                Object selectedElement = theSelection[0];
                if (selectedElement instanceof IContainer) {
                    valid = true;
                } else if (selectedElement instanceof File && !(selectedFile = (File)selectedElement).isDirectory()) {
                    valid = false;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo("org.teiid.designer.vdb.ui") : new StatusInfo("org.teiid.designer.vdb.ui", 4, ImportVdbMainPage.getString("noProjectOrFolderSelected"));
            return result;
        }
    };

    public static int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    static String getString(String id) {
        return VdbUiConstants.Util.getString("ImportVdbMainPage." + id, new Object[0]);
    }

    private static String getString(String id, Object object) {
        return VdbUiConstants.Util.getString("ImportVdbMainPage." + id, object);
    }

    public ImportVdbMainPage() {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializing = true;
        this.initializeDialogUnits((Control)parent);
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout());
        topComposite.setLayoutData((Object)new GridData(272));
        topComposite.setSize(topComposite.computeSize(-1, -1));
        topComposite.setFont(parent.getFont());
        this.importFromFileSystemCheckbox = new Button(topComposite, 16);
        this.importFromFileSystemCheckbox.setFont(topComposite.getFont());
        this.importFromFileSystemCheckbox.setSelection(true);
        this.importFromFileSystemCheckbox.addListener(13, (Listener)this);
        this.importFromFileSystemCheckbox.setText(ImportVdbMainPage.getString("importFromFileSystem"));
        this.createFromFileSystemGroup(topComposite);
        new Label(topComposite, 0);
        this.importFromWorkspaceCheckbox = new Button(topComposite, 16);
        this.importFromWorkspaceCheckbox.setFont(topComposite.getFont());
        this.importFromWorkspaceCheckbox.addListener(13, (Listener)this);
        this.importFromWorkspaceCheckbox.setText(ImportVdbMainPage.getString("extractFromWorkspace"));
        this.createFromWorkspaceGroup(topComposite);
        this.createProjectListGroup(topComposite);
        this.createDestinationGroup(topComposite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(true);
        this.setMessage(INITIAL_MESSAGE);
        this.setControl((Control)topComposite);
        this.initializing = false;
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(ImportVdbMainPage.getString("folderLabel"));
        resourcesLabel.setFont(parent.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(parent.getFont());
        this.containerBrowseButton = new Button(containerGroup, 8);
        this.containerBrowseButton.setText(ImportVdbMainPage.getString("browse"));
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.containerBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.containerBrowseButton);
        this.initialPopulateContainerField();
    }

    protected void createFromFileSystemGroup(Composite parent) {
        Group fromFileSystemContainerGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        fromFileSystemContainerGroup.setLayout((Layout)layout);
        fromFileSystemContainerGroup.setFont(parent.getFont());
        fromFileSystemContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label((Composite)fromFileSystemContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.fileSystemSourceNameField = new Combo((Composite)fromFileSystemContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fileSystemSourceNameField.setLayoutData((Object)data);
        this.fileSystemSourceNameField.setFont(parent.getFont());
        this.fileSystemSourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportVdbMainPage.this.fileSystemSourceFile = ImportVdbMainPage.this.fileSystemSourceNameField.getText();
                ImportVdbMainPage.this.setCompletionStatus();
            }
        });
        this.fileSystemSourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportVdbMainPage.this.entryChanged = true;
                ImportVdbMainPage.this.setCompletionStatus();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fileSystemSourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportVdbMainPage.this.entryChanged) {
                    ImportVdbMainPage.this.entryChanged = false;
                    ImportVdbMainPage.this.setCompletionStatus();
                }
            }
        });
        this.fileSystemSourceBrowseButton = new Button((Composite)fromFileSystemContainerGroup, 8);
        this.fileSystemSourceBrowseButton.setText(ImportVdbMainPage.getString("browse_3"));
        this.fileSystemSourceBrowseButton.addListener(13, (Listener)this);
        this.fileSystemSourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.fileSystemSourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.fileSystemSourceBrowseButton);
        this.createLoadVdbGroup((Composite)fromFileSystemContainerGroup);
    }

    protected void createFromWorkspaceGroup(Composite parent) {
        Group fromWorkspaceContainerGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        fromWorkspaceContainerGroup.setLayout((Layout)layout);
        fromWorkspaceContainerGroup.setFont(parent.getFont());
        fromWorkspaceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel2 = new Label((Composite)fromWorkspaceContainerGroup, 0);
        groupLabel2.setText(this.getSourceLabel());
        groupLabel2.setFont(parent.getFont());
        this.workspaceSourceNameField = new Combo((Composite)fromWorkspaceContainerGroup, 2048);
        GridData data2 = new GridData(768);
        data2.widthHint = 250;
        this.workspaceSourceNameField.setLayoutData((Object)data2);
        this.workspaceSourceNameField.setFont(parent.getFont());
        this.workspaceSourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportVdbMainPage.this.workspaceSourceFile = ImportVdbMainPage.this.workspaceSourceNameField.getText();
                ImportVdbMainPage.this.setCompletionStatus();
            }
        });
        this.workspaceSourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportVdbMainPage.this.entryChanged = true;
                ImportVdbMainPage.this.setCompletionStatus();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.workspaceSourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportVdbMainPage.this.entryChanged) {
                    ImportVdbMainPage.this.entryChanged = false;
                    ImportVdbMainPage.this.setCompletionStatus();
                }
            }
        });
        this.workspaceSourceBrowseButton = new Button((Composite)fromWorkspaceContainerGroup, 8);
        this.workspaceSourceBrowseButton.setText(ImportVdbMainPage.getString("browse_3"));
        this.workspaceSourceBrowseButton.addListener(13, (Listener)this);
        this.workspaceSourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.workspaceSourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.fileSystemSourceBrowseButton);
    }

    private void createLoadVdbGroup(Composite parent) {
        Group loadVdbGroup = new Group(parent, 0);
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        loadVdbGroup.setLayout((Layout)layout1);
        GridData gd_load_group = new GridData(768);
        gd_load_group.horizontalSpan = 3;
        loadVdbGroup.setLayoutData((Object)gd_load_group);
        loadVdbGroup.setFont(parent.getFont());
        loadVdbGroup.setText(ImportVdbMainPage.getString("optionsLabel"));
        this.loadVdbIntoProjectCheckbox = new Button((Composite)loadVdbGroup, 32);
        this.loadVdbIntoProjectCheckbox.setFont(loadVdbGroup.getFont());
        this.loadVdbIntoProjectCheckbox.setSelection(true);
        this.loadVdbIntoProjectCheckbox.addListener(13, (Listener)this);
        this.loadVdbIntoProjectCheckbox.setText(ImportVdbMainPage.getString("importVdbFromFileSystem"));
        GridData gd_load_ckbx = new GridData(768);
        gd_load_ckbx.horizontalSpan = 3;
        this.loadVdbIntoProjectCheckbox.setLayoutData((Object)gd_load_ckbx);
        Label resourcesLabel = new Label((Composite)loadVdbGroup, 0);
        resourcesLabel.setText(ImportVdbMainPage.getString("targetProjectOrFolder"));
        resourcesLabel.setFont(loadVdbGroup.getFont());
        this.vdbLocationNameField = new Text((Composite)loadVdbGroup, 2052);
        this.vdbLocationNameField.addListener(24, (Listener)this);
        GridData vdbLocData = new GridData(768);
        vdbLocData.widthHint = 250;
        this.vdbLocationNameField.setLayoutData((Object)vdbLocData);
        this.vdbLocationNameField.setFont(loadVdbGroup.getFont());
        this.vdbLocationNameField.setEditable(false);
        this.vdbLocationBrowseButton = new Button((Composite)loadVdbGroup, 8);
        this.vdbLocationBrowseButton.setText(ImportVdbMainPage.getString("browse_3"));
        this.vdbLocationBrowseButton.addListener(13, (Listener)this);
        this.vdbLocationBrowseButton.setLayoutData((Object)new GridData(256));
        this.vdbLocationBrowseButton.setFont(loadVdbGroup.getFont());
        this.setButtonLayoutData(this.vdbLocationBrowseButton);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
    }

    private void createProjectListGroup(Composite parent) {
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText(ImportVdbMainPage.getString("projectListMessage"));
        messageLabel.setFont(parent.getFont());
        Table table = new Table(parent, 2048);
        GridData data = new GridData(1808);
        int availableRows = ImportVdbMainPage.availableRows(parent);
        data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        this.projectViewer = new TableViewer(table);
        this.projectViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectReferenceLabelProvider());
        List<IProject> projects = Collections.emptyList();
        this.setViewerContents(projects);
    }

    protected boolean ensureSourceIsValid(Object specifiedFile) {
        return specifiedFile != null;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)ImportVdbMainPage.getString("importProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        this.saveWidgetValues();
        return true;
    }

    protected IPath getContainerFullPath() {
        IPath testPath = this.getResourcePath();
        return testPath;
    }

    IPath getDefaultFolder() {
        return ModelerCore.getWorkspace().getRoot().getRawLocation();
    }

    public IPath getLocationPath(String projectName) {
        return new Path(this.getResourcePath() + "\\" + projectName);
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    protected String getSourceLabel() {
        return ImportVdbMainPage.getString("fromDirectory");
    }

    protected String getSourceName() {
        if (this.importFromFileSystemCheckbox.getSelection()) {
            return this.fileSystemSourceFile;
        }
        return this.workspaceSourceFile;
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace workspace = ModelerCore.getWorkspace();
        IPath path = this.getContainerFullPath();
        if (workspace.getRoot().exists(path)) {
            return (IContainer)workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected File getSpecifiedSourceFile() {
        this.fileSystemSourceNameField.setFocus();
        return null;
    }

    protected void handleContainerBrowseButtonPressed() {
        UiBusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] selection;
                FileSystemDialog dialog = new FileSystemDialog(ImportVdbMainPage.this.containerNameField.getShell());
                dialog.setAllowMultiple(false);
                dialog.setInitialSelection((Object)ImportVdbMainPage.this.getDefaultFolder().toFile());
                dialog.setOnlyShowFolders();
                dialog.setValidator((ISelectionStatusValidator)new Validator());
                dialog.setTitle(ImportVdbMainPage.getString("dialog.targetFolder.title"));
                dialog.setMessage(ImportVdbMainPage.getString("dialog.targetFolder.msg"));
                if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
                    ImportVdbMainPage.this.containerNameField.setText(((File)selection[0]).getAbsolutePath());
                }
            }
        });
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.fileSystemSourceBrowseButton) {
                this.handleFileSystemSourceBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.workspaceSourceBrowseButton) {
                this.handleWorkspaceSourceBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.containerBrowseButton) {
                this.handleContainerBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.fileSystemSourceNameField || event.widget == this.containerNameField) {
                validate = true;
            }
            if (event.widget == this.importFromFileSystemCheckbox || event.widget == this.importFromWorkspaceCheckbox) {
                this.setOptionsWidgetsState();
                validate = true;
            }
            if (event.widget == this.loadVdbIntoProjectCheckbox) {
                this.vdbLocationBrowseButton.setEnabled(this.loadVdbIntoProjectCheckbox.getSelection());
                this.vdbLocationNameField.setEnabled(this.loadVdbIntoProjectCheckbox.getSelection());
                validate = true;
            }
            if (event.widget == this.containerBrowseButton) {
                this.handleContainerBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.vdbLocationBrowseButton) {
                this.handleVdbLocationBrowseButtonPressed();
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    protected void handleFileSystemSourceBrowseButtonPressed() {
        String selectedFile = null;
        if (this.importFromFileSystemCheckbox.getSelection()) {
            int lastSeparatorIndex;
            FileDialog dialog = new FileDialog(this.fileSystemSourceNameField.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
            String currentSourceString = this.getSourceName();
            if (currentSourceString != null && (lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator)) != -1) {
                dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            }
            selectedFile = dialog.open();
        }
        if (selectedFile != null) {
            if (!selectedFile.equals(this.getSourceName())) {
                this.fileSystemSourceNameField.setText(selectedFile);
                this.fileSystemSourceFile = selectedFile;
            }
        } else {
            this.fileSystemSourceNameField.setText(null);
            this.fileSystemSourceFile = null;
        }
    }

    protected void handleVdbLocationBrowseButtonPressed() {
        Object[] selectedFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ImportVdbMainPage.getString("vdbLocationTitle"), (String)ImportVdbMainPage.getString("vdbLocationMessage"), (boolean)true, null, (ViewerFilter)new ModelingResourceFilter(this.vdbLocationFilter), (ISelectionStatusValidator)this.vdbLocationValidator);
        if (selectedFiles != null && selectedFiles.length == 1 && selectedFiles[0] instanceof IContainer) {
            this.vdbLocation = (IContainer)selectedFiles[0];
            this.vdbLocationNameField.setText(this.vdbLocation.getFullPath().toOSString());
        }
    }

    protected void handleWorkspaceSourceBrowseButtonPressed() {
        String selectedFile = null;
        IFile selectedIFile = null;
        Object[] selectedFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ImportVdbMainPage.getString("selectVdbInWorkspaceTitle"), (String)ImportVdbMainPage.getString("selectVdbInWorkspaceMessage"), (boolean)true, null, (ViewerFilter)new ModelingResourceFilter(this.vdbFilter), (ISelectionStatusValidator)this.vdbValidator);
        if (selectedFiles != null && selectedFiles.length == 1) {
            selectedIFile = (IFile)selectedFiles[0];
            selectedFile = ((IFile)selectedFiles[0]).getFullPath().toOSString();
        }
        if (selectedIFile != null) {
            if (!selectedFile.equals(this.getSourceName())) {
                this.workspaceSourceNameField.setText(selectedFile);
                this.workspaceSourceFile = selectedIFile.getLocation().toOSString();
            }
        } else {
            this.workspaceSourceNameField.setText(null);
            this.workspaceSourceFile = null;
        }
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        }
    }

    private boolean isClosedWorkspaceModelProjectFolder(String projectName) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ModelerCore.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(projectName) && !project.isOpen()) {
                try {
                    if (DotProjectUtils.isDotProject((IResource)project, (boolean)true)) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    ModelerCore.Util.log((Throwable)ex);
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isNonWorkspaceModelProjectFolderOrDecendent(String projectName) {
        return false;
    }

    private boolean isOpenWorkspaceModelProjectFolder(String projectName) {
        Collection projects = DotProjectUtils.getOpenModelProjects();
        for (IProject project : projects) {
            if (!project.getName().equals(projectName)) continue;
            return true;
        }
        return false;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)STORE_FILE_SYSTEM_SOURCE_NAMES_ID);
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)STORE_WORKSPACE_SOURCE_NAMES_ID);
        if (settings != null) {
            String sourceName;
            String[] sourceNames = settings.getArray(STORE_FILE_SYSTEM_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            String[] stringArray = sourceNames;
            int n = sourceNames.length;
            int n2 = 0;
            while (n2 < n) {
                sourceName = stringArray[n2];
                this.fileSystemSourceNameField.add(sourceName);
                ++n2;
            }
            sourceNames = null;
            sourceNames = settings.getArray(STORE_WORKSPACE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            stringArray = sourceNames;
            n = sourceNames.length;
            n2 = 0;
            while (n2 < n) {
                sourceName = stringArray[n2];
                this.workspaceSourceNameField.add(sourceName);
                ++n2;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_FILE_SYSTEM_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceName());
            settings.put(STORE_FILE_SYSTEM_SOURCE_NAMES_ID, sourceNames);
            sourceNames = null;
            sourceNames = settings.getArray(STORE_WORKSPACE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceName());
            settings.put(STORE_WORKSPACE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    protected boolean setCompletionStatus() {
        String selectedFileString = this.getSourceName();
        if (selectedFileString != null && selectedFileString.length() > 0) {
            if (this.validateTargetFolder() && this.validateLoadVdb()) {
                this.setErrorMessage(null);
                this.setMessage(INITIAL_MESSAGE);
                this.setPageComplete(true);
                return true;
            }
        } else {
            this.validateTargetFolder();
            this.setErrorMessage(SOURCE_EMPTY_MESSAGE);
        }
        this.setPageComplete(false);
        return false;
    }

    protected void setFileSystemSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.fileSystemSourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.fileSystemSourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fileSystemSourceNameField.select(selectionIndex);
        }
    }

    private void setOptionsWidgetsState() {
        this.loadVdbIntoProjectCheckbox.setEnabled(this.importFromFileSystemCheckbox.getSelection());
        this.vdbLocationBrowseButton.setEnabled(this.importFromFileSystemCheckbox.getSelection());
        this.vdbLocationNameField.setEnabled(this.importFromFileSystemCheckbox.getSelection());
        this.workspaceSourceNameField.setEnabled(this.importFromWorkspaceCheckbox.getSelection());
        this.workspaceSourceBrowseButton.setEnabled(this.importFromWorkspaceCheckbox.getSelection());
        this.fileSystemSourceNameField.setEnabled(this.importFromFileSystemCheckbox.getSelection());
        this.fileSystemSourceBrowseButton.setEnabled(this.importFromFileSystemCheckbox.getSelection());
    }

    private void setViewerContents(List<IProject> projectList) {
        ArrayList<IProject> pList = new ArrayList<IProject>(projectList);
        this.projectViewer.setInput(pList);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileSystemSourceNameField.setFocus();
        }
    }

    protected void setWorkspaceSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.workspaceSourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.workspaceSourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.workspaceSourceNameField.select(selectionIndex);
        }
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        this.setOptionsWidgetsState();
    }

    protected boolean validateDestinationGroup() {
        return true;
    }

    private boolean validateLoadVdb() {
        if (this.importFromFileSystemCheckbox.getSelection() && this.loadVdbIntoProjectCheckbox.getSelection()) {
            this.setErrorMessage(ImportVdbMainPage.getString("noVdbLocationSelected"));
            return this.vdbLocation != null;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    private final boolean validateTargetFolder() {
        IPath containerPath = this.getContainerFullPath();
        if (containerPath == null) {
            this.setMessage(EMPTY_FOLDER_MESSAGE);
            return false;
        }
        File directory = containerPath.toFile();
        if (!directory.isDirectory()) {
            this.setMessage(null);
            this.setErrorMessage(ImportVdbMainPage.getString("folderDoesNotExist", containerPath));
            return false;
        }
        if (this.isOpenWorkspaceModelProjectFolder(directory.getName())) {
            this.setErrorMessage(ImportVdbMainPage.getString("badOpenProjectLocation"));
            return false;
        }
        if (this.isClosedWorkspaceModelProjectFolder(directory.getName())) {
            this.setErrorMessage(ImportVdbMainPage.getString("badClosedProjectLocation"));
            return false;
        }
        if (this.isNonWorkspaceModelProjectFolderOrDecendent(directory.getAbsolutePath())) {
            this.setErrorMessage(ImportVdbMainPage.getString("badNonWorkspaceProjectLocation"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    class ProjectReferenceLabelProvider
    implements ILabelProvider {
        ProjectReferenceLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            if (element instanceof IProject) {
                return UiPlugin.getDefault().getProjectImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class Validator
    implements ISelectionStatusValidator {
        Validator() {
        }

        private boolean containsProjectFile(File theFile) {
            return false;
        }

        public IStatus validate(Object[] theSelection) {
            IStatus result = STATUS_OK;
            if (theSelection.length > 0 && this.containsProjectFile((File)theSelection[0])) {
                result = STATUS_ERROR;
            }
            return result;
        }
    }
}

