/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.refactor.AbstractRefactorModelHandler;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ResourceFilter;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.editor.VdbEditor;

public class VdbUiRefactorHandler
extends AbstractRefactorModelHandler {
    public boolean preProcess(IRefactorModelHandler.RefactorType refactorType, IResource refactoredResource, IProgressMonitor monitor) {
        if (RefactorResourcesUtils.isClosedProject((IResource)refactoredResource)) {
            return true;
        }
        Collection allVdbResourcesInProject = WorkspaceResourceFinderUtil.getProjectFileResources((IProject)refactoredResource.getProject(), (ResourceFilter)WorkspaceResourceFinderUtil.VDB_RESOURCE_FILTER);
        ArrayList<IFile> targetVdbs = new ArrayList<IFile>();
        ArrayList<VdbEditor> openVdbEditors = new ArrayList<VdbEditor>();
        for (IFile theVdb : allVdbResourcesInProject) {
            if (refactoredResource instanceof IFolder) {
                IFolder folder = (IFolder)refactoredResource;
                try {
                    IResource[] members = folder.members();
                    int i = 0;
                    while (i < members.length) {
                        this.preProcess(refactorType, members[i], monitor);
                        ++i;
                    }
                    continue;
                }
                catch (CoreException ex) {
                    VdbUiConstants.Util.log((Throwable)ex);
                    return false;
                }
            }
            if (!(refactoredResource instanceof IFile)) continue;
            try {
                if (!VdbUtil.modelInVdb((IFile)theVdb, (IFile)((IFile)refactoredResource))) continue;
                targetVdbs.add(theVdb);
                VdbEditor vdbEditor = VdbUiRefactorHandler.getVdbEditorForFile((IResource)theVdb);
                if (vdbEditor == null) continue;
                openVdbEditors.add(vdbEditor);
            }
            catch (Exception ex) {
                VdbUiConstants.Util.log((Throwable)ex);
                return false;
            }
        }
        if (targetVdbs.isEmpty()) {
            return true;
        }
        for (VdbEditor editor : openVdbEditors) {
            VdbUiRefactorHandler.closeVdbEditor(editor);
        }
        return true;
    }

    public static VdbEditor getVdbEditorForFile(IResource vdb) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (vdb != null && vdb.exists() && (window = UiPlugin.getDefault().getCurrentWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && (vdb.equals((Object)((IFileEditorInput)input).getFile()) || vdb.getFullPath().equals((Object)((IFileEditorInput)input).getFile().getFullPath()))) {
                    if (!ModelUtil.isVdbArchiveFile((IResource)vdb)) break;
                    return (VdbEditor)editor;
                }
                ++i;
            }
        }
        return null;
    }

    public static void closeVdbEditor(final VdbEditor editor) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, true);
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public static void closeVdbEditor(IResource vdb) {
        VdbEditor editor = VdbUiRefactorHandler.getVdbEditorForFile(vdb);
        if (editor != null) {
            VdbUiRefactorHandler.closeVdbEditor(editor);
        }
    }
}

