/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.table.ResourceEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.VdbIndexedEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.connections.SourceHandlerExtensionManager;
import org.teiid.designer.vdb.ui.Messages;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;
import org.teiid.designer.vdb.ui.editor.VdbEditor;

public class ModelDetailsPanel {
    static final String DESCRIPTION_COLUMN_NAME = ModelDetailsPanel.i18n("descriptionColumnName");
    Text modelNameText;
    Text modelLocationText;
    StyledTextEditor modelDescriptionEditor;
    Button multiSourceCB;
    Button addColumnCB;
    Button addButton;
    Button deleteButton;
    Text columnAliasText;
    Label columnAliaslabel;
    TableViewerBuilder bindingsViewer;
    TableViewerBuilder problemsViewer;
    VdbModelEntry selectedVdbModelEntry;
    VdbEditor vdbEditor;

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    public ModelDetailsPanel(Composite parent, VdbEditor vdbEditor) {
        this.vdbEditor = vdbEditor;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Composite mainPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)1, (int)1);
        Composite headerPanel = WidgetFactory.createPanel((Composite)mainPanel, (int)0, (int)768, (int)1, (int)2);
        headerPanel.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(headerPanel, 0);
        label.setText("Name");
        this.modelNameText = new Text(headerPanel, 2060);
        this.modelNameText.setLayoutData((Object)new GridData(768));
        this.modelNameText.setBackground(headerPanel.getBackground());
        this.modelNameText.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        label = new Label(headerPanel, 0);
        label.setText("Location");
        this.modelLocationText = new Text(headerPanel, 2060);
        this.modelLocationText.setLayoutData((Object)new GridData(768));
        this.modelLocationText.setBackground(headerPanel.getBackground());
        this.modelLocationText.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)mainPanel);
        CTabItem bindingsTab = new CTabItem(tabFolder, 0);
        bindingsTab.setText(Messages.modelDetailsPanel_sourceBindingDefinition);
        bindingsTab.setToolTipText(Messages.modelDetailsPanel_sourceBindingDefinitionTooltip);
        Composite sourceBindingsGroup = new Composite((Composite)tabFolder, 0);
        sourceBindingsGroup.setLayout((Layout)new GridLayout(1, false));
        sourceBindingsGroup.setLayoutData((Object)new GridData(1808));
        bindingsTab.setControl((Control)sourceBindingsGroup);
        Composite subPanel_1 = WidgetFactory.createPanel((Composite)sourceBindingsGroup, (int)0, (int)768, (int)1, (int)4);
        subPanel_1.setLayout((Layout)new GridLayout(4, false));
        this.multiSourceCB = WidgetFactory.createButton((Composite)subPanel_1, (String)Messages.modelDetailsPanel_multiSourceLabel, (int)0, (int)1, (int)32);
        this.multiSourceCB.setToolTipText(Messages.modelDetailsPanel_multiSourceCheckBoxTooltip);
        this.multiSourceCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelDetailsPanel.this.selectedVdbModelEntry != null) {
                    ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().setIsMultiSource(ModelDetailsPanel.this.multiSourceCB.getSelection());
                }
                ModelDetailsPanel.this.refreshModelDetails();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addColumnCB = WidgetFactory.createButton((Composite)subPanel_1, (String)(String.valueOf(Messages.modelDetailsPanel_addColumnLabel) + "      "), (int)0, (int)1, (int)32);
        this.addColumnCB.setToolTipText(Messages.modelDetailsPanel_addColumnCheckBoxTooltip);
        this.addColumnCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelDetailsPanel.this.selectedVdbModelEntry != null) {
                    ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().setAddColumn(ModelDetailsPanel.this.addColumnCB.getSelection());
                }
                ModelDetailsPanel.this.refreshModelDetails();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnAliaslabel = new Label(subPanel_1, 0);
        this.columnAliaslabel.setText("Column Alias");
        this.columnAliaslabel.setToolTipText(Messages.modelDetailsPanel_columnAliaslabelTooltip);
        this.columnAliasText = new Text(subPanel_1, 2052);
        this.columnAliasText.setLayoutData((Object)new GridData(768));
        this.columnAliasText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().setColumnAlias(ModelDetailsPanel.this.columnAliasText.getText());
            }
        });
        Composite lowerPanel = WidgetFactory.createPanel((Composite)sourceBindingsGroup, (int)0, (int)1808, (int)2, (int)1);
        lowerPanel.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1842);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        lowerPanel.setLayoutData((Object)gridData);
        Composite leftToolbarPanel = WidgetFactory.createPanel((Composite)lowerPanel, (int)0, (int)1040);
        GridLayout tbGL = new GridLayout();
        tbGL.marginHeight = 0;
        tbGL.marginWidth = 0;
        tbGL.verticalSpacing = 2;
        leftToolbarPanel.setLayout((Layout)tbGL);
        this.addButton = new Button(leftToolbarPanel, 8);
        this.addButton.setText(UILabelUtil.getLabel((int)1));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(false);
        this.addButton.setToolTipText(Messages.modelDetailsPanel_addButtonTooltip);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int numSources = ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().getSources().size();
                boolean added = false;
                while (!added) {
                    String newName = "Name_" + numSources;
                    added = ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().add(newName, "JNDI_NAME", "TRANSLATOR_NAME");
                    if (added) continue;
                    ++numSources;
                }
                ModelDetailsPanel.this.refreshModelDetails();
            }
        });
        this.deleteButton = new Button(leftToolbarPanel, 8);
        this.deleteButton.setText(UILabelUtil.getLabel((int)2));
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(Messages.modelDetailsPanel_deleteButtonTooltip);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ModelDetailsPanel.this.bindingsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof VdbSource) {
                        ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().removeSource((VdbSource)obj);
                        ModelDetailsPanel.this.refreshModelDetails();
                    }
                    ++n2;
                }
            }
        });
        int tableStyle = 68356;
        this.bindingsViewer = new TableViewerBuilder(lowerPanel, tableStyle);
        TableViewerColumn column = this.bindingsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.modelDetailsPanel_sourceNameLabel) + "                      ");
        column.setEditingSupport((EditingSupport)new SourceNameTextEditingSupport((ColumnViewer)this.bindingsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new BindingDataLabelProvider(0));
        column = this.bindingsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.modelDetailsPanel_translatorNameLabel) + "            ");
        column.setEditingSupport((EditingSupport)new TranslatorEditingSupport((ColumnViewer)this.bindingsViewer.getTableViewer(), (IResource)this.vdbEditor.getVdb().getFile()));
        column.setLabelProvider((CellLabelProvider)new BindingDataLabelProvider(1));
        column = this.bindingsViewer.createColumn(16384, 30, 30, true);
        column.getColumn().setText(String.valueOf(Messages.modelDetailsPanel_jndiNameLabel) + "          ");
        column.setEditingSupport((EditingSupport)new JndiEditingSupport((ColumnViewer)this.bindingsViewer.getTableViewer(), (IResource)this.vdbEditor.getVdb().getFile()));
        column.setLabelProvider((CellLabelProvider)new BindingDataLabelProvider(2));
        this.bindingsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ModelDetailsPanel.this.deleteButton.setEnabled(false);
                } else if (ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().isMultiSource()) {
                    Object[] objs;
                    boolean enable = true;
                    Object[] objectArray = objs = sel.toArray();
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof VdbSource)) {
                            enable = false;
                            break;
                        }
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ModelDetailsPanel.this.deleteButton.setEnabled(enable);
                }
            }
        });
        CTabItem modelsTab = new CTabItem(tabFolder, 0);
        modelsTab.setText(ModelDetailsPanel.i18n("description"));
        modelsTab.setToolTipText(Messages.modelDetailsPanel_modelDetailsTooltip);
        Composite modelDetailsPanel = new Composite((Composite)tabFolder, 0);
        modelDetailsPanel.setLayout((Layout)new GridLayout(1, false));
        modelDetailsPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)modelDetailsPanel.getLayoutData()).widthHint = 200;
        modelsTab.setControl((Control)modelDetailsPanel);
        this.modelDescriptionEditor = new StyledTextEditor(modelDetailsPanel, 2882);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.modelDescriptionEditor.setLayoutData((Object)gridData);
        this.modelDescriptionEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (ModelDetailsPanel.this.selectedVdbModelEntry != null) {
                    ModelDetailsPanel.this.selectedVdbModelEntry.setDescription(ModelDetailsPanel.this.modelDescriptionEditor.getText());
                }
            }
        });
        this.selectedVdbModelEntry = null;
        this.modelNameText.setText(Messages.noSelection);
        this.modelLocationText.setText(Messages.noSelection);
        this.modelDescriptionEditor.setText("");
        this.modelDescriptionEditor.getTextViewer().setEditable(false);
        CTabItem problemsTab = new CTabItem(tabFolder, 0);
        problemsTab.setText(Messages.modelDetailsPanel_problemsTabLabel);
        problemsTab.setToolTipText(Messages.modelDetailsPanel_problemsTabTooltip);
        Composite modelProblemsPanel = new Composite((Composite)tabFolder, 0);
        modelProblemsPanel.setLayout((Layout)new GridLayout(1, false));
        modelProblemsPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)modelProblemsPanel.getLayoutData()).widthHint = 200;
        problemsTab.setControl((Control)modelProblemsPanel);
        Composite subPanel_12 = WidgetFactory.createPanel((Composite)modelProblemsPanel, (int)0, (int)1808, (int)1, (int)1);
        subPanel_12.setLayout((Layout)new GridLayout(1, false));
        tableStyle = 2820;
        this.problemsViewer = new TableViewerBuilder(subPanel_12, tableStyle);
        column = this.problemsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(String.valueOf(Messages.modelDetailsPanel_problemPathLabel) + "                                    ");
        column.setLabelProvider((CellLabelProvider)new ProblemMarkerLabelProvider(0));
        column = this.problemsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText("      ");
        column.setLabelProvider((CellLabelProvider)new ProblemMarkerLabelProvider(1));
        column = this.problemsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(String.valueOf(Messages.modelDetailsPanel_problemDescriptionLabel) + "            ");
        column.setLabelProvider((CellLabelProvider)new ProblemMarkerLabelProvider(2));
        tabFolder.setSelection(0);
        this.multiSourceCB.setEnabled(false);
        this.addColumnCB.setEnabled(false);
        this.columnAliasText.setEnabled(false);
        this.addButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.columnAliaslabel.setEnabled(false);
        this.columnAliasText.setBackground(Display.getCurrent().getSystemColor(19));
    }

    public void refreshModelDetails() {
        if (this.selectedVdbModelEntry == null) {
            this.modelNameText.setText(Messages.noSelection);
            this.modelLocationText.setText(Messages.noSelection);
            this.modelDescriptionEditor.setText("");
            this.bindingsViewer.getTable().removeAll();
            this.multiSourceCB.setEnabled(false);
            this.addColumnCB.setEnabled(false);
            this.columnAliasText.setEnabled(false);
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.columnAliaslabel.setEnabled(false);
            this.columnAliasText.setBackground(Display.getCurrent().getSystemColor(19));
            this.problemsViewer.getTable().removeAll();
            this.modelDescriptionEditor.getTextViewer().setEditable(false);
        } else {
            this.modelNameText.setText(this.selectedVdbModelEntry.getName().lastSegment());
            this.modelLocationText.setText(this.selectedVdbModelEntry.getName().removeLastSegments(1).toString());
            this.modelDescriptionEditor.setText(this.selectedVdbModelEntry.getDescription());
            this.modelDescriptionEditor.getTextViewer().setEditable(true);
            this.bindingsViewer.getTable().removeAll();
            for (VdbSource vdbSource : this.selectedVdbModelEntry.getSourceInfo().getSources()) {
                this.bindingsViewer.add((Object)vdbSource);
            }
            this.problemsViewer.getTable().removeAll();
            for (VdbIndexedEntry.Problem prob : this.selectedVdbModelEntry.getProblems()) {
                this.problemsViewer.add((Object)prob);
            }
            boolean enable = this.selectedVdbModelEntry.getSourceInfo().isMultiSource();
            this.multiSourceCB.setEnabled(true);
            this.multiSourceCB.setSelection(enable);
            this.addColumnCB.setEnabled(enable);
            this.columnAliasText.setEnabled(enable);
            this.addButton.setEnabled(enable);
            this.deleteButton.setEnabled(this.selectedVdbModelEntry.getSourceInfo().getSourceCount() > 1 && !this.bindingsViewer.getSelection().isEmpty());
            this.columnAliaslabel.setEnabled(enable);
            if (enable) {
                this.columnAliasText.setBackground(Display.getCurrent().getSystemColor(25));
            } else {
                this.columnAliasText.setBackground(Display.getCurrent().getSystemColor(19));
            }
        }
    }

    public void setSelectedVdbModelEntry(VdbModelEntry selection) {
        this.selectedVdbModelEntry = selection;
        this.refreshModelDetails();
    }

    class BindingDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public BindingDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof VdbSource) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((VdbSource)element).getName();
                    }
                    case 1: {
                        return ((VdbSource)element).getTranslatorName();
                    }
                    case 2: {
                        return ((VdbSource)element).getJndiName();
                    }
                }
            }
            return "";
        }
    }

    class JndiEditingSupport
    extends ResourceEditingSupport {
        public JndiEditingSupport(ColumnViewer viewer, IResource vdb) {
            super(viewer, vdb);
        }

        protected boolean canAddNewValue(Object element) {
            return true;
        }

        protected String getElementValue(Object element) {
            return ((VdbSource)element).getJndiName();
        }

        protected String[] refreshItems(Object element) {
            ArrayList<String> dsJndiNameList = new ArrayList<String>();
            String[] dsJndiNames = SourceHandlerExtensionManager.getVdbConnectionFinder().getDataSourceJndiNames();
            if (dsJndiNames != null) {
                dsJndiNameList.addAll(Arrays.asList(dsJndiNames));
            }
            Collections.sort(dsJndiNameList);
            return dsJndiNameList.toArray(new String[dsJndiNameList.size()]);
        }

        protected void setElementValue(Object element, String newValue) {
            if (newValue == null) {
                newValue = "";
            }
            ((VdbSource)element).setJndiName(newValue);
            ModelDetailsPanel.this.refreshModelDetails();
            ModelDetailsPanel.this.bindingsViewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    class ProblemMarkerLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ProblemMarkerLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof VdbIndexedEntry.Problem) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((VdbIndexedEntry.Problem)element).getLocation();
                    }
                    case 2: {
                        return ((VdbIndexedEntry.Problem)element).getMessage();
                    }
                }
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof VdbIndexedEntry.Problem) {
                switch (this.columnNumber) {
                    case 1: {
                        int severity = ((VdbIndexedEntry.Problem)element).getSeverity();
                        if (severity == 2) {
                            return VdbUiPlugin.singleton.getImage("icons/full/obj16/error_st_obj.gif");
                        }
                        return VdbUiPlugin.singleton.getImage("icons/full/obj16/warning_st_obj.gif");
                    }
                }
            }
            return null;
        }
    }

    class SourceNameTextEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public SourceNameTextEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof VdbSource) {
                return ((VdbSource)element).getName();
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof VdbSource) {
                String oldValue = ((VdbSource)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    String newName = this.ensureUniqueName(newValue, (VdbSource)element);
                    ((VdbSource)element).setName(newName);
                    ModelDetailsPanel.this.refreshModelDetails();
                    ModelDetailsPanel.this.bindingsViewer.setSelection((ISelection)new StructuredSelection(element));
                }
            }
        }

        private String ensureUniqueName(String name, VdbSource currentSource) {
            String uniqueName = name;
            ArrayList<String> otherSourceNames = new ArrayList<String>();
            for (VdbSource vdbSource : ModelDetailsPanel.this.selectedVdbModelEntry.getSourceInfo().getSources()) {
                if (vdbSource.equals((Object)currentSource)) continue;
                otherSourceNames.add(vdbSource.getName().toLowerCase());
            }
            boolean isUnique = false;
            int i = 1;
            while (!isUnique) {
                boolean bl = isUnique = !otherSourceNames.contains(uniqueName.toLowerCase());
                if (isUnique) continue;
                uniqueName = String.valueOf(uniqueName) + i;
            }
            return uniqueName;
        }
    }

    class TranslatorEditingSupport
    extends ResourceEditingSupport {
        public TranslatorEditingSupport(ColumnViewer viewer, IResource vdb) {
            super(viewer, vdb);
        }

        protected boolean canAddNewValue(Object element) {
            return true;
        }

        protected String getElementValue(Object element) {
            return ((VdbSource)element).getTranslatorName();
        }

        protected String[] refreshItems(Object element) {
            ArrayList<String> translators = new ArrayList<String>();
            String[] serverTypes = SourceHandlerExtensionManager.getVdbConnectionFinder().getTranslatorTypes();
            if (serverTypes != null) {
                translators.addAll(Arrays.asList(serverTypes));
            }
            for (TranslatorOverride translator : ModelDetailsPanel.this.vdbEditor.getVdb().getTranslators()) {
                translators.add(translator.getName());
            }
            Collections.sort(translators);
            return translators.toArray(new String[translators.size()]);
        }

        protected void setElementValue(Object element, String newValue) {
            if (newValue == null) {
                newValue = "";
            }
            ((VdbSource)element).setTranslatorName(newValue);
            ModelDetailsPanel.this.refreshModelDetails();
            ModelDetailsPanel.this.bindingsViewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }
}

