/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.wizard.DataRoleResolver;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbDataRole;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;

public class VdbDataRoleResolver {
    static final String WEB_SERVICES_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/WebService";
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    private Vdb vdb;

    public VdbDataRoleResolver(Vdb vdb) {
        this.vdb = vdb;
    }

    public void modelEntriesRemoved(Set<VdbEntry> entries) {
        HashSet<String> modelNames = new HashSet<String>(entries.size());
        for (VdbEntry entry : entries) {
            modelNames.add(entry.getName().removeFileExtension().lastSegment());
        }
        this.removePermissionsForModels(modelNames);
    }

    private void removePermissionsForModels(Set<String> modelNames) {
        Set roles = this.vdb.getDataPolicyEntries();
        for (VdbDataRole role : roles) {
            boolean changedPerms = false;
            ArrayList<Permission> keepPermList = new ArrayList<Permission>();
            List permissions = role.getPermissions();
            for (Permission perm : permissions) {
                boolean shouldRemovePermission = this.targetIsInStringList(modelNames, perm.getTargetName());
                if (shouldRemovePermission) {
                    changedPerms = true;
                    continue;
                }
                keepPermList.add(perm);
            }
            if (!changedPerms || keepPermList.isEmpty()) continue;
            this.vdb.removeDataPolicy(role);
            DataRole dr = new DataRole(role.getName());
            dr.setDescription(role.getDescription());
            if (!role.getMappedRoleNames().isEmpty()) {
                dr.setRoleNames((Collection)role.getMappedRoleNames());
            }
            dr.setPermissions(keepPermList);
            dr.setAnyAuthenticated(role.isAnyAuthenticated());
            this.vdb.addDataPolicy(dr, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean targetIsInStringList(Set<String> modelNames, String targetName) {
        Path targetModelPath = new Path(this.getTargetNamePath(targetName));
        String targetModelName = targetModelPath.segment(0);
        for (String modelName : modelNames) {
            if (!modelName.equalsIgnoreCase(targetModelName)) continue;
            return true;
        }
        return false;
    }

    private String getTargetNamePath(String dotPath) {
        return dotPath.replace('.', '/');
    }

    private DataRole getDataRole(VdbDataRole vdbDataRole) {
        DataRole dr = new DataRole(vdbDataRole.getName());
        dr.setDescription(vdbDataRole.getDescription());
        if (!vdbDataRole.getMappedRoleNames().isEmpty()) {
            dr.setRoleNames((Collection)vdbDataRole.getMappedRoleNames());
        }
        ArrayList perms = new ArrayList(vdbDataRole.getPermissions());
        dr.setPermissions(perms);
        return dr;
    }

    public void modelSynchronized(VdbEntry element) {
        if (element instanceof VdbModelEntry) {
            ContainerImpl tempContainer;
            block13: {
                tempContainer = null;
                VdbModelEntry entry = (VdbModelEntry)element;
                try {
                    try {
                        File modelFile = null;
                        for (File file : this.vdb.getModelFiles()) {
                            String entryName = entry.getName().lastSegment();
                            if (!file.getName().equals(entryName)) continue;
                            modelFile = file;
                            break;
                        }
                        if (modelFile != null) {
                            tempContainer = (ContainerImpl)ModelerCore.createContainer((String)"tempVdbModelContainer");
                            ModelEditorImpl.setContainer((ContainerImpl)tempContainer);
                            boolean isVisible = true;
                            Resource r = tempContainer.getResource(URI.createFileURI((String)modelFile.getPath()), true);
                            if (isVisible && ModelUtil.isModelFile((Resource)r) && !ModelUtil.isXsdFile((Resource)r)) {
                                EObject firstEObj = (EObject)r.getContents().get(0);
                                ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                                String mmURI = ma.getPrimaryMetamodelUri();
                                if (!("http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(mmURI) || WEB_SERVICES_VIEW_MODEL_URI.equalsIgnoreCase(mmURI))) {
                                    tempContainer.getResources().remove((Object)r);
                                }
                            } else {
                                tempContainer.getResources().remove((Object)r);
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        ModelEditorImpl.setContainer(null);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    ModelEditorImpl.setContainer(null);
                    throw throwable;
                }
                ModelEditorImpl.setContainer(null);
            }
            if (tempContainer != null) {
                DataRoleResolver resolver = new DataRoleResolver(tempContainer);
                for (VdbDataRole existingRole : this.vdb.getDataPolicyEntries()) {
                    DataRole existingDataRole = this.getDataRole(existingRole);
                    DataRole changedDataRole = resolver.resolveDataRole(existingDataRole);
                    if (changedDataRole == null) continue;
                    this.vdb.removeDataPolicy(existingRole);
                    this.vdb.addDataPolicy(changedDataRole, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    public void allSynchronized() {
        ContainerImpl tempContainer;
        block9: {
            tempContainer = null;
            try {
                try {
                    Collection modelFiles = this.vdb.getModelFiles();
                    tempContainer = (ContainerImpl)ModelerCore.createContainer((String)"tempVdbModelContainer");
                    ModelEditorImpl.setContainer((ContainerImpl)tempContainer);
                    for (File modelFile : modelFiles) {
                        boolean isVisible = true;
                        Resource r = tempContainer.getResource(URI.createFileURI((String)modelFile.getPath()), true);
                        if (isVisible && ModelUtil.isModelFile((Resource)r) && !ModelUtil.isXsdFile((Resource)r)) {
                            EObject firstEObj = (EObject)r.getContents().get(0);
                            ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                            String mmURI = ma.getPrimaryMetamodelUri();
                            if ("http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(mmURI) || "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(mmURI) || WEB_SERVICES_VIEW_MODEL_URI.equalsIgnoreCase(mmURI)) continue;
                            tempContainer.getResources().remove((Object)r);
                            continue;
                        }
                        tempContainer.getResources().remove((Object)r);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    ModelEditorImpl.setContainer(null);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                ModelEditorImpl.setContainer(null);
                throw throwable;
            }
            ModelEditorImpl.setContainer(null);
        }
        if (tempContainer != null) {
            DataRoleResolver resolver = new DataRoleResolver((Container)tempContainer);
            for (VdbDataRole existingRole : this.vdb.getDataPolicyEntries()) {
                DataRole existingDataRole = this.getDataRole(existingRole);
                DataRole changedDataRole = resolver.resolveDataRole(existingDataRole);
                if (changedDataRole == null) continue;
                this.vdb.removeDataPolicy(existingRole);
                this.vdb.addDataPolicy(changedDataRole, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

