/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.messages;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.jmx.commons.messages.Body;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.ExchangeList;
import org.fusesource.ide.jmx.commons.messages.Header;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.Message;
import org.fusesource.ide.jmx.commons.messages.PreMarshalHook;
import org.fusesource.ide.jmx.commons.messages.support.NamespaceFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Exchanges {
    protected static final Pattern startBodyElementRegex = Pattern.compile("<body type=\"[^\"]*\">");

    public static JAXBContext newJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{ExchangeList.class, Exchange.class, Message.class, Header.class, Body.class});
    }

    public static Exchange unmarshalXmlString(String message) throws JAXBException {
        Unmarshaller unmarshaller = Exchanges.createUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)new StringReader(message));
        return Exchanges.asExchange(object);
    }

    public static Exchange unmarshalNoNamespaceXmlString(String badMessage) throws JAXBException, SAXException {
        String message = Exchanges.wrapBadXmlMessage(badMessage);
        Unmarshaller unmarshaller = Exchanges.createUnmarshaller();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        NamespaceFilter inFilter = new NamespaceFilter("http://fabric.fusesource.org/schema/messages", true);
        inFilter.setParent(reader);
        InputSource is = new InputSource(new StringReader(message));
        SAXSource source = new SAXSource(inFilter, is);
        Object object = unmarshaller.unmarshal((Source)source);
        return Exchanges.asExchange(object);
    }

    public static String wrapBadXmlMessage(String message) {
        int start;
        String middle;
        Matcher m;
        int end = message.lastIndexOf("</body>");
        if (end > 0 && (m = startBodyElementRegex.matcher(message)).find() && (middle = message.substring(start = m.end(), end)).startsWith("<")) {
            String prefix = message.substring(0, start);
            String postfix = message.substring(end);
            String answer = String.valueOf(prefix) + "<![CDATA[" + middle + "]]>" + postfix;
            return answer;
        }
        return message;
    }

    public static ExchangeList unmarshalExchangesXmlString(String message) throws JAXBException {
        Unmarshaller unmarshaller = Exchanges.createUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)new StringReader(message));
        return Exchanges.asExchangeList(object);
    }

    public static void marshal(Object message, File file) throws JAXBException {
        Marshaller marshaller = Exchanges.createMarshaller(message);
        marshaller.marshal(message, file);
    }

    public static String marshal(Object message) throws JAXBException {
        Marshaller marshaller = Exchanges.createMarshaller(message);
        StringWriter writer = new StringWriter();
        marshaller.marshal(message, (Writer)writer);
        return writer.toString();
    }

    public static IMessage toMessage(Object object) {
        IMessage message = null;
        if (object instanceof IExchange) {
            IExchange exchange = (IExchange)object;
            message = exchange.getIn();
        } else if (object instanceof IMessage) {
            message = (IMessage)object;
        }
        return message;
    }

    public static void preMarshalHook(Object object) {
        if (object instanceof PreMarshalHook) {
            PreMarshalHook hook = (PreMarshalHook)object;
            hook.preMarshal();
        }
    }

    public static IMessage loadMessage(Object description, InputStream in) throws JAXBException {
        Object object = Exchanges.loadObject(description, in);
        return Exchanges.asMessage(object);
    }

    public static ExchangeList loadExchanges(Object description, InputStream in) throws JAXBException {
        Object object = Exchanges.loadObject(description, in);
        return Exchanges.asExchangeList(object);
    }

    protected static Object loadObject(Object description, InputStream in) throws JAXBException {
        Unmarshaller unmarshaller = Exchanges.createUnmarshaller();
        return unmarshaller.unmarshal(in);
    }

    public static RiderLogFacade getLogger() {
        return Activator.getLogger();
    }

    public static IMessage loadMessage(File file) throws JAXBException {
        Unmarshaller unmarshaller = Exchanges.createUnmarshaller();
        Object object = null;
        try {
            object = unmarshaller.unmarshal(file);
        }
        catch (Exception e) {
            Exchanges.getLogger().info("Could not parse " + file + " as a message file so using it as a payload. " + e, (Throwable)e);
        }
        if (object instanceof IMessage) {
            return (IMessage)object;
        }
        return null;
    }

    public static Exchange asExchange(Object object) {
        ExchangeList exchangeList;
        List<Exchange> list;
        if (object instanceof Exchange) {
            return (Exchange)object;
        }
        if (object instanceof Message) {
            return new Exchange((Message)object);
        }
        if (object instanceof ExchangeList && (list = (exchangeList = (ExchangeList)object).getExchanges()) != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static ExchangeList asExchangeList(Object object) {
        if (object instanceof ExchangeList) {
            return (ExchangeList)object;
        }
        ExchangeList answer = new ExchangeList();
        Exchange exchange = Exchanges.asExchange(object);
        if (exchange != null) {
            answer.getExchanges().add(exchange);
            return answer;
        }
        return null;
    }

    public static IMessage asMessage(Object object) {
        if (object instanceof IMessage) {
            return (IMessage)object;
        }
        Exchange exchange = Exchanges.asExchange(object);
        if (exchange != null) {
            return exchange.getIn();
        }
        return null;
    }

    protected static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = Exchanges.newJaxbContext();
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    protected static Marshaller createMarshaller(Object object) throws JAXBException, PropertyException {
        JAXBContext context = Exchanges.newJaxbContext();
        Marshaller marshaller = context.createMarshaller();
        Exchanges.preMarshalHook(object);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    public static Object getBody(IExchange exchange) {
        IMessage message;
        if (exchange != null && (message = exchange.getIn()) != null) {
            return message.getBody();
        }
        return null;
    }

    public static Map<String, Object> getHeaders(IExchange exchange) {
        Map<String, Object> headers;
        IMessage message;
        if (exchange != null && (message = exchange.getIn()) != null && (headers = message.getHeaders()) != null) {
            return headers;
        }
        return Collections.emptyMap();
    }
}

