/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.messages;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.commons.util.TextFilter;
import org.fusesource.ide.commons.util.TextFilters;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.Message;
import org.fusesource.ide.jmx.commons.messages.PreMarshalHook;

@XmlRootElement(name="exchange")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Exchange
implements IExchange,
TextFilter,
PreMarshalHook,
Comparable<Exchange> {
    @XmlAttribute(required=false)
    private String id;
    @XmlElement(name="message", required=false)
    private Message in;
    @XmlElement(name="outMessage", required=false)
    private Message out;
    @XmlTransient
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Date timestamp;
    private Integer exchangeIndex;

    public Exchange() {
    }

    public Exchange(Message in) {
        this.in = in;
    }

    @Override
    public int compareTo(Exchange that) {
        if (this == that) {
            return 0;
        }
        int answer = Objects.compare((Object)this.id, (Object)that.id);
        if (answer == 0) {
            Long uuid2;
            Long uuid1 = this.in != null ? this.in.getUuid() : null;
            Long l = uuid2 = that.in != null ? that.in.getUuid() : null;
            if (uuid1 != null && uuid2 != null) {
                answer = uuid1.compareTo(uuid2);
            }
        }
        if (answer == 0) {
            answer = Objects.compare((Object)this.in.getExchangeIndex(), (Object)that.in.getExchangeIndex());
        }
        if (answer == 0) {
            answer = Objects.compare((Object)this.in.getTimestamp(), (Object)that.in.getTimestamp());
        }
        return answer;
    }

    public String toString() {
        return "Exchange[" + Strings.join((String)", ", (Object[])new Object[]{this.id}) + " : " + this.in + "]";
    }

    public Integer getExchangeIndex() {
        if (this.in != null) {
            return this.in.getExchangeIndex();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public IMessage getIn() {
        return this.in;
    }

    @Override
    public IMessage getOut() {
        return this.out;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIn(Message in) {
        this.in = in;
    }

    public void setOut(Message out) {
        this.out = out;
    }

    public boolean matches(String searchText) {
        return TextFilters.matches((String)searchText, (String)this.getId()) || TextFilters.matches((String)searchText, this.getProperties()) || TextFilters.matches((String)searchText, (Object)this.getIn()) || TextFilters.matches((String)searchText, (Object)this.getOut());
    }

    @Override
    public void preMarshal() {
        if (this.in != null) {
            this.in.preMarshal();
        }
        if (this.out != null) {
            this.out.preMarshal();
        }
    }
}

