/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BPMN2PersistencyBehavior
extends DefaultPersistencyBehavior {
    BPMN2Editor editor;

    public BPMN2PersistencyBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
        this.editor = (BPMN2Editor)diagramBehavior.getDiagramContainer();
    }

    public Diagram loadDiagram(URI diagramUri) {
        Diagram diagram = super.loadDiagram(diagramUri);
        return diagram;
    }

    public void saveDiagram(IProgressMonitor monitor) {
        Resource resource = this.editor.getResource();
        IStatus status = BPMN2ProjectValidator.validateLive((EObject)ModelUtil.getDefinitions((Object)resource));
        if (status.getSeverity() >= 4) {
            String statusList = "";
            for (IStatus s : this.collectStatus(status)) {
                statusList = String.valueOf(statusList) + "  " + s.getMessage() + "\n";
            }
            MessageDialog.openError((Shell)this.editor.getEditorSite().getShell(), (String)Messages.BPMN2PersistencyBehavior_Cannot_Save_Title, (String)(String.valueOf(Messages.BPMN2PersistencyBehavior_Cannot_Save_Message) + statusList));
            monitor.setCanceled(true);
            return;
        }
        super.saveDiagram(monitor);
    }

    List<IStatus> collectStatus(IStatus status) {
        if (status.getChildren().length == 0) {
            return Collections.singletonList(status);
        }
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            for (IStatus s : this.collectStatus(child)) {
                if (result.contains(s)) continue;
                result.add(s);
            }
            ++n2;
        }
        return result;
    }

    protected IRunnableWithProgress createOperation(Set<Resource> savedResources, Map<Resource, Map<?, ?>> saveOptions) {
        SaveOperation operation = new SaveOperation(saveOptions, savedResources);
        return operation;
    }

    protected final class SaveOperation
    implements IRunnableWithProgress,
    IThreadListener {
        private final Map<Resource, Map<?, ?>> saveOptions;
        private final Set<Resource> savedResources;

        private SaveOperation(Map<Resource, Map<?, ?>> saveOptions, Set<Resource> savedResources) {
            this.saveOptions = saveOptions;
            this.savedResources = savedResources;
        }

        public void run(final IProgressMonitor monitor) {
            try {
                this.savedResources.addAll(BPMN2PersistencyBehavior.this.save(BPMN2PersistencyBehavior.this.diagramBehavior.getEditingDomain(), this.saveOptions, monitor));
            }
            catch (WrappedException e) {
                String emsg = e.getMessage().replaceAll("\tat .*", "").replaceFirst(".*Exception: ", "").trim();
                final String msg = emsg.replace("\r\n\r\n", "").replace("\n\n", "");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BPMN2PersistencyBehavior_Cannot_Save_Title, (String)msg);
                        monitor.setCanceled(true);
                    }
                });
                throw e;
            }
        }

        public void threadChange(Thread thread) {
            ISchedulingRule rule = Job.getJobManager().currentRule();
            if (rule != null) {
                Job.getJobManager().transferRule(rule, thread);
            }
        }
    }
}

