/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.builder.BPMN2Builder;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.Bpmn2TabbedPropertySheetPage;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.AbstractObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.model.ProxyURIConverterImplExtension;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.DiagramEditorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.FileUtils;
import org.eclipse.bpmn2.modeler.core.utils.MarkerUtils;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ValidationStatusLoader;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2ToolBehaviorProvider;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditingDomainListener;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditorDiagramBehavior;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MarkerChangeListener;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MultiPageEditor;
import org.eclipse.bpmn2.modeler.ui.editor.ConnectionLayerClippingStrategy;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.bpmn2.modeler.ui.property.PropertyTabDescriptorProvider;
import org.eclipse.bpmn2.modeler.ui.util.PropertyUtil;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorOutlinePage;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorSelectionSynchronizer;
import org.eclipse.bpmn2.modeler.ui.wizards.BPMN2DiagramCreator;
import org.eclipse.bpmn2.modeler.ui.wizards.FileService;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.GFPaletteRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class BPMN2Editor
extends DiagramEditor
implements IEclipsePreferences.IPreferenceChangeListener,
IGotoMarker {
    public static final String EDITOR_ID = "org.eclipse.bpmn2.modeler.ui.bpmn2editor";
    public static final String CONTRIBUTOR_ID = "org.eclipse.bpmn2.modeler.ui.PropertyContributor";
    private ModelHandler modelHandler;
    private URI modelUri;
    private URI diagramUri;
    private boolean editable = true;
    protected BPMNDiagram bpmnDiagram;
    protected Bpmn2ResourceImpl bpmnResource;
    private IWorkbenchListener workbenchListener;
    private IPartListener2 selectionListener;
    private IResourceChangeListener markerChangeListener;
    private boolean workbenchShutdown = false;
    private static BPMN2Editor activeEditor;
    private IEditorInput currentInput;
    private static ITabDescriptorProvider tabDescriptorProvider;
    private BPMN2EditingDomainListener editingDomainListener;
    private Bpmn2Preferences preferences;
    private TargetRuntime targetRuntime;
    private ModelEnablements modelEnablements;
    private boolean importInProgress;
    private BPMN2EditorSelectionSynchronizer synchronizer;
    protected DiagramEditorAdapter editorAdapter;
    protected BPMN2MultiPageEditor multipageEditor;
    protected IPropertySheetPage propertySheetPage;
    protected IContentOutlinePage outlinePage;
    protected boolean saveInProgress = false;
    private static NotificationFilter filterNone;

    static {
        TargetRuntime.createTargetRuntimes();
        filterNone = new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                return false;
            }
        };
    }

    public BPMN2Editor(BPMN2MultiPageEditor mpe) {
        this.multipageEditor = mpe;
    }

    public static BPMN2Editor getActiveEditor() {
        return activeEditor;
    }

    public IEditorInput getEditorInput() {
        return this.currentInput;
    }

    private void setActiveEditor(BPMN2Editor editor) {
        activeEditor = editor;
        if (activeEditor != null) {
            Bpmn2Preferences.setActiveProject((IProject)activeEditor.getProject());
            TargetRuntime.setCurrentRuntime((TargetRuntime)activeEditor.getTargetRuntime());
        } else {
            TargetRuntime.setCurrentRuntime(null);
        }
    }

    public BPMN2MultiPageEditor getMultipageEditor() {
        return this.multipageEditor;
    }

    protected DiagramEditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.currentInput = input;
        this.setActiveEditor(this);
        if (input instanceof IFileEditorInput) {
            BPMN2Builder.INSTANCE.loadExtensions(((IFileEditorInput)input).getFile().getProject());
        }
        if (this.getDiagramBehavior() == null) {
            super.init(site, input);
            this.addWorkbenchListener();
            this.addSelectionListener();
            this.addMarkerChangeListener();
        } else if (input instanceof Bpmn2DiagramEditorInput) {
            this.bpmnDiagram = ((Bpmn2DiagramEditorInput)input).getBpmnDiagram();
            if (this.bpmnDiagram != null) {
                this.setBpmnDiagram(this.bpmnDiagram);
            }
        }
    }

    private Bpmn2DiagramEditorInput createNewDiagramEditorInput(IEditorInput input, ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace) throws PartInitException {
        this.modelUri = FileService.getInputUri(input);
        if (this.modelUri == null) {
            throw new PartInitException(Messages.BPMN2Editor_Cannot_Create_Editor_Input);
        }
        input = BPMN2DiagramCreator.createDiagram(input, this.modelUri, diagramType, targetNamespace, this);
        this.diagramUri = ((Bpmn2DiagramEditorInput)((Object)input)).getUri();
        return (Bpmn2DiagramEditorInput)((Object)input);
    }

    private void saveModelFile() {
        try {
            this.bpmnResource.save(null);
            ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
            this.updateDirtyState();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setInput(IEditorInput input) {
        try {
            if (input instanceof Bpmn2DiagramEditorInput) {
                ModelUtil.Bpmn2DiagramType diagramType = ModelUtil.Bpmn2DiagramType.NONE;
                String targetNamespace = null;
                diagramType = ((Bpmn2DiagramEditorInput)((Object)input)).getInitialDiagramType();
                targetNamespace = ((Bpmn2DiagramEditorInput)((Object)input)).getTargetNamespace();
                input = this.createNewDiagramEditorInput((IEditorInput)input, diagramType, targetNamespace);
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        this.currentInput = input;
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)this, input);
        TargetRuntime targetRuntime = this.getTargetRuntime((IEditorInput)input);
        this.getTargetRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_STARTUP, (Object)this));
        ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
        resourceSet.setURIConverter((URIConverter)new ProxyURIConverterImplExtension(this.modelUri));
        this.editorAdapter = new DiagramEditorAdapter((DiagramEditor)this);
        resourceSet.eAdapters().add((Object)this.editorAdapter);
        targetRuntime.registerExtensionResourceFactory(resourceSet);
        this.bpmnResource = otherEditor == null ? (Bpmn2ResourceImpl)resourceSet.createResource(this.modelUri, "org.eclipse.bpmn2.content-type.xml") : otherEditor.bpmnResource;
        super.setInput(input);
        this.getEditingDomainListener();
        this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)this.bpmnResource);
        ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
        this.setActiveEditor(this);
        this.getTargetRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_INITIALIZED, (Object)this));
        if (otherEditor == null) {
            try {
                this.getPreferences().setDoCoreValidation(false);
                BasicCommandStack commandStack = (BasicCommandStack)this.getEditingDomain().getCommandStack();
                commandStack.execute((Command)new RecordingCommand(this.getEditingDomain()){

                    protected void doExecute() {
                        BPMN2Editor.this.importDiagram();
                    }
                });
                Definitions definitions = ModelUtil.getDefinitions((Object)this.bpmnResource);
                if (definitions != null) {
                    ((Bpmn2DiagramEditorInput)((Object)input)).setTargetNamespace(definitions.getTargetNamespace());
                    ((Bpmn2DiagramEditorInput)((Object)input)).setInitialDiagramType(ModelUtil.getDiagramType((DiagramEditor)this));
                }
                commandStack.saveIsDone();
                commandStack.flush();
            }
            finally {
                this.getPreferences().setDoCoreValidation(true);
            }
        }
        this.loadMarkers();
    }

    protected DiagramEditorInput convertToDiagramEditorInput(IEditorInput input) throws PartInitException {
        Bpmn2DiagramEditorInput newInput = this.createNewDiagramEditorInput(input, ModelUtil.Bpmn2DiagramType.NONE, "");
        if (newInput == null) {
            newInput = super.convertToDiagramEditorInput(input);
        }
        return newInput;
    }

    private void importDiagram() {
        try {
            this.importInProgress = true;
            Diagram diagram = this.getDiagramTypeProvider().getDiagram();
            IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
            diagram.setActive(true);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            ModelUtil.Bpmn2DiagramType diagramType = input.getInitialDiagramType();
            String targetNamespace = input.getTargetNamespace();
            if (diagramType != ModelUtil.Bpmn2DiagramType.NONE) {
                this.bpmnDiagram = this.modelHandler.createDiagramType(diagramType, targetNamespace);
                featureProvider.link((PictogramElement)diagram, (Object)this.bpmnDiagram);
                this.saveModelFile();
            } else if (targetNamespace != null && !targetNamespace.isEmpty()) {
                this.modelHandler.getDefinitions().setTargetNamespace(targetNamespace);
            }
            DIImport di = new DIImport((IDiagramContainer)this, this.getPreferences());
            di.setModelHandler(this.modelHandler);
            di.generateFromDI();
        }
        finally {
            this.importInProgress = false;
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDirty() {
        if (!this.editable) {
            return false;
        }
        if (this.getEditorInput() == null) {
            return false;
        }
        return super.isDirty();
    }

    protected DiagramBehavior createDiagramBehavior() {
        BPMN2EditorDiagramBehavior diagramBehavior = new BPMN2EditorDiagramBehavior(this);
        return diagramBehavior;
    }

    public Bpmn2Preferences getPreferences() {
        if (this.preferences == null) {
            this.loadPreferences(this.getProject());
        }
        return this.preferences;
    }

    private void loadPreferences(IProject project) {
        this.preferences = Bpmn2Preferences.getInstance((IProject)project);
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public String getContributorId() {
        return CONTRIBUTOR_ID;
    }

    public TargetRuntime getTargetRuntime() {
        if (this.targetRuntime == null) {
            this.targetRuntime = this.getTargetRuntime(this.getEditorInput());
        }
        return this.targetRuntime;
    }

    public ModelEnablements getModelEnablements() {
        String profileName = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime());
        if (this.modelEnablements != null && !this.modelEnablements.getId().equals(profileName)) {
            this.modelEnablements = null;
        }
        if (this.modelEnablements == null) {
            this.modelEnablements = this.getPreferences().getModelEnablements(this.getTargetRuntime(), profileName);
            if (this.modelEnablements.size() == 0) {
                profileName = this.getPreferences().getDefaultToolProfile(TargetRuntime.getDefaultRuntime());
                ModelEnablements defaultEnablements = this.getPreferences().getModelEnablements(TargetRuntime.getDefaultRuntime(), profileName);
                this.modelEnablements.copy(defaultEnablements);
            }
        }
        return this.modelEnablements;
    }

    protected TargetRuntime getTargetRuntime(IEditorInput input) {
        if (this.targetRuntime == null && input != null) {
            if (input instanceof Bpmn2DiagramEditorInput) {
                this.targetRuntime = ((Bpmn2DiagramEditorInput)input).getRuntime();
            }
            if (this.targetRuntime == null) {
                this.targetRuntime = TargetRuntime.getRuntime((IEditorInput)input);
            }
            TargetRuntime.setCurrentRuntime((TargetRuntime)this.targetRuntime);
        }
        return this.targetRuntime;
    }

    public void updatePalette() {
        GFPaletteRoot pr = (GFPaletteRoot)this.getPaletteRoot();
        if (pr != null) {
            this.modelEnablements = null;
            pr.updatePaletteEntries();
            Bpmn2ToolBehaviorProvider toolBehaviorProvider = (Bpmn2ToolBehaviorProvider)this.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            toolBehaviorProvider.createPaletteProfilesGroup(this, (PaletteRoot)pr);
        }
    }

    private void addWorkbenchListener() {
        if (this.workbenchListener == null) {
            this.workbenchListener = new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    BPMN2Editor.this.workbenchShutdown = true;
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            };
            PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        }
    }

    public void gotoMarker(IMarker marker) {
        ResourceSet rs = this.getEditingDomain().getResourceSet();
        EObject target = MarkerUtils.getTargetObject((ResourceSet)rs, (IMarker)marker);
        if (target == null) {
            return;
        }
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        ContainerShape pe = MarkerUtils.getContainerShape((IFeatureProvider)fp, (IMarker)marker);
        if (pe != null) {
            this.selectPictogramElements(new PictogramElement[]{pe});
        }
        if (pe == null || PropertyUtil.getPropertySheetView() == null) {
            ObjectEditingDialog dialog = new ObjectEditingDialog((DiagramEditor)this, target);
            ObjectEditingDialog.openWithTransaction((AbstractObjectEditingDialog)dialog);
        }
    }

    private void loadMarkers() {
        if (this.getModelFile() != null) {
            BPMN2ValidationStatusLoader vsl = new BPMN2ValidationStatusLoader((DiagramEditor)this);
            try {
                vsl.load(Arrays.asList(this.getModelFile().findMarkers(null, true, 0)));
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
        }
    }

    private void removeWorkbenchListener() {
        if (this.workbenchListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            this.workbenchListener = null;
        }
    }

    private void addSelectionListener() {
        if (this.selectionListener == null) {
            IWorkbenchPage page = this.getSite().getPage();
            this.selectionListener = new IPartListener2(){

                public void partActivated(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof BPMN2MultiPageEditor) {
                        BPMN2MultiPageEditor mpe = (BPMN2MultiPageEditor)part;
                        BPMN2Editor.this.setActiveEditor((BPMN2Editor)mpe.getDesignEditor());
                    }
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof BPMN2MultiPageEditor) {
                        BPMN2MultiPageEditor mpe = (BPMN2MultiPageEditor)part;
                        BPMN2Editor.this.setActiveEditor((BPMN2Editor)mpe.getDesignEditor());
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }
            };
            page.addPartListener(this.selectionListener);
        }
    }

    private void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removePartListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    private void addMarkerChangeListener() {
        if (this.getModelFile() != null && this.markerChangeListener == null) {
            this.markerChangeListener = new BPMN2MarkerChangeListener(this);
            this.getModelFile().getWorkspace().addResourceChangeListener(this.markerChangeListener, 16);
        }
    }

    private void removeMarkerChangeListener() {
        if (this.markerChangeListener != null) {
            this.getModelFile().getWorkspace().removeResourceChangeListener(this.markerChangeListener);
            this.markerChangeListener = null;
        }
    }

    public void refreshTitle() {
        if (this.getEditorInput() != null) {
            String name = this.getEditorInput().getName();
            this.setPartName(URI.decode((String)name));
        }
    }

    public BPMN2EditingDomainListener getEditingDomainListener() {
        if (this.editingDomainListener == null) {
            TransactionalEditingDomainImpl editingDomain = (TransactionalEditingDomainImpl)this.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            this.editingDomainListener = new BPMN2EditingDomainListener(this);
            TransactionalEditingDomain.Lifecycle domainLifeCycle = (TransactionalEditingDomain.Lifecycle)editingDomain.getAdapter(TransactionalEditingDomain.Lifecycle.class);
            domainLifeCycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this.editingDomainListener);
        }
        return this.editingDomainListener;
    }

    public BasicDiagnostic getDiagnostics() {
        return this.getEditingDomainListener().getDiagnostics();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new BPMN2EditorSelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public Object getAdapter(Class required) {
        if (required == DiagramEditor.class) {
            return this;
        }
        if (required == ITabDescriptorProvider.class) {
            if (tabDescriptorProvider == null) {
                tabDescriptorProvider = new PropertyTabDescriptorProvider();
            }
            return tabDescriptorProvider;
        }
        if (required == TargetRuntime.class) {
            return this.getTargetRuntime();
        }
        if (required == Bpmn2Preferences.class) {
            return this.getPreferences();
        }
        if (required == IPropertySheetPage.class) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new Bpmn2TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!BPMN2Editor.this.propertySheetPage.getControl().isDisposed()) {
                            BPMN2Editor.this.propertySheetPage.getControl().addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent e) {
                                    (this).BPMN2Editor.this.propertySheetPage = null;
                                }
                            });
                        }
                    }
                });
            }
            return this.propertySheetPage;
        }
        if (required == SelectionSynchronizer.class) {
            return this.getSelectionSynchronizer();
        }
        if (required == IContentOutlinePage.class && this.getDiagramTypeProvider() != null) {
            if (this.outlinePage == null) {
                this.outlinePage = new BPMN2EditorOutlinePage(this);
            }
            return this.outlinePage;
        }
        if (required == StructuredTextEditor.class && this.multipageEditor.getActiveEditor() == this.multipageEditor.getSourceViewer()) {
            return this.multipageEditor.getSourceViewer();
        }
        if (required == ModelEnablements.class) {
            return this.getModelEnablements();
        }
        if (required == ToolPaletteDescriptor.class) {
            String profileName = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime());
            return this.getTargetRuntime().getToolPalette(profileName);
        }
        if (required == NotificationFilter.class) {
            if (this.saveInProgress) {
                return filterNone;
            }
            return null;
        }
        if (required == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        File diagramFile;
        IWorkbenchPage[] pages;
        if (this.targetRuntime != null) {
            this.targetRuntime.notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_SHUTDOWN, (Object)this));
        }
        int instances = 0;
        IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] refs;
            IWorkbenchPage p = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = refs = p.findEditors(null, EDITOR_ID, 2);
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference r = iEditorReferenceArray[n4];
                if (r.getEditor(false) instanceof BPMN2MultiPageEditor && ((BPMN2MultiPageEditor)r.getEditor((boolean)false)).designEditor != this) {
                    ++instances;
                }
                ++n4;
            }
            ++n2;
        }
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)this, this.getEditorInput());
        if (otherEditor == null && this.diagramUri != null && (diagramFile = new File(this.diagramUri.toFileString())).exists()) {
            try {
                diagramFile.delete();
            }
            catch (Exception exception) {}
        }
        if (this.modelHandler != null) {
            ModelUtil.clearIDs((Resource)this.modelHandler.getResource(), (instances == 0 ? 1 : 0) != 0);
            this.modelHandler.dispose();
        }
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.selectionChanged((IWorkbenchPart)this, null);
        }
        if (tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        if (this.getResourceSet() != null) {
            this.getResourceSet().eAdapters().remove((Object)this.getEditorAdapter());
        }
        this.removeSelectionListener();
        if (instances == 0) {
            this.setActiveEditor(null);
        }
        super.dispose();
        if (this.modelUri != null) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            if (!this.workbenchShutdown && FileUtils.isTempFile((URI)this.modelUri)) {
                FileUtils.deleteTempFile((URI)this.modelUri);
            }
        }
        this.removeWorkbenchListener();
        this.removeMarkerChangeListener();
        if (this.preferences != null) {
            this.preferences.dispose();
        }
        this.currentInput = null;
    }

    public IPath getModelPath() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getFullPath();
        }
        return null;
    }

    public IProject getProject() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getProject();
        }
        return null;
    }

    public IFile getModelFile() {
        String uriString;
        if (this.modelUri != null && (uriString = this.modelUri.trimFragment().toPlatformString(true)) != null) {
            Path fullPath = new Path(uriString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
        }
        return null;
    }

    public URI getModelUri() {
        return this.modelUri;
    }

    public URI getDiagramUri() {
        return this.diagramUri;
    }

    public ModelHandler getModelHandler() {
        return this.modelHandler;
    }

    public Resource getResource() {
        return this.bpmnResource;
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public void refresh() {
        if (!this.importInProgress) {
            this.getDiagramBehavior().getRefreshBehavior().refresh();
        }
    }

    public void createPartControl(Composite parent) {
        if (this.getGraphicalViewer() == null) {
            super.createPartControl(parent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpmn2.modeler.help.TOC");
        }
    }

    public BPMNDiagram getBpmnDiagram() {
        Definitions definitions;
        if (this.bpmnDiagram == null && (definitions = ModelUtil.getDefinitions((Object)this.bpmnResource)) != null && definitions.getDiagrams().size() > 0) {
            this.bpmnDiagram = (BPMNDiagram)definitions.getDiagrams().get(0);
        }
        return this.bpmnDiagram;
    }

    public void setBpmnDiagram(BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
        this.selectPictogramElements(new PictogramElement[0]);
        this.getDiagramTypeProvider().resourceReloaded(diagram);
        this.getDiagramBehavior().getRefreshBehavior().initRefresh();
        this.setPictogramElementsForSelection(null);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)diagram);
        EditPart ep = viewer.getRootEditPart().getContents();
        if (ep instanceof AbstractGraphicalEditPart) {
            IFigure fig = ((AbstractGraphicalEditPart)ep).getFigure();
            fig.setBorder((Border)new MarginBorder(50));
        }
        ConnectionLayerClippingStrategy.applyTo(viewer);
        this.getDiagramBehavior().refreshContent();
        this.bpmnDiagram = bpmnDiagram;
        this.modelEnablements = null;
    }

    public void doSave(IProgressMonitor monitor) {
        final PictogramElement[] selections = this.getSelectedPictogramElements();
        try {
            this.saveInProgress = true;
            super.doSave(monitor);
        }
        finally {
            this.saveInProgress = false;
        }
        Resource resource = this.getResourceSet().getResource(this.modelUri, false);
        BPMN2ProjectValidator.validateOnSave((Resource)resource, (IProgressMonitor)monitor);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPMN2Editor.this.selectPictogramElements(selections);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return this.getModelFile() != null;
    }

    public void doSaveAs() {
        IFile oldFile = this.getModelFile();
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(oldFile);
        saveAsDialog.create();
        if (saveAsDialog.open() == 1) {
            return;
        }
        IPath newFilePath = saveAsDialog.getResult();
        if (newFilePath == null) {
            return;
        }
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
        IWorkbenchPage page = this.getSite().getPage();
        try {
            if (newFile.exists()) {
                IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)newFile);
                if (editorPart != null) {
                    page.closeEditor(editorPart, false);
                }
                newFile.delete(true, null);
            }
            oldFile.copy(newFilePath, true, null);
        }
        catch (CoreException e) {
            this.showErrorDialogWithLogging((Exception)((Object)e));
            return;
        }
        URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
        this.handleResourceMoved((Resource)this.bpmnResource, newURI);
        this.doSave(null);
    }

    public void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean closed = BPMN2Editor.this.getSite().getPage().closeEditor((IEditorPart)BPMN2Editor.this, false);
                if (!closed) {
                    IFile oldFile = ResourcesPlugin.getWorkspace().getRoot().getFile(BPMN2Editor.this.getModelPath());
                    IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)BPMN2Editor.this.getSite().getPage(), (IFile)oldFile);
                    closed = BPMN2Editor.this.getSite().getPage().closeEditor(editorPart, false);
                }
            }
        });
    }

    private void showErrorDialogWithLogging(Exception e) {
        Status status = new Status(4, "org.eclipse.bpmn2.modeler.ui", e.getMessage(), (Throwable)e);
        ErrorUtils.showErrorWithLogging((IStatus)status);
    }

    public boolean handleResourceChanged(Resource resource) {
        URI newURI;
        if (resource == this.bpmnResource && !this.modelUri.equals(newURI = resource.getURI())) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            this.modelUri = newURI;
            if (this.preferences != null) {
                this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                this.preferences.dispose();
                this.preferences = null;
            }
            this.targetRuntime = null;
            this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            input.updateUri(newURI);
            this.multipageEditor.setInput((IEditorInput)input);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BPMN2Editor.this.getEditorInput() != null) {
                    BPMN2Editor.this.updateDirtyState();
                    BPMN2Editor.this.refreshTitle();
                }
            }
        });
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        this.closeEditor();
        return true;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        URI oldURI = resource.getURI();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            for (EReference r : o.eClass().getEAllReferences()) {
                o.eGet((EStructuralFeature)r);
            }
        }
        resource.setURI(newURI);
        if (resource == this.bpmnResource) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            this.modelUri = newURI;
            if (this.preferences != null) {
                this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                this.preferences.dispose();
                this.preferences = null;
            }
            this.targetRuntime = null;
            this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            input.updateUri(newURI);
            this.multipageEditor.setInput((IEditorInput)input);
            this.handleResourceChanged(resource);
        } else if (this.diagramUri.equals(oldURI)) {
            ModelHandlerLocator.remove((URI)this.diagramUri);
            this.diagramUri = newURI;
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
        this.getPreferences().reload();
        if (event.getKey().contains("/model.enablement/")) {
            this.modelEnablements = null;
        }
        if ((event.getKey().contains("show.advanced.properties") || event.getKey().contains("/tool.profile/")) && tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        if (event.getKey().contains("/shape.style/")) {
            int i = event.getKey().lastIndexOf(47);
            if (i <= 0) {
                return;
            }
            final String name = event.getKey().substring(i + 1);
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    IFeatureProvider fp = BPMN2Editor.this.getDiagramTypeProvider().getFeatureProvider();
                    Graphiti.getPeService();
                    Resource resource = BPMN2Editor.this.getDiagramTypeProvider().getDiagram().eResource();
                    for (PictogramElement pe : ModelUtil.getAllObjectsOfType((Resource)resource, PictogramElement.class)) {
                        UpdateContext context;
                        IUpdateFeature feature;
                        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
                        if (be == null || !be.eClass().getName().equals(name)) continue;
                        GraphicsAlgorithm ga = StyleUtil.getShapeStyleContainer((PictogramElement)pe);
                        String style = ShapeStyle.encode((ShapeStyle)ShapeStyle.getShapeStyle((BaseElement)be));
                        if (!style.equals(event.getNewValue())) continue;
                        StyleUtil.applyStyle((GraphicsAlgorithm)ga, (BaseElement)be);
                        if (!(pe instanceof Shape) || !FeatureSupport.isLabelShape((PictogramElement)((Shape)pe)) || (feature = fp.getUpdateFeature((IUpdateContext)(context = new UpdateContext(pe)))) == null || !feature.canUpdate((IUpdateContext)context)) continue;
                        feature.update((IUpdateContext)context);
                    }
                }
            });
        }
        if (event.getKey().contains(ShapeStyle.Category.GRID.toString())) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    ShapeStyle ss = BPMN2Editor.this.getPreferences().getShapeStyle(ShapeStyle.Category.GRID);
                    Diagram diagram = BPMN2Editor.this.getDiagramTypeProvider().getDiagram();
                    diagram.setGridUnit(ss.getDefaultWidth());
                    diagram.setVerticalGridUnit(ss.getDefaultHeight());
                    diagram.setSnapToGrid(ss.getSnapToGrid());
                    GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
                    IGaService gaService = Graphiti.getGaService();
                    ga.setForeground(gaService.manageColor(diagram, ss.getShapeForeground()));
                    BPMN2Editor.this.refresh();
                    BPMN2Editor.this.getGraphicalControl().redraw();
                }
            });
        }
        if (event.getKey().contains(ShapeStyle.Category.CANVAS.toString())) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    ShapeStyle ss = BPMN2Editor.this.getPreferences().getShapeStyle(ShapeStyle.Category.CANVAS);
                    Diagram diagram = BPMN2Editor.this.getDiagramTypeProvider().getDiagram();
                    GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
                    IGaService gaService = Graphiti.getGaService();
                    ga.setBackground(gaService.manageColor(diagram, ss.getShapeBackground()));
                    BPMN2Editor.this.refresh();
                    BPMN2Editor.this.getGraphicalControl().redraw();
                }
            });
        }
    }

    public static BPMN2Editor findOpenEditor(IEditorPart newEditor, IEditorInput newInput) {
        if (newEditor != null && newInput != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference[] otherEditors;
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = otherEditors = page.findEditors(newInput, null, 1);
                int n3 = otherEditors.length;
                int n4 = 0;
                while (n4 < n3) {
                    BPMN2Editor otherEditor;
                    IEditorReference ref = iEditorReferenceArray[n4];
                    IEditorPart part = ref.getEditor(true);
                    if (part instanceof BPMN2MultiPageEditor ? (otherEditor = ((BPMN2MultiPageEditor)part).getDesignEditor()) != newEditor : part instanceof BPMN2Editor && (otherEditor = (BPMN2Editor)part) != newEditor) {
                        return otherEditor;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEditorPart openEditor(URI modelURI) {
        IEditorPart part = null;
        try {
            Bpmn2DiagramEditorInput input = BPMN2DiagramCreator.createDiagram(modelURI, ModelUtil.Bpmn2DiagramType.NONE, "");
            part = BPMN2DiagramCreator.openEditor(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return part;
    }

    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }
}

