/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemAwareElementPropertiesAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class DataInputPropertiesAdapter
extends ItemAwareElementPropertiesAdapter<DataInput> {
    public DataInputPropertiesAdapter(AdapterFactory adapterFactory, DataInput object) {
        super(adapterFactory, object);
        EAttribute f = Bpmn2Package.eINSTANCE.getDataInput_Name();
        FeatureDescriptor<DataInput> fd = new FeatureDescriptor<DataInput>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)f){

            public void setTextValue(String text) {
                int i = text.lastIndexOf("/");
                if (i >= 0) {
                    text = text.substring(i + 1);
                }
                text = text.trim();
                ((DataInput)this.object).setName(text);
            }

            public String getChoiceString(Object context) {
                DataInput dataInput = (DataInput)this.adopt(context);
                String text = dataInput.getName();
                if (text == null || text.isEmpty()) {
                    text = dataInput.getId();
                }
                if (text != null) {
                    String type;
                    if (dataInput.isIsCollection()) {
                        text = String.valueOf(text) + "[]";
                    }
                    if ((type = ExtendedPropertiesProvider.getTextValue((EObject)dataInput.getItemSubjectRef())) != null) {
                        text = String.valueOf(text) + " (" + type + ")";
                    }
                }
                return text;
            }
        };
        this.setFeatureDescriptor((EStructuralFeature)f, (FeatureDescriptor)fd);
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<DataInput>((ExtendedPropertiesAdapter)this, object, (FeatureDescriptor)fd){
            private final /* synthetic */ FeatureDescriptor val$fd;
            {
                this.val$fd = featureDescriptor;
                super($anonymous0, (EObject)$anonymous1);
            }

            public void setTextValue(String text) {
                this.val$fd.setTextValue(text);
                ModelUtil.setID((EObject)this.object);
            }

            public String getTextValue() {
                return this.val$fd.getChoiceString((Object)this.object);
            }
        });
    }

    public static DataInput createDataInput(Resource resource, List<DataInput> dataInputs) {
        DataInput dataInput = (DataInput)Bpmn2ModelerFactory.create((Resource)resource, DataInput.class);
        dataInput.setName(DataInputPropertiesAdapter.generateName(dataInputs));
        dataInputs.add(dataInput);
        return dataInput;
    }

    public static String generateName(List<DataInput> dataInputs) {
        String base = "input";
        int suffix = 1;
        String name = String.valueOf(base) + suffix;
        while (true) {
            boolean found = false;
            for (DataInput p : dataInputs) {
                if (!name.equals(p.getName())) continue;
                found = true;
                break;
            }
            if (!found) break;
            name = String.valueOf(base) + ++suffix;
        }
        return name;
    }
}

