/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class RemoveConnectionInfoAction
extends SortableSelectionAction
implements IConnectionAction {
    private static final String label = DatatoolsUiConstants.UTIL.getString("SetConnectionProfileAction.title", new Object[0]);
    private ConnectionInfoHelper helper;

    public RemoveConnectionInfoAction() {
        super(label, -1);
        this.setImageDescriptor(DatatoolsUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/remove-connection.png"));
        this.helper = new ConnectionInfoHelper();
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection) && this.hasConnectionInfo(selection);
    }

    public void run() {
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Remove Connection Info", (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)modelFile, (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    ModelResource modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                    this.helper.clearConnectionInfo(modelResource);
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)DatatoolsUiConstants.UTIL.getString("RemoveConnectionInfoAction.exceptionMessage", new Object[0]), (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("RemoveConnectionInfoAction.exceptionMessage", new Object[0]), (Throwable)e);
                DatatoolsUiConstants.UTIL.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection) && this.hasConnectionInfo(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    private boolean hasConnectionInfo(ISelection selection) {
        try {
            ModelResource mr = this.getSelectedModel(selection);
            return this.helper.hasConnectionInfo(mr);
        }
        catch (ModelWorkspaceException e) {
            Status status = new Status(4, "org.teiid.designer.datatools.ui", DatatoolsUiConstants.UTIL.getString("RemoveConnectionInfoAction.exceptionMessage", new Object[0]), (Throwable)e);
            DatatoolsUiConstants.UTIL.log((IStatus)status);
            return false;
        }
    }

    private ModelResource getSelectedModel(ISelection selection) throws ModelWorkspaceException {
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)selection).get(0);
        return ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
    }
}

