/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices.util;

import java.util.Properties;
import org.teiid.designer.webservice.WebServicePlugin;

public class SecurityCredentials {
    private static final String I18N_PREFIX = "WebArchiveBuilder.";
    private String securityType;
    private String securityRealm;
    private String securityRole;
    private String securityUsername;
    private String securityPassword;

    public SecurityCredentials(Properties properties) {
        this.securityType = properties.getProperty("securityType");
        this.securityRealm = properties.getProperty("securityRealm");
        this.securityRole = properties.getProperty("securityRole");
        this.securityUsername = properties.getProperty("securityUsername");
        this.securityPassword = properties.getProperty("securityPassword");
    }

    protected static String getString(String id) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, new Object[0]);
    }

    public boolean hasType(String type) {
        return this.securityType != null && this.securityType.equals(type);
    }

    public String getSecurityType() {
        return this.securityType;
    }

    private void checkSecurityType() throws Exception {
        if (this.getSecurityType() == null) {
            throw new Exception(SecurityCredentials.getString("WebArchiveCreationFailed_SecurityTypeNotDefined"));
        }
    }

    public String getSecurityRealm() throws Exception {
        this.checkSecurityType();
        if (this.securityRealm == null) {
            throw new Exception(SecurityCredentials.getString("WebArchiveCreationFailed_SecurityRealmNotDefined"));
        }
        return this.securityRealm;
    }

    public String getSecurityRole() throws Exception {
        this.checkSecurityType();
        if (this.securityRole == null) {
            throw new Exception(SecurityCredentials.getString("WebArchiveCreationFailed_SecurityRoleNotDefined"));
        }
        return this.securityRole;
    }

    public String getSecurityUsername() throws Exception {
        this.checkSecurityType();
        if (this.securityUsername == null) {
            throw new Exception(SecurityCredentials.getString("WebArchiveCreationFailed_SecurityUsernameNotDefined"));
        }
        return this.securityUsername;
    }

    public String getSecurityPassword() throws Exception {
        this.checkSecurityType();
        if (this.securityPassword == null) {
            throw new Exception(SecurityCredentials.getString("WebArchiveCreationFailed_SecurityPasswordNotDefined"));
        }
        return this.securityPassword;
    }
}

