/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.webservices.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.TempDirectory;
import org.teiid.designer.DesignerSPIPlugin;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.ui.wizards.webservices.WarDeploymentInfoPanel;
import org.teiid.designer.runtime.ui.wizards.webservices.util.RestProcedure;
import org.teiid.designer.runtime.ui.wizards.webservices.util.SecurityCredentials;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WarArchiveUtil;
import org.teiid.designer.runtime.ui.wizards.webservices.util.WebArchiveBuilder;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.lib.WebServiceLibConstants;
import org.teiid.designer.webservice.lib.WebServiceLibPlugin;
import org.teiid.designer.webservice.util.AntTasks;

public class RestWebArchiveBuilderImpl
implements WebArchiveBuilder,
WebServiceLibConstants,
StringConstants {
    private IPath webServicePluginPath = null;
    private List<String> models = new ArrayList<String>();
    private Map<String, List<RestProcedure>> modelMapOfProcedures = new HashMap<String, List<RestProcedure>>();
    File webXmlFile = null;
    public static String NEWLINE = System.getProperty("line.separator");
    private static final String I18N_PREFIX = "WebArchiveBuilder.";
    private static final String TASK_CREATE_DIRECTORIES = RestWebArchiveBuilderImpl.getString("taskCreateDirectory");
    private static final String TASK_COPYING_FILES = RestWebArchiveBuilderImpl.getString("taskCopyingFiles");
    private static final String TASK_CREATING_WAR_ARCHIVE = RestWebArchiveBuilderImpl.getString("taskCreatingWarArchive");
    private static final String TASK_COPYING_WAR_FILE = RestWebArchiveBuilderImpl.getString("taskCopyingWarFile");
    private static final String TASK_CLEANUP = RestWebArchiveBuilderImpl.getString("taskCleanup");
    private static final String JNDI_PREFIX = "java:";

    protected RestWebArchiveBuilderImpl() {
    }

    public Map<String, List<RestProcedure>> getModelMapOfProcedures() {
        return this.modelMapOfProcedures;
    }

    public void setModelMapOfProcedures(Map<String, List<RestProcedure>> modelMapOfProcedures) {
        this.modelMapOfProcedures = modelMapOfProcedures;
    }

    @Override
    public IStatus validateContextName(String contextName) {
        try {
            URLValidator urlValidator = new URLValidator();
            String[] invalidChars = new String[]{"/", "\\", CoreStringUtil.Constants.SPACE};
            String invalidChar = this.validateInvalidCharactersInContextName(contextName, invalidChars);
            if (invalidChar != null) {
                String msg = null;
                if (CoreStringUtil.Constants.SPACE.equals(invalidChar)) {
                    msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidSpace");
                } else {
                    Object[] params = new Object[]{invalidChar};
                    msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidCharacter", params);
                }
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            if ("".equals(contextName)) {
                String msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationFailed_Empty");
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            if (!urlValidator.isValidValue("http://www.teiid.org/" + contextName)) {
                String msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
                return new Status(4, "org.teiid.designer.webservice", 1, msg, null);
            }
            String msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationSucceeded");
            return new Status(0, "org.teiid.designer.webservice", 2, msg, null);
        }
        catch (Exception e) {
            String msg = RestWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
            return new Status(4, "org.teiid.designer.webservice", 1, msg, (Throwable)e);
        }
    }

    @Override
    public IStatus createWebArchive(Properties properties, IProgressMonitor monitor) {
        IStatus status;
        try {
            String contextName = (String)properties.get("ContextName");
            status = this.validateContextName(contextName);
            if (4 == status.getSeverity()) {
                throw new Exception(status.getException());
            }
            this.modelMapOfProcedures = (Map)properties.get("RESTProcedures");
            this.setModels(this.modelMapOfProcedures);
            String webServicePluginPath = WebServiceLibPlugin.getDefault().getInstallPath().toOSString();
            String buildDirectoryName = String.valueOf(webServicePluginPath) + File.separator + "rest_war_build";
            File buildDirectory = new File(buildDirectoryName);
            buildDirectory.mkdir();
            monitor.subTask(TASK_CREATE_DIRECTORIES);
            String workDirectoryName = String.valueOf(buildDirectoryName) + File.separator + "work";
            File workDirectory = new File(workDirectoryName);
            workDirectory.mkdir();
            FileUtils.removeChildrenRecursively((File)workDirectory);
            TempDirectory tempDir = TempDirectory.getTempDirectory((String)workDirectoryName);
            String tempDirectoryName = tempDir.getPath();
            String contextDirectoryName = String.valueOf(tempDirectoryName) + File.separator + contextName;
            File contextDirectory = new File(contextDirectoryName);
            contextDirectory.mkdir();
            String webInfDirectoryName = String.valueOf(contextDirectoryName) + File.separator + "WEB-INF";
            File webInfDirectory = new File(webInfDirectoryName);
            webInfDirectory.mkdir();
            String webInfClassesDirectoryName = String.valueOf(webInfDirectoryName) + File.separator + "classes";
            String webInfLibDirectoryName = String.valueOf(webInfDirectoryName) + File.separator + "lib";
            File webInfClassesDirectory = new File(webInfClassesDirectoryName);
            File webInfLibDirectory = new File(webInfLibDirectoryName);
            webInfLibDirectory.mkdir();
            webInfClassesDirectory.mkdir();
            monitor.worked(10);
            monitor.subTask(TASK_COPYING_FILES);
            this.getWebFiles(contextDirectory, webInfDirectory);
            SecurityCredentials securityCredentials = new SecurityCredentials(properties);
            if (securityCredentials.hasType(WarDeploymentInfoPanel.BASIC)) {
                this.replaceJBossWebXmlVariables(webInfDirectoryName, securityCredentials.getSecurityRealm());
            }
            this.replaceWebXmlVariables(webInfDirectoryName, securityCredentials, contextName);
            this.createPropertiesFile(webInfClassesDirectory, properties);
            this.createResourceJavaClasses(contextDirectory, webInfLibDirectory, webInfClassesDirectory, properties);
            monitor.worked(10);
            monitor.subTask(TASK_CREATING_WAR_ARCHIVE);
            String warFileName = String.valueOf(tempDirectoryName) + File.separator + contextName + ".war";
            AntTasks.zip((String)contextDirectoryName, (String)warFileName);
            monitor.worked(20);
            String newWarFileDir = (String)properties.get("WARFileSaveLocation");
            File newWarDir = new File(newWarFileDir);
            if (!newWarDir.exists()) {
                newWarDir.mkdir();
            }
            monitor.subTask(TASK_COPYING_WAR_FILE);
            File warFile = new File(warFileName);
            String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), String.valueOf(contextName) + ".war");
            File newWarFile = new File(newWarFileName);
            if (newWarFile.exists() && !newWarFile.delete()) {
                String msg = RestWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotDeleteExistingWARFile");
                throw new Exception(msg);
            }
            if (!warFile.renameTo(newWarFile)) {
                String msg = RestWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotSaveWARFile");
                throw new Exception(msg);
            }
            monitor.subTask(TASK_CLEANUP);
            tempDir.remove();
            monitor.worked(5);
        }
        catch (Exception e) {
            String msg = RestWebArchiveBuilderImpl.getString("WebArchiveCreationFailed");
            Status status2 = new Status(4, "org.teiid.designer.webservice", 5, msg, (Throwable)e);
            WebServicePlugin.Util.log((IStatus)status2);
            return status2;
        }
        String msg = RestWebArchiveBuilderImpl.getString("WebArchiveCreationSucceeded");
        status = new Status(0, "org.teiid.designer.webservice", 6, msg, null);
        return status;
    }

    @Override
    public boolean targetWarFileExists(Properties properties) {
        boolean fileExists = false;
        String contextName = properties.getProperty("ContextName");
        IStatus status = this.validateContextName(contextName);
        if (4 == status.getSeverity()) {
            fileExists = true;
            return fileExists;
        }
        String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), String.valueOf(contextName) + ".war");
        fileExists = new File(newWarFileName).exists();
        return fileExists;
    }

    private static String getString(String id) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, new Object[0]);
    }

    private static String getString(String id, Object[] params) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, params);
    }

    private String validateInvalidCharactersInContextName(String contextName, String[] invalidChars) {
        int numChars = invalidChars.length;
        int charCounter = 0;
        while (charCounter < numChars) {
            String invalidChar = invalidChars[charCounter];
            if (contextName.indexOf(invalidChar) >= 0) {
                return invalidChar;
            }
            ++charCounter;
        }
        return null;
    }

    private String getFileName(String path, String name) {
        String fileName = path;
        if (!fileName.endsWith("/") && !fileName.endsWith("\\")) {
            fileName = String.valueOf(fileName) + File.separator;
        }
        fileName = String.valueOf(fileName) + name;
        return fileName;
    }

    private void getWebFiles(File contextDirectory, File webInfDirectory) throws Exception {
        String webLibPath = WebServiceLibPlugin.getDefault().getRestWebLibDirectoryPath();
        String webAppsDirectoryName = String.valueOf(webLibPath) + File.separator + "webapps";
        File webAppsDirectory = new File(webAppsDirectoryName);
        FileUtils.copyRecursively((File)webAppsDirectory, (File)contextDirectory, null, (boolean)false);
    }

    private void replaceJBossWebXmlVariables(String webInfDirectoryName, String securityDomain) {
        File jbossWebXmlFile = new File(String.valueOf(webInfDirectoryName) + File.separator + "jboss-web.xml");
        String securityDomainNode = "<security-domain>java:/jaas/" + securityDomain + "</security-domain>";
        AntTasks.replace((File)jbossWebXmlFile, (String)"<!--<security-domain>java:/jaas/teiid-security</security-domain>-->", (String)securityDomainNode);
    }

    private String getUrlPatterns() {
        StringBuilder patternStringBuilder = new StringBuilder();
        for (String model : this.models) {
            patternStringBuilder.append("<url-pattern>/").append(model).append("/*</url-pattern>").append(NEWLINE);
        }
        return patternStringBuilder.toString();
    }

    private void replaceWebXmlVariables(String webInfDirectoryName, SecurityCredentials securityCredentials, String contextName) throws Exception {
        this.webXmlFile = new File(String.valueOf(webInfDirectoryName) + File.separator + "web.xml");
        String urlPatterns = this.getUrlPatterns();
        AntTasks.replace((File)this.webXmlFile, (String)"${urlPattern}", (String)urlPatterns);
        if (securityCredentials.hasType(WarDeploymentInfoPanel.BASIC)) {
            AntTasks.replace((File)this.webXmlFile, (String)"<!--<security-constraint>", (String)"\t<security-constraint>");
            AntTasks.replace((File)this.webXmlFile, (String)"${realmName}", (String)securityCredentials.getSecurityRealm());
            AntTasks.replace((File)this.webXmlFile, (String)"${roleName}", (String)securityCredentials.getSecurityRole());
            AntTasks.replace((File)this.webXmlFile, (String)"</login-config>-->", (String)"</login-config>");
        }
        AntTasks.replace((File)this.webXmlFile, (String)"${warname}", (String)contextName);
        AntTasks.replace((File)this.webXmlFile, (String)"${contextName}", (String)contextName);
    }

    private void createPropertiesFile(File webInfClassesDirectory, Properties properties) throws IOException {
        File teiidRestProperties = new File(webInfClassesDirectory + File.separator + "teiidrest.properties");
        String jndiValue = properties.getProperty("jndiName");
        if (jndiValue != null && !jndiValue.startsWith(JNDI_PREFIX)) {
            jndiValue = "java:/" + jndiValue;
        }
        ITeiidServerVersion teiidVersion = ModelerCore.getTeiidServerVersion();
        String version = teiidVersion.toString();
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(teiidRestProperties);
            out = new BufferedWriter(fstream);
            out.write("jndiName=" + jndiValue + NEWLINE);
            out.write("teiidVersion=" + version);
        }
        finally {
            out.close();
        }
    }

    private void createResourceJavaClasses(File contextDirectory, File webInfLibDirectory, File webInfClassesDirectory, Properties properties) throws Exception {
        String pathToResource = "/org" + File.separator + "teiid" + File.separator + "rest" + File.separator + "services";
        String pathToPlugin = "/org" + File.separator + "teiid" + File.separator + "rest";
        String teiidProviderJavaFile = null;
        String vdbFileName = properties.getProperty("VdbFileName");
        String context = properties.getProperty("ContextName");
        String vdbName = vdbFileName.substring(vdbFileName.lastIndexOf(File.separator));
        vdbName = String.valueOf(vdbName.substring(1, vdbName.lastIndexOf("."))) + " VDB";
        ArrayList<File> resources = new ArrayList<File>();
        StringBuilder singletonSb = new StringBuilder();
        for (String resource : this.getModels()) {
            String resourceJavaFilePath = String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToResource + File.separator + resource + ".java";
            FileUtils.copy((String)(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToResource + File.separator + "ResourceTemplate.java"), (String)resourceJavaFilePath, (boolean)true);
            File indexHtml = new File(String.valueOf(contextDirectory.getCanonicalPath()) + File.separator + "index.html");
            File resourceJavaFile = new File(resourceJavaFilePath);
            resources.add(resourceJavaFile);
            ITeiidServerVersion version = ModelerCore.getTeiidServerVersion();
            boolean greaterThan82 = version.isGreaterThan(TeiidServerVersion.Version.TEIID_8_2.get());
            teiidProviderJavaFile = greaterThan82 ? "TeiidRSProviderPost" : "TeiidRSProviderPre";
            AntTasks.replace((File)resourceJavaFile, (String)"${TeiidRSProvider}", (String)("org.teiid.rest.services." + teiidProviderJavaFile));
            AntTasks.replace((File)resourceJavaFile, (String)"${className}", (String)resource);
            AntTasks.replace((File)resourceJavaFile, (String)"${modelName}", (String)("org.teiid.rest.services." + resource));
            AntTasks.replace((File)resourceJavaFile, (String)"${path}", (String)("@Path( \"/" + resource + "\")"));
            AntTasks.replace((File)resourceJavaFile, (String)"${api}", (String)("@Api( value=\"/" + resource + "\", description=\"REST operations\")"));
            String methods = this.generateMethods(resource);
            AntTasks.replace((File)resourceJavaFile, (String)"${httpMethods}", (String)methods);
            AntTasks.replace((File)indexHtml, (String)"${title}", (String)vdbName);
            AntTasks.replace((File)indexHtml, (String)"${context}", (String)context);
            singletonSb.append(String.valueOf(NEWLINE) + "singletons.add(new org.teiid.rest.services." + resource + "());");
        }
        File template = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToResource + File.separator + "ResourceTemplate.java");
        File restPlugin = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToPlugin + File.separator + "RestPlugin.java");
        File teiidProvider = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToResource + File.separator + teiidProviderJavaFile + ".java");
        File teiidRestApplication = new File(String.valueOf(webInfClassesDirectory.getCanonicalPath()) + pathToResource + File.separator + "TeiidRestApplication.java");
        AntTasks.replace((File)teiidRestApplication, (String)"${resources}", (String)singletonSb.toString());
        template.delete();
        String spiPath = DesignerSPIPlugin.getPluginPath();
        File spiFile = new File(spiPath);
        String runtimePath = ModelerCore.getTeiidRuntimePath();
        File runtimeFile = new File(runtimePath);
        JavaCompiler compilerTool = ToolProvider.getSystemJavaCompiler();
        if (compilerTool != null) {
            StandardJavaFileManager fileManager = compilerTool.getStandardFileManager(null, null, null);
            String pathToJar1 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "jackson-core-asl.jar";
            String pathToJar2 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "jackson-jaxrs.jar";
            String pathToJar3 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "jackson-mapper-asl.jar";
            String pathToJar4 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "json.jar";
            String pathToJar5 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "jaxrs-api.jar";
            String pathToJar6 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "saxonhe.jar";
            String pathToJar7 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "swagger-annotations_2.9.1.jar";
            String pathToJar8 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "swagger-core_2.9.1.jar";
            String pathToJar9 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "swagger-jaxrs_2.9.1.jar";
            String pathToJar10 = String.valueOf(webInfLibDirectory.getCanonicalPath()) + File.separator + "swagger-jersey-jaxrs_2.9.1.jar";
            FileUtils.copy((File)spiFile, (File)webInfLibDirectory, (boolean)true);
            FileUtils.copy((File)runtimeFile, (File)webInfLibDirectory, (boolean)true);
            ArrayList<File> classPaths = new ArrayList<File>();
            classPaths.add(new File(pathToJar1));
            classPaths.add(new File(pathToJar2));
            classPaths.add(new File(pathToJar3));
            classPaths.add(new File(pathToJar4));
            classPaths.add(new File(pathToJar5));
            classPaths.add(new File(pathToJar6));
            classPaths.add(new File(pathToJar7));
            classPaths.add(new File(pathToJar8));
            classPaths.add(new File(pathToJar9));
            classPaths.add(new File(pathToJar10));
            classPaths.add(runtimeFile);
            classPaths.add(spiFile);
            fileManager.setLocation(StandardLocation.CLASS_PATH, classPaths);
            ArrayList<File> sourceFileList = new ArrayList<File>();
            for (File resourceClass : resources) {
                sourceFileList.add(resourceClass);
            }
            sourceFileList.add(restPlugin);
            sourceFileList.add(teiidProvider);
            sourceFileList.add(teiidRestApplication);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFileList);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            ArrayList<String> options = new ArrayList<String>();
            JavaCompiler.CompilationTask task = compilerTool.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            task.call();
            List diagnosticList = diagnostics.getDiagnostics();
            for (Diagnostic diagnostic : diagnosticList) {
                diagnostic.getKind();
                if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
                throw new Exception(diagnostic.getMessage(null));
            }
            fileManager.close();
            Boolean includeJars = (Boolean)properties.get("IncludeJars");
            if (!includeJars.booleanValue()) {
                File tempFolder = new File(webInfClassesDirectory + "/tmp");
                File jsonJar = new File(pathToJar4);
                File saxonJar = new File(pathToJar6);
                ArrayList jarsToAdd = new ArrayList();
                jarsToAdd.add(saxonJar);
                jarsToAdd.add(jsonJar);
                jarsToAdd.add(spiFile);
                jarsToAdd.add(runtimeFile);
                Iterator iter = jarsToAdd.iterator();
                while (iter.hasNext()) {
                    FileUtils.copy((File)((File)iter.next()), (File)tempFolder, (boolean)true);
                }
                FileUtils.removeChildrenRecursively((File)webInfLibDirectory);
                jarsToAdd = FileUtils.getFilesForPattern((String)tempFolder.getCanonicalPath(), (String)"", (String)".jar");
                iter = jarsToAdd.iterator();
                while (iter.hasNext()) {
                    FileUtils.copy((File)((File)iter.next()), (File)webInfLibDirectory, (boolean)true);
                }
                tempFolder.delete();
            }
        }
    }

    private String generateMethods(String name) {
        StringBuilder sb = new StringBuilder();
        ArrayList procedureList = (ArrayList)this.modelMapOfProcedures.get(name);
        for (RestProcedure restProcedure : procedureList) {
            if (restProcedure.getProducesAnnotation() != null && restProcedure.getProducesAnnotation().contains("MediaType.APPLICATION_JSON")) {
                this.createJSONMethod(sb, restProcedure);
                continue;
            }
            this.createXMLMethod(sb, restProcedure);
        }
        return sb.toString();
    }

    private void createXMLMethod(StringBuilder sb, RestProcedure restProcedure) {
        this.commonRestMethodLogic(sb, restProcedure, "", true);
        if (restProcedure.getConsumesAnnotation() != null && !restProcedure.getConsumesAnnotation().isEmpty()) {
            sb.append("\tparameterMap = getInputs(is);" + NEWLINE + "\t");
        }
        sb.append("\treturn teiidProvider.execute(\"" + restProcedure.getFullyQualifiedProcedureName() + "\", parameterMap, \"" + restProcedure.getCharSet() + "\", properties);" + NEWLINE + "}" + NEWLINE + "\t");
    }

    private void createJSONMethod(StringBuilder sb, RestProcedure restProcedure) {
        this.commonRestMethodLogic(sb, restProcedure, "json", false);
        if (restProcedure.getConsumesAnnotation() != null && !restProcedure.getConsumesAnnotation().isEmpty()) {
            sb.append("\tparameterMap = getJSONInputs(is, \"" + restProcedure.getCharSet() + "\");" + NEWLINE + "\t");
        }
        sb.append("\tString result = convertStreamToString(teiidProvider.execute(\"" + restProcedure.getFullyQualifiedProcedureName() + "\", parameterMap, \"" + restProcedure.getCharSet() + "\", properties), \"" + restProcedure.getCharSet() + "\");" + NEWLINE + "\t");
        sb.append("\tString json = convertXMLToJSON(result);" + NEWLINE + "\t");
        sb.append("\treturn json;" + NEWLINE + "\t" + "}" + NEWLINE + "\t");
    }

    /*
     * WARNING - void declaration
     */
    private void commonRestMethodLogic(StringBuilder sb, RestProcedure restProcedure, String methodAppendString, boolean isXml) {
        sb.append("@" + restProcedure.getRestMethod().toUpperCase() + NEWLINE + "\t");
        String uri = methodAppendString == "" ? restProcedure.getUri() : String.valueOf(methodAppendString) + "/" + restProcedure.getUri();
        sb.append("@Path( \"/" + uri + "\" )" + NEWLINE + "\t");
        if (restProcedure.getConsumesAnnotation() != null && !restProcedure.getConsumesAnnotation().isEmpty()) {
            sb.append(String.valueOf(restProcedure.getConsumesAnnotation()) + NEWLINE + "\t");
        }
        if (restProcedure.getProducesAnnotation() != null && !restProcedure.getProducesAnnotation().isEmpty()) {
            sb.append(String.valueOf(restProcedure.getProducesAnnotation()) + NEWLINE + "\t");
        }
        if (isXml) {
            sb.append("@ApiOperation(value=\"(XML) " + restProcedure.getProcedureName() + ": " + restProcedure.getDescription() + "\",response=InputStream.class)" + NEWLINE + "\t");
            sb.append("public InputStream " + restProcedure.getProcedureName() + methodAppendString + "( ");
        } else {
            sb.append("@ApiOperation(value=\"(JSON) " + restProcedure.getProcedureName() + ": " + restProcedure.getDescription() + "\",response=String.class)" + NEWLINE + "\t");
            sb.append("public String " + restProcedure.getProcedureName() + methodAppendString + "( ");
        }
        ArrayList<String> pathParams = WarArchiveUtil.getPathParameters(uri);
        int pathParamCount = 0;
        for (String param : pathParams) {
            sb.append("@ApiParam( \"" + param + "\" ) ");
            sb.append("@PathParam( \"" + param + "\" ) String " + param);
            if (++pathParamCount >= pathParams.size()) continue;
            sb.append(", ");
        }
        LinkedList<Object> headerParamList = new LinkedList();
        if (this.hasHeaders(restProcedure)) {
            int headerParamCount = 0;
            headerParamList = restProcedure.getHeaderParameterList();
            for (String string : headerParamList) {
                sb.append("@HeaderParam( \"" + string + "\" ) String " + string);
                if (++headerParamCount >= headerParamList.size()) continue;
                sb.append(", ");
            }
            if (this.hasQueryParameters(restProcedure)) {
                sb.append(", ");
            }
        }
        LinkedList<Object> queryParamList = new LinkedList();
        if (pathParamCount == 0 && this.hasQueryParameters(restProcedure)) {
            boolean bl = false;
            queryParamList = restProcedure.getQueryParameterList();
            for (String string : queryParamList) {
                void var10_21;
                sb.append("@QueryParam( \"" + string + "\" ) String " + string);
                if (++var10_21 >= queryParamList.size()) continue;
                sb.append(", ");
            }
        }
        if (restProcedure.getConsumesAnnotation() != null && !restProcedure.getConsumesAnnotation().isEmpty()) {
            if (pathParams.size() > 0 || headerParamList.size() > 0 || queryParamList.size() > 0) {
                sb.append(", ");
            }
            sb.append(" InputStream is ) { " + NEWLINE + "\t");
        } else {
            sb.append(" ) { " + NEWLINE + "\t");
        }
        sb.append("\tMap<String, String> parameterMap = getParameterMap();" + NEWLINE + "\t");
        if (headerParamList.size() > 0) {
            for (String string : headerParamList) {
                sb.append("\tparameterMap.put(\"" + string + "\", " + string + ");" + NEWLINE + "\t");
            }
        }
        if (pathParams.size() > 0) {
            for (String string : pathParams) {
                sb.append("\tparameterMap.put(\"" + string + "\", " + string + ");" + NEWLINE + "\t");
            }
        }
        if (queryParamList.size() > 0) {
            for (String string : queryParamList) {
                sb.append("\tparameterMap.put(\"" + string + "\", " + string + ");" + NEWLINE + "\t");
            }
        }
    }

    private boolean hasQueryParameters(RestProcedure restProcedure) {
        return restProcedure.getQueryParameterList() != null && restProcedure.getQueryParameterList().size() > 0;
    }

    private boolean hasHeaders(RestProcedure restProcedure) {
        return restProcedure.getHeaderParameterList() != null && restProcedure.getHeaderParameterList().size() > 0;
    }

    public void setModels(Map<String, List<RestProcedure>> modelToProcedureMap) {
        Set<String> modelNameSet = modelToProcedureMap.keySet();
        this.models = new ArrayList<String>(modelNameSet);
    }

    public List<String> getModels() {
        return this.models;
    }

    class URLValidator
    implements Serializable {
        private static final long serialVersionUID = -4756137226908808631L;

        URLValidator() {
        }

        public boolean isValidValue(Object value) {
            if (value instanceof String) {
                try {
                    new URL(value.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return true;
            }
            return value instanceof URL;
        }
    }
}

