/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.ui.IMemento;

public class TeiidServerPreviewOptionContributor {
    public static String PREVIEW_OPTIONS_PROPERTY = "PreviewOptionsProperty";
    private static TeiidServerPreviewOptionContributor instance;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final String MENU_MEMENTO = "menu-settings";
    private static final String SHOW_PREVIEW_VDBS = "show-preview-vdbs";
    private static final String SHOW_PREVIEW_DATA_SOURCES = "show-preview-data-sources";
    private PreviewOptions previewOptions = new PreviewOptions(false, false);

    public static TeiidServerPreviewOptionContributor getDefault() {
        if (instance == null) {
            instance = new TeiidServerPreviewOptionContributor();
        }
        return instance;
    }

    public boolean isShowPreviewDataSources() {
        return this.previewOptions.isShowPreviewDataSources();
    }

    public boolean isShowPreviewVdbs() {
        return this.previewOptions.isShowPreviewVdbs();
    }

    public void setShowPreviewOptions(boolean showPreviewDataSources, boolean showPreviewVdbs) {
        PreviewOptions oldValue = this.previewOptions;
        this.previewOptions = new PreviewOptions(showPreviewDataSources, showPreviewVdbs);
        if (!oldValue.equals(this.previewOptions)) {
            this.propertyChangeSupport.firePropertyChange(PREVIEW_OPTIONS_PROPERTY, oldValue, this.previewOptions);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void saveState(IMemento memento) {
        IMemento menuMemento = memento.createChild(MENU_MEMENTO);
        menuMemento.putBoolean(SHOW_PREVIEW_DATA_SOURCES, this.previewOptions.isShowPreviewDataSources());
        menuMemento.putBoolean(SHOW_PREVIEW_VDBS, this.previewOptions.isShowPreviewVdbs());
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento childMemento = memento.getChild(MENU_MEMENTO);
        if (childMemento == null) {
            return;
        }
        this.setShowPreviewOptions(childMemento.getBoolean(SHOW_PREVIEW_DATA_SOURCES), childMemento.getBoolean(SHOW_PREVIEW_VDBS));
    }

    public static class PreviewOptions {
        private final boolean showPreviewVdbs;
        private final boolean showPreviewDataSources;

        public PreviewOptions(boolean showPreviewDataSources, boolean showPreviewVdbs) {
            this.showPreviewDataSources = showPreviewDataSources;
            this.showPreviewVdbs = showPreviewVdbs;
        }

        public boolean isShowPreviewDataSources() {
            return this.showPreviewDataSources;
        }

        public boolean isShowPreviewVdbs() {
            return this.showPreviewVdbs;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.showPreviewDataSources ? 1231 : 1237);
            result = 31 * result + (this.showPreviewVdbs ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreviewOptions other = (PreviewOptions)obj;
            if (this.showPreviewDataSources != other.showPreviewDataSources) {
                return false;
            }
            return this.showPreviewVdbs == other.showPreviewVdbs;
        }
    }
}

