/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class TeiidImporterTimeoutPreferenceContributor
implements IGeneralPreferencePageContributor,
DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TeiidImporterTimeoutPreferenceContributor.class);
    private Text timeoutSecTextField;

    public void createPreferenceEditor(Composite theParent) {
        Composite pnl = new Composite(theParent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData());
        this.timeoutSecTextField = WidgetFactory.createTextField((Composite)pnl, (int)768, (int)1);
        this.timeoutSecTextField.setToolTipText(this.getToolTip());
        Label label = new Label(pnl, 0);
        label.setText(this.getName());
        label.setToolTipText(this.getToolTip());
        this.refresh();
    }

    public String getName() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IEclipsePreferences getPreferences() {
        return DqpPlugin.getInstance().getPreferences();
    }

    public String getToolTip() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performDefaults() {
        this.timeoutSecTextField.setText("120");
        try {
            this.getPreferences().flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean performOk() {
        IEclipsePreferences prefs = this.getPreferences();
        String timeoutStr = this.timeoutSecTextField.getText();
        if (!CoreStringUtil.isEmpty((String)timeoutStr)) {
            try {
                Integer.parseInt(timeoutStr);
                prefs.put("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", timeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                prefs.put("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", "120");
            }
        } else {
            prefs.put("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", "120");
        }
        try {
            prefs.flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void refresh() {
        IEclipsePreferences prefs = this.getPreferences();
        String timeoutSec = prefs.get("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", "120");
        this.timeoutSecTextField.setText(timeoutSec);
    }

    public void setPreferencePage(PreferencePage preferencePage) {
    }

    public void setWorkbench(IWorkbench theWorkbench) {
    }
}

