/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.dialogs;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.metamodels.relational.aspects.sql.ProcedureParameterAspect;
import org.teiid.designer.runtime.ui.DqpUiConstants;

public class ParameterValueValidator
implements DqpUiConstants {
    private static final IStatus EMPTY_STATUS = new Status(4, "org.teiid.designer.dqp.ui", 0, UTIL.getString(String.valueOf(I18nUtil.getPropertyPrefix(ParameterValueValidator.class)) + "emptyValue", new Object[0]), null);
    private static final IStatus LENGTH_ERROR_STATUS = new Status(4, "org.teiid.designer.dqp.ui", 0, UTIL.getString(String.valueOf(I18nUtil.getPropertyPrefix(ParameterValueValidator.class)) + "maxLengthExceeded", new Object[0]), null);

    public static boolean canBeNull(EObject param) {
        if (param instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)param).isNillable();
        }
        SqlAspect aspect = SqlAspectHelper.getSqlAspect((EObject)param);
        if (aspect instanceof SqlColumnAspect) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)aspect;
            return columnAspect.getNullType(param) == 1;
        }
        if (aspect instanceof ProcedureParameterAspect) {
            ProcedureParameterAspect paramAspect = (ProcedureParameterAspect)aspect;
            return paramAspect.getNullType(param) == 1;
        }
        return false;
    }

    public static IStatus isValidValue(EObject object, String value) {
        XSDSimpleTypeDefinition.Assessment assessment;
        Collection diagnostics;
        Status status = null;
        XSDTypeDefinition dataType = null;
        if (value == null) {
            if (ParameterValueValidator.canBeNull(object)) {
                return null;
            }
            return EMPTY_STATUS;
        }
        if (CoreStringUtil.isEmpty((String)value)) {
            return EMPTY_STATUS;
        }
        if (object instanceof XSDElementDeclaration) {
            dataType = ((XSDElementDeclaration)object).getTypeDefinition();
        } else {
            SqlAspect aspect = SqlAspectHelper.getSqlAspect((EObject)object);
            if (aspect instanceof SqlColumnAspect) {
                SqlColumnAspect columnAspect = (SqlColumnAspect)aspect;
                if (columnAspect.getLength(object) > 0 && value.length() > columnAspect.getLength(object)) {
                    return LENGTH_ERROR_STATUS;
                }
                dataType = columnAspect.getDatatype(object);
            } else if (aspect instanceof ProcedureParameterAspect) {
                ProcedureParameterAspect paramAspect = (ProcedureParameterAspect)aspect;
                if (paramAspect.getLength(object) > 0 && value.length() > paramAspect.getLength(object)) {
                    return LENGTH_ERROR_STATUS;
                }
                dataType = paramAspect.getDatatype(object);
            }
        }
        if (dataType instanceof XSDSimpleTypeDefinition && (diagnostics = (assessment = ((XSDSimpleTypeDefinition)dataType).assess(value)).getLocalDiagnostics()) != null && !diagnostics.isEmpty()) {
            for (XSDDiagnostic diagnostic : diagnostics) {
                if (diagnostic.getSeverity() != XSDDiagnosticSeverity.ERROR_LITERAL) continue;
                String name = ModelerCore.getModelEditor().getName(object);
                if (CoreStringUtil.isEmpty((String)name)) {
                    name = object.getClass().getSimpleName();
                }
                String param = UTIL.getString(String.valueOf(I18nUtil.getPropertyPrefix(ParameterValueValidator.class)) + "parameter", new Object[0]);
                String msg = MessageFormat.format(diagnostic.getMessage(), param, name);
                status = new Status(4, "org.teiid.designer.dqp.ui", 0, msg, null);
                break;
            }
        }
        return status;
    }

    private ParameterValueValidator() {
    }
}

