/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.connection.ModelConnectionMapper;
import org.teiid.designer.runtime.connection.TranslatorUtils;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.connection.SelectJndiDataSourceDialog;
import org.teiid.designer.runtime.ui.connection.SelectTranslatorDialog;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.connections.SourceHandler;
import org.teiid.designer.vdb.connections.VdbSourceConnection;

public class VdbSourceConnectionHandler
implements SourceHandler {
    static final String PREFIX = I18nUtil.getPropertyPrefix(VdbSourceConnectionHandler.class);
    private static final String JNDI_PROPERTY_KEY = "jndi-name";
    private static SelectTranslatorAction selectTranslatorAction;
    private static SelectJndiDataSourceAction selectJndiDataSourceAction;
    private static Object[] actions;
    private static boolean initialized;

    static {
        initialized = false;
    }

    static String getString(String stringId) {
        return DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + stringId, new Object[0]);
    }

    public VdbSourceConnection ensureVdbSourceConnection(String sourceModelname, Properties properties) throws Exception {
        CoreArgCheck.isNotNull((Object)properties, (String)"properties");
        ModelConnectionMapper mapper = new ModelConnectionMapper(sourceModelname, properties);
        VdbSourceConnection vdbSourceConnection = null;
        String uuid = ModelerCore.workspaceUuid().toString();
        try {
            vdbSourceConnection = mapper.getVdbSourceConnection(this.getDefaultServer(), uuid);
        }
        catch (ModelWorkspaceException e) {
            DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("VdbSourceConnectionHandler.Error_could_not_find_source_connection_info_for_{0}_model", (Object)sourceModelname));
        }
        return vdbSourceConnection;
    }

    public Object[] getApplicableActions(Object obj) {
        IStructuredSelection sel;
        ITeiidServer defServer;
        if (!initialized) {
            this.initialize();
        }
        if ((defServer = this.getDefaultServer()) == null || !defServer.isConnected()) {
            return null;
        }
        if (obj instanceof IStructuredSelection && (sel = (IStructuredSelection)obj).getFirstElement() instanceof VdbModelEntry && ((VdbModelEntry)sel.getFirstElement()).getType() == ModelType.PHYSICAL_LITERAL.getName()) {
            selectTranslatorAction.setSelection((VdbModelEntry)sel.getFirstElement());
            selectJndiDataSourceAction.setSelection((VdbModelEntry)sel.getFirstElement());
            return actions;
        }
        selectTranslatorAction.setSelection(null);
        selectJndiDataSourceAction.setSelection(null);
        return null;
    }

    private void initialize() {
        selectTranslatorAction = new SelectTranslatorAction(VdbSourceConnectionHandler.getString("selectTranslatorAction.label"));
        selectJndiDataSourceAction = new SelectJndiDataSourceAction(VdbSourceConnectionHandler.getString("selectJndiDataSourceAction.label"));
        ArrayList<Action> actionsList = new ArrayList<Action>();
        actionsList.add(selectTranslatorAction);
        actionsList.add(selectJndiDataSourceAction);
        actions = actionsList.toArray();
    }

    public String[] getDataSourceJndiNames() {
        ITeiidServer defaultServer = this.getDefaultServer();
        if (defaultServer != null && defaultServer.isConnected()) {
            Collection dataSources = null;
            try {
                dataSources = defaultServer.getDataSources();
            }
            catch (Exception e) {
                DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("VdbSourceConnectionHandler.errorObtainingDataSources", (Object)defaultServer.getHost()));
            }
            if (dataSources != null) {
                ArrayList<String> dataSourceJndiNames = new ArrayList<String>();
                for (ITeiidDataSource dataSource : dataSources) {
                    if (dataSource.isPreview()) continue;
                    String sourceJndiName = dataSource.getPropertyValue(JNDI_PROPERTY_KEY);
                    if (CoreStringUtil.isEmpty((String)sourceJndiName)) {
                        sourceJndiName = dataSource.getName();
                    }
                    dataSourceJndiNames.add(sourceJndiName);
                }
                return dataSourceJndiNames.toArray(new String[dataSourceJndiNames.size()]);
            }
        }
        return null;
    }

    ITeiidServer getDefaultServer() {
        return DqpPlugin.getInstance().getServerManager().getDefaultServer();
    }

    public PropertyDefinition[] getTranslatorDefinitions(String translatorName) {
        return TranslatorUtils.getTranslatorPropertyDefinitions((String)translatorName, (ITeiidTranslator.TranslatorPropertyType)ITeiidTranslator.TranslatorPropertyType.OVERRIDE);
    }

    public String[] getTranslatorTypes() {
        ITeiidServer defaultServer = this.getDefaultServer();
        if (defaultServer != null && defaultServer.isConnected()) {
            Collection translators = null;
            try {
                translators = defaultServer.getTranslators();
            }
            catch (Exception e) {
                DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("VdbSourceConnectionHandler.errorObtainingTranslators", (Object)defaultServer.getHost()));
            }
            if (translators != null) {
                ArrayList<String> translatorTypes = new ArrayList<String>();
                for (ITeiidTranslator translator : translators) {
                    translatorTypes.add(translator.getName());
                }
                return translatorTypes.toArray(new String[translatorTypes.size()]);
            }
        }
        return null;
    }

    class SelectJndiDataSourceAction
    extends Action {
        private VdbModelEntry vdbModelEntry;

        public SelectJndiDataSourceAction(String text) {
            super(text);
        }

        public void setSelection(VdbModelEntry vdbModelEntry) {
            this.vdbModelEntry = vdbModelEntry;
        }

        public void run() {
            if (this.vdbModelEntry != null) {
                Object result;
                String jndiName = this.vdbModelEntry.getSourceInfo().getSource(0).getJndiName();
                SelectJndiDataSourceDialog dialog = new SelectJndiDataSourceDialog(Display.getCurrent().getActiveShell());
                ITeiidDataSource initialSelection = null;
                ITeiidServer defServer = VdbSourceConnectionHandler.this.getDefaultServer();
                if (defServer != null && defServer.isConnected()) {
                    try {
                        initialSelection = defServer.getDataSource(jndiName);
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("VdbSourceConnectionHandler.Error_could_not_find_data_source_for_name", (Object)jndiName));
                    }
                    dialog.setInitialSelection(initialSelection);
                }
                dialog.open();
                if (dialog.getReturnCode() == 0 && (result = dialog.getFirstResult()) != null && result instanceof ITeiidDataSource) {
                    this.vdbModelEntry.setJndiName(0, ((ITeiidDataSource)result).getName());
                }
            }
        }
    }

    class SelectTranslatorAction
    extends Action {
        private VdbModelEntry vdbModelEntry;

        public SelectTranslatorAction(String text) {
            super(text);
        }

        public void setSelection(VdbModelEntry vdbModelEntry) {
            this.vdbModelEntry = vdbModelEntry;
        }

        public void run() {
            if (this.vdbModelEntry != null) {
                Object result;
                String transName = this.vdbModelEntry.getSourceInfo().getSource(0).getTranslatorName();
                SelectTranslatorDialog dialog = new SelectTranslatorDialog(Display.getCurrent().getActiveShell());
                ITeiidTranslator initialSelection = null;
                ITeiidServer defServer = VdbSourceConnectionHandler.this.getDefaultServer();
                if (defServer != null && defServer.isConnected()) {
                    try {
                        initialSelection = defServer.getTranslator(transName);
                    }
                    catch (Exception e) {
                        DqpUiConstants.UTIL.log(4, (Throwable)e, DqpUiConstants.UTIL.getString("VdbSourceConnectionHandler.Error_could_not_find_translator_for_name", (Object)transName));
                    }
                    dialog.setInitialSelection(initialSelection);
                }
                dialog.open();
                if (dialog.getReturnCode() == 0 && (result = dialog.getFirstResult()) != null && result instanceof ITeiidTranslator) {
                    this.vdbModelEntry.setTranslatorName(0, ((ITeiidTranslator)result).getName());
                }
            }
        }
    }

    class TranslatorProperty
    implements PropertyDefinition {
        private final String className;
        boolean advanced;
        String[] allowedValues;
        String defaultValue;
        String description;
        String displayName;
        String id;
        boolean masked;
        boolean modifiable;
        boolean required;

        public TranslatorProperty(String className) {
            this.className = className;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.id.equals(((TranslatorProperty)obj).id);
        }

        public String[] getAllowedValues() {
            return this.allowedValues;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean isAdvanced() {
            return this.advanced;
        }

        public boolean isMasked() {
            return this.masked;
        }

        public boolean isModifiable() {
            return this.modifiable;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String isValidValue(String newValue) {
            if (StringUtilities.isEmpty((String)newValue)) {
                if (this.isRequired() && StringUtilities.isEmpty((String)this.getDefaultValue())) {
                    return DqpPlugin.Util.getString("invalidNullPropertyValue", (Object)this.getDisplayName());
                }
                return null;
            }
            if (Boolean.class.getName().equals(this.className) || Boolean.TYPE.getName().equals(this.className)) {
                if (!newValue.equalsIgnoreCase(Boolean.TRUE.toString()) && !newValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Boolean.TYPE.getName()});
                }
            } else if (Character.class.getName().equals(this.className) || Character.TYPE.getName().equals(this.className)) {
                if (newValue.length() != 1) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Character.TYPE.getName()});
                }
            } else if (Byte.class.getName().equals(this.className) || Byte.TYPE.getName().equals(this.className)) {
                try {
                    Byte.parseByte(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Byte.TYPE.getName()});
                }
            } else if (Short.class.getName().equals(this.className) || Short.TYPE.getName().equals(this.className)) {
                try {
                    Short.parseShort(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Short.TYPE.getName()});
                }
            } else if (Integer.class.getName().equals(this.className) || Integer.TYPE.getName().equals(this.className)) {
                try {
                    Integer.parseInt(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Integer.TYPE.getName()});
                }
            } else if (Long.class.getName().equals(this.className) || Long.TYPE.getName().equals(this.className)) {
                try {
                    Long.parseLong(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Long.TYPE.getName()});
                }
            } else if (Float.class.getName().equals(this.className) || Float.TYPE.getName().equals(this.className)) {
                try {
                    Float.parseFloat(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Float.TYPE.getName()});
                }
            } else if (Double.class.getName().equals(this.className) || Double.TYPE.getName().equals(this.className)) {
                try {
                    Double.parseDouble(newValue);
                }
                catch (Exception exception) {
                    return DqpPlugin.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Double.TYPE.getName()});
                }
            } else if (!String.class.getName().equals(this.className)) {
                return DqpPlugin.Util.getString("unknownPropertyType", new Object[]{this.displayName, this.className});
            }
            return null;
        }
    }
}

