/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.connection.CreateDataSourceWizard;
import org.teiid.designer.runtime.ui.connection.TeiidDataSourceInfo;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.dialog.AbstractPasswordDialog;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class CreateDataSourceAction
extends SortableSelectionAction
implements IConnectionAction,
DqpUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateDataSourceAction.class);
    private static final String label = DqpUiConstants.UTIL.getString("label", new Object[0]);
    private String pwd;
    private ConnectionInfoProviderFactory providerFactory;
    private ITeiidServer cachedServer;

    private static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    public CreateDataSourceAction() {
        super(label, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
        this.providerFactory = new ConnectionInfoProviderFactory();
    }

    public void setTeiidServer(ITeiidServer teiidServer) {
        this.cachedServer = teiidServer;
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
        ModelResource modelResource = null;
        if (!this.getSelection().isEmpty()) {
            IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
            modelResource = ModelUtilities.getModelResource((Object)modelFile);
        }
        try {
            Properties connProps;
            ITeiidServer teiidServer = this.cachedServer;
            if (teiidServer == null) {
                teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                if (teiidServer == null) {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CreateDataSourceAction.getString("noServer.message"), true)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                } else {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CreateDataSourceAction.getString("noServer.message"), false)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                }
            }
            if ((connProps = this.getModelConnectionProperties(modelResource)) == null || connProps.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)CreateDataSourceAction.getString("noInfo.title"), (String)CreateDataSourceAction.getString("noInfo.message", modelResource.getItemName()));
                return;
            }
            Collection<ModelResource> relationalModels = this.getRelationalModelsWithConnections();
            CreateDataSourceWizard dialog = new CreateDataSourceWizard(iww.getShell(), teiidServer, relationalModels, modelResource);
            int rc = dialog.open();
            if (rc != 0) {
                return;
            }
            TeiidDataSourceInfo info = dialog.getTeiidDataSourceInfo();
            Properties props = info.getProperties();
            IConnectionInfoProvider provider = info.getConnectionInfoProvider();
            if (provider == null) return;
            boolean cancelledPassword = false;
            if (provider.getDataSourcePasswordPropertyKey() != null && props.get(provider.getDataSourcePasswordPropertyKey()) == null && info.requiresPassword()) {
                int result = new AbstractPasswordDialog(iww.getShell(), CreateDataSourceAction.getString("passwordTitle"), null){

                    protected boolean isPasswordValid(String password) {
                        CreateDataSourceAction.this.pwd = password;
                        return true;
                    }
                }.open();
                if (result != 0) return;
                props.put(provider.getDataSourcePasswordPropertyKey(), this.pwd);
            }
            if (cancelledPassword) return;
            teiidServer.getOrCreateDataSource(info.getDisplayName(), info.getJndiName(), provider.getDataSourceType(), props);
            return;
        }
        catch (Exception e) {
            if (modelResource != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)CreateDataSourceAction.getString("errorCreatingDataSourceForModel", modelResource.getItemName()), (String)e.getMessage());
                DqpUiConstants.UTIL.log(4, (Throwable)e, CreateDataSourceAction.getString("errorCreatingDataSourceForModel", modelResource.getItemName()));
                return;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)CreateDataSourceAction.getString("errorCreatingDataSource"), (String)e.getMessage());
            DqpUiConstants.UTIL.log(4, (Throwable)e, CreateDataSourceAction.getString("errorCreatingDataSource"));
        }
    }

    private Collection<ModelResource> getRelationalModelsWithConnections() {
        ArrayList<ModelResource> result = new ArrayList<ModelResource>();
        try {
            ModelResource[] mrs;
            ModelResource[] modelResourceArray = mrs = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().getModelResources();
            int n = mrs.length;
            int n2 = 0;
            while (n2 < n) {
                ModelResource mr = modelResourceArray[n2];
                if (ModelIdentifier.isRelationalSourceModel((ModelResource)mr)) {
                    Properties properties;
                    IConnectionInfoProvider provider = null;
                    try {
                        provider = this.getProvider(mr);
                    }
                    catch (Exception exception) {}
                    if (provider != null && (properties = provider.getConnectionProperties(mr)) != null && !properties.isEmpty()) {
                        result.add(mr);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DqpUiConstants.UTIL.log((Throwable)e);
        }
        return result;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public IConnectionInfoProvider getProvider(ModelResource modelResource) throws Exception {
        IConnectionInfoProvider provider = null;
        provider = this.providerFactory.getProvider(modelResource);
        if (provider == null) {
            throw new Exception(CreateDataSourceAction.getString("noConnectionInfoProvider.message"));
        }
        return provider;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    private Properties getModelConnectionProperties(ModelResource mr) {
        block8: {
            try {
                if (!ModelIdentifier.isRelationalSourceModel((ModelResource)mr)) break block8;
                IConnectionInfoProvider provider = null;
                try {
                    provider = this.getProvider(mr);
                }
                catch (Exception exception) {}
                if (provider != null) {
                    Properties properties = provider.getProfileProperties(mr);
                    Properties p2 = provider.getConnectionProperties(mr);
                    String translatorName = provider.getTranslatorName(mr);
                    for (Object key : p2.keySet()) {
                        properties.put(key, p2.get(key));
                    }
                    if (translatorName != null) {
                        properties.put(CreateDataSourceAction.getString("translatorKey"), translatorName);
                    }
                    if (properties != null && !properties.isEmpty()) {
                        return properties;
                    }
                }
            }
            catch (CoreException e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
        }
        return null;
    }
}

