/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.utils;

import io.fabric8.api.CreateContainerOptions;
import io.fabric8.insight.log.LogFilter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.Fabric8CorePlugin;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class JsonHelper {
    public static ModelNode getModelNode(String content) throws Exception {
        if (content == null) {
            throw new Exception("Could not unmarshall response: no content.");
        }
        ModelNode node = ModelNode.fromJSONString((String)content);
        if (!node.isDefined()) {
            throw new Exception("Could not unmarshall response: erroneous content.");
        }
        return node;
    }

    public static String getAsString(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asString() : null;
    }

    public static Long getAsLong(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? Long.valueOf(propertyNode.asLong()) : null;
    }

    public static List<ModelNode> getAsList(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asList() : new ArrayList();
    }

    public static Map<String, String> getAsPropertiesMap(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        List propertyList = propertyNode.isDefined() ? propertyNode.asPropertyList() : new ArrayList();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property prop : propertyList) {
            properties.put(prop.getName(), prop.getValue().asString());
        }
        return properties;
    }

    public static Map<String, Object> getAsMap(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        List propertyList = propertyNode.isDefined() ? propertyNode.asPropertyList() : new ArrayList();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Property prop : propertyList) {
            properties.put(prop.getName(), prop.getValue());
        }
        return properties;
    }

    public static Map<String, Object> getAsMap(ModelNode node) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        block17: for (String key : node.keys()) {
            ModelNode value = node.get(key);
            ModelType t = value.getType();
            block0 : switch (t) {
                case BIG_DECIMAL: {
                    properties.put(key, value.asBigDecimal());
                    break;
                }
                case BIG_INTEGER: {
                    properties.put(key, value.asBigInteger());
                    break;
                }
                case BOOLEAN: {
                    properties.put(key, value.asBoolean(false));
                    break;
                }
                case BYTES: {
                    properties.put(key, value.asBytes());
                    break;
                }
                case DOUBLE: {
                    properties.put(key, value.asDouble(0.0));
                    break;
                }
                case INT: {
                    properties.put(key, value.asInt(0));
                    break;
                }
                case LIST: {
                    List l = value.asList();
                    if (l.isEmpty()) continue block17;
                    ModelNode lo = (ModelNode)l.get(0);
                    switch (lo.getType()) {
                        case STRING: {
                            List<String> listBigDecValue = JsonHelper.getStringList(value);
                            properties.put(key, listBigDecValue);
                            break block0;
                        }
                    }
                    properties.put(key, l);
                    break;
                }
                case LONG: {
                    properties.put(key, value.asLong(0L));
                    break;
                }
                case OBJECT: {
                    properties.put(key, value.asObject());
                    break;
                }
                case PROPERTY: {
                    properties.put(key, value.asProperty());
                    break;
                }
                case STRING: {
                    properties.put(key, value.asString());
                    break;
                }
                case UNDEFINED: {
                    properties.put(key, null);
                    break;
                }
                default: {
                    properties.put(key, value);
                }
            }
        }
        return properties;
    }

    public static List<String> getStringList(ModelNode node) {
        ArrayList<String> result = new ArrayList<String>();
        List l = node.asList();
        for (ModelNode n : l) {
            result.add(n.asString());
        }
        return result;
    }

    public static String[] getAsStringArray(ModelNode node, String propertyName) {
        List<String> result = JsonHelper.getAsStringList(node, propertyName);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> getAsStringList(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        List propertyList = propertyNode.isDefined() ? propertyNode.asPropertyList() : new ArrayList();
        ArrayList<String> result = new ArrayList<String>();
        for (Property p : propertyList) {
            result.add(p.getValue().asString());
        }
        return result;
    }

    public static Map<String, Object> asMap(CreateContainerOptions options) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            BeanInfo info = Introspector.getBeanInfo(options.getClass());
            PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object val;
                Method reader;
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (!pd.getName().equalsIgnoreCase("class") && (reader = pd.getReadMethod()) != null && (val = reader.invoke((Object)options, new Object[0])) != null) {
                    map.put(pd.getName(), val);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            Fabric8CorePlugin.getLogger().error((Throwable)ex);
        }
        return map;
    }

    public static String convertToJson(LogFilter filter) {
        String json = null;
        ModelNode node = new ModelNode();
        try {
            try {
                BeanInfo info = Introspector.getBeanInfo(filter.getClass());
                PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object val;
                    Method reader;
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    if (!pd.getName().equalsIgnoreCase("class") && (reader = pd.getReadMethod()) != null && (val = reader.invoke((Object)filter, new Object[0])) != null) {
                        if (val instanceof Integer) {
                            node.get(pd.getName()).set(((Integer)val).intValue());
                        } else if (val instanceof String[]) {
                            String[] strings;
                            String[] stringArray = strings = (String[])val;
                            int n3 = strings.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String s = stringArray[n4];
                                node.get(pd.getName()).add(s);
                                ++n4;
                            }
                        } else if (val instanceof String) {
                            node.get(pd.getName()).set((String)val);
                        } else if (val instanceof Long) {
                            node.get(pd.getName()).set(((Long)val).longValue());
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                Fabric8CorePlugin.getLogger().error((Throwable)ex);
                json = node.toJSONString(true);
            }
        }
        finally {
            json = node.toJSONString(true);
        }
        return json;
    }
}

