/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class VersionSequenceDTO
implements Comparable<VersionSequenceDTO> {
    private final String name;
    private final int[] numbers;

    public static Comparator<String> getComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String thisId, String thatId) {
                VersionSequenceDTO thisSeq = new VersionSequenceDTO(thisId);
                VersionSequenceDTO thatSeq = new VersionSequenceDTO(thatId);
                return thisSeq.compareTo(thatSeq);
            }
        };
    }

    public VersionSequenceDTO(String name) {
        String[] split;
        this.name = name;
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] stringArray = split = name.split("\\.");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            if ((text = text.trim()).length() > 0) {
                try {
                    int number = Integer.parseInt(text);
                    list.add(number);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        int size = list.size();
        this.numbers = new int[size];
        int i = 0;
        while (i < size) {
            this.numbers[i] = (Integer)list.get(i);
            ++i;
        }
    }

    protected VersionSequenceDTO(VersionSequenceDTO previous) {
        int[] pn = previous.numbers;
        int size = pn.length;
        if (size <= 0) {
            this.numbers = new int[]{1};
        } else {
            this.numbers = Arrays.copyOf(pn, size);
            int n = size - 1;
            this.numbers[n] = this.numbers[n] + 1;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < size) {
            if (i > 0) {
                builder.append(".");
            }
            builder.append(this.numbers[i]);
            ++i;
        }
        this.name = builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionSequenceDTO that = (VersionSequenceDTO)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Arrays.equals(this.numbers, that.numbers);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.numbers);
        return result;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(VersionSequenceDTO that) {
        if (this.equals(that)) {
            return 0;
        }
        int[] n1 = this.numbers;
        int[] n2 = that.numbers;
        int i = 0;
        while (i < n1.length) {
            if (i >= n2.length) {
                return 1;
            }
            int diff = n1[i] - n2[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return n1.length - n2.length;
    }

    public String getName() {
        return this.name;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public VersionSequenceDTO next() {
        return new VersionSequenceDTO(this);
    }
}

