/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.VersionSequenceDTO;

public class VersionDTO
extends BaseDTO {
    private static final String JSON_FIELD_ATTRIBUTES = "attributes";
    private static final String JSON_FIELD_PROFILES = "profiles";
    private static final String JSON_FIELD_PROFILE_IDS = "profileIds";
    private static final String JSON_FIELD_DEFAULT_VERSION = "defaultVersion";
    private static final String JSON_FIELD_REVISION = "revision";
    private String revision = "HEAD";
    private final VersionSequenceDTO sequence = new VersionSequenceDTO(this.getId());

    public VersionDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    public Boolean isDefaultVersion() {
        return (Boolean)this.getFieldValue(JSON_FIELD_DEFAULT_VERSION);
    }

    public List<String> getProfileIds() {
        List profileIds = (List)this.getFieldValue(JSON_FIELD_PROFILE_IDS);
        if (profileIds == null) {
            profileIds = (List)this.getFieldValue(JSON_FIELD_PROFILES);
        }
        return profileIds == null ? new ArrayList() : profileIds;
    }

    public List<ProfileDTO> getProfiles() {
        ArrayList<ProfileDTO> profiles = new ArrayList<ProfileDTO>();
        for (String pid : this.getProfileIds()) {
            ProfileDTO p = this.fabric8.getProfile(this.getId(), pid);
            if (p == null) continue;
            profiles.add(p);
        }
        return profiles;
    }

    public Map<String, Object> getAttributes() {
        return (Map)this.getFieldValue(JSON_FIELD_ATTRIBUTES);
    }

    public VersionSequenceDTO getVersionSequence() {
        return this.sequence;
    }

    public String getRevision() {
        return this.revision;
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void update() {
    }
}

