/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;

public class ProfileDTO
extends BaseDTO {
    private static final String JSON_FIELD_ABSTRACT = "abstract";
    private static final String JSON_FIELD_HIDDEN = "hidden";
    private static final String JSON_FIELD_LOCKED = "locked";
    private static final String JSON_FIELD_OVERLAY = "overlay";
    private static final String JSON_FIELD_CONTAINER_COUNT = "containerCount";
    private static final String JSON_FIELD_ICON_URL = "iconURL";
    private static final String JSON_FIELD_PROFILE_HASH = "profileHash";
    private static final String JSON_FIELD_SUMMARY_MARKDOWN = "summaryMarkdown";
    private static final String JSON_FIELD_VERSION = "version";
    private static final String JSON_FIELD_CHILD_IDS = "childIds";
    private static final String JSON_FIELD_CONTAINERS = "containers";
    private static final String JSON_FIELD_FABS = "fabs";
    private static final String JSON_FIELD_FEATURES = "features";
    private static final String JSON_FIELD_PARENT_IDS = "parentIds";
    private static final String JSON_FIELD_TAGS = "tags";
    private static final String JSON_FIELD_BUNDLES = "bundles";
    private static final String JSON_FIELD_LIBS = "libraries";
    private static final String JSON_FIELD_REPOSITORIES = "repositories";
    private static final String JSON_FIELD_OPTIONALS = "optionals";
    private static final String JSON_FIELD_OVERRIDES = "overrides";
    private static final String JSON_FIELD_ENDORSED_LIBS = "endorsedLibraries";
    private static final String JSON_FIELD_EXTENSION_LIBS = "extensionLibraries";
    private static final String JSON_FIELD_CONFIGS = "configurations";
    private static final String JSON_FIELD_FILE_CONFIGS = "fileConfigurations";
    private static final String JSON_FIELD_CONFIG_FILE_NAMES = "configurationFileNames";
    private static final String JSON_FIELD_PARENTS = "parents";

    public ProfileDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return (Map)this.getFieldValue(JSON_FIELD_CONFIGS);
    }

    public List<String> getExtensionLibraries() {
        return (List)this.getFieldValue(JSON_FIELD_EXTENSION_LIBS);
    }

    public List<String> getEndorsedLibraries() {
        return (List)this.getFieldValue(JSON_FIELD_ENDORSED_LIBS);
    }

    public List<String> getOverrides() {
        return (List)this.getFieldValue(JSON_FIELD_OVERRIDES);
    }

    public List<String> getOptionals() {
        return (List)this.getFieldValue(JSON_FIELD_OPTIONALS);
    }

    public List<String> getRepositories() {
        return (List)this.getFieldValue(JSON_FIELD_REPOSITORIES);
    }

    public List<String> getLibraries() {
        return (List)this.getFieldValue(JSON_FIELD_LIBS);
    }

    public List<String> getBundles() {
        return (List)this.getFieldValue(JSON_FIELD_BUNDLES);
    }

    public Boolean isAbstract() {
        return (Boolean)this.getFieldValue(JSON_FIELD_ABSTRACT);
    }

    public Boolean isHidden() {
        return (Boolean)this.getFieldValue(JSON_FIELD_HIDDEN);
    }

    public Boolean isLocked() {
        return (Boolean)this.getFieldValue(JSON_FIELD_LOCKED);
    }

    public Boolean isOverlay() {
        return (Boolean)this.getFieldValue(JSON_FIELD_OVERLAY);
    }

    public Integer getContainerCount() {
        return (Integer)this.getFieldValue(JSON_FIELD_CONTAINER_COUNT);
    }

    public String getIconUrl() {
        return (String)this.getFieldValue(JSON_FIELD_ICON_URL);
    }

    public String getProfileHash() {
        return (String)this.getFieldValue(JSON_FIELD_PROFILE_HASH);
    }

    public String getSummaryMarkdown() {
        return (String)this.getFieldValue(JSON_FIELD_SUMMARY_MARKDOWN);
    }

    public String getVersionId() {
        return (String)this.getFieldValue(JSON_FIELD_VERSION);
    }

    public List<String> getChildProfileIDs() {
        return (List)this.getFieldValue(JSON_FIELD_CHILD_IDS);
    }

    public List<String> getContainerIDs() {
        return (List)this.getFieldValue(JSON_FIELD_CONTAINERS);
    }

    public List<String> getFabs() {
        return (List)this.getFieldValue(JSON_FIELD_FABS);
    }

    public List<String> getFeatures() {
        return (List)this.getFieldValue(JSON_FIELD_FEATURES);
    }

    public List<String> getParentIDs() {
        return (List)this.getFieldValue(JSON_FIELD_PARENT_IDS);
    }

    public List<ProfileDTO> getParents() {
        ArrayList<ProfileDTO> parents = new ArrayList<ProfileDTO>();
        for (String pId : this.getParentIDs()) {
            ProfileDTO p = this.fabric8.getProfile(this.getVersionId(), pId);
            if (p == null) continue;
            parents.add(p);
        }
        return parents;
    }

    public List<String> getTags() {
        return (List)this.getFieldValue(JSON_FIELD_TAGS);
    }

    public void setOptionals(List<String> optionals) {
        this.setFieldValue(JSON_FIELD_OPTIONALS, optionals);
        this.fabric8.setProfileOptionals(this.getVersionId(), this.getId(), optionals);
    }

    public void setParentIds(List<String> profileIds) {
        this.setFieldValue(JSON_FIELD_PARENT_IDS, profileIds);
        this.fabric8.setProfileParentIds(this.getVersionId(), this.getId(), profileIds);
    }

    public void setParents(List<ProfileDTO> profiles) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ProfileDTO p : profiles) {
            if (p == null || p.getId() == null) continue;
            ids.add(p.getId());
        }
        this.setParentIds(ids);
    }

    public void setBundles(List<String> bundles) {
        this.setFieldValue(JSON_FIELD_BUNDLES, bundles);
        this.fabric8.setProfileBundles(this.getVersionId(), this.getId(), bundles);
    }

    public void setFabs(List<String> fabs) {
        this.setFieldValue(JSON_FIELD_FABS, fabs);
        this.fabric8.setProfileFabs(this.getVersionId(), this.getId(), fabs);
    }

    public void setFeatures(List<String> features) {
        this.setFieldValue(JSON_FIELD_FEATURES, features);
        this.fabric8.setProfileFeatures(this.getVersionId(), this.getId(), features);
    }

    public void setRepositories(List<String> repositories) {
        this.setFieldValue(JSON_FIELD_REPOSITORIES, repositories);
        this.fabric8.setProfileRepositories(this.getVersionId(), this.getId(), repositories);
    }

    public void setOverrides(List<String> overrides) {
        this.setFieldValue(JSON_FIELD_OVERRIDES, overrides);
        this.fabric8.setProfileOverrides(this.getVersionId(), this.getId(), overrides);
    }

    @Override
    public void create() {
        ProfileDTO newProfile = this.fabric8.createProfile(this.getVersionId(), this.getId());
        newProfile.jsonAttribs.putAll(this.jsonAttribs);
        newProfile.update();
    }

    @Override
    public void delete() {
        this.fabric8.deleteProfile(this.getVersionId(), this.getId());
    }

    @Override
    public void update() {
    }
}

