/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.launch;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.run.util.MavenLaunchUtils;
import org.fusesource.ide.launcher.ui.Activator;
import org.fusesource.ide.launcher.ui.launch.ExecutePomActionPostProcessor;
import org.fusesource.ide.launcher.ui.launch.InvalidConfigurationException;

public class ExecutePomActionSupport
implements ILaunchShortcut,
IExecutableExtension {
    private final String launchConfigurationId;
    private final String launchConfigTypeId;
    private final String defaultMavenGoals;
    private String goalName;
    private boolean showDialog = false;
    private ExecutePomActionPostProcessor postProcessor;

    public ExecutePomActionSupport(String launchConfigurationId, String launchConfigTypeId, String defaultMavenGoals) {
        this.launchConfigurationId = launchConfigurationId;
        this.launchConfigTypeId = launchConfigTypeId;
        this.defaultMavenGoals = defaultMavenGoals;
        this.goalName = defaultMavenGoals;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if ("WITH_DIALOG".equals(data)) {
            this.showDialog = true;
        } else {
            this.goalName = (String)data;
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            this.launchCamelContext(((IFileEditorInput)editorInput).getFile(), mode);
        }
    }

    public void setPostProcessor(ExecutePomActionPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public ExecutePomActionPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.launchCamelContext((IFile)object, mode);
        }
    }

    private void launchCamelContext(IFile file, String mode) {
        ILaunchConfiguration launchConfiguration;
        if (file == null) {
            return;
        }
        IContainer basedir = this.findPomXmlBasedir(file.getParent());
        try {
            launchConfiguration = this.getLaunchConfiguration(basedir, mode);
            if (launchConfiguration == null && (launchConfiguration = this.createLaunchConfiguration(basedir, this.defaultMavenGoals)) == null) {
                return;
            }
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            return;
        }
        boolean isWARPackaging = false;
        try {
            isWARPackaging = MavenLaunchUtils.isPackagingTypeWAR((IFile)basedir.getFile(Path.fromOSString((String)"pom.xml")));
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        ILaunchConfigurationWorkingCopy lc = null;
        try {
            lc = launchConfiguration.getWorkingCopy();
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to launch...", (String)("An error occured when trying to launch the project. Message: " + ex.getMessage()));
            return;
        }
        boolean openDialog = this.showDialog;
        if (!openDialog) {
            try {
                String goals = lc.getAttribute("M2_GOALS", null);
                if (Strings.isBlank((String)goals)) {
                    goals = isWARPackaging ? "clean package org.eclipse.jetty:jetty-maven-plugin:run " : "clean package org.apache.camel:camel-maven-plugin:run ";
                } else if (goals.indexOf("clean package") != -1) {
                    goals = goals.replaceAll("clean package", isWARPackaging ? "clean package org.eclipse.jetty:jetty-maven-plugin:run " : "clean package org.apache.camel:camel-maven-plugin:run ");
                } else {
                    String string = goals = isWARPackaging ? "clean package org.eclipse.jetty:jetty-maven-plugin:run " : "clean package org.apache.camel:camel-maven-plugin:run ";
                }
                if (Strings.isBlank((String)lc.getAttribute("rider.file", ""))) {
                    lc.setAttribute("rider.file", file.getLocation().toOSString());
                }
                openDialog = Strings.isBlank((String)goals) || Strings.isBlank((String)lc.getAttribute("rider.file", ""));
                lc.setAttribute("M2_GOALS", goals);
            }
            catch (CoreException ex) {
                Activator.getLogger().error("Error getting the maven goals from the configuration.", (Throwable)ex);
            }
        }
        if (openDialog) {
            String category = "org.fusesource.ide.launcher.ui.runCamelLaunchGroup";
            if (mode == "debug") {
                category = "org.fusesource.ide.launcher.ui.debugCamelLaunchGroup";
            }
            if (DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.getShell(), (ILaunchConfiguration)lc, (String)category, null) == 1) {
                return;
            }
        }
        try {
            final ILaunch launch = lc.launch(mode, (IProgressMonitor)new NullProgressMonitor());
            if (this.postProcessor != null) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!launch.isTerminated()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        IProcess[] processes = launch.getProcesses();
                        boolean failed = false;
                        IProcess[] iProcessArray = processes;
                        int n = processes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess process = iProcessArray[n2];
                            try {
                                if (process.getExitValue() != 0) {
                                    failed = true;
                                    break;
                                }
                            }
                            catch (DebugException e) {
                                Activator.getLogger().error("Failed to get exit code of build process", (Throwable)e);
                            }
                            ++n2;
                        }
                        if (!failed) {
                            ExecutePomActionSupport.this.postProcessor.executeOnSuccess();
                        } else {
                            ExecutePomActionSupport.this.postProcessor.executeOnFailure();
                        }
                    }
                });
                t.setDaemon(false);
                t.start();
            }
        }
        catch (CoreException coreException) {
            DebugUITools.launch((ILaunchConfiguration)lc, (String)mode);
        }
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    /*
     * Exception decompiling
     */
    private IContainer findPomXmlBasedir(IContainer dir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ILaunchConfiguration createLaunchConfiguration(IContainer basedir, String goal) {
        ILaunchConfiguration config = null;
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
            String launchSafeGoalName = goal.replace(':', '-');
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "Executing " + launchSafeGoalName + " in " + basedir.getLocation().toString().replace('/', '-'));
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getLocation().toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${project}");
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, basedir.getProject().getName());
            this.appendAttributes(basedir, workingCopy, goal);
            this.setProjectConfiguration(workingCopy, basedir);
            IPath path = this.getJREContainerPath(basedir);
            if (path != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            workingCopy.setMappedResources(new IResource[]{basedir});
            config = workingCopy.doSave();
            return config;
        }
        catch (CoreException ex) {
            Activator.getLogger().error("Unable to create launch configuration", (Throwable)ex);
            return null;
        }
    }

    protected void appendAttributes(IContainer basedir, ILaunchConfigurationWorkingCopy workingCopy, String goal) {
    }

    private void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir) {
        ResolverConfiguration configuration;
        String activeProfiles;
        IFile pomFile;
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade projectFacade = projectRegistry.create(pomFile = basedir.getFile((IPath)new Path("pom.xml")), false, (IProgressMonitor)new NullProgressMonitor());
        if (projectFacade != null && (activeProfiles = (configuration = projectFacade.getResolverConfiguration()).getActiveProfiles()) != null && activeProfiles.length() > 0) {
            workingCopy.setAttribute("M2_PROFILES", activeProfiles);
        }
    }

    private IPath getJREContainerPath(IContainer basedir) throws CoreException {
        IProject project = basedir.getProject();
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return entry.getPath();
                }
                ++i;
            }
        }
        return null;
    }

    private ILaunchConfiguration getLaunchConfiguration(IContainer basedir, String mode) {
        String newName;
        IPath basedirLocation;
        ILaunchConfigurationType launchConfigurationType;
        block21: {
            if (this.goalName != null) {
                return this.createLaunchConfiguration(basedir, this.goalName);
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchConfigurationType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
            basedirLocation = basedir.getLocation();
            if (!this.showDialog) {
                try {
                    ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
                    ArrayList<ILaunchConfiguration> matchingConfigs = new ArrayList<ILaunchConfiguration>();
                    ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
                    int n = launchConfigurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Path workPath;
                        ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                        String workDir = MavenLaunchUtils.substituteVar((String)configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, null));
                        if (workDir != null && basedirLocation.equals((Object)(workPath = new Path(workDir)))) {
                            matchingConfigs.add(configuration);
                        }
                        ++n2;
                    }
                    if (matchingConfigs.size() == 1) {
                        Activator.getLogger().info("Using existing launch configuration");
                        return (ILaunchConfiguration)matchingConfigs.get(0);
                    }
                    if (matchingConfigs.size() > 1) {
                        final IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), new ILabelProvider(){

                            public Image getImage(Object element) {
                                return labelProvider.getImage(element);
                            }

                            public String getText(Object element) {
                                if (element instanceof ILaunchConfiguration) {
                                    ILaunchConfiguration configuration = (ILaunchConfiguration)element;
                                    try {
                                        return String.valueOf(labelProvider.getText(element)) + " : " + configuration.getAttribute("M2_GOALS", "");
                                    }
                                    catch (CoreException coreException) {}
                                }
                                return labelProvider.getText(element);
                            }

                            public boolean isLabelProperty(Object element, String property) {
                                return labelProvider.isLabelProperty(element, property);
                            }

                            public void addListener(ILabelProviderListener listener) {
                                labelProvider.addListener(listener);
                            }

                            public void removeListener(ILabelProviderListener listener) {
                                labelProvider.removeListener(listener);
                            }

                            public void dispose() {
                                labelProvider.dispose();
                            }
                        });
                        dialog.setElements((Object[])matchingConfigs.toArray(new ILaunchConfiguration[matchingConfigs.size()]));
                        dialog.setTitle("Select Configuration");
                        if (mode.equals("debug")) {
                            dialog.setMessage("Select a launch configuration to debug:");
                        } else {
                            dialog.setMessage("Select a launch configuration to run:");
                        }
                        dialog.setMultipleSelection(false);
                        int result = dialog.open();
                        labelProvider.dispose();
                        return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
                    }
                }
                catch (CoreException ex) {
                    Activator.getLogger().error("Unable to get the launch configuration.", (Throwable)ex);
                }
            }
            Activator.getLogger().info("Creating new launch configuration");
            newName = null;
            try {
                Method m = DebugPlugin.getDefault().getLaunchManager().getClass().getMethod("generateLaunchConfigurationName", String.class);
                newName = (String)m.invoke((Object)DebugPlugin.getDefault().getLaunchManager(), basedir.getName());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                newName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(basedir.getName());
                if (newName == null) {
                    newName = basedir.getName();
                }
                break block21;
            }
            catch (Exception exception) {
                try {
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (newName == null) {
                        newName = basedir.getName();
                    }
                }
            }
            if (newName != null) break block21;
            newName = basedir.getName();
        }
        try {
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, newName);
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedirLocation.toString());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, basedir.getProject().getName());
            this.appendAttributes(basedir, workingCopy, this.goalName);
            this.setProjectConfiguration(workingCopy, basedir);
            return workingCopy.doSave();
        }
        catch (Exception ex) {
            Activator.getLogger().error("Error creating new launch configuration", (Throwable)ex);
            return null;
        }
    }

    protected String getSelectedFilePath() {
        StructuredSelection ssel;
        Object elem;
        ISelectionService selService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection isel = selService.getSelection();
        if (isel != null && isel instanceof StructuredSelection && (elem = (ssel = (StructuredSelection)isel).getFirstElement()) != null && elem instanceof IFile) {
            IFile f = (IFile)elem;
            return f.getLocationURI().toString();
        }
        return null;
    }

    protected IFile getPomFile(IContainer basedir) {
        return basedir.getFile(Path.fromOSString((String)"pom.xml"));
    }
}

