/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution.processor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.metamodels.builder.ModelBuilder;
import org.teiid.designer.metamodels.builder.execution.processor.AbstractProcessor;
import org.teiid.designer.metamodels.builder.execution.util.MetamodelBuilderUtil;
import org.teiid.designer.metamodels.builder.translator.RecordGenerator;
import org.teiid.designer.metamodels.builder.translator.ResultSetTranslator;

public class ModelProcessor
extends AbstractProcessor {
    private static final String TOCREATE_TABLE = "ToCreate";
    private static final String[] PROCESSING_ORDER = new String[]{"ToCreate"};
    private final ModelBuilder modelBuilder;
    private final MultiStatus status;
    private List createdResources;
    private String targetLocationStr;

    public ModelProcessor(Connection sqlConnection, ModelBuilder modelBuilder, String modelAndSchemaName, ResourceSet resourceSet, String targetLocStr, MultiStatus status) {
        super(sqlConnection, modelAndSchemaName);
        CoreArgCheck.isNotNull((Object)resourceSet);
        CoreArgCheck.isNotNull((Object)status);
        this.status = status;
        this.targetLocationStr = targetLocStr;
        this.modelBuilder = modelBuilder;
    }

    public int getRecordCount() {
        int totalRows = 0;
        List tableNames = null;
        try {
            tableNames = this.getSchemaTables();
        }
        catch (SQLException e) {
            String msg = "Error retrieving the tables for " + this.modelAndSchemaName;
            MetamodelBuilderUtil.addStatus(this.status, 4, msg, e);
            return totalRows;
        }
        if (tableNames != null) {
            int i = 0;
            while (i < PROCESSING_ORDER.length) {
                if (tableNames.contains(PROCESSING_ORDER[i])) {
                    int tableRows = this.countToCreateTableRows();
                    if (tableRows > 0) {
                        totalRows += tableRows;
                    }
                    if (this.status.getSeverity() == 4) {
                        return totalRows;
                    }
                }
                ++i;
            }
        }
        return totalRows;
    }

    public IStatus process(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Processing Models");
        }
        List tableNames = null;
        try {
            tableNames = this.getSchemaTables();
        }
        catch (SQLException e) {
            MetamodelBuilderUtil.addStatus(this.status, 4, "Error retrieving the Model Table", e);
            return this.status;
        }
        if (tableNames != null) {
            int i = 0;
            while (i < PROCESSING_ORDER.length) {
                if (tableNames.contains(PROCESSING_ORDER[i])) {
                    this.processTable(PROCESSING_ORDER[i], monitor);
                    if (this.status.getSeverity() == 4) {
                        return this.status;
                    }
                }
                ++i;
            }
        }
        if (monitor != null && monitor.isCanceled()) {
            MetamodelBuilderUtil.addStatus(this.status, 8, "Model Processing Cancelled");
            return this.status;
        }
        return this.status;
    }

    public List getCreatedResources() {
        return this.createdResources;
    }

    private void processTable(String tableName, IProgressMonitor monitor) {
        if (tableName.equalsIgnoreCase(TOCREATE_TABLE)) {
            this.processToCreateTable(monitor);
            return;
        }
        MetamodelBuilderUtil.addStatus(this.status, 4, "Model Table not found");
    }

    private void processToCreateTable(IProgressMonitor monitor) {
        ResultSet rs = null;
        try {
            rs = this.executeTableQuery(TOCREATE_TABLE);
            List modelRecords = RecordGenerator.generateModelRecords((ResultSet)rs, (String)this.targetLocationStr, (MultiStatus)this.status, null);
            this.createdResources = this.modelBuilder.create(modelRecords);
            if (monitor != null) {
                monitor.worked(modelRecords.size());
            }
            rs.close();
        }
        catch (SQLException e) {
            MetamodelBuilderUtil.addStatus(this.status, 4, "Error Processing the ToCreate Table", e);
            return;
        }
    }

    private int countToCreateTableRows() {
        int tableRows = 0;
        ResultSet rs = null;
        try {
            rs = this.executeTableQuery(TOCREATE_TABLE);
            int rsRowCount = ResultSetTranslator.getRowCount((ResultSet)rs);
            if (rsRowCount > 0) {
                tableRows += rsRowCount;
            }
            rs.close();
        }
        catch (SQLException e) {
            MetamodelBuilderUtil.addStatus(this.status, 2, "Error doing row count on the ToCreate Table", e);
            return tableRows;
        }
        return tableRows;
    }
}

