/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.panels.ColumnsInfoPanel;
import org.teiid.designer.transformation.ui.wizards.xmlfile.panels.XmlFileContentsGroup;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class TeiidXmlImportXmlConfigurationPage
extends AbstractWizardPage
implements UiConstants {
    private TeiidMetadataImportInfo info;
    Group headerGroup;
    TextViewer sqlTextViewer;
    IDocument sqlDocument;
    Button parseRowButton;
    Action createColumnAction;
    Action setRootPathAction;
    Button addColumnButton;
    Button deleteButton;
    Button upButton;
    Button downButton;
    Text selectedFileText;
    XmlFileContentsGroup xmlFileContentsGroup;
    ColumnsInfoPanel columnsInfoPanel;
    private TeiidXmlFileInfo fileInfo;
    boolean creatingControl = false;

    public TeiidXmlImportXmlConfigurationPage(TeiidMetadataImportInfo info) {
        super(TeiidXmlImportXmlConfigurationPage.class.getSimpleName(), Messages.XmlConfigPageTitle);
        this.info = info;
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
    }

    public void createControl(Composite parent) {
        this.creatingControl = true;
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.setMessage(Messages.XmlConfigPageInitialMessage);
        this.createColumnsDefinitionSplitter(mainPanel);
        this.createXmlTableSqlGroup(mainPanel);
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.creatingControl = false;
        this.setPageComplete(false);
    }

    private void createColumnsDefinitionSplitter(Composite parent) {
        Composite columnsPanel = new Composite(parent, 0);
        columnsPanel.setLayout((Layout)new GridLayout(2, false));
        columnsPanel.setLayoutData((Object)new GridData(1808));
        Label selectedFileLabel = new Label(columnsPanel, 0);
        selectedFileLabel.setText(Messages.XMLFile);
        this.selectedFileText = new Text(columnsPanel, 2052);
        this.selectedFileText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedFileText.setForeground(Display.getCurrent().getSystemColor(10));
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.selectedFileText.setEditable(false);
        SashForm splitter = new SashForm(columnsPanel, 256);
        GridData gid = new GridData(1808);
        gid.horizontalSpan = 2;
        gid.heightHint = 200;
        gid.widthHint = 400;
        splitter.setLayoutData((Object)gid);
        this.xmlFileContentsGroup = new XmlFileContentsGroup((Composite)splitter, this);
        this.columnsInfoPanel = new ColumnsInfoPanel((Composite)splitter, this);
        this.xmlFileContentsGroup.setColumnsInfoPanel(this.columnsInfoPanel);
        splitter.setWeights(new int[]{30, 70});
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            TeiidXmlFileInfo xmlFileInfo = null;
            for (TeiidXmlFileInfo xmlInfo : this.info.getXmlFileInfos()) {
                if (!xmlInfo.doProcess()) continue;
                xmlFileInfo = xmlInfo;
                break;
            }
            if (xmlFileInfo != null) {
                this.fileInfo = xmlFileInfo;
                this.loadFileContentsViewer();
                this.selectedFileText.setText(this.fileInfo.getDataFile().getName());
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.isFileInfoValid() ? super.canFlipToNextPage() : false;
    }

    private boolean validatePage() {
        this.info.validate();
        if (!this.isFileInfoValid()) {
            this.setThisPageComplete(this.fileInfo.getStatus().getMessage(), 3);
            return false;
        }
        if (this.fileInfo.getStatus().getSeverity() == 2) {
            this.setThisPageComplete(this.fileInfo.getStatus().getMessage(), 2);
            return true;
        }
        this.setThisPageComplete("", 0);
        return true;
    }

    private boolean isFileInfoValid() {
        return this.fileInfo.getStatus().isOK() || this.fileInfo.getStatus().getSeverity() == 2;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    private void createXmlTableSqlGroup(Composite parent) {
        Group xmlTableOptionsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.GeneratedSQLStatement, (int)0, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        xmlTableOptionsGroup.setLayoutData((Object)gd);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)xmlTableOptionsGroup, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput((Object)this.sqlDocument);
        this.sqlTextViewer.setEditable(false);
        this.sqlTextViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(19));
        this.sqlDocument.set("");
        this.sqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.updateSqlText();
    }

    public void handleInfoChanged(boolean reloadFileContents) {
        this.columnsInfoPanel.refresh();
        this.updateSqlText();
        this.validatePage();
    }

    private void loadFileContentsViewer() {
        this.xmlFileContentsGroup.loadFileContentsViewer();
    }

    public TeiidXmlFileInfo getFileInfo() {
        return this.fileInfo;
    }

    void updateSqlText() {
        if (this.fileInfo != null) {
            if (this.info.getSourceModelName() != null) {
                String sourceModelName = this.fileInfo.getModelNameWithoutExtension(this.info.getSourceModelName());
                if (this.fileInfo.getViewProcedureName() != null) {
                    String viewModelName = this.fileInfo.getModelNameWithoutExtension(this.info.getViewModelName());
                    this.sqlTextViewer.getDocument().set(this.fileInfo.getSqlString(sourceModelName, viewModelName, this.fileInfo.getViewProcedureName()));
                } else {
                    this.sqlTextViewer.getDocument().set(this.fileInfo.getSqlString(sourceModelName));
                }
            } else {
                this.sqlTextViewer.getDocument().set(this.fileInfo.getSqlStringTemplate());
            }
        }
    }

    public void createColumn() {
        this.xmlFileContentsGroup.createColumn();
    }
}

