/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.proc.ITeiidColumnInfo;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.wizards.file.DelimiterOptionsDialog;
import org.teiid.designer.transformation.ui.wizards.file.ParsedDataRowDialog;
import org.teiid.designer.transformation.ui.wizards.file.TeiidColumnInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TextTableFunctionOptionsDialog;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class TeiidMetadataImportOptionsPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportOptionsPage.class);
    private static final String DELIMITED_TITLE = TeiidMetadataImportOptionsPage.getString("delimitedColumnsTitle");
    private static final String FIXED_COLUMNS_WIDTH_TITLE = TeiidMetadataImportOptionsPage.getString("fixedColumnsWidthTitle");
    private static final String INITIAL_MESSAGE = TeiidMetadataImportOptionsPage.getString("initialMessage");
    private final String EMPTY = "";
    private final int GROUP_HEIGHT_190 = 190;
    private final int GROUP_HEIGHT_160 = 160;
    private TeiidMetadataImportInfo info;
    private TeiidMetadataFileInfo dataFileInfo;
    Composite stackPanel;
    StackLayout stackLayout;
    Text selectedFileText;
    Button useFileTextRadio;
    Button useFilterTextRadio;
    TextViewer sqlTextViewer;
    IDocument sqlDocument;
    Composite delimitedColumnsPanel;
    ListViewer delimitedFileContentsViewer;
    TableViewerBuilder delimitedColumnsViewer;
    Label headerLineNumberLabel;
    Text headerLineNumberText;
    Text delimitedFirstDataRowText;
    Button useHeaderForColumnNamesCB;
    Button delimitedParseRowButton;
    Action delimitedParseRowAction;
    Button addColumnDelimitedButton;
    Button deleteColumnDelimitedButton;
    Button upColumnDelimitedButton;
    Button downColumnDelimitedButton;
    Composite fixedWidthColumnsPanel;
    TextViewer fixedFileContentsViewer;
    TableViewerBuilder fixedColumnsViewer;
    Text fixedFirstDataRowText;
    Text cursorPositionText;
    Text selectedTextLengthText;
    Button addColumnFixedButton;
    Button deleteColumnFixedButton;
    Button upColumnFixedButton;
    Button downColumnFixedButton;
    Action createColumnAction;
    boolean creatingControl = false;
    boolean synchronizing = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, param);
    }

    public TeiidMetadataImportOptionsPage(TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportOptionsPage.class.getSimpleName(), DELIMITED_TITLE);
        CoreArgCheck.isNotNull((Object)info, (String)"info");
        this.info = info;
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
    }

    public void createControl(Composite parent) {
        this.creatingControl = true;
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Composite upperPanel = WidgetFactory.createPanel((Composite)mainPanel, (int)0, (int)768, (int)2, (int)2);
        upperPanel.setLayout((Layout)new GridLayout(2, false));
        this.setMessage(INITIAL_MESSAGE);
        Label selectedFileLabel = new Label(upperPanel, 0);
        selectedFileLabel.setText(TeiidMetadataImportOptionsPage.getString("selectedFile"));
        this.selectedFileText = new Text(upperPanel, 2048);
        this.selectedFileText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedFileText.setForeground(Display.getCurrent().getSystemColor(10));
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.createStackLayout(mainPanel);
        this.createSqlGroup(mainPanel);
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.creatingControl = false;
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            TeiidMetadataFileInfo fileInfo = null;
            for (TeiidMetadataFileInfo theFileInfo : this.info.getFileInfos()) {
                if (!theFileInfo.doProcess()) continue;
                fileInfo = theFileInfo;
                break;
            }
            if (fileInfo != null) {
                this.dataFileInfo = fileInfo;
                this.loadFileContentsViewers();
            }
            this.useFileTextRadio.setSelection(true);
            this.useFilterTextRadio.setSelection(false);
            this.synchronizeUI();
            this.validatePage();
        }
    }

    private boolean validatePage() {
        if (!this.dataFileInfo.getStatus().isOK() && this.dataFileInfo.getStatus().getSeverity() != 2) {
            this.setThisPageComplete(this.dataFileInfo.getStatus().getMessage(), 4);
            return false;
        }
        this.setThisPageComplete("", 0);
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    private void synchronizeUI() {
        String dataRow;
        this.synchronizing = true;
        if (this.dataFileInfo == null) {
            return;
        }
        this.selectedFileText.setText(this.dataFileInfo.getDataFile().getName());
        boolean isDelimitedOption = this.dataFileInfo.doUseDelimitedColumns();
        this.useHeaderForColumnNamesCB.setSelection(this.dataFileInfo.doUseHeaderForColumnNames());
        String lineNum = Integer.toString(this.dataFileInfo.getHeaderLineNumber());
        if (!lineNum.equals(this.headerLineNumberText.getText())) {
            this.headerLineNumberText.setText(lineNum);
        }
        if (!(dataRow = Integer.toString(this.dataFileInfo.getFirstDataRow())).equals(this.delimitedFirstDataRowText.getText())) {
            this.delimitedFirstDataRowText.setText(dataRow);
        }
        this.fixedFirstDataRowText.setText(Integer.toString(this.dataFileInfo.getFirstDataRow()));
        boolean enable = isDelimitedOption;
        this.useHeaderForColumnNamesCB.setEnabled(enable);
        this.headerLineNumberText.setEnabled(this.useHeaderForColumnNamesCB.getSelection());
        this.delimitedColumnsViewer.getTable().setEnabled(enable);
        this.fixedColumnsViewer.getTable().setEnabled(!enable);
        this.headerLineNumberLabel.setEnabled(this.dataFileInfo.doUseHeaderForColumnNames());
        this.headerLineNumberText.setEnabled(this.dataFileInfo.doUseHeaderForColumnNames());
        this.delimitedColumnsViewer.getTable().removeAll();
        for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
            this.delimitedColumnsViewer.add((Object)row);
        }
        this.fixedColumnsViewer.getTable().removeAll();
        for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
            this.fixedColumnsViewer.add((Object)row);
        }
        this.updateSqlText();
        if (isDelimitedOption) {
            this.stackLayout.topControl = this.delimitedColumnsPanel;
            this.setTitle(DELIMITED_TITLE);
        } else {
            this.stackLayout.topControl = this.fixedWidthColumnsPanel;
            this.setTitle(FIXED_COLUMNS_WIDTH_TITLE);
        }
        this.stackPanel.layout();
        this.synchronizing = false;
    }

    private void createStackLayout(Composite parent) {
        this.stackPanel = new Composite(parent, 4);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.stackPanel.setLayout((Layout)this.stackLayout);
        this.stackPanel.setLayoutData((Object)new GridData(768));
        this.createDelimitedColumnsPanel(this.stackPanel);
        this.createFixedWidthColumnsPanel(this.stackPanel);
    }

    private void createDelimitedColumnsPanel(Composite parentPanel) {
        GridLayout glOuterGridLayout = new GridLayout();
        glOuterGridLayout.marginHeight = 0;
        glOuterGridLayout.marginWidth = 0;
        this.delimitedColumnsPanel = new Composite(parentPanel, 0);
        this.delimitedColumnsPanel.setLayout((Layout)glOuterGridLayout);
        this.delimitedColumnsPanel.setLayoutData((Object)new GridData(1808));
        Composite topPanel = WidgetFactory.createPanel((Composite)this.delimitedColumnsPanel, (int)0, (int)768, (int)2);
        GridLayout tpGL = new GridLayout(2, false);
        tpGL.marginHeight = 1;
        topPanel.setLayout((Layout)tpGL);
        this.createDelimitedFileOptionsGroup(topPanel);
        this.createDelimitedFileContentsGroup(topPanel);
        Composite bottomPanel = WidgetFactory.createPanel((Composite)this.delimitedColumnsPanel, (int)0, (int)768, (int)2);
        GridLayout bpGL = new GridLayout(2, false);
        bpGL.marginHeight = 1;
        bottomPanel.setLayout((Layout)bpGL);
        this.createDelimitedColumnInfoGroup(bottomPanel);
    }

    private void createFixedWidthColumnsPanel(Composite parentPanel) {
        GridLayout glOuterGridLayout = new GridLayout();
        glOuterGridLayout.marginHeight = 0;
        glOuterGridLayout.marginWidth = 0;
        this.fixedWidthColumnsPanel = new Composite(parentPanel, 0);
        this.fixedWidthColumnsPanel.setLayout((Layout)glOuterGridLayout);
        this.fixedWidthColumnsPanel.setLayoutData((Object)new GridData(1808));
        Composite topPanel = WidgetFactory.createPanel((Composite)this.fixedWidthColumnsPanel, (int)0, (int)768, (int)2);
        GridLayout tpGL = new GridLayout(2, false);
        tpGL.marginHeight = 1;
        topPanel.setLayout((Layout)tpGL);
        this.createFixedFileOptionsGroup(topPanel);
        this.createFixedFileContentsGroup(topPanel);
        Composite bottomPanel = WidgetFactory.createPanel((Composite)this.fixedWidthColumnsPanel, (int)0, (int)768, (int)2);
        GridLayout bpGL = new GridLayout(2, false);
        bpGL.marginHeight = 1;
        bottomPanel.setLayout((Layout)bpGL);
        this.createFixedColumnsOptionsGroup(bottomPanel);
        this.createFixedColumnInfoGroup(bottomPanel);
    }

    private void createDelimitedFileOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)"Format Options", (int)0, (int)1, (int)2);
        GridData groupGD = new GridData(2);
        groupGD.heightHint = 210;
        theGroup.setLayoutData((Object)groupGD);
        this.useHeaderForColumnNamesCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TeiidMetadataImportOptionsPage.getString("useHeaderForColumnNames"), (int)0, (int)2);
        this.useHeaderForColumnNamesCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TeiidMetadataImportOptionsPage.this.synchronizing) {
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.setDoUseHeaderForColumnNames(TeiidMetadataImportOptionsPage.this.useHeaderForColumnNamesCB.getSelection());
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.setIncludeHeader(TeiidMetadataImportOptionsPage.this.useHeaderForColumnNamesCB.getSelection());
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                }
            }
        });
        this.delimitedParseRowAction = new Action(TeiidMetadataImportOptionsPage.getString("parseSelectedRow")){

            public void run() {
                TeiidMetadataImportOptionsPage.this.parseDelimitedSelectedDataRow();
            }
        };
        this.headerLineNumberLabel = new Label((Composite)theGroup, 0);
        this.headerLineNumberLabel.setText(TeiidMetadataImportOptionsPage.getString("headerLineNumber"));
        this.headerLineNumberText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        GridData gd = new GridData(768);
        gd.minimumWidth = 40;
        gd.minimumHeight = 23;
        this.headerLineNumberText.setLayoutData((Object)gd);
        this.headerLineNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TeiidMetadataImportOptionsPage.this.synchronizing) {
                    if (!TeiidMetadataImportOptionsPage.this.headerLineNumberText.getText().isEmpty()) {
                        try {
                            int lineNumber = Integer.parseInt(TeiidMetadataImportOptionsPage.this.headerLineNumberText.getText());
                            if (lineNumber == 0) {
                                TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("headerLineNumberCannotBeNullOrZero"));
                                return;
                            }
                            if (lineNumber != TeiidMetadataImportOptionsPage.this.dataFileInfo.getHeaderLineNumber()) {
                                TeiidMetadataImportOptionsPage.this.dataFileInfo.setHeaderLineNumber(lineNumber);
                                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                            }
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("headerLineNumberMustBeInteger", TeiidMetadataImportOptionsPage.this.headerLineNumberText.getText()));
                            return;
                        }
                    } else {
                        TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("headerLineNumberCannotBeNullOrZero"));
                        return;
                    }
                }
            }
        });
        this.headerLineNumberLabel.setEnabled(this.useHeaderForColumnNamesCB.getSelection());
        this.headerLineNumberText.setEnabled(this.useHeaderForColumnNamesCB.getSelection());
        Label firstDataRowLabel = new Label((Composite)theGroup, 0);
        firstDataRowLabel.setText(TeiidMetadataImportOptionsPage.getString("firstRowLineNumber"));
        firstDataRowLabel.setToolTipText(TeiidMetadataImportOptionsPage.getString("firstDataRowTooltip"));
        this.delimitedFirstDataRowText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        gd = new GridData(768);
        gd.minimumWidth = 20;
        gd.horizontalSpan = 1;
        this.delimitedFirstDataRowText.setLayoutData((Object)gd);
        this.delimitedFirstDataRowText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TeiidMetadataImportOptionsPage.this.synchronizing) {
                    if (!TeiidMetadataImportOptionsPage.this.delimitedFirstDataRowText.getText().isEmpty()) {
                        try {
                            int nLines = Integer.parseInt(TeiidMetadataImportOptionsPage.this.delimitedFirstDataRowText.getText());
                            if (nLines < 1) {
                                TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowCannotBeZeroOrNegative"));
                                return;
                            }
                            if (nLines != TeiidMetadataImportOptionsPage.this.dataFileInfo.getFirstDataRow()) {
                                TeiidMetadataImportOptionsPage.this.dataFileInfo.setFirstDataRow(nLines);
                                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                            }
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowMustBeInteger", TeiidMetadataImportOptionsPage.this.headerLineNumberText.getText()));
                            return;
                        }
                    } else {
                        TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowCannotBeZeroOrNegative"));
                        return;
                    }
                }
            }
        });
        this.delimitedFirstDataRowText.setToolTipText(TeiidMetadataImportOptionsPage.getString("firstDataRowTooltip"));
        this.delimitedParseRowButton = WidgetFactory.createButton((Composite)theGroup, (int)8);
        this.delimitedParseRowButton.setText(TeiidMetadataImportOptionsPage.getString("parseSelectedRow"));
        gd = new GridData(768);
        gd.minimumWidth = 120;
        gd.horizontalSpan = 2;
        this.delimitedParseRowButton.setLayoutData((Object)gd);
        this.delimitedParseRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidMetadataImportOptionsPage.this.parseDelimitedSelectedDataRow();
            }
        });
        Button editDelimiterButton = WidgetFactory.createButton((Composite)theGroup, (int)8);
        editDelimiterButton.setText(TeiidMetadataImportOptionsPage.getString("editDelimiterButtonLabel"));
        gd = new GridData(768);
        gd.minimumWidth = 120;
        gd.horizontalSpan = 2;
        editDelimiterButton.setLayoutData((Object)gd);
        editDelimiterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog dialog = new DelimiterOptionsDialog(TeiidMetadataImportOptionsPage.this.getShell(), TeiidMetadataImportOptionsPage.this.dataFileInfo);
                dialog.open();
                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
            }
        });
        editDelimiterButton.setEnabled(true);
        Button editTextTableOptionsButton = WidgetFactory.createButton((Composite)theGroup, (int)8);
        editTextTableOptionsButton.setText(TeiidMetadataImportOptionsPage.getString("editTextTableOptionsButtonLabel"));
        gd = new GridData(768);
        gd.minimumWidth = 120;
        gd.horizontalSpan = 2;
        editTextTableOptionsButton.setLayoutData((Object)gd);
        editTextTableOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTableFunctionOptionsDialog dialog = new TextTableFunctionOptionsDialog(TeiidMetadataImportOptionsPage.this.getShell(), TeiidMetadataImportOptionsPage.this.dataFileInfo);
                dialog.open();
                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
            }
        });
        editTextTableOptionsButton.setEnabled(true);
    }

    private void createDelimitedFileContentsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("fileContentsGroup"), (int)0, (int)1, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 190;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.delimitedFileContentsViewer = new ListViewer((Composite)theGroup, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.delimitedFileContentsViewer.getControl().setFont(JFaceResources.getTextFont());
        this.delimitedFileContentsViewer.getControl().setLayoutData((Object)data);
        if (this.dataFileInfo != null) {
            String[] stringArray = this.dataFileInfo.getCachedFirstLines();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                if (row != null) {
                    this.delimitedFileContentsViewer.add((Object)row);
                }
                ++n2;
            }
        }
        final MenuManager columnMenuManager = new MenuManager();
        this.delimitedFileContentsViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
        this.delimitedFileContentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                columnMenuManager.removeAll();
                IStructuredSelection sel = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.delimitedFileContentsViewer.getSelection();
                if (sel.size() == 1) {
                    columnMenuManager.add((IAction)TeiidMetadataImportOptionsPage.this.delimitedParseRowAction);
                    TeiidMetadataImportOptionsPage.this.delimitedParseRowButton.setEnabled(true);
                } else {
                    TeiidMetadataImportOptionsPage.this.delimitedParseRowButton.setEnabled(false);
                }
            }
        });
    }

    private void createDelimitedColumnInfoGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("columnInfoGroup"), (int)0, (int)2, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 140;
        theGroup.setLayoutData((Object)groupGD);
        this.delimitedColumnsViewer = new TableViewerBuilder((Composite)theGroup, 68356);
        GridDataFactory.fillDefaults().grab(true, true).span(4, -1).applyTo((Control)this.delimitedColumnsViewer.getTableComposite());
        TableViewerColumn column = this.delimitedColumnsViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(String.valueOf(TeiidMetadataImportOptionsPage.getString("columnName")) + this.getSpaces(36));
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.delimitedColumnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.delimitedColumnsViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(String.valueOf(TeiidMetadataImportOptionsPage.getString("datatype")) + this.getSpaces(12));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.delimitedColumnsViewer.getTableViewer()));
        if (this.dataFileInfo != null) {
            for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
                this.delimitedColumnsViewer.add((Object)row);
            }
        }
        this.addColumnDelimitedButton = new Button((Composite)theGroup, 8);
        this.addColumnDelimitedButton.setText(TeiidMetadataImportOptionsPage.getString("addLabel"));
        this.addColumnDelimitedButton.setLayoutData((Object)new GridData(768));
        this.addColumnDelimitedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportOptionsPage.this.createColumn();
            }
        });
        this.deleteColumnDelimitedButton = new Button((Composite)theGroup, 8);
        this.deleteColumnDelimitedButton.setText(TeiidMetadataImportOptionsPage.getString("deleteLabel"));
        this.deleteColumnDelimitedButton.setLayoutData((Object)new GridData(768));
        this.deleteColumnDelimitedButton.setEnabled(false);
        this.deleteColumnDelimitedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (ITeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.removeColumn(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.deleteColumnDelimitedButton.setEnabled(false);
                }
            }
        });
        this.upColumnDelimitedButton = new Button((Composite)theGroup, 8);
        this.upColumnDelimitedButton.setText(TeiidMetadataImportOptionsPage.getString("upLabel"));
        this.upColumnDelimitedButton.setLayoutData((Object)new GridData(768));
        this.upColumnDelimitedButton.setEnabled(false);
        this.upColumnDelimitedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (TeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getTable().getSelectionIndex();
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.moveColumnUp(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getTable().select(selectedIndex - 1);
                    TeiidMetadataImportOptionsPage.this.downColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(info));
                    TeiidMetadataImportOptionsPage.this.upColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(info));
                }
            }
        });
        this.downColumnDelimitedButton = new Button((Composite)theGroup, 8);
        this.downColumnDelimitedButton.setText(TeiidMetadataImportOptionsPage.getString("downLabel"));
        this.downColumnDelimitedButton.setLayoutData((Object)new GridData(768));
        this.downColumnDelimitedButton.setEnabled(false);
        this.downColumnDelimitedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (TeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getTable().getSelectionIndex();
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.moveColumnDown(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getTable().select(selectedIndex + 1);
                    TeiidMetadataImportOptionsPage.this.downColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(info));
                    TeiidMetadataImportOptionsPage.this.upColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(info));
                }
            }
        });
        this.delimitedColumnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    TeiidMetadataImportOptionsPage.this.deleteColumnDelimitedButton.setEnabled(false);
                    TeiidMetadataImportOptionsPage.this.upColumnDelimitedButton.setEnabled(false);
                    TeiidMetadataImportOptionsPage.this.downColumnDelimitedButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    ITeiidColumnInfo columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof ITeiidColumnInfo)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (ITeiidColumnInfo)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    TeiidMetadataImportOptionsPage.this.deleteColumnDelimitedButton.setEnabled(enable);
                    if (enable) {
                        TeiidMetadataImportOptionsPage.this.upColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(columnInfo));
                        TeiidMetadataImportOptionsPage.this.downColumnDelimitedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(columnInfo));
                    }
                }
            }
        });
    }

    private void createFixedFileOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)"Format Options", (int)0, (int)1, (int)2);
        GridData groupGD = new GridData(2);
        groupGD.heightHint = 190;
        theGroup.setLayoutData((Object)groupGD);
        Label firstDataRowLabel = new Label((Composite)theGroup, 0);
        firstDataRowLabel.setText(TeiidMetadataImportOptionsPage.getString("firstRowLineNumber"));
        firstDataRowLabel.setToolTipText(TeiidMetadataImportOptionsPage.getString("firstDataRowTooltip"));
        this.fixedFirstDataRowText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        GridData gd = new GridData(768);
        gd.minimumWidth = 20;
        gd.horizontalSpan = 1;
        this.fixedFirstDataRowText.setLayoutData((Object)gd);
        this.fixedFirstDataRowText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TeiidMetadataImportOptionsPage.this.synchronizing) {
                    if (!TeiidMetadataImportOptionsPage.this.fixedFirstDataRowText.getText().isEmpty()) {
                        try {
                            int nLines = Integer.parseInt(TeiidMetadataImportOptionsPage.this.fixedFirstDataRowText.getText());
                            if (nLines < 1) {
                                TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowCannotBeZeroOrNegative"));
                                return;
                            }
                            if (nLines != TeiidMetadataImportOptionsPage.this.dataFileInfo.getFirstDataRow()) {
                                TeiidMetadataImportOptionsPage.this.dataFileInfo.setFirstDataRow(nLines);
                                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                            }
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowMustBeInteger", TeiidMetadataImportOptionsPage.this.headerLineNumberText.getText()));
                            return;
                        }
                    } else {
                        TeiidMetadataImportOptionsPage.this.setErrorMessage(TeiidMetadataImportOptionsPage.getString("firstDataRowCannotBeZeroOrNegative"));
                        return;
                    }
                }
            }
        });
        this.fixedFirstDataRowText.setToolTipText(TeiidMetadataImportOptionsPage.getString("firstDataRowTooltip"));
        Label curorPositionLabel = new Label((Composite)theGroup, 0);
        curorPositionLabel.setText("Cursor Position");
        this.cursorPositionText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        gd = new GridData(768);
        gd.minimumWidth = 20;
        gd.horizontalSpan = 1;
        this.cursorPositionText.setLayoutData((Object)gd);
        this.cursorPositionText.setEditable(false);
        this.cursorPositionText.setBackground(Display.getCurrent().getSystemColor(19));
        Label selectedTextLengthLabel = new Label((Composite)theGroup, 0);
        selectedTextLengthLabel.setText("Text Length");
        this.selectedTextLengthText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        gd = new GridData(768);
        gd.minimumWidth = 20;
        gd.horizontalSpan = 1;
        this.selectedTextLengthText.setLayoutData((Object)gd);
        this.selectedTextLengthText.setEditable(false);
        this.selectedTextLengthText.setBackground(Display.getCurrent().getSystemColor(19));
    }

    private void createFixedFileContentsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("fileContentsGroup"), (int)0, (int)1, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 190;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.fixedFileContentsViewer = new TextViewer((Composite)theGroup, 2816);
        Document fileDocument = new Document();
        this.fixedFileContentsViewer.setInput((Object)fileDocument);
        this.fixedFileContentsViewer.setEditable(false);
        fileDocument.set("");
        this.fixedFileContentsViewer.getControl().setLayoutData((Object)new GridData(1808));
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.fixedFileContentsViewer.getControl().setFont(JFaceResources.getTextFont());
        this.fixedFileContentsViewer.getControl().setLayoutData((Object)data);
        if (this.dataFileInfo != null) {
            String[] stringArray = this.dataFileInfo.getCachedFirstLines();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                if (row != null) {
                    this.delimitedFileContentsViewer.add((Object)row);
                }
                ++n2;
            }
        }
        final MenuManager fileContentsMenuManager = new MenuManager();
        this.fixedFileContentsViewer.getControl().setMenu(fileContentsMenuManager.createContextMenu((Control)parent));
        this.fixedFileContentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TextSelection sel;
                fileContentsMenuManager.removeAll();
                if (event.getSelection() instanceof TextSelection && (sel = (TextSelection)event.getSelection()).getLength() > 0) {
                    fileContentsMenuManager.add((IAction)TeiidMetadataImportOptionsPage.this.createColumnAction);
                }
            }
        });
        this.fixedFileContentsViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof TextSelection) {
                    TextSelection sel = (TextSelection)event.getSelection();
                    int offset = TeiidMetadataImportOptionsPage.this.fixedFileContentsViewer.getTextWidget().getCaretOffset();
                    int line = 0;
                    int lineOffset = 0;
                    try {
                        line = TeiidMetadataImportOptionsPage.this.fixedFileContentsViewer.getDocument().getLineOfOffset(offset);
                        lineOffset = TeiidMetadataImportOptionsPage.this.fixedFileContentsViewer.getDocument().getLineOffset(line);
                    }
                    catch (BadLocationException badLocationException) {}
                    int column = offset - lineOffset;
                    TeiidMetadataImportOptionsPage.this.cursorPositionText.setText(Integer.toString(column));
                    TeiidMetadataImportOptionsPage.this.selectedTextLengthText.setText(Integer.toString(sel.getLength()));
                }
            }
        });
        this.createColumnAction = new Action(TeiidMetadataImportOptionsPage.getString("createColumnActionLabel")){

            public void run() {
                TeiidMetadataImportOptionsPage.this.createColumn();
            }
        };
    }

    private void createFixedColumnsOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("columnOptionsGroup"), (int)0, (int)1, (int)1);
        GridData groupGD = new GridData();
        groupGD.heightHint = 160;
        theGroup.setLayoutData((Object)groupGD);
        this.addColumnFixedButton = new Button((Composite)theGroup, 8);
        this.addColumnFixedButton.setText(TeiidMetadataImportOptionsPage.getString("addLabel"));
        this.addColumnFixedButton.setLayoutData((Object)new GridData(768));
        this.addColumnFixedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportOptionsPage.this.createColumn();
                TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
            }
        });
        this.deleteColumnFixedButton = new Button((Composite)theGroup, 8);
        this.deleteColumnFixedButton.setText(TeiidMetadataImportOptionsPage.getString("deleteLabel"));
        this.deleteColumnFixedButton.setLayoutData((Object)new GridData(768));
        this.deleteColumnFixedButton.setEnabled(false);
        this.deleteColumnFixedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (ITeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.removeColumn(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.deleteColumnFixedButton.setEnabled(false);
                }
            }
        });
        this.upColumnFixedButton = new Button((Composite)theGroup, 8);
        this.upColumnFixedButton.setText(TeiidMetadataImportOptionsPage.getString("upLabel"));
        this.upColumnFixedButton.setLayoutData((Object)new GridData(768));
        this.upColumnFixedButton.setEnabled(false);
        this.upColumnFixedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (TeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTable().getSelectionIndex();
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.moveColumnUp(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTable().select(selectedIndex - 1);
                    TeiidMetadataImportOptionsPage.this.downColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(info));
                    TeiidMetadataImportOptionsPage.this.upColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(info));
                }
            }
        });
        this.downColumnFixedButton = new Button((Composite)theGroup, 8);
        this.downColumnFixedButton.setText(TeiidMetadataImportOptionsPage.getString("downLabel"));
        this.downColumnFixedButton.setLayoutData((Object)new GridData(768));
        this.downColumnFixedButton.setEnabled(false);
        this.downColumnFixedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidColumnInfo info = null;
                IStructuredSelection selection = (IStructuredSelection)TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ITeiidColumnInfo) {
                        info = (TeiidColumnInfo)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTable().getSelectionIndex();
                    TeiidMetadataImportOptionsPage.this.dataFileInfo.moveColumnDown(info);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                    TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTable().select(selectedIndex + 1);
                    TeiidMetadataImportOptionsPage.this.downColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(info));
                    TeiidMetadataImportOptionsPage.this.upColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(info));
                }
            }
        });
    }

    private void createFixedColumnInfoGroup(Composite parent) {
        Group columnInfoGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("columnInfoGroup"), (int)0, (int)1, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 160;
        columnInfoGroup.setLayoutData((Object)gd);
        this.fixedColumnsViewer = new TableViewerBuilder((Composite)columnInfoGroup, 68356);
        TableViewerColumn column = this.fixedColumnsViewer.createColumn(16384, 30, 50, true);
        column.getColumn().setText(String.valueOf(TeiidMetadataImportOptionsPage.getString("columnName")) + this.getSpaces(36));
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.fixedColumnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.fixedColumnsViewer.createColumn(16384, 30, 50, true);
        column.getColumn().setText(String.valueOf(TeiidMetadataImportOptionsPage.getString("datatype")) + this.getSpaces(12));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.fixedColumnsViewer.getTableViewer()));
        column = this.fixedColumnsViewer.createColumn(16384, 30, 50, true);
        column.getColumn().setText(String.valueOf(TeiidMetadataImportOptionsPage.getString("width")) + this.getSpaces(12));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ColumnWidthEditingSupport((ColumnViewer)this.fixedColumnsViewer.getTableViewer()));
        if (this.dataFileInfo != null) {
            for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
                this.fixedColumnsViewer.add((Object)row);
            }
        }
        this.fixedColumnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    TeiidMetadataImportOptionsPage.this.deleteColumnFixedButton.setEnabled(false);
                    TeiidMetadataImportOptionsPage.this.upColumnFixedButton.setEnabled(false);
                    TeiidMetadataImportOptionsPage.this.downColumnFixedButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    ITeiidColumnInfo columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof ITeiidColumnInfo)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (ITeiidColumnInfo)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    TeiidMetadataImportOptionsPage.this.deleteColumnFixedButton.setEnabled(enable);
                    if (enable) {
                        TeiidMetadataImportOptionsPage.this.upColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveUp(columnInfo));
                        TeiidMetadataImportOptionsPage.this.downColumnFixedButton.setEnabled(TeiidMetadataImportOptionsPage.this.dataFileInfo.canMoveDown(columnInfo));
                    }
                }
            }
        });
    }

    private void createSqlGroup(Composite parent) {
        Group textTableOptionsGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportOptionsPage.getString("textTableOptionsGroup"), (int)0, (int)2, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        textTableOptionsGroup.setLayoutData((Object)gd);
        Composite radioPanel = new Composite((Composite)textTableOptionsGroup, 0);
        radioPanel.setLayout((Layout)new GridLayout(2, false));
        GridData gd2 = new GridData(768);
        radioPanel.setLayoutData((Object)gd2);
        this.useFileTextRadio = new Button(radioPanel, 16);
        this.useFileTextRadio.setText(TeiidMetadataImportOptionsPage.getString("sqlUseSelectedFile"));
        this.useFileTextRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TeiidMetadataImportOptionsPage.this.useFileTextRadio.getSelection()) {
                    TeiidMetadataImportOptionsPage.this.useFilterTextRadio.setSelection(false);
                    TeiidMetadataImportOptionsPage.this.updateSqlText();
                }
            }
        });
        this.useFilterTextRadio = new Button(radioPanel, 16);
        this.useFilterTextRadio.setText(TeiidMetadataImportOptionsPage.getString("sqlUseSelectedFilter"));
        this.useFilterTextRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TeiidMetadataImportOptionsPage.this.useFilterTextRadio.getSelection()) {
                    TeiidMetadataImportOptionsPage.this.useFileTextRadio.setSelection(false);
                    TeiidMetadataImportOptionsPage.this.updateSqlText();
                }
            }
        });
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)textTableOptionsGroup, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput((Object)this.sqlDocument);
        this.sqlTextViewer.setEditable(false);
        this.sqlTextViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(19));
        this.sqlDocument.set("");
        this.sqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.updateSqlText();
    }

    private void createColumn() {
        String newName = "column_" + (this.dataFileInfo.getColumnInfoList().size() + 1);
        int length = 10;
        if (this.selectedTextLengthText.getText().length() > 0) {
            int textLength = Integer.parseInt(this.selectedTextLengthText.getText());
            length = textLength > 0 ? textLength : length;
        }
        TeiidColumnInfo newColumn = new TeiidColumnInfo(newName, "string", length);
        this.dataFileInfo.addColumn(newColumn);
        this.handleInfoChanged(false);
    }

    void updateSqlText() {
        if (this.dataFileInfo != null) {
            String fileFilterText = this.info.getFileFilterText();
            boolean useFilterTextInSQL = this.useFilterTextRadio.getSelection();
            if (useFilterTextInSQL) {
                if (fileFilterText != null) {
                    this.dataFileInfo.setDataFileFilter(fileFilterText);
                } else {
                    this.dataFileInfo.setDataFileFilter("*.*");
                }
            } else {
                this.dataFileInfo.setDataFileFilter(null);
            }
            if (this.info.getSourceModelName() != null) {
                String modelName = this.dataFileInfo.getModelNameWithoutExtension(this.info.getSourceModelName());
                this.sqlTextViewer.getDocument().set(this.dataFileInfo.getSqlString(modelName));
            } else {
                this.sqlTextViewer.getDocument().set(this.dataFileInfo.getSqlStringTemplate());
            }
        }
    }

    private String getSpaces(int nSpaces) {
        StringBuffer sb = new StringBuffer(nSpaces);
        int i = 0;
        while (i < nSpaces) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private void parseDelimitedSelectedDataRow() {
        IStructuredSelection selectedFile = (IStructuredSelection)this.delimitedFileContentsViewer.getSelection();
        if (selectedFile.getFirstElement() != null && selectedFile.getFirstElement() instanceof String) {
            String dataRowStr = (String)selectedFile.getFirstElement();
            ParsedDataRowDialog dialog = new ParsedDataRowDialog(this.getShell(), this.dataFileInfo, dataRowStr);
            dialog.open();
        }
    }

    private void handleInfoChanged(boolean reloadFileContents) {
        if (this.synchronizing) {
            return;
        }
        this.synchronizeUI();
        if (reloadFileContents) {
            this.loadFileContentsViewers();
        }
        this.delimitedColumnsViewer.getTable().removeAll();
        for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
            this.delimitedColumnsViewer.add((Object)row);
        }
        this.fixedColumnsViewer.getTable().removeAll();
        for (ITeiidColumnInfo row : this.dataFileInfo.getColumnInfoList()) {
            this.fixedColumnsViewer.add((Object)row);
        }
        this.validatePage();
    }

    private void loadFileContentsViewers() {
        this.delimitedFileContentsViewer.getList().removeAll();
        String[] stringArray = this.dataFileInfo.getCachedFirstLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            if (row != null) {
                this.delimitedFileContentsViewer.add((Object)row);
            }
            ++n2;
        }
        this.fixedFileContentsViewer.getDocument().set("");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int nLines = this.dataFileInfo.getNumberOfCachedFileLines();
        String[] stringArray2 = this.dataFileInfo.getCachedFirstLines();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String row = stringArray2[n4];
            if (row != null) {
                sb.append(row);
                if (i < nLines) {
                    sb.append('\n');
                }
                ++i;
            }
            ++n4;
        }
        this.fixedFileContentsViewer.getDocument().set(sb.toString());
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof ITeiidColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ITeiidColumnInfo)element).getName();
                    }
                    case 1: {
                        return ((ITeiidColumnInfo)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((ITeiidColumnInfo)element).getWidth());
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }

    class ColumnNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof ITeiidColumnInfo) {
                return ((ITeiidColumnInfo)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ITeiidColumnInfo) {
                String oldValue = ((ITeiidColumnInfo)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((TeiidColumnInfo)element).setName(newValue);
                    TeiidMetadataImportOptionsPage.this.delimitedColumnsViewer.getTableViewer().refresh(element);
                    TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTableViewer().refresh(element);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                }
            }
        }
    }

    class ColumnWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof ITeiidColumnInfo) {
                return Integer.toString(((ITeiidColumnInfo)element).getWidth());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ITeiidColumnInfo) {
                int oldValue;
                int newValue = oldValue = ((ITeiidColumnInfo)element).getWidth();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((TeiidColumnInfo)element).setWidth(newValue);
                    TeiidMetadataImportOptionsPage.this.fixedColumnsViewer.getTableViewer().refresh(element);
                    TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
                }
            }
        }
    }

    class DatatypeEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
            Set unsortedDatatypes = service.getAllDataTypeNames();
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            return ((ITeiidColumnInfo)element).getDatatype();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            ((TeiidColumnInfo)element).setDatatype(newValue);
            TeiidMetadataImportOptionsPage.this.handleInfoChanged(false);
        }
    }
}

