/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class DelimiterOptionsDialog
extends TitleAreaDialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(DelimiterOptionsDialog.class);
    private final String TITLE = DelimiterOptionsDialog.getString("title");
    private TeiidMetadataFileInfo fileInfo;
    Button commaRB;
    Button spaceRB;
    Button tabRB;
    Button semicolonRB;
    Button barRB;
    Button otherDelimiterRB;
    Text otherDelimiterText;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public DelimiterOptionsDialog(Shell parent, TeiidMetadataFileInfo fileInfo) {
        super(parent);
        this.fileInfo = fileInfo;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.TITLE);
        this.setTitleImage(UiPlugin.getDefault().getImage("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.setMessage(DelimiterOptionsDialog.getString("titleMessage"));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        this.createDelimitedColumnsOptionsGroup(composite);
        return composite;
    }

    private void createDelimitedColumnsOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)"Delimeter Options", (int)0, (int)1, (int)2);
        theGroup.setLayoutData((Object)new GridData(1808));
        this.commaRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("commaLabel"), (int)0, (int)2, (boolean)true);
        this.commaRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.spaceRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("spaceLabel"), (int)0, (int)2, (boolean)false);
        this.spaceRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.tabRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("tabLabel"), (int)0, (int)2, (boolean)false);
        this.tabRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.semicolonRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("semicolonLabel"), (int)0, (int)2, (boolean)false);
        this.semicolonRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.barRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("barLabel"), (int)0, (int)2, (boolean)false);
        this.barRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.otherDelimiterRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)DelimiterOptionsDialog.getString("otherLabel"), (int)0, (int)1, (boolean)false);
        this.otherDelimiterRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelimiterOptionsDialog.this.otherDelimiterText.setEnabled(DelimiterOptionsDialog.this.otherDelimiterRB.getSelection());
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.otherDelimiterText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        this.otherDelimiterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DelimiterOptionsDialog.this.setDelimiterValue();
            }
        });
        this.otherDelimiterText.setEnabled(false);
    }

    private void setDelimiterValue() {
        if (this.fileInfo.doUseDelimitedColumns()) {
            this.setErrorMessage(null);
            if (this.otherDelimiterRB.getSelection()) {
                if (!this.otherDelimiterText.getText().isEmpty()) {
                    this.fileInfo.setDelimiter(this.otherDelimiterText.getText().substring(0, 1));
                } else {
                    this.setErrorMessage(DelimiterOptionsDialog.getString("delimiterCannotBeNull"));
                    return;
                }
            }
            if (this.commaRB.getSelection()) {
                this.fileInfo.setDelimiter(",");
            } else if (this.spaceRB.getSelection()) {
                this.fileInfo.setDelimiter(" ");
            } else if (this.tabRB.getSelection()) {
                this.fileInfo.setDelimiter("\t");
            } else if (this.semicolonRB.getSelection()) {
                this.fileInfo.setDelimiter(";");
            } else if (this.barRB.getSelection()) {
                this.fileInfo.setDelimiter("|");
            } else if (!this.otherDelimiterText.getText().isEmpty()) {
                this.fileInfo.setDelimiter(this.otherDelimiterText.getText().substring(0, 1));
            }
        }
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
        this.synchronizeUI();
    }

    private void synchronizeUI() {
        this.commaRB.setSelection(false);
        this.spaceRB.setSelection(false);
        this.tabRB.setSelection(false);
        this.semicolonRB.setSelection(false);
        this.barRB.setSelection(false);
        this.otherDelimiterRB.setSelection(false);
        this.otherDelimiterText.setEnabled(false);
        String delimiter = this.fileInfo.getDelimiter();
        if (",".equals(delimiter)) {
            this.commaRB.setSelection(true);
        } else if (";".equals(delimiter)) {
            this.semicolonRB.setSelection(true);
        } else if ("|".equals(delimiter)) {
            this.barRB.setSelection(true);
        } else if (" ".equals(delimiter)) {
            this.spaceRB.setSelection(true);
        } else if ("\t".equals(delimiter)) {
            this.tabRB.setSelection(true);
        } else {
            this.otherDelimiterRB.setSelection(true);
            String charStr = delimiter;
            this.otherDelimiterText.setText(charStr);
            this.otherDelimiterText.setEnabled(true);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

