/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;

public class SqlAliasAccumulatorSource
implements IAccumulatorSource {
    private static final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.transformation.ui");
    private ILabelProvider labelProvider;
    private List initialValues;
    private List currentValues = new ArrayList();
    private Table table;

    public SqlAliasAccumulatorSource(ILabelProvider labelProvider, List initialValues) {
        this.labelProvider = labelProvider;
        this.initialValues = initialValues;
    }

    public void accumulatedValuesRemoved(Collection values) {
        for (Object obj : values) {
            int index = this.indexForValueInserting(obj);
            TableItem tableItem = new TableItem(this.table, 0, index);
            Image image = this.labelProvider.getImage(obj);
            String text = this.labelProvider.getText(obj);
            tableItem.setImage(image);
            tableItem.setText(text);
            this.currentValues.add(index, obj);
        }
    }

    public void accumulatedValuesAdded(Collection values) {
        for (Object value : values) {
            int index = this.indexForValueRemoving(value);
            this.table.remove(index);
            this.currentValues.remove(index);
        }
    }

    public Collection getAvailableValues() {
        ArrayList itemsColl = new ArrayList(this.currentValues.size());
        Iterator it = this.currentValues.iterator();
        while (it.hasNext()) {
            itemsColl.add(it.next());
        }
        return itemsColl;
    }

    public int getAvailableValuesCount() {
        int count = this.table.getItemCount();
        return count;
    }

    public Collection getSelectedAvailableValues() {
        int[] itemIndices = this.table.getSelectionIndices();
        ArrayList itemsColl = new ArrayList(itemIndices.length);
        int i = 0;
        while (i < itemIndices.length) {
            Object obj = this.currentValues.get(itemIndices[i]);
            itemsColl.add(obj);
            ++i;
        }
        return itemsColl;
    }

    public int getSelectedAvailableValuesCount() {
        int count = this.table.getSelectionCount();
        return count;
    }

    public Control createControl(Composite parent) {
        this.table = new Table(parent, 2818);
        GridData tableGridData = new GridData();
        tableGridData.widthHint = 200;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)tableGridData);
        int loc = 0;
        for (Object obj : this.initialValues) {
            TableItem tableItem = new TableItem(this.table, 0, loc);
            Image image = this.labelProvider.getImage(obj);
            String text = this.labelProvider.getText(obj);
            tableItem.setImage(image);
            tableItem.setText(text);
            this.currentValues.add(obj);
            ++loc;
        }
        return this.table;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    private int indexForValueRemoving(Object value) {
        int index = this.currentValues.indexOf(value);
        return index;
    }

    private int indexForValueInserting(Object value) {
        int index = -1;
        int originalIndex = this.initialValues.indexOf(value);
        if (originalIndex < 0) {
            index = this.currentValues.size();
        } else {
            boolean found = false;
            int loc = originalIndex - 1;
            while (!found && loc >= 0) {
                Object objectLookingFor = this.initialValues.get(loc);
                int curIndexOfObject = this.currentValues.indexOf(objectLookingFor);
                if (curIndexOfObject >= 0) {
                    found = true;
                    index = curIndexOfObject + 1;
                    continue;
                }
                --loc;
            }
            if (!found) {
                index = 0;
            }
        }
        return index;
    }

    public boolean supportsAddAll() {
        return true;
    }

    public IStatus getSelectionStatus() {
        return OK_STATUS;
    }
}

