/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.FunctionParameter;
import org.teiid.designer.metamodels.function.ReturnParameter;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.util.IModelNotificationHandler;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class FunctionModelNotificationHandler
implements IModelNotificationHandler,
UiConstants {
    private boolean isFunctionModelObject(Object obj) {
        if (obj instanceof ScalarFunction || obj instanceof FunctionParameter || obj instanceof ReturnParameter) {
            return true;
        }
        if (obj instanceof Procedure) {
            return ((Procedure)obj).isFunction();
        }
        if (obj instanceof ProcedureParameter) {
            return ((ProcedureParameter)obj).getProcedure().isFunction();
        }
        return false;
    }

    private Collection getModelChangeNotifications(Collection notifications, Object source) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            ModelResource mr;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) && !NotificationUtilities.isAdded((Notification)notification) && !NotificationUtilities.isChanged((Notification)notification)) continue;
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            if (this.isFunctionModelObject(changedObj)) {
                if (result == null) {
                    result = new ArrayList<Notification>(notifications.size());
                }
                result.add(notification);
                iter.remove();
                continue;
            }
            if (changedObj == null || !(changedObj instanceof EmfResource) || !ModelIdentifier.isFunctionModel((ModelResource)(mr = ModelUtilities.getModelResource((Resource)((Resource)changedObj), (boolean)false)))) continue;
            if (result == null) {
                result = new ArrayList(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private void handleModelChangeNotification(Collection notifications, Object txnSource) {
        HashSet<ModelResource> changedMRs = new HashSet<ModelResource>();
        for (Notification notification : notifications) {
            Object changedObj;
            if (NotificationUtilities.isAdded((Notification)notification) || NotificationUtilities.isRemoved((Notification)notification)) {
                ModelResource mr;
                changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                ModelResource changedModelResource = null;
                if (changedObj instanceof ScalarFunction) {
                    EObject eObject = (EObject)changedObj;
                    changedModelResource = ModelUtilities.getModelResource((Object)eObject);
                } else if (changedObj instanceof EmfResource && (ModelIdentifier.isFunctionModel((ModelResource)(mr = ModelUtilities.getModelResource((Resource)((Resource)changedObj), (boolean)false))) || this.isSourceModelWithPushdownFunction(mr))) {
                    changedModelResource = mr;
                }
                if (changedModelResource == null) continue;
                HashSet affectedDependentModelResources = new HashSet();
                affectedDependentModelResources.addAll(ModelUtilities.getResourcesThatUse((ModelResource)changedModelResource));
                try {
                    for (ModelResource modelResource : affectedDependentModelResources) {
                        EmfResource emfRes = (EmfResource)modelResource.getEmfResource();
                        List transformations = emfRes.getModelContents().getTransformations();
                        for (EObject eObj : transformations) {
                            if (!(eObj instanceof SqlTransformationMappingRoot)) continue;
                            SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)eObj;
                            SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                        }
                        this.rebuildImportsInTransaction(modelResource.getEmfResource());
                    }
                }
                catch (ModelWorkspaceException ex) {
                    Util.log(4, (Throwable)ex, ex.getMessage());
                }
                continue;
            }
            if (!NotificationUtilities.isChanged((Notification)notification)) continue;
            changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            boolean dependentModelChanged = false;
            ModelResource changedModelResource = null;
            try {
                if (!(changedObj instanceof EObject) || !this.isFunction((EObject)changedObj)) continue;
                EObject eObject = (EObject)changedObj;
                EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature(eObject);
                if (!notification.getFeature().equals(nameFeature)) continue;
                String oldName = notification.getOldStringValue();
                String newName = notification.getNewStringValue();
                changedModelResource = ModelUtilities.getModelResource((Object)changedObj);
                HashSet affectedDependentModelResources = new HashSet();
                affectedDependentModelResources.addAll(ModelUtilities.getResourcesThatUse((ModelResource)changedModelResource));
                for (ModelResource modelResource : affectedDependentModelResources) {
                    EmfResource emfRes = (EmfResource)modelResource.getEmfResource();
                    ModelEditor mEditor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)false);
                    List transformations = emfRes.getModelContents().getTransformations();
                    for (EObject eObj : transformations) {
                        TransformationObjectEditorPage transOEP;
                        ModelObjectEditorPage moep;
                        boolean handled;
                        String changedSql;
                        if (!(eObj instanceof SqlTransformationMappingRoot)) continue;
                        SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)eObj;
                        String sql = TransformationHelper.getSelectSqlString((Object)mappingRoot);
                        boolean statusWasInvalidated = false;
                        if (sql != null && (sql.contains(oldName) || sql.contains(oldName.toUpperCase()))) {
                            changedSql = null;
                            changedSql = sql.contains(oldName) ? sql.replaceAll(oldName, newName) : sql.replaceAll(oldName.toUpperCase(), newName.toUpperCase());
                            statusWasInvalidated = true;
                            SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                            handled = false;
                            if (mEditor != null && (moep = mEditor.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
                                transOEP = (TransformationObjectEditorPage)moep;
                                handled = this.updateSqlEditorPanel(transOEP, 0, (EObject)mappingRoot, changedSql);
                            }
                            if (!handled) {
                                dependentModelChanged = true;
                                this.updateSqlInTransaction((EObject)mappingRoot, 0, changedSql, false, txnSource);
                            }
                        }
                        if ((sql = TransformationHelper.getInsertSqlString((Object)mappingRoot)) != null && (sql.contains(oldName) || sql.contains(oldName.toUpperCase()))) {
                            changedSql = null;
                            changedSql = sql.contains(oldName) ? sql.replaceAll(oldName, newName) : sql.replaceAll(oldName.toUpperCase(), newName.toUpperCase());
                            if (!statusWasInvalidated) {
                                SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                            }
                            handled = false;
                            if (mEditor != null && (moep = mEditor.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
                                transOEP = (TransformationObjectEditorPage)moep;
                                handled = this.updateSqlEditorPanel(transOEP, 1, (EObject)mappingRoot, changedSql);
                            }
                            if (!handled) {
                                dependentModelChanged = true;
                                this.updateSqlInTransaction((EObject)mappingRoot, 1, changedSql, false, txnSource);
                            }
                        }
                        if ((sql = TransformationHelper.getUpdateSqlString((Object)mappingRoot)) != null && (sql.contains(oldName) || sql.contains(oldName.toUpperCase()))) {
                            changedSql = null;
                            changedSql = sql.contains(oldName) ? sql.replaceAll(oldName, newName) : sql.replaceAll(oldName.toUpperCase(), newName.toUpperCase());
                            if (!statusWasInvalidated) {
                                SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                            }
                            handled = false;
                            if (mEditor != null && (moep = mEditor.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
                                transOEP = (TransformationObjectEditorPage)moep;
                                handled = this.updateSqlEditorPanel(transOEP, 2, (EObject)mappingRoot, changedSql);
                            }
                            if (!handled) {
                                dependentModelChanged = true;
                                this.updateSqlInTransaction((EObject)mappingRoot, 2, changedSql, false, txnSource);
                            }
                        }
                        if ((sql = TransformationHelper.getDeleteSqlString((Object)mappingRoot)) != null && (sql.contains(oldName) || sql.contains(oldName.toUpperCase()))) {
                            changedSql = null;
                            changedSql = sql.contains(oldName) ? sql.replaceAll(oldName, newName) : sql.replaceAll(oldName.toUpperCase(), newName.toUpperCase());
                            if (!statusWasInvalidated) {
                                SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                            }
                            handled = false;
                            if (mEditor != null && (moep = mEditor.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
                                transOEP = (TransformationObjectEditorPage)moep;
                                handled = this.updateSqlEditorPanel(transOEP, 3, (EObject)mappingRoot, changedSql);
                            }
                            if (!handled) {
                                dependentModelChanged = true;
                                this.updateSqlInTransaction((EObject)mappingRoot, 3, changedSql, false, txnSource);
                            }
                        }
                        if (!dependentModelChanged) continue;
                        EList sqlAliases = ((SqlTransformation)mappingRoot.getHelper()).getAliases();
                        SqlAlias oldAlias = null;
                        for (EObject sqlAlias : sqlAliases) {
                            if (!(sqlAlias instanceof SqlAlias) || !((SqlAlias)sqlAlias).getAlias().equalsIgnoreCase(oldName)) continue;
                            oldAlias = (SqlAlias)sqlAlias;
                            break;
                        }
                        if (oldAlias == null) continue;
                        this.swapAliasInTransaction((EObject)mappingRoot, oldAlias, newName);
                    }
                    if (!dependentModelChanged || modelResource == null) continue;
                    changedMRs.add(modelResource);
                }
            }
            catch (ModelWorkspaceException ex) {
                Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        if (!changedMRs.isEmpty()) {
            for (ModelResource mr : changedMRs) {
                try {
                    this.rebuildImportsInTransaction(mr.getEmfResource());
                    mr.save((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (ModelWorkspaceException ex) {
                    Util.log(4, (Throwable)ex, ex.getMessage());
                }
            }
        }
    }

    @Override
    public void handleNotifications(Collection notifications, Object txnSource) {
        Collection functionObjectChanges;
        if (!notifications.isEmpty() && !(functionObjectChanges = this.getModelChangeNotifications(notifications, txnSource)).isEmpty()) {
            this.handleModelChangeNotification(functionObjectChanges, txnSource);
        }
    }

    @Override
    public void processModelResourceEvent(ModelResourceEvent event) {
        if (ModelIdentifier.isFunctionModel((ModelResource)event.getModelResource()) && (event.getType() == 6 || event.getType() == 4 || event.getType() == 8)) {
            HashSet affectedDependentModelResources = new HashSet();
            affectedDependentModelResources.addAll(ModelUtilities.getResourcesThatUse((ModelResource)event.getModelResource()));
            for (ModelResource modelResource : affectedDependentModelResources) {
                try {
                    EmfResource emfRes = (EmfResource)modelResource.getEmfResource();
                    List transformations = emfRes.getModelContents().getTransformations();
                    for (EObject eObj : transformations) {
                        if (!(eObj instanceof SqlTransformationMappingRoot)) continue;
                        SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)eObj;
                        SqlMappingRootCache.invalidateStatus((Object)mappingRoot, (boolean)false, (Object)this);
                    }
                }
                catch (ModelWorkspaceException e) {
                    Util.log(4, (Throwable)e, e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean shouldHandleChangedObject(Object object) {
        return this.isFunctionModelObject(object);
    }

    private void updateSqlInTransaction(EObject mappingRoot, int sqlType, String sql, boolean significant, Object txnSource) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update SQL on function object change", (Object)this);
        boolean succeeded = false;
        try {
            switch (sqlType) {
                case 0: {
                    TransformationHelper.setSelectSqlString((Object)mappingRoot, (String)sql, (boolean)false, (Object)txnSource);
                    break;
                }
                case 1: {
                    TransformationHelper.setInsertSqlString((Object)mappingRoot, (String)sql, (boolean)false, (Object)txnSource);
                    break;
                }
                case 2: {
                    TransformationHelper.setUpdateSqlString((Object)mappingRoot, (String)sql, (boolean)false, (Object)txnSource);
                    break;
                }
                case 3: {
                    TransformationHelper.setDeleteSqlString((Object)mappingRoot, (String)sql, (boolean)false, (Object)txnSource);
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private boolean updateSqlEditorPanel(TransformationObjectEditorPage transOEP, int sqlType, EObject mappingRoot, String changedSql) {
        if (transOEP.getCurrentMappingRoot() == mappingRoot) {
            int panelType = transOEP.getCurrentSqlEditor().getPanelType();
            switch (sqlType) {
                case 0: {
                    if (panelType != 0 && panelType != 1) break;
                    this.updateSqlTextInTransaction(transOEP, mappingRoot, changedSql);
                    return true;
                }
                case 1: {
                    if (panelType != 2) break;
                    this.updateSqlTextInTransaction(transOEP, mappingRoot, changedSql);
                    return true;
                }
                case 2: {
                    if (panelType != 3) break;
                    this.updateSqlTextInTransaction(transOEP, mappingRoot, changedSql);
                    return true;
                }
                case 3: {
                    if (panelType != 4) break;
                    this.updateSqlTextInTransaction(transOEP, mappingRoot, changedSql);
                    return true;
                }
            }
        }
        return false;
    }

    private void updateSqlTextInTransaction(TransformationObjectEditorPage transOEP, EObject mappingRoot, String changedSql) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update SQL on function object change", (Object)this);
        boolean succeeded = false;
        try {
            transOEP.getCurrentSqlEditor().setText(changedSql);
            transOEP.updateMessagePanel();
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void swapAliasInTransaction(EObject mappingRoot, SqlAlias oldAlias, String newName) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"SQL Alias on function object change", (Object)this);
        boolean succeeded = false;
        try {
            EObject target = oldAlias.getAliasedObject();
            boolean removed = TransformationHelper.removeSourceAlias((Object)mappingRoot, (EObject)target, (String)oldAlias.getAlias(), (boolean)false, (Object)this);
            if (removed) {
                TransformationHelper.addSqlAlias((Object)mappingRoot, (EObject)target, (String)newName, (boolean)false, (Object)this);
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void rebuildImportsInTransaction(Resource resource) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Rebuild Imports", (Object)this);
        boolean succeeded = false;
        try {
            ModelBuildUtil.rebuildImports((Resource)resource, (boolean)true);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSourceModelWithPushdownFunction(ModelResource modelResource) {
        try {
            Object eObj;
            String uri = modelResource.getPrimaryMetamodelUri();
            if (!"http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(uri) && modelResource.getModelType() != ModelType.PHYSICAL_LITERAL) {
                return false;
            }
            ModelObjectCollector moc = new ModelObjectCollector(modelResource.getEmfResource());
            Iterator iterator = moc.getEObjects().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((eObj = iterator.next()) instanceof Procedure) || !((Procedure)eObj).isFunction());
            return true;
        }
        catch (ModelWorkspaceException ex) {
            Util.log(4, (Throwable)ex, ex.getMessage());
        }
        return false;
    }

    private boolean isFunction(EObject eObject) {
        if (eObject instanceof ScalarFunction) {
            return true;
        }
        return eObject instanceof Procedure && ((Procedure)eObject).isFunction();
    }
}

