/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.BindingCellModifier;
import org.teiid.designer.transformation.ui.reconciler.BindingLabelProvider;
import org.teiid.designer.transformation.ui.reconciler.BindingList;
import org.teiid.designer.transformation.ui.reconciler.ColorManager;
import org.teiid.designer.transformation.ui.reconciler.IBindingListViewer;
import org.teiid.designer.transformation.ui.reconciler.datatype.DatatypeReconcilerDialog;
import org.teiid.designer.ui.common.table.TableSizeAdapter;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class BindingsTablePanel
extends Composite {
    private static final int BUTTON_GRID_STYLE = 576;
    private static final int LABEL_GRID_STYLE = 32;
    private static final String LOCKED_CHECKBOX_TEXT = UiConstants.Util.getString("BindingsTablePanel.lockedCheckbox.text", new Object[0]);
    private static final String UP_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.upAttrButton.text", new Object[0]);
    private static final String DOWN_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.downAttrButton.text", new Object[0]);
    private static final String SWAP_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.swapAttrButton.text", new Object[0]);
    private static final String TOP_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.topAttrButton.text", new Object[0]);
    private static final String BOTTOM_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.bottomAttrButton.text", new Object[0]);
    private static final String DELETE_ATTR_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.deleteAttrButton.text", new Object[0]);
    private static final String RESOLVE_TYPE_BUTTON_TEXT = UiConstants.Util.getString("BindingsTablePanel.resolveTypeButton.text", new Object[0]);
    private static final String BINDINGS_TABLE_TITLE_TEXT = UiConstants.Util.getString("BindingsTablePanel.table.title", new Object[0]);
    private static final String BINDINGS_TABLE_DATAYPE_NOTE_TEXT = UiConstants.Util.getString("BindingsTablePanel.datatype.note", new Object[0]);
    private static final String BINDINGS_TABLE_ATTR_COL_TEXT = UiConstants.Util.getString("BindingsTablePanel.attrCol.title", new Object[0]);
    private static final String BINDINGS_TABLE_SQL_COL_TEXT = UiConstants.Util.getString("BindingsTablePanel.sqlColumn.title", new Object[0]);
    private static final String DATATYPE_RECONCILER_DIALOG_TITLE = UiConstants.Util.getString("DatatypeReconciler.title.text", new Object[0]);
    private final String ATTRIBUTE_COLUMN = "attribute";
    private final String SQL_COLUMN = "sql";
    private ColorManager colorManager = new ColorManager();
    BindingList bindingList;
    private Table table;
    TableViewer tableViewer;
    private Button upButton;
    private Button downButton;
    private Button swapButton;
    private Button topButton;
    private Button bottomButton;
    private Button deleteButton;
    private Button resolveTypeButton;
    private Button targetLockedCheckbox;
    private boolean sqlModifiable = true;
    private boolean isReadOnly = false;
    String[] columnNames = new String[]{"attribute", "sql"};

    public BindingsTablePanel(Composite parent) {
        super(parent, 0);
        this.init();
    }

    public BindingsTablePanel(Composite parent, boolean readOnlyState) {
        super(parent, 0);
        this.isReadOnly = readOnlyState;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        WidgetFactory.createLabel((Composite)this, (int)32, (int)1, (String)BINDINGS_TABLE_DATAYPE_NOTE_TEXT);
        Composite comp = new Composite((Composite)this, 0);
        GridData gridDataComp = new GridData(768);
        comp.setLayoutData((Object)gridDataComp);
        GridLayout gridLayout2 = new GridLayout();
        comp.setLayout((Layout)gridLayout2);
        gridLayout2.numColumns = 2;
        GridData gridDataLeft = new GridData(1808);
        gridDataLeft.horizontalAlignment = 1;
        this.targetLockedCheckbox = WidgetFactory.createCheckBox((Composite)comp, (String)LOCKED_CHECKBOX_TEXT);
        this.targetLockedCheckbox.setEnabled(!this.isReadOnly);
        this.targetLockedCheckbox.setLayoutData((Object)gridDataLeft);
        this.targetLockedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                BindingsTablePanel.this.targetLockedChanged();
            }
        });
        GridData gridDataRight = new GridData(1808);
        gridDataRight.horizontalAlignment = 0x1000008;
        org.teiid.designer.ui.common.widget.Label leftLabel = WidgetFactory.createLabel((Composite)comp, (int)32, (int)2, (String)BINDINGS_TABLE_TITLE_TEXT);
        leftLabel.setLayoutData((Object)gridDataRight);
        this.createTableViewerPanel();
        this.createControlButtonPanel();
        this.setButtonStates();
    }

    private void createTableViewerPanel() {
        this.createTable(this);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new BindingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider(true));
        this.bindingList = new BindingList();
        this.tableViewer.setInput((Object)this.bindingList);
    }

    private void createControlButtonPanel() {
        Composite buttonComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        buttonComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 9;
        GridData gridData = new GridData(64);
        buttonComposite.setLayoutData((Object)gridData);
        this.topButton = WidgetFactory.createButton((Composite)buttonComposite, (String)TOP_ATTR_BUTTON_TEXT, (int)576);
        this.topButton.setEnabled(!this.isReadOnly);
        this.topButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.topButtonPressed();
            }
        });
        this.upButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UP_ATTR_BUTTON_TEXT, (int)576);
        this.upButton.setEnabled(!this.isReadOnly);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.upButtonPressed();
            }
        });
        this.swapButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SWAP_ATTR_BUTTON_TEXT, (int)576);
        this.swapButton.setEnabled(!this.isReadOnly);
        this.swapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.swapButtonPressed();
            }
        });
        this.downButton = WidgetFactory.createButton((Composite)buttonComposite, (String)DOWN_ATTR_BUTTON_TEXT, (int)576);
        this.downButton.setEnabled(!this.isReadOnly);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.downButtonPressed();
            }
        });
        this.bottomButton = WidgetFactory.createButton((Composite)buttonComposite, (String)BOTTOM_ATTR_BUTTON_TEXT, (int)576);
        this.bottomButton.setEnabled(!this.isReadOnly);
        this.bottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.bottomButtonPressed();
            }
        });
        WidgetFactory.createLabel((Composite)buttonComposite, (int)576, (String)"    ");
        this.deleteButton = WidgetFactory.createButton((Composite)buttonComposite, (String)DELETE_ATTR_BUTTON_TEXT, (int)576);
        this.deleteButton.setEnabled(!this.isReadOnly);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.deleteButtonPressed();
            }
        });
        WidgetFactory.createLabel((Composite)buttonComposite, (int)576, (String)"    ");
        this.resolveTypeButton = WidgetFactory.createButton((Composite)buttonComposite, (String)RESOLVE_TYPE_BUTTON_TEXT, (int)576);
        this.resolveTypeButton.setEnabled(!this.isReadOnly);
        this.resolveTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingsTablePanel.this.resolveTypeButtonPressed();
            }
        });
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.table, 16384, 0);
        column1.setText(BINDINGS_TABLE_ATTR_COL_TEXT);
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column2 = new TableColumn(this.table, 16384, 1);
        column2.setText(BINDINGS_TABLE_SQL_COL_TEXT);
        weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        this.createTableTooltipListeners(this.table);
        new TableSizeAdapter(this.table, 10);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        editors[1] = null;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new BindingCellModifier(this));
    }

    private void createTableTooltipListeners(final Table table) {
        table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Point pt = new Point(event.x, event.y);
                        int index = table.getTopIndex();
                        while (index < table.getItemCount()) {
                            TableItem item = table.getItem(index);
                            int iCol = 0;
                            while (iCol < BindingsTablePanel.this.columnNames.length) {
                                Rectangle rect = item.getBounds(iCol);
                                if (rect.contains(pt)) {
                                    if (this.tip != null && !this.tip.isDisposed()) {
                                        this.tip.dispose();
                                    }
                                    this.tip = new Shell(BindingsTablePanel.this.getShell(), 16384);
                                    this.tip.setLayout((Layout)new FillLayout());
                                    this.label = new Label((Composite)this.tip, 0);
                                    this.label.setForeground(BindingsTablePanel.this.getShell().getDisplay().getSystemColor(28));
                                    this.label.setBackground(BindingsTablePanel.this.getShell().getDisplay().getSystemColor(29));
                                    this.label.setData("_TABLEITEM", (Object)item);
                                    Object data = item.getData();
                                    String tipText = null;
                                    if (data != null && data instanceof Binding) {
                                        IExpression symbol;
                                        if (iCol == 0) {
                                            tipText = ((Binding)data).getAttributeFullName();
                                        } else if (iCol == 1 && (symbol = ((Binding)data).getCurrentSymbol()) != null) {
                                            IQueryService queryService = ModelerCore.getTeiidQueryService();
                                            tipText = queryService.getSymbolName(symbol);
                                        }
                                    }
                                    if (tipText != null) {
                                        this.label.setText(tipText);
                                    }
                                    this.label.addListener(7, labelListener);
                                    this.label.addListener(3, labelListener);
                                    Point size = this.tip.computeSize(-1, -1);
                                    Point pt2 = table.toDisplay(rect.x, rect.y);
                                    this.tip.setBounds(pt2.x, pt2.y, size.x, size.y);
                                    this.tip.setVisible(true);
                                }
                                ++iCol;
                            }
                            ++index;
                        }
                        break;
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
    }

    public void setTargetLocked(boolean isLocked) {
        this.targetLockedCheckbox.setSelection(isLocked);
    }

    public void addTableSelectionListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void removeTableSelectionListener(ISelectionChangedListener listener) {
        this.tableViewer.removeSelectionChangedListener(listener);
    }

    public void addTargetLockedCheckboxListener(SelectionListener listener) {
        this.targetLockedCheckbox.addSelectionListener(listener);
    }

    public void removeTargetLockedCheckboxListener(SelectionListener listener) {
        this.targetLockedCheckbox.removeSelectionListener(listener);
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void selectNextBound(Binding binding) {
        Binding nextSelection = this.bindingList.getNextBound(binding);
        if (nextSelection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        }
    }

    public void selectNextUnbound(Binding binding) {
        Binding nextSelection = this.bindingList.getNextUnbound(binding);
        if (nextSelection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        }
    }

    public void selectFirstBound() {
        Binding nextSelection = this.bindingList.getFirstBound();
        if (nextSelection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        }
    }

    public void selectFirstUnbound() {
        Binding nextSelection = this.bindingList.getFirstUnbound();
        if (nextSelection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        }
    }

    public void setBindingList(BindingList list) {
        this.bindingList = list;
        this.tableViewer.setInput((Object)this.bindingList);
        this.table.getColumn(0).pack();
        this.table.getColumn(1).pack();
        this.table.pack();
        this.setButtonStates();
        this.updateRowColors();
    }

    public BindingList getBindingList() {
        return this.bindingList;
    }

    public void addBinding(Binding binding) {
        this.bindingList.add(binding);
    }

    public List getSelectedBindings() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        return selection.toList();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public boolean isTargetLocked() {
        return this.targetLockedCheckbox.getSelection();
    }

    public void setButtonStates() {
        if (this.isReadOnly) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.swapButton.setEnabled(false);
            this.topButton.setEnabled(false);
            this.bottomButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.resolveTypeButton.setEnabled(false);
            return;
        }
        boolean upEnabled = false;
        boolean downEnabled = false;
        boolean swapEnabled = false;
        boolean deleteEnabled = false;
        boolean resolveTypeEnabled = false;
        int[] selectedBindings = this.table.getSelectionIndices();
        int nSelected = selectedBindings.length;
        List allBindings = this.bindingList.getAll();
        for (Binding binding : allBindings) {
            if (!binding.isBound() || !binding.hasTypeConflict()) continue;
            resolveTypeEnabled = true;
            break;
        }
        if (!this.targetLockedCheckbox.getSelection()) {
            int nBindings = this.getBindingList().size();
            if (nSelected >= 1) {
                deleteEnabled = true;
            }
            if (nBindings > 1 && this.sqlModifiable) {
                if (nSelected == 1) {
                    if (selectedBindings[0] != nBindings - 1) {
                        downEnabled = true;
                    }
                    if (selectedBindings[0] != 0) {
                        upEnabled = true;
                    }
                } else if (nSelected == 2) {
                    swapEnabled = true;
                }
            }
        }
        this.upButton.setEnabled(upEnabled);
        this.topButton.setEnabled(upEnabled);
        this.downButton.setEnabled(downEnabled);
        this.bottomButton.setEnabled(downEnabled);
        this.swapButton.setEnabled(swapEnabled);
        this.deleteButton.setEnabled(deleteEnabled);
        this.resolveTypeButton.setEnabled(resolveTypeEnabled);
    }

    public void updateRowColors() {
        int rows = this.table.getItemCount();
        int i = 0;
        while (i < rows) {
            TableItem item = this.table.getItem(i);
            Binding binding = this.getBindingList().get(i);
            if (!binding.isBound() || binding.hasTypeConflict()) {
                item.setBackground(this.colorManager.getColor(ColorManager.UNBOUND_BACKGROUND));
            } else {
                item.setBackground(this.colorManager.getColor(ColorManager.BOUND_BACKGROUND));
            }
            ++i;
        }
    }

    void upButtonPressed() {
        List selections = this.getSelectedBindings();
        if (selections.size() == 1) {
            this.bindingList.moveUp((Binding)selections.get(0));
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selections), true);
    }

    void downButtonPressed() {
        List selections = this.getSelectedBindings();
        if (selections.size() == 1) {
            this.bindingList.moveDown((Binding)selections.get(0));
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selections), true);
    }

    void swapButtonPressed() {
        List selections = this.getSelectedBindings();
        if (selections.size() == 2) {
            this.bindingList.swap((Binding)selections.get(0), (Binding)selections.get(1));
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selections), true);
    }

    void topButtonPressed() {
        List selections = this.getSelectedBindings();
        if (selections.size() == 1) {
            this.bindingList.moveTop((Binding)selections.get(0));
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selections), true);
    }

    void bottomButtonPressed() {
        List selections = this.getSelectedBindings();
        if (selections.size() == 1) {
            this.bindingList.moveBottom((Binding)selections.get(0));
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selections), true);
    }

    void deleteButtonPressed() {
        List selections = this.getSelectedBindings();
        if (!selections.isEmpty()) {
            this.bindingList.removeAll(selections);
        }
        this.bindingList.refresh(true);
    }

    void resolveTypeButtonPressed() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        BindingList typeConflictBindings = new BindingList();
        int i = 0;
        while (i < this.bindingList.size()) {
            Binding currentBinding = this.bindingList.get(i);
            if (currentBinding.isBound() && currentBinding.hasTypeConflict()) {
                typeConflictBindings.add(currentBinding);
            }
            ++i;
        }
        boolean isLocked = this.targetLockedCheckbox.getSelection();
        DatatypeReconcilerDialog datatypeReconcilerDialog = new DatatypeReconcilerDialog(shell, typeConflictBindings, isLocked, this.colorManager, DATATYPE_RECONCILER_DIALOG_TITLE);
        int returnStatus = datatypeReconcilerDialog.open();
        if (returnStatus == 0) {
            if (datatypeReconcilerDialog.hasModifications()) {
                datatypeReconcilerDialog.applyBindingTypeModifications();
            }
        } else {
            datatypeReconcilerDialog.clearBindingTypeModifications();
        }
        this.bindingList.refresh(true);
        this.updateRowColors();
        this.setButtonStates();
    }

    void targetLockedChanged() {
        this.setButtonStates();
    }

    class BindingContentProvider
    implements IStructuredContentProvider,
    IBindingListViewer {
        BindingContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((BindingList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((BindingList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            BindingsTablePanel.this.bindingList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return BindingsTablePanel.this.bindingList.getAll().toArray();
        }

        @Override
        public void addBinding(Binding binding) {
            BindingsTablePanel.this.tableViewer.add((Object)binding);
        }

        @Override
        public void insertBinding(Binding binding, int index) {
            BindingsTablePanel.this.tableViewer.insert((Object)binding, index);
        }

        @Override
        public void addBindings(Object[] bindings) {
            BindingsTablePanel.this.tableViewer.add(bindings);
        }

        @Override
        public void removeBinding(Binding binding) {
            BindingsTablePanel.this.tableViewer.remove((Object)binding);
        }

        @Override
        public void removeBindings(Object[] bindings) {
            BindingsTablePanel.this.tableViewer.remove(bindings);
        }

        @Override
        public void updateBinding(Binding binding) {
            BindingsTablePanel.this.tableViewer.update((Object)binding, null);
        }

        @Override
        public void refresh(boolean updateLabels) {
            BindingsTablePanel.this.tableViewer.refresh(updateLabels);
        }
    }
}

