/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelFactoryImpl;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.NotationModelGenerator;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlPackageNode;
import org.teiid.designer.diagram.ui.util.DiagramEntityAdapter;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.connection.TransformationLink;
import org.teiid.designer.transformation.ui.model.TransformationDiagramNode;
import org.teiid.designer.transformation.ui.model.TransformationDiagramNotificationHelper;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;
import org.teiid.designer.transformation.ui.util.TransformationUmlEObjectHelper;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TransformationDiagramModelFactory
extends DiagramModelFactoryImpl
implements UiConstants {
    private static final String KEY_TRANSFORMATION_DIAGRAM_NAME = "DiagramNames.transformationDiagram";
    private static final String THIS_CLASS = "TransformationDiagramModelFactory";
    private String sNotationId;
    private NotationModelGenerator generator;
    private boolean hideLinksAlways = false;

    protected void setNotationId(String sNotationId) {
        this.sNotationId = sNotationId;
    }

    protected String getNotationId() {
        return this.sNotationId;
    }

    public DiagramModelNode createModel(Object baseObject) {
        return null;
    }

    public DiagramModelNode createModel(Object baseObject, String sNotationId, IProgressMonitor monitor) {
        if (!(baseObject instanceof Diagram)) {
            return null;
        }
        this.setNotationId(sNotationId);
        Diagram diagram = (Diagram)baseObject;
        TransformationDiagramNode diagramModelNode = null;
        diagramModelNode = new TransformationDiagramNode((EObject)diagram, UiConstants.Util.getString(KEY_TRANSFORMATION_DIAGRAM_NAME, new Object[0]));
        diagramModelNode.addChildren(this.getTransformationDiagramContents((DiagramModelNode)diagramModelNode, diagram));
        this.cleanDiagramEntities(diagram);
        if (diagram.getType() != null && diagram.getType().equals("dependencyDiagramType")) {
            this.addDependencies((DiagramModelNode)diagramModelNode, diagram);
        }
        this.addLockedImages((DiagramModelNode)diagramModelNode);
        return diagramModelNode;
    }

    private boolean isDependencyDiagram(Diagram diagram) {
        return diagram.getType() != null && diagram.getType().equals("dependencyDiagramType");
    }

    private boolean isDependencyDiagram(DiagramModelNode diagramNode) {
        if (diagramNode.getModelObject() instanceof Diagram) {
            return this.isDependencyDiagram((Diagram)diagramNode.getModelObject());
        }
        return false;
    }

    protected List getTransformationDiagramContents(DiagramModelNode diagramModelNode, Diagram transformationDiagram) {
        ArrayList<Object> diagramContents = new ArrayList<Object>();
        EObject virtualGroupEObject = transformationDiagram.getTarget();
        DiagramModelNode targetModelNode = null;
        if (this.getGenerator() != null) {
            targetModelNode = this.getGenerator().createModel((Object)virtualGroupEObject, transformationDiagram);
            if (targetModelNode != null) {
                diagramContents.add(targetModelNode);
            }
        } else {
            UiConstants.Util.log(2, UiConstants.Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
        }
        EObject transformationEObject = this.getTransformationObject(virtualGroupEObject);
        TransformationNode transformNode = new TransformationNode(transformationDiagram, transformationEObject);
        diagramContents.add((Object)transformNode);
        List labelNodes = null;
        if (this.showLinksInTransformation(diagramModelNode)) {
            TransformationLink targetLink = this.getTargetConnectionModel((DiagramModelNode)transformNode, targetModelNode);
            ((DiagramModelNode)targetLink.getSourceNode()).addSourceConnection((NodeConnectionModel)targetLink);
            ((DiagramModelNode)targetLink.getTargetNode()).addTargetConnection((NodeConnectionModel)targetLink);
            labelNodes = targetLink.getLabelNodes();
            if (labelNodes != null && !labelNodes.isEmpty()) {
                diagramContents.addAll(labelNodes);
            }
        }
        Iterator sourceIter = this.getSourceEObjects(transformationEObject).iterator();
        EObject nextSourceEObject = null;
        DiagramModelNode nextSourceNode = null;
        TransformationLink sourceLink = null;
        while (sourceIter.hasNext()) {
            nextSourceEObject = (EObject)sourceIter.next();
            if (this.getGenerator() != null) {
                nextSourceNode = this.getGenerator().createModel((Object)nextSourceEObject, transformationDiagram);
                if (nextSourceNode != null) {
                    diagramContents.add(nextSourceNode);
                }
            } else {
                UiConstants.Util.log(2, UiConstants.Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
            }
            if (!this.showLinksInTransformation(diagramModelNode) || nextSourceNode == null) continue;
            sourceLink = this.getSourceConnectionModel(nextSourceNode, (DiagramModelNode)transformNode);
            ((DiagramModelNode)sourceLink.getSourceNode()).addSourceConnection((NodeConnectionModel)sourceLink);
            ((DiagramModelNode)sourceLink.getTargetNode()).addTargetConnection((NodeConnectionModel)sourceLink);
            labelNodes = sourceLink.getLabelNodes();
            if (labelNodes == null || labelNodes.isEmpty()) continue;
            diagramContents.addAll(labelNodes);
        }
        return diagramContents;
    }

    protected void cleanDiagramEntities(Diagram diagram) {
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram);
        if (mr != null && !mr.isReadOnly() && ModelUtilities.allDependenciesOpenInWorkspace((ModelResource)mr)) {
            DiagramEntityManager.cleanDiagramEntities((Diagram)diagram);
        }
    }

    protected NotationModelGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = DiagramUiPlugin.getDiagramNotationManager().getDiagramModelGenerator(this.getNotationId());
        }
        return this.generator;
    }

    protected List getSourceEObjects(EObject transformationEObject) {
        List sourceEObjects = TransformationSourceManager.getSourceEObjects(transformationEObject);
        ArrayList<EObject> realEObjects = new ArrayList<EObject>(sourceEObjects.size());
        Iterator iter = sourceEObjects.iterator();
        EObject pseudoEObj = null;
        EObject realEObj = null;
        while (iter.hasNext()) {
            pseudoEObj = (EObject)iter.next();
            realEObj = ModelObjectUtilities.getRealEObject((EObject)pseudoEObj);
            if (realEObj == null) continue;
            realEObjects.add(realEObj);
        }
        return realEObjects;
    }

    protected List getDiagramEObjects(DiagramModelNode transformationDiagramModelNode) {
        Iterator iter = transformationDiagramModelNode.getChildren().iterator();
        ArrayList<EObject> diagramEObjects = new ArrayList<EObject>();
        DiagramModelNode nextDMN = null;
        while (iter.hasNext()) {
            nextDMN = (DiagramModelNode)iter.next();
            if (nextDMN.getModelObject() == null) continue;
            diagramEObjects.add(nextDMN.getModelObject());
        }
        return diagramEObjects;
    }

    private boolean isValidDiagram(DiagramModelNode diagramModelNode) {
        String type;
        ModelResource mr;
        boolean result = false;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (diagram != null && diagram.getTarget() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null && (type = diagram.getType()) != null && (type.equals("transformationDiagramType") || type.equals("dependencyDiagramType"))) {
            result = true;
        }
        return result;
    }

    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        TransformationDiagramNotificationHelper notificationHelper;
        boolean currentDiagramOK = true;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (this.currentDiagramRemoved(diagram)) {
            currentDiagramOK = false;
        }
        if (currentDiagramOK && this.isValidDiagram(diagramModelNode) && this.sourceIsNotThis(notification) && (notificationHelper = new TransformationDiagramNotificationHelper(notification, diagramModelNode)).shouldHandleNotification()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update Transforamation Diagram", (Object)this);
            boolean succeeded = false;
            boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction((Diagram)diagram);
            try {
                try {
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramUnderConstruction((Diagram)diagram);
                    }
                    this.handleNotification(notificationHelper);
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                    }
                    diagramModelNode.update("layout");
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                }
                diagramModelNode.update("layout");
            }
        }
        return currentDiagramOK;
    }

    private boolean sourceIsNotThis(Notification notification) {
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            if (source == null) {
                return true;
            }
            return !source.equals(this);
        }
        return true;
    }

    protected TransformationLink getTargetConnectionModel(DiagramModelNode transformationNode, DiagramModelNode targetClassifierNode) {
        TransformationLink association = new TransformationLink(transformationNode, targetClassifierNode);
        return association;
    }

    protected TransformationLink getSourceConnectionModel(DiagramModelNode sourceClassifierNode, DiagramModelNode transformationNode) {
        TransformationLink association = new TransformationLink(sourceClassifierNode, transformationNode);
        return association;
    }

    public EObject getTransformationObject(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getTransformationMappingRoot((EObject)targetVirtualGroupEObject);
    }

    private void handleNotification(TransformationDiagramNotificationHelper notificationHelper) {
        boolean associationsChanged = false;
        boolean updateLayout = false;
        if (notificationHelper.shouldReconcileSources()) {
            this.reconcileSourceTables(notificationHelper.getDiagramNode());
            associationsChanged = true;
        }
        Iterator iter = notificationHelper.getReconcileTableNodes().iterator();
        DiagramModelNode diagramNode2 = null;
        while (iter.hasNext()) {
            diagramNode2 = (DiagramModelNode)iter.next();
            if (diagramNode2 instanceof UmlClassifierNode) {
                ((UmlClassifierNode)diagramNode2).reconcile();
                diagramNode2.update("connection");
                updateLayout = true;
            }
            if (this.isNestedClassifier(diagramNode2)) {
                DiagramModelNode parentClassifierNode = DiagramUiUtilities.getClassifierParentNode((DiagramModelNode)diagramNode2);
                parentClassifierNode.updateForChild(false);
                updateLayout = true;
                continue;
            }
            diagramNode2.updateForChild(false);
            updateLayout = true;
        }
        for (DiagramModelNode diagramNode2 : notificationHelper.getChangedNodes()) {
            this.getGenerator().performUpdate(diagramNode2, null);
            if (!associationsChanged && this.getGenerator().isAssociation(diagramNode2.getModelObject())) {
                associationsChanged = true;
                continue;
            }
            diagramNode2.updateAssociations();
            updateLayout = true;
        }
        for (DiagramModelNode diagramNode2 : notificationHelper.getMovedNodes()) {
            diagramNode2.updateForChild(true);
        }
        if (associationsChanged) {
            updateLayout = true;
            this.updateAssociations(notificationHelper.getDiagramNode());
            DiagramModelNode tNode = this.getTransformationNode(notificationHelper.getDiagramNode());
            if (tNode != null) {
                tNode.update("name");
            }
        }
        if (updateLayout) {
            notificationHelper.getDiagramNode().update("layout");
        }
        DiagramEntityManager.cleanUpDiagram((Diagram)((Diagram)notificationHelper.getDiagramNode().getModelObject()));
    }

    public DiagramModelNode getPrimaryDiagramModelNode(DiagramModelNode diagramModelNode, EObject someModelObject) {
        if ((diagramModelNode instanceof UmlClassifierNode || diagramModelNode instanceof TransformationNode) && diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject().equals(someModelObject)) {
            return diagramModelNode;
        }
        DiagramModelNode matchedNode = null;
        List contents = diagramModelNode.getChildren();
        if (contents != null && !contents.isEmpty()) {
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DiagramModelNode nextNode = null;
            while (iter.hasNext() && matchedNode == null) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                nextNode = nextObj;
                matchedNode = this.getPrimaryDiagramModelNode(nextNode, someModelObject);
            }
        }
        return matchedNode;
    }

    protected void performAdd(Notification notification, DiagramModelNode transformationDiagramModelNode) {
        EObject targetObject = this.getEObjectTarget(notification);
        DiagramModelNode targetNode = this.getPrimaryDiagramModelNode(transformationDiagramModelNode, targetObject);
        if (this.canAddOrRemove(targetNode)) {
            if (!this.isNestedClassifier(targetNode)) {
                EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < newChildren.length) {
                    DiagramModelNode dNode = this.getGenerator().createChildModel(targetNode, (Object)newChildren[iChild]);
                    dNode.update("children");
                    dNode.update("layout");
                    ++iChild;
                }
            } else {
                targetNode = this.getModelNode(transformationDiagramModelNode, targetObject);
                if (targetNode != null && this.isNestedClassifier(targetNode)) {
                    EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                    int iChild = 0;
                    while (iChild < newChildren.length) {
                        this.getGenerator().createChildModel(targetNode, (Object)newChildren[iChild]);
                        ++iChild;
                    }
                    targetNode.getParent().getParent().updateForChild(false);
                }
            }
        }
    }

    private boolean canAddOrRemove(DiagramModelNode targetNode) {
        boolean canDo = false;
        if (targetNode != null && targetNode instanceof UmlClassifierNode) {
            canDo = true;
        }
        return canDo;
    }

    private boolean isNestedClassifier(DiagramModelNode targetNode) {
        return targetNode.getParent() instanceof UmlClassifierContainerNode;
    }

    protected void performRemove(Notification notification, DiagramModelNode transformationDiagramModelNode) {
        EObject targetObject = this.getEObjectTarget(notification);
        DiagramModelNode parentNode = this.getPrimaryDiagramModelNode(transformationDiagramModelNode, targetObject);
        if (parentNode != null && this.canAddOrRemove(parentNode)) {
            DiagramModelNode removedNode = null;
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int iChild = 0;
            while (iChild < removedChildren.length) {
                removedNode = this.getModelNode(transformationDiagramModelNode, removedChildren[iChild]);
                if (removedNode != null) {
                    parentNode.removeChild(removedNode, false);
                }
                ++iChild;
            }
            if (this.isNestedClassifier(parentNode)) {
                parentNode.getParent().getParent().updateForChild(false);
            }
            parentNode.update("children");
            parentNode.update("layout");
        }
    }

    protected void performChange(Notification notification, DiagramModelNode transformationDiagramModelNode) {
        EObject targetObject = this.getEObjectTarget(notification);
        DiagramModelNode targetNode = this.getModelNode(transformationDiagramModelNode, targetObject);
        if (targetNode != null) {
            if (notification.getEventType() == 7) {
                targetNode.updateForChild(true);
            } else {
                this.getGenerator().performUpdate(targetNode, notification);
                if (this.getGenerator().isAssociation(targetObject)) {
                    this.updateAssociations(transformationDiagramModelNode);
                } else {
                    targetNode.updateAssociations();
                }
            }
        }
    }

    protected boolean isRemovingSqlObjects(Notification notification) {
        boolean result = true;
        EObject[] removedEObjects = NotificationUtilities.getRemovedChildren((Notification)notification);
        int i = 0;
        while (i < removedEObjects.length) {
            if (!this.isSqlTableOrColumn(removedEObjects[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isSqlTableOrColumn(EObject eObj) {
        boolean result = false;
        if (TransformationHelper.isSqlTable((Object)eObj) || TransformationHelper.isSqlColumn((Object)eObj)) {
            result = true;
        }
        return result;
    }

    protected void clearAllSourceNodes(DiagramModelNode transformationDiagramModelNode) {
        EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)transformationDiagramModelNode.getModelObject());
        Iterator iter = this.getCurrentSourceNodes(transformationDiagramModelNode).iterator();
        DiagramModelNode nextSourceNode = null;
        while (iter.hasNext()) {
            nextSourceNode = (DiagramModelNode)iter.next();
            this.removeSourceTable(transformationEObject, transformationDiagramModelNode, nextSourceNode.getModelObject());
        }
    }

    protected boolean associationExists(DiagramModelNode diagramModelNode, TransformationLink targetAssociation) {
        if (this.showLinksInTransformation(diagramModelNode)) {
            List currentChildren = diagramModelNode.getChildren();
            for (DiagramModelNode childModelNode : currentChildren) {
                Vector sourceConnections = childModelNode.getSourceConnections();
                TransformationLink nextAssociation2 = null;
                for (TransformationLink nextAssociation2 : sourceConnections) {
                    if (!this.associationsMatch((NodeConnectionModel)targetAssociation, (NodeConnectionModel)nextAssociation2)) continue;
                    return true;
                }
                Vector targetConnections = childModelNode.getTargetConnections();
                for (TransformationLink nextAssociation2 : targetConnections) {
                    if (!this.associationsMatch((NodeConnectionModel)targetAssociation, (NodeConnectionModel)nextAssociation2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean associationsMatch(NodeConnectionModel associationOne, NodeConnectionModel associationTwo) {
        if (associationOne.getSourceNode().equals(associationTwo.getSourceNode()) && associationOne.getTargetNode().equals(associationTwo.getTargetNode())) {
            return true;
        }
        return associationTwo.getSourceNode().equals(associationOne.getSourceNode()) && associationTwo.getTargetNode().equals(associationOne.getTargetNode());
    }

    protected List getStaleAssociations(List expectedAssociations, DiagramModelNode diagramModelNode) {
        ArrayList<TransformationLink> staleAssociations = new ArrayList<TransformationLink>();
        if (this.showLinksInTransformation(diagramModelNode)) {
            Iterator iter = this.getCurrentAssociations(diagramModelNode).iterator();
            Iterator expectedIter = null;
            TransformationLink nextCurrentAssociation = null;
            TransformationLink nextExpectedAssociation = null;
            boolean foundMatch = false;
            while (iter.hasNext()) {
                foundMatch = false;
                nextCurrentAssociation = (TransformationLink)((Object)iter.next());
                expectedIter = expectedAssociations.iterator();
                while (expectedIter.hasNext() && !foundMatch) {
                    nextExpectedAssociation = (TransformationLink)((Object)expectedIter.next());
                    if (!this.associationsMatch((NodeConnectionModel)nextExpectedAssociation, (NodeConnectionModel)nextCurrentAssociation)) continue;
                    foundMatch = true;
                }
                if (foundMatch) continue;
                staleAssociations.add(nextCurrentAssociation);
            }
        }
        return staleAssociations;
    }

    protected List getCurrentAssociations(DiagramModelNode diagramModelNode) {
        ArrayList<TransformationLink> currentAssociations = new ArrayList<TransformationLink>();
        if (this.showLinksInTransformation(diagramModelNode)) {
            for (DiagramModelNode childModelNode : diagramModelNode.getChildren()) {
                Vector sourceConnections = childModelNode.getSourceConnections();
                TransformationLink nextAssociation2 = null;
                for (TransformationLink nextAssociation2 : sourceConnections) {
                    if (currentAssociations.contains((Object)nextAssociation2)) continue;
                    currentAssociations.add(nextAssociation2);
                }
                Vector targetConnections = childModelNode.getTargetConnections();
                for (TransformationLink nextAssociation2 : targetConnections) {
                    if (currentAssociations.contains((Object)nextAssociation2)) continue;
                    currentAssociations.add(nextAssociation2);
                }
            }
        }
        return currentAssociations;
    }

    protected DiagramModelNode getTargetNode(DiagramModelNode diagramModelNode) {
        EObject targetObject;
        DiagramModelNode root = null;
        DiagramModelNode transformationModelNode = this.getTransformationNode(diagramModelNode);
        Diagram diagram = transformationModelNode.getDiagram();
        if (diagram != null && (targetObject = diagram.getTarget()) != null) {
            root = DiagramUiUtilities.getDiagramModelNode((EObject)targetObject, (DiagramModelNode)transformationModelNode.getParent());
        }
        return root;
    }

    protected List getCurrentSourceNodes(DiagramModelNode diagramModelNode) {
        ArrayList<DiagramModelNode> currentSourceNodes = new ArrayList<DiagramModelNode>();
        DiagramModelNode rootNode = this.getTargetNode(diagramModelNode);
        Iterator iter = diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof UmlClassifierNode) && !(nextNode instanceof UmlPackageNode) || nextNode == rootNode) continue;
            currentSourceNodes.add(nextNode);
        }
        return currentSourceNodes;
    }

    protected List getVisibleSourceEObjects(DiagramModelNode tranformationDiagramModelNode) {
        ArrayList<EObject> visibleSourceEObjects = new ArrayList<EObject>();
        List visibleSourceNodes = this.getCurrentSourceNodes(tranformationDiagramModelNode);
        Iterator iter = visibleSourceNodes.iterator();
        DiagramModelNode nextSourceNode = null;
        while (iter.hasNext()) {
            nextSourceNode = (DiagramModelNode)iter.next();
            if (nextSourceNode == null) continue;
            visibleSourceEObjects.add(nextSourceNode.getModelObject());
        }
        return visibleSourceEObjects;
    }

    protected List cleanUpStaleAssociations(List staleAssociations, DiagramModelNode diagramModelNode) {
        ArrayList<Object> updatedNodes = new ArrayList<Object>();
        if (this.showLinksInTransformation(diagramModelNode)) {
            Iterator iter = staleAssociations.iterator();
            TransformationLink nextAssociation = null;
            while (iter.hasNext()) {
                nextAssociation = (TransformationLink)((Object)iter.next());
                ((DiagramModelNode)nextAssociation.getSourceNode()).removeSourceConnection((NodeConnectionModel)nextAssociation);
                ((DiagramModelNode)nextAssociation.getTargetNode()).removeTargetConnection((NodeConnectionModel)nextAssociation);
                if (!updatedNodes.contains(nextAssociation.getSourceNode())) {
                    updatedNodes.add(nextAssociation.getSourceNode());
                }
                if (!updatedNodes.contains(nextAssociation.getTargetNode())) {
                    updatedNodes.add(nextAssociation.getTargetNode());
                }
                this.removeLinkLabels(diagramModelNode, nextAssociation);
            }
        }
        return updatedNodes;
    }

    protected List getRealAssociations(boolean isDependency, EObject transformationEObject, DiagramModelNode transformationDiagramModelNode) {
        ArrayList<TransformationLink> realAssociations = new ArrayList<TransformationLink>();
        if (this.showLinksInTransformation(transformationDiagramModelNode)) {
            EObject targetEObject = ((Diagram)transformationDiagramModelNode.getModelObject()).getTarget();
            Iterator sourceIter = this.getSourceEObjects(transformationEObject).iterator();
            DiagramModelNode transformationNode = this.getTransformationNode(transformationDiagramModelNode);
            while (sourceIter.hasNext()) {
                EObject myTransformationEObject;
                DiagramModelNode myTransformationNode;
                EObject nextSourceEObject = (EObject)sourceIter.next();
                DiagramModelNode nextSourceNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextSourceEObject, (DiagramModelNode)transformationDiagramModelNode);
                if (nextSourceNode == null) continue;
                realAssociations.add(new TransformationLink(nextSourceNode, transformationNode));
                if (!isDependency || !ModelObjectUtilities.isVirtual((EObject)nextSourceEObject) || (myTransformationNode = this.getNodeInDiagram(transformationDiagramModelNode, myTransformationEObject = this.getTransformationObject(nextSourceEObject))) == null) continue;
                List depAssocs = this.getRealDependencyAssociations(myTransformationEObject, transformationDiagramModelNode, nextSourceEObject, myTransformationNode);
                realAssociations.addAll(depAssocs);
            }
            DiagramModelNode targetNode = DiagramUiUtilities.getDiagramModelNode((EObject)targetEObject, (DiagramModelNode)transformationDiagramModelNode);
            if (targetNode != null) {
                realAssociations.add(new TransformationLink(transformationNode, targetNode));
            }
        }
        return realAssociations;
    }

    protected List getRealDependencyAssociations(EObject transformationEObject, DiagramModelNode rootDiagramModelNode, EObject targetEObject, DiagramModelNode transformationNode) {
        ArrayList<TransformationLink> realAssociations = new ArrayList<TransformationLink>();
        if (this.showLinksInTransformation(rootDiagramModelNode)) {
            for (EObject nextSourceEObject : this.getSourceEObjects(transformationEObject)) {
                EObject myTransformationEObject;
                DiagramModelNode myTransformationNode;
                DiagramModelNode nextSourceNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextSourceEObject, (DiagramModelNode)rootDiagramModelNode);
                if (nextSourceNode == null) continue;
                realAssociations.add(new TransformationLink(nextSourceNode, transformationNode));
                if (!ModelObjectUtilities.isVirtual((EObject)nextSourceEObject) || TransformationUmlEObjectHelper.getEObjectType(nextSourceEObject) != 1 || (myTransformationNode = this.getNodeInDiagram(rootDiagramModelNode, myTransformationEObject = this.getTransformationObject(nextSourceEObject))) == null) continue;
                List depAssocs = this.getRealDependencyAssociations(myTransformationEObject, rootDiagramModelNode, nextSourceEObject, myTransformationNode);
                realAssociations.addAll(depAssocs);
            }
            DiagramModelNode targetNode = DiagramUiUtilities.getDiagramModelNode((EObject)targetEObject, (DiagramModelNode)rootDiagramModelNode);
            if (targetNode != null) {
                realAssociations.add(new TransformationLink(transformationNode, targetNode));
            }
        }
        return realAssociations;
    }

    protected void updateAssociations(DiagramModelNode transformationDiagramModelNode) {
        if (this.showLinksInTransformation(transformationDiagramModelNode)) {
            Diagram diagram = (Diagram)transformationDiagramModelNode.getModelObject();
            EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(diagram);
            if (transformationEObject == null) {
                return;
            }
            boolean isDep = "dependencyDiagramType".equals(diagram.getType());
            List realAssociations = this.getRealAssociations(isDep, transformationEObject, transformationDiagramModelNode);
            List staleAssociations = this.getStaleAssociations(realAssociations, transformationDiagramModelNode);
            ArrayList<Object> updatedNodes = new ArrayList<Object>(this.cleanUpStaleAssociations(staleAssociations, transformationDiagramModelNode));
            for (TransformationLink nextAssociation : realAssociations) {
                List labelNodes;
                if (this.associationExists(transformationDiagramModelNode, nextAssociation)) continue;
                ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection((NodeConnectionModel)nextAssociation);
                ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection((NodeConnectionModel)nextAssociation);
                if (!updatedNodes.contains(nextAssociation.getSourceNode())) {
                    updatedNodes.add(nextAssociation.getSourceNode());
                }
                if (!updatedNodes.contains(nextAssociation.getTargetNode())) {
                    updatedNodes.add(nextAssociation.getTargetNode());
                }
                if ((labelNodes = nextAssociation.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
                transformationDiagramModelNode.addChildren(labelNodes);
            }
            if (!updatedNodes.isEmpty()) {
                Iterator iter = updatedNodes.iterator();
                DiagramModelNode nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (DiagramModelNode)iter.next();
                    nextNode.updateAssociations();
                }
            }
        }
    }

    public DiagramModelNode getTransformationNode(DiagramModelNode transformationDiagramModelNode) {
        Iterator iter = transformationDiagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof TransformationNode)) continue;
            return nextNode;
        }
        return null;
    }

    protected void reconcileSourceTables(DiagramModelNode transformationDiagramModelNode) {
        boolean childrenChanged = false;
        ArrayList<EObject> removeSourceList = new ArrayList<EObject>();
        Diagram diagram = (Diagram)transformationDiagramModelNode.getModelObject();
        EObject virtualGroupEObject = diagram.getTarget();
        EObject transformationEObject = this.getTransformationObject(virtualGroupEObject);
        ModelResource txResource = ModelUtilities.getModelResourceForModelObject((EObject)transformationEObject);
        if (txResource != null) {
            List currentSourceNodes = this.getCurrentSourceNodes(transformationDiagramModelNode);
            ArrayList currentSourceTableEObjects = new ArrayList(this.getSourceEObjects(transformationEObject));
            if (currentSourceTableEObjects.isEmpty()) {
                this.clearAllSourceNodes(transformationDiagramModelNode);
                childrenChanged = true;
            } else {
                DiagramModelNode nextNode2 = null;
                for (DiagramModelNode nextNode2 : currentSourceNodes) {
                    if (currentSourceTableEObjects.contains(nextNode2.getModelObject())) continue;
                    removeSourceList.add(nextNode2.getModelObject());
                    childrenChanged = true;
                }
                Iterator iter = removeSourceList.iterator();
                EObject nextSourceEObject = null;
                while (iter.hasNext()) {
                    nextSourceEObject = (EObject)iter.next();
                    if (TransformationHelper.isSqlInputSet((Object)nextSourceEObject)) continue;
                    this.removeSourceTable(transformationEObject, transformationDiagramModelNode, nextSourceEObject);
                }
                DiagramEntityManager.cleanUpDiagram((Diagram)diagram);
                ArrayList visibleSourceTableEObjects = new ArrayList(this.getVisibleSourceEObjects(transformationDiagramModelNode));
                for (Object nextObj : currentSourceTableEObjects) {
                    if (visibleSourceTableEObjects.contains(nextObj)) continue;
                    this.addSourceTable(transformationEObject, transformationDiagramModelNode, (EObject)nextObj);
                    childrenChanged = true;
                }
                this.getTransformationNode(transformationDiagramModelNode).update("subscript");
                this.addLockedImages(transformationDiagramModelNode);
            }
            DiagramEntityManager.cleanDiagramEntities((Diagram)diagram);
            if (childrenChanged) {
                transformationDiagramModelNode.update("children");
            }
        }
    }

    public void addSourceTable(EObject transformationEObject, DiagramModelNode transformationDiagramModelNode, EObject sourceEObject) {
        DiagramModelNode newSourceNode = null;
        DiagramModelNode transformNode = this.getTransformationNode(transformationDiagramModelNode);
        if (this.getGenerator() != null && transformNode != null) {
            newSourceNode = this.getGenerator().createModel((Object)sourceEObject, (Diagram)transformationDiagramModelNode.getModelObject());
            if (newSourceNode != null) {
                newSourceNode.setParent(transformationDiagramModelNode);
                transformationDiagramModelNode.addChild(newSourceNode);
            }
        } else {
            UiConstants.Util.log(2, UiConstants.Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
        }
        if (newSourceNode != null) {
            this.setLockedImage(newSourceNode);
            if (this.showLinksInTransformation(transformationDiagramModelNode)) {
                TransformationLink sourceLink = this.getSourceConnectionModel(newSourceNode, transformNode);
                ((DiagramModelNode)sourceLink.getSourceNode()).addSourceConnection((NodeConnectionModel)sourceLink);
                ((DiagramModelNode)sourceLink.getTargetNode()).addTargetConnection((NodeConnectionModel)sourceLink);
                List labelNodes = sourceLink.getLabelNodes();
                if (labelNodes != null && !labelNodes.isEmpty()) {
                    transformationDiagramModelNode.addChildren(labelNodes);
                }
                newSourceNode.updateAssociations();
                transformNode.updateAssociations();
            }
        }
    }

    public void removeSourceTable(EObject transformationEObject, DiagramModelNode transformationDiagramModelNode, EObject sourceEObject) {
        DiagramModelNode removedNode = DiagramUiUtilities.getDiagramModelNode((EObject)sourceEObject, (DiagramModelNode)transformationDiagramModelNode);
        if (removedNode != null) {
            this.removeConnectionsForNode(transformationDiagramModelNode, removedNode);
            transformationDiagramModelNode.removeChild(removedNode, true);
            DiagramEntity de = removedNode.getDiagramModelObject();
            if (de != null) {
                DiagramEntityAdapter.setModelObject((DiagramEntity)de, null);
            }
        }
    }

    protected void removeLinkLabels(DiagramModelNode transformationDiagramModelNode, TransformationLink theLink) {
        List labelNodes = theLink.getLabelNodes();
        theLink.clearLabelNodes();
        if (labelNodes != null && !labelNodes.isEmpty()) {
            transformationDiagramModelNode.removeChildren(labelNodes, false);
        }
    }

    protected void removeConnectionsForNode(DiagramModelNode transformationDiagramModelNode, DiagramModelNode removedNode) {
        DiagramModelNode transformNode = this.getTransformationNode(transformationDiagramModelNode);
        TransformationLink tempAssociation = new TransformationLink(removedNode, transformNode);
        Vector sourceConnections = removedNode.getSourceConnections();
        TransformationLink nextAssociation = null;
        Iterator sIter = sourceConnections.iterator();
        while (sIter.hasNext()) {
            nextAssociation = (TransformationLink)((Object)sIter.next());
            if (!this.associationsMatch((NodeConnectionModel)nextAssociation, (NodeConnectionModel)tempAssociation)) continue;
            sIter.remove();
            this.removeLinkLabels(transformationDiagramModelNode, nextAssociation);
        }
        Vector targetConnections = removedNode.getTargetConnections();
        sIter = targetConnections.iterator();
        while (sIter.hasNext()) {
            nextAssociation = (TransformationLink)((Object)sIter.next());
            if (!this.associationsMatch((NodeConnectionModel)nextAssociation, (NodeConnectionModel)tempAssociation)) continue;
            sIter.remove();
            this.removeLinkLabels(transformationDiagramModelNode, nextAssociation);
        }
        targetConnections = transformNode.getTargetConnections();
        sIter = targetConnections.iterator();
        while (sIter.hasNext()) {
            nextAssociation = (TransformationLink)((Object)sIter.next());
            if (!this.associationsMatch((NodeConnectionModel)nextAssociation, (NodeConnectionModel)tempAssociation)) continue;
            sIter.remove();
            this.removeLinkLabels(transformationDiagramModelNode, nextAssociation);
        }
        transformNode.updateAssociations();
        removedNode.updateAssociations();
    }

    public String toString() {
        return "TransformationDiagamModelFactory()";
    }

    private void addDependencies(DiagramModelNode diagramModelNode, Diagram baseTransformationDiagram) {
        EObject virtualGroupEObject = baseTransformationDiagram.getTarget();
        EObject transformationEObject = this.getTransformationObject(virtualGroupEObject);
        Iterator sourceIter = this.getSourceEObjects(transformationEObject).iterator();
        EObject nextSourceEObject = null;
        while (sourceIter.hasNext()) {
            nextSourceEObject = (EObject)sourceIter.next();
            if (!ModelObjectUtilities.isVirtual((EObject)nextSourceEObject) || TransformationUmlEObjectHelper.getEObjectType(nextSourceEObject) != 1) continue;
            this.addDependencies(diagramModelNode, baseTransformationDiagram, nextSourceEObject);
        }
    }

    private void addDependencies(DiagramModelNode diagramModelNode, Diagram baseTransformationDiagram, EObject virtualSource) {
        ArrayList<TransformationNode> diagramContents = new ArrayList<TransformationNode>();
        ArrayList<EObject> virtualSources = new ArrayList<EObject>();
        DiagramModelNode targetModelNode = null;
        EObject transformationEObject = null;
        TransformationNode transformNode = null;
        targetModelNode = this.getModelNode(diagramModelNode, virtualSource);
        transformationEObject = this.getTransformationObject(virtualSource);
        transformNode = new TransformationNode(baseTransformationDiagram, transformationEObject);
        diagramContents.add(transformNode);
        if (targetModelNode != null) {
            TransformationLink targetLink = this.getTargetConnectionModel((DiagramModelNode)transformNode, targetModelNode);
            ((DiagramModelNode)targetLink.getSourceNode()).addSourceConnection((NodeConnectionModel)targetLink);
            ((DiagramModelNode)targetLink.getTargetNode()).addTargetConnection((NodeConnectionModel)targetLink);
            List labelNodes = targetLink.getLabelNodes();
            if (labelNodes != null && !labelNodes.isEmpty()) {
                diagramContents.addAll(labelNodes);
            }
            Iterator sourceIter = this.getSourceEObjects(transformationEObject).iterator();
            EObject nextSourceEObject = null;
            DiagramModelNode nextSourceNode = null;
            TransformationLink sourceLink = null;
            while (sourceIter.hasNext()) {
                nextSourceEObject = (EObject)sourceIter.next();
                if (this.getGenerator() != null) {
                    nextSourceNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextSourceEObject, (DiagramModelNode)diagramModelNode);
                    if (nextSourceNode == null && (nextSourceNode = this.getGenerator().createModel((Object)nextSourceEObject, baseTransformationDiagram)) != null) {
                        diagramContents.add((TransformationNode)nextSourceNode);
                        if (ModelObjectUtilities.isVirtual((EObject)nextSourceEObject) && TransformationUmlEObjectHelper.getEObjectType(nextSourceEObject) == 1) {
                            virtualSources.add(nextSourceEObject);
                        }
                    }
                } else {
                    UiConstants.Util.log(2, UiConstants.Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
                }
                if (nextSourceNode == null) continue;
                sourceLink = this.getSourceConnectionModel(nextSourceNode, (DiagramModelNode)transformNode);
                ((DiagramModelNode)sourceLink.getSourceNode()).addSourceConnection((NodeConnectionModel)sourceLink);
                ((DiagramModelNode)sourceLink.getTargetNode()).addTargetConnection((NodeConnectionModel)sourceLink);
                labelNodes = sourceLink.getLabelNodes();
                if (labelNodes == null || labelNodes.isEmpty()) continue;
                diagramContents.addAll(labelNodes);
            }
        }
        if (!diagramContents.isEmpty()) {
            diagramModelNode.addChildren(diagramContents);
        }
        if (!virtualSources.isEmpty()) {
            Iterator vIter = virtualSources.iterator();
            while (vIter.hasNext()) {
                this.addDependencies(diagramModelNode, baseTransformationDiagram, (EObject)vIter.next());
            }
        }
    }

    protected boolean isSecondaryMappingGroup(EObject eObject) {
        return eObject instanceof InputSet || eObject instanceof StagingTable;
    }

    protected void addLockedImages(DiagramModelNode transformationDiagramNode) {
        List allDiagramNodes = transformationDiagramNode.getChildren();
        if (allDiagramNodes != null && !allDiagramNodes.isEmpty()) {
            Image image = UiPlugin.getDefault().getImage("icons/full/ovr16/lock_vg.gif");
            Iterator iter = allDiagramNodes.iterator();
            DiagramModelNode diagramNode = null;
            EObject classifierEObject = null;
            while (iter.hasNext()) {
                diagramNode = (DiagramModelNode)iter.next();
                if (!(diagramNode instanceof UmlClassifierNode) || ModelUtilities.getModelResourceForModelObject((EObject)(classifierEObject = diagramNode.getModelObject())) == null) continue;
                if (!this.isSecondaryMappingGroup(classifierEObject) && TransformationHelper.isTargetGroupLocked((Object)classifierEObject)) {
                    if (image != null) {
                        diagramNode.setSecondOverlayImage(image, 2);
                    }
                } else {
                    diagramNode.setSecondOverlayImage(null, 2);
                }
                diagramNode.update("image");
            }
        }
    }

    public void setLockedImage(DiagramModelNode diagramModelNode) {
        if (diagramModelNode instanceof UmlClassifierNode) {
            EObject classifierEObject = diagramModelNode.getModelObject();
            if (ModelUtilities.getModelResourceForModelObject((EObject)classifierEObject) != null) {
                if (!this.isSecondaryMappingGroup(classifierEObject) && TransformationHelper.isTargetGroupLocked((Object)classifierEObject)) {
                    Image image = UiPlugin.getDefault().getImage("icons/full/ovr16/lock_vg.gif");
                    if (image != null) {
                        diagramModelNode.setSecondOverlayImage(image, 2);
                    }
                } else {
                    diagramModelNode.setSecondOverlayImage(null, 2);
                }
            }
        } else {
            diagramModelNode.setSecondOverlayImage(null, 2);
        }
        diagramModelNode.update("image");
    }

    public boolean shouldRefreshDiagram(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        if ("dependencyDiagramType".equals(sDiagramTypeId)) {
            TransformationDiagramNotificationHelper notificationHelper = new TransformationDiagramNotificationHelper(notification, diagramModelNode);
            return notificationHelper.shouldRefreshDiagram();
        }
        return false;
    }

    private boolean showLinksInTransformation(DiagramModelNode diagramModelNode) {
        return (this.isDependencyDiagram(diagramModelNode) || TransformationDiagramUtil.isTreeLayout()) && !this.hideLinksAlways;
    }

    protected void setHideLinksAlways(boolean theHideLinksAlways) {
        this.hideLinksAlways = theHideLinksAlways;
    }

    public void handleLabelProviderChanged(DiagramModelNode diagramModelNode, List eObjects) {
        HashMap<DiagramModelNode, String> updateNodes = new HashMap<DiagramModelNode, String>(eObjects.size());
        for (EObject nextEObject : eObjects) {
            DiagramModelNode tNode;
            EObject tRoot;
            DiagramModelNode nextNode = this.getModelNode(diagramModelNode, nextEObject);
            if (nextNode == null) continue;
            updateNodes.put(nextNode, "x");
            DiagramModelNode parentClassNode = DiagramUiUtilities.getClassifierParentNode((DiagramModelNode)nextNode);
            if (parentClassNode != null) {
                updateNodes.put(parentClassNode, "x");
            }
            if (!TransformationHelper.isValidTransformationTarget((Object)nextEObject) || (tRoot = TransformationHelper.getMappingRoot((EObject)nextEObject)) == null || (tNode = this.getModelNode(diagramModelNode, tRoot)) == null) continue;
            updateNodes.put(tNode, "x");
        }
        for (DiagramModelNode nextNode : updateNodes.keySet()) {
            if (nextNode == null) continue;
            nextNode.updateForErrorsAndWarnings();
        }
    }
}

