/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.connection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.connection.AbstractNodeConnectionModel;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.figure.LabeledRectangleFigure;
import org.teiid.designer.diagram.ui.model.AssociationLabelModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.util.TransformationHelper;

public class TransformationLink
extends AbstractNodeConnectionModel {
    private static final String EMPTY_LABEL = " ";
    private DiagramModelNode sourceNode;
    private DiagramModelNode targetNode;
    private LabelModelNode suidLabelNode;
    private LabelModelNode aliasLabelNode;
    private String sName;
    private int ltCurrentLinkType = 1;
    private static final int DELTA_X = 6;
    private static final int DELTA_Y = 4;
    private String sRouterStyle;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);

    public TransformationLink(DiagramModelNode source, DiagramModelNode target) {
        this.setSourceNode(source);
        this.setTargetNode(target);
        this.init();
    }

    public TransformationLink(DiagramModelNode source, DiagramModelNode target, String sName) {
        this.sName = sName;
        this.setSourceNode(source);
        this.setTargetNode(target);
        this.init();
    }

    private void init() {
    }

    public void updateLabels() {
        String aliasText;
        String suidText = this.getSuidText();
        if (suidText != null) {
            if (this.suidLabelNode == null) {
                this.suidLabelNode = new AssociationLabelModelNode(suidText, 1);
            } else {
                this.suidLabelNode.setName(suidText);
            }
            this.suidLabelNode.update();
        }
        if ((aliasText = this.getAliasText()) != null) {
            if (this.aliasLabelNode == null) {
                this.aliasLabelNode = new AssociationLabelModelNode(aliasText, 0);
            } else {
                this.aliasLabelNode.setName(aliasText);
            }
            this.aliasLabelNode.update();
        }
    }

    private String getSuidText() {
        EObject tableEObject;
        String text = EMPTY_LABEL;
        if (this.getTargetNode() instanceof TransformationNode) {
            EObject targetTableEObject = TransformationHelper.getTransformationLinkTarget((EObject)((DiagramModelNode)this.getTargetNode()).getModelObject());
            if (TransformationHelper.tableSupportsUpdate((EObject)targetTableEObject)) {
                text = "s";
                if (TransformationHelper.supportsUpdate((EObject)((DiagramModelNode)this.getTargetNode()).getModelObject(), (EObject)((DiagramModelNode)this.getSourceNode()).getModelObject())) {
                    text = String.valueOf(text) + "u";
                }
                if (TransformationHelper.supportsInsert((EObject)((DiagramModelNode)this.getTargetNode()).getModelObject(), (EObject)((DiagramModelNode)this.getSourceNode()).getModelObject())) {
                    text = String.valueOf(text) + "i";
                }
                if (TransformationHelper.supportsDelete((EObject)((DiagramModelNode)this.getTargetNode()).getModelObject(), (EObject)((DiagramModelNode)this.getSourceNode()).getModelObject())) {
                    text = String.valueOf(text) + "d";
                }
            }
        } else if (SqlAspectHelper.isTable((EObject)((DiagramModelNode)this.getTargetNode()).getModelObject()) && TransformationHelper.tableSupportsUpdate((EObject)(tableEObject = ((DiagramModelNode)this.getTargetNode()).getModelObject()))) {
            text = "suid";
        }
        return text;
    }

    private String getAliasText() {
        List aliases;
        String text = EMPTY_LABEL;
        if (this.getTargetNode() instanceof TransformationNode && (aliases = TransformationHelper.getSqlAliasesForSource((Object)((DiagramModelNode)this.getTargetNode()).getModelObject(), (EObject)((DiagramModelNode)this.getSourceNode()).getModelObject())) != null && !aliases.isEmpty() && aliases.size() > 1) {
            text = EMPTY_LABEL + aliases.size();
        }
        return text;
    }

    public void setSource(DiagramModelNode iSource) {
        this.sourceNode = iSource;
    }

    public void setTarget(DiagramModelNode iTarget) {
        this.targetNode = iTarget;
    }

    public void setName(String sName) {
        this.sName = sName;
    }

    public String getName() {
        return this.sName;
    }

    public void layout() {
    }

    public void setRouterStyle(String sRouterStyle) {
        if (this.sRouterStyle == null || !this.sRouterStyle.equals(sRouterStyle)) {
            this.sRouterStyle = sRouterStyle;
        }
    }

    public int getRouterStyle() {
        return 1;
    }

    public Object getSourceNode() {
        return this.sourceNode;
    }

    public Object getTargetNode() {
        return this.targetNode;
    }

    public void setSourceNode(Object node) {
        this.sourceNode = (DiagramModelNode)node;
    }

    public void setTargetNode(Object node) {
        this.targetNode = (DiagramModelNode)node;
    }

    public LabelModelNode getNameLabel() {
        return this.aliasLabelNode;
    }

    public LabelModelNode getSuidLabel() {
        return this.suidLabelNode;
    }

    public void setName(LabelModelNode node) {
        this.aliasLabelNode = node;
    }

    public void setSuidLabel(LabelModelNode node) {
        this.suidLabelNode = node;
    }

    public List getLabelNodes() {
        ArrayList<LabelModelNode> currentLabels = new ArrayList<LabelModelNode>();
        if (this.suidLabelNode != null) {
            currentLabels.add(this.suidLabelNode);
        }
        if (this.aliasLabelNode != null) {
            currentLabels.add(this.aliasLabelNode);
        }
        if (currentLabels.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return currentLabels;
    }

    public void clearLabelNodes() {
        this.suidLabelNode = null;
        this.aliasLabelNode = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public int getLinkType() {
        return this.ltCurrentLinkType;
    }

    private void updateFonts(DiagramEditPart adepParentEditPart) {
        Font fntNew = this.getLabelFont();
        this.updateFontOnLabelFigure(adepParentEditPart, this.suidLabelNode, fntNew);
        this.updateFontOnLabelFigure(adepParentEditPart, this.aliasLabelNode, fntNew);
    }

    private void updateFontOnLabelFigure(DiagramEditPart adepParentEditPart, LabelModelNode lmnLabel, Font fntNew) {
        DiagramFigure df1;
        DiagramEditPart dep;
        DiagramEditPart depLabelled;
        if (lmnLabel != null && (depLabelled = (dep = (DiagramEditPart)adepParentEditPart.getParent()).getEditPart((DiagramModelNode)lmnLabel)) != null && (df1 = depLabelled.getDiagramFigure()) instanceof LabeledRectangleFigure) {
            ((LabeledRectangleFigure)df1).updateForFont(fntNew);
        }
    }

    private Font getLabelFont() {
        return ScaledFontManager.getFont((int)-1);
    }

    public void layout(ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor, DiagramEditPart adepParentEditPart) {
        boolean isTNode = sourceAnchor instanceof ChopboxAnchor;
        if (isTNode) {
            if (this.canShowSuid()) {
                this.updateLabels();
                this.updateFonts(adepParentEditPart);
                int arrowPtX = ((DiagramModelNode)this.getSourceNode()).getX();
                int arrowPtY = ((DiagramModelNode)this.getSourceNode()).getY() + ((DiagramModelNode)this.getSourceNode()).getHeight() / 2;
                double strHeight = this.suidLabelNode.getHeight();
                double strWidth = this.suidLabelNode.getWidth();
                int strX = arrowPtX - (int)strWidth - 4;
                int strY = arrowPtY - (int)strHeight - 4;
                this.suidLabelNode.setPosition(new Point(strX, strY));
            }
        } else {
            if (!(sourceAnchor instanceof NodeConnectionAnchor)) {
                return;
            }
            if (this.suidLabelNode == null) {
                this.updateLabels();
                return;
            }
            this.updateLabels();
            this.updateFonts(adepParentEditPart);
            Point pSourceAnchor = null;
            int sourceX = ((NodeConnectionAnchor)sourceAnchor).getOffsetH() + ((DiagramModelNode)this.getSourceNode()).getX();
            int sourceY = ((NodeConnectionAnchor)sourceAnchor).getOffsetV() + ((DiagramModelNode)this.getSourceNode()).getY();
            pSourceAnchor = new Point(sourceX, sourceY);
            double deltaX = 6.0;
            double deltaY = 4.0;
            int sourceSide = 0;
            Point sourceStartPt = pSourceAnchor;
            sourceSide = ((NodeConnectionAnchor)sourceAnchor).getDirection();
            double sourceAngleInRadians = this.getSourceAngleInRadians(sourceSide);
            int tmpPtX = 0;
            int tmpPtY = 0;
            double startX = 0.0;
            double startY = 0.0;
            double strHeight = 0.0;
            double strWidth = 0.0;
            double tmpAngle = 0.0;
            if (this.canShowSuid()) {
                strHeight = this.suidLabelNode.getHeight();
                strWidth = this.suidLabelNode.getWidth();
                startX = sourceStartPt.x;
                startY = sourceStartPt.y;
                tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(sourceAngleInRadians) : 360.0 - Math.toDegrees(sourceAngleInRadians);
                switch (sourceSide) {
                    case 0: {
                        if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY - deltaY - strHeight);
                            break;
                        }
                        if (tmpAngle < 60.0) {
                            tmpPtX = (int)(startX - strWidth);
                            tmpPtY = (int)(startY - deltaY - strHeight);
                            break;
                        }
                        tmpPtX = (int)startX;
                        tmpPtY = (int)(startY - deltaY - strHeight);
                        break;
                    }
                    case 2: {
                        if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY + deltaY);
                            break;
                        }
                        if (tmpAngle < 240.0) {
                            tmpPtX = (int)(startX - strWidth);
                            tmpPtY = (int)(startY + deltaY);
                            break;
                        }
                        tmpPtX = (int)startX;
                        tmpPtY = (int)(startY + deltaY);
                        break;
                    }
                    case 1: {
                        if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)(startY - deltaY - strHeight);
                            break;
                        }
                        if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)startY;
                            break;
                        }
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - strHeight);
                        break;
                    }
                    case 3: {
                        if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY - deltaY - strHeight);
                            break;
                        }
                        if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY - strHeight);
                            break;
                        }
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - strHeight);
                        break;
                    }
                }
                this.suidLabelNode.setPosition(new Point(tmpPtX, tmpPtY));
            }
            if (this.canShowAliasedValues()) {
                strHeight = this.aliasLabelNode.getHeight();
                strWidth = this.aliasLabelNode.getWidth();
                startX = sourceStartPt.x;
                startY = sourceStartPt.y;
                tmpAngle = this.getLinkType() == 0 ? Math.toDegrees(sourceAngleInRadians) : 360.0 - Math.toDegrees(sourceAngleInRadians);
                switch (sourceSide) {
                    case 0: {
                        if (tmpAngle >= 60.0 && tmpAngle <= 120.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)(startY - deltaY - strHeight);
                            break;
                        }
                        if (tmpAngle < 60.0) {
                            tmpPtX = (int)(startX - strWidth);
                            tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                            break;
                        }
                        tmpPtX = (int)startX;
                        tmpPtY = (int)(startY - deltaY - strHeight * 2.0);
                        break;
                    }
                    case 2: {
                        if (tmpAngle >= 240.0 && tmpAngle <= 300.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)(startY + deltaY);
                            break;
                        }
                        if (tmpAngle < 240.0) {
                            tmpPtX = (int)startX;
                            tmpPtY = (int)(startY + deltaY + strHeight);
                            break;
                        }
                        tmpPtX = (int)(startX - strWidth);
                        tmpPtY = (int)(startY + deltaY + strHeight);
                        break;
                    }
                    case 1: {
                        if (tmpAngle <= 20.0 || tmpAngle >= 340.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)(startY + deltaY);
                            break;
                        }
                        if (tmpAngle > 20.0 && tmpAngle <= 91.0) {
                            tmpPtX = (int)(startX + deltaX);
                            tmpPtY = (int)(startY + strHeight);
                            break;
                        }
                        tmpPtX = (int)(startX + deltaX);
                        tmpPtY = (int)(startY - strHeight * 2.0);
                        break;
                    }
                    case 3: {
                        if (tmpAngle <= 200.0 && tmpAngle >= 160.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY + deltaY);
                            break;
                        }
                        if (tmpAngle > 89.0 && tmpAngle < 160.0) {
                            tmpPtX = (int)(startX - deltaX - strWidth);
                            tmpPtY = (int)(startY + strHeight);
                            break;
                        }
                        tmpPtX = (int)(startX - deltaX - strWidth);
                        tmpPtY = (int)(startY - strHeight * 2.0);
                        break;
                    }
                }
                this.aliasLabelNode.setPosition(new Point(tmpPtX, tmpPtY));
            }
        }
    }

    public void placeStereotypeAndName(int iSourceSide, int iTargetSide, PointList plConnectionPoints) {
    }

    private double getSourceAngleInRadians(int iSourceSide) {
        double sourceAngleInRadians = 0.0;
        if (this.getLinkType() == 0) {
            sourceAngleInRadians = iSourceSide == 3 ? Math.PI : (iSourceSide == 1 ? 0.0 : (iSourceSide == 0 ? 1.5707963267948966 : 4.71238898038469));
        }
        return sourceAngleInRadians;
    }

    private boolean canShowSuid() {
        return this.suidLabelNode != null && this.suidLabelNode.getName().length() > 0;
    }

    private boolean canShowAliasedValues() {
        return this.aliasLabelNode != null && this.aliasLabelNode.getName().length() > 0;
    }

    public String toString() {
        String suidText = null;
        if (this.suidLabelNode != null) {
            suidText = this.suidLabelNode.getDisplayString();
        }
        String nameText = null;
        if (this.aliasLabelNode != null) {
            nameText = this.aliasLabelNode.getDisplayString();
        }
        return new StringBuffer().append(" TransformationLink:").append(" Source Node = ").append(this.sourceNode.getName()).append(" Target Node = ").append(this.targetNode.getName()).append(" SUID  = ").append(suidText).append(" Aliases  = ").append(nameText).toString();
    }

    public int getTargetDecoratorId() {
        return 0;
    }

    public int getSourceDecoratorId() {
        return 0;
    }

    public int getLineStyle() {
        return 1;
    }

    public List getToolTipStrings() {
        ArrayList<String> newList = new ArrayList<String>(1);
        newList.add(this.sName);
        return newList;
    }
}

