/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.builder.AbstractCompositeExpressionEditor;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.expression.ConstantEditor;
import org.teiid.designer.transformation.ui.builder.expression.ElementEditor;
import org.teiid.designer.transformation.ui.builder.expression.FunctionEditor;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.query.ui.builder.model.CompositeLanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ExpressionEditorModel;

public class ExpressionEditor
extends AbstractCompositeExpressionEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ExpressionEditor.class);
    private ConstantEditor constantEditor;
    private ElementEditor elementEditor;
    private FunctionEditor functionEditor;

    public ExpressionEditor(Composite theParent, ExpressionEditorModel theModel) {
        super(theParent, (CompositeLanguageObjectEditorModel)theModel);
    }

    @Override
    protected List createExpressionEditors(Composite theParent) {
        ArrayList<AbstractLanguageObjectEditor> editors = new ArrayList<AbstractLanguageObjectEditor>(3);
        ExpressionEditorModel model = (ExpressionEditorModel)this.getModel();
        this.elementEditor = new ElementEditor(theParent, model.getElementEditorModel());
        editors.add(this.elementEditor);
        this.constantEditor = new ConstantEditor(theParent, model.getConstantEditorModel());
        editors.add(this.constantEditor);
        this.functionEditor = new FunctionEditor(theParent, model.getFunctionEditorModel());
        editors.add(this.functionEditor);
        return editors;
    }

    @Override
    protected ILanguageObjectEditor getDefaultEditor() {
        return this.elementEditor;
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    public void setFunctionOnly(boolean theEnableFlag) {
        this.setEditorEnabled(this.elementEditor, !theEnableFlag);
        this.setEditorEnabled(this.constantEditor, !theEnableFlag);
        if (theEnableFlag) {
            WidgetUtil.selectRadioButton((Button)this.getEditorButton(this.functionEditor));
        }
    }
}

