/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectBuilder;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.expression.ExpressionEditor;
import org.teiid.query.ui.builder.model.ExpressionEditorModel;

public final class ExpressionBuilder
extends AbstractLanguageObjectBuilder {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ExpressionBuilder.class);
    private ExpressionEditor expressionEditor;
    private boolean functionOnly;

    public ExpressionBuilder(Shell theShell, boolean functionOnly) {
        super(theShell, Util.getString(String.valueOf(PREFIX) + "title", new Object[0]));
        this.functionOnly = functionOnly;
        this.setSizeRelativeToScreen(50, 75);
        this.setCenterOnDisplay(true);
    }

    public ExpressionBuilder(Shell theShell) {
        this(theShell, false);
    }

    @Override
    protected ILanguageObjectEditor createEditor(Composite theParent) {
        this.expressionEditor = new ExpressionEditor(theParent, new ExpressionEditorModel());
        this.getButton(0).setToolTipText(Util.getString(String.valueOf(PREFIX) + "okButton.tip", new Object[0]));
        this.getButton(1).setToolTipText(Util.getString(String.valueOf(PREFIX) + "cancelButton.tip", new Object[0]));
        return this.expressionEditor;
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    protected void handleTreeSelection() {
        super.handleTreeSelection();
        if (this.functionOnly) {
            this.expressionEditor.setFunctionOnly(this.isTreeSelectionRoot());
        }
    }
}

