/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.LanguageObjectBuilderTreeViewer;
import org.teiid.designer.transformation.ui.builder.actions.DeleteViewerObjectAction;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlDisplayPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.util.BuilderUtils;

public abstract class AbstractLanguageObjectBuilder
extends Dialog
implements UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AbstractLanguageObjectBuilder.class);
    private IAction deleteAction;
    private ILanguageObjectEditor editor;
    private ILanguageObject savedSelection;
    protected ILanguageObject savedLangObj;
    protected Button btnSet;
    protected Button btnReset;
    private Label lblTitle;
    private Composite pnlEditor;
    private Composite pnlEditorDetail;
    LanguageObjectBuilderTreeViewer treeViewer;
    private SqlDisplayPanel currentSql;
    private SqlDisplayPanel originalSql;
    private CLabel originalLanguageObjLabel;

    protected AbstractLanguageObjectBuilder(Shell theParent, String theTitle) {
        super(theParent, theTitle);
    }

    public void create() {
        super.create();
        this.editor = this.createEditor(this.pnlEditorDetail);
        this.editor.getModel().addModelListener(new ILanguageObjectEditorModelListener(){

            public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
                AbstractLanguageObjectBuilder.this.handleModelChanged();
            }
        });
        this.lblTitle.setText(this.editor.getTitle());
        Composite pnlEditorButtons = new Composite(this.pnlEditor, 0);
        pnlEditorButtons.setLayoutData((Object)new GridData(4));
        pnlEditorButtons.setLayout((Layout)new GridLayout());
        this.btnSet = new Button(pnlEditorButtons, 0);
        this.btnSet.setEnabled(false);
        this.btnSet.setText(Util.getString(String.valueOf(PREFIX) + "btnSet", new Object[0]));
        this.btnSet.setToolTipText(Util.getString(String.valueOf(PREFIX) + "btnSet.tip", new Object[0]));
        this.btnSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                AbstractLanguageObjectBuilder.this.handleSetSelected();
            }
        });
        this.btnReset = new Button(pnlEditorButtons, 0);
        this.btnReset.setEnabled(false);
        this.btnReset.setText(Util.getString(String.valueOf(PREFIX) + "btnReset", new Object[0]));
        this.btnReset.setToolTipText(Util.getString(String.valueOf(PREFIX) + "btnReset.tip", new Object[0]));
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                AbstractLanguageObjectBuilder.this.handleResetSelected();
            }
        });
        this.setLanguageObject(null);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractLanguageObjectBuilder.this.treeViewer.selectRoot();
            }
        });
    }

    protected Control createDialogArea(Composite theParent) {
        this.originalLanguageObjLabel = WidgetFactory.createLabel((Composite)theParent, (String)"");
        Composite pnlContents = (Composite)super.createDialogArea(theParent);
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)pnlContents);
        CTabItem treeTab = WidgetFactory.createTab((CTabFolder)tabFolder, (String)Util.getString(String.valueOf(PREFIX) + "treeTab", new Object[0]));
        treeTab.setToolTipText(Util.getString(String.valueOf(PREFIX) + "treeTab.tip", new Object[0]));
        SashForm treeTabSash = new SashForm((Composite)tabFolder, 512);
        treeTabSash.setLayoutData((Object)new GridData(1808));
        treeTab.setControl((Control)treeTabSash);
        CTabItem sqlTab = WidgetFactory.createTab((CTabFolder)tabFolder, (String)Util.getString(String.valueOf(PREFIX) + "sqlTab", new Object[0]));
        sqlTab.setToolTipText(Util.getString(String.valueOf(PREFIX) + "sqlTab.tip", new Object[0]));
        SashForm sqlTabSash = new SashForm((Composite)tabFolder, 512);
        sqlTabSash.setLayoutData((Object)new GridData(1808));
        sqlTab.setControl((Control)sqlTabSash);
        ViewForm formTree = new ViewForm((Composite)treeTabSash, 2048);
        Composite pnlTree = new Composite((Composite)formTree, 8);
        formTree.setContent((Control)pnlTree);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pnlTree.setLayout((Layout)layout);
        pnlTree.setLayoutData((Object)new GridData(1808));
        ViewForm formEditor = new ViewForm((Composite)treeTabSash, 2048);
        this.pnlEditor = new Composite((Composite)formEditor, 8);
        formEditor.setContent((Control)this.pnlEditor);
        this.pnlEditor.setLayoutData((Object)new GridData(1808));
        this.lblTitle = new Label((Composite)formEditor, 0x1000000);
        this.lblTitle.setBackground(BuilderUtils.COLOR_HIGHLIGHT);
        formEditor.setTopLeft((Control)this.lblTitle);
        treeTabSash.setWeights(new int[]{30, 70});
        ViewForm formCurrentSql = new ViewForm((Composite)sqlTabSash, 2048);
        ViewForm formOriginalSql = new ViewForm((Composite)sqlTabSash, 2048);
        Composite pnlCurrentSql = new Composite((Composite)formCurrentSql, 0);
        formCurrentSql.setContent((Control)pnlCurrentSql);
        pnlCurrentSql.setLayout((Layout)new GridLayout());
        pnlCurrentSql.setLayoutData((Object)new GridData(1808));
        this.currentSql = new SqlDisplayPanel(pnlCurrentSql);
        this.currentSql.setLayoutData(new GridData(1808));
        CLabel lblCurrent = new CLabel((Composite)formCurrentSql, 0);
        lblCurrent.setBackground(BuilderUtils.COLOR_HIGHLIGHT);
        lblCurrent.setText(Util.getString(String.valueOf(PREFIX) + "lblCurrent", new Object[0]));
        lblCurrent.setToolTipText(Util.getString(String.valueOf(PREFIX) + "lblCurrent.tip", new Object[0]));
        formCurrentSql.setTopLeft((Control)lblCurrent);
        Composite pnlOriginalSql = new Composite((Composite)formOriginalSql, 0);
        formOriginalSql.setContent((Control)pnlOriginalSql);
        pnlOriginalSql.setLayout((Layout)new GridLayout());
        pnlOriginalSql.setLayoutData((Object)new GridData(1808));
        this.originalSql = new SqlDisplayPanel(pnlOriginalSql);
        this.originalSql.setLayoutData(new GridData(1808));
        CLabel lblOriginal = new CLabel((Composite)formOriginalSql, 0);
        lblOriginal.setBackground(BuilderUtils.COLOR_HIGHLIGHT);
        lblOriginal.setText(Util.getString(String.valueOf(PREFIX) + "lblOriginal", new Object[0]));
        lblOriginal.setToolTipText(Util.getString(String.valueOf(PREFIX) + "lblOriginal.tip", new Object[0]));
        formOriginalSql.setTopLeft((Control)lblOriginal);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pnlTree.setLayout((Layout)layout);
        this.treeViewer = new LanguageObjectBuilderTreeViewer(pnlTree);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                AbstractLanguageObjectBuilder.this.handleTreeSelection();
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager theMenuMgr) {
                AbstractLanguageObjectBuilder.this.fillContextMenu(theMenuMgr);
            }
        });
        this.treeViewer.getTree().setMenu(menuMgr.createContextMenu((Control)this.treeViewer.getTree()));
        Composite pnlButtons = new Composite(pnlTree, 0);
        pnlButtons.setLayout((Layout)new GridLayout());
        this.createTreeButtons(pnlButtons);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.pnlEditor.setLayout((Layout)layout);
        this.pnlEditorDetail = new Composite(this.pnlEditor, 0);
        this.pnlEditorDetail.setLayoutData((Object)new GridData(1808));
        this.pnlEditorDetail.setLayout((Layout)new GridLayout());
        return pnlContents;
    }

    protected abstract ILanguageObjectEditor createEditor(Composite var1);

    protected void createTreeButtons(Composite theParent) {
        Runnable deleteRunner = new Runnable(){

            @Override
            public void run() {
                AbstractLanguageObjectBuilder.this.handleDeleteSelected();
            }
        };
        this.deleteAction = new DeleteViewerObjectAction(theParent, deleteRunner);
    }

    protected void fillContextMenu(IMenuManager theMenuMgr) {
        theMenuMgr.add(this.deleteAction);
    }

    public ILanguageObjectEditor getEditor() {
        return this.editor;
    }

    public ILanguageObject getLanguageObject() {
        return this.treeViewer.getLanguageObject();
    }

    protected ILanguageObject getSavedLanguageObject() {
        return this.savedLangObj;
    }

    public abstract String getTitle();

    protected LanguageObjectBuilderTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void handleDeleteSelected() {
        this.editor.clear();
        this.treeViewer.deleteSelection();
        this.setCurrentSql(this.treeViewer.getLanguageObject());
        this.editor.acceptFocus();
    }

    void handleModelChanged() {
        boolean isEnabled = false;
        boolean isComplete = false;
        boolean hasChanged = false;
        isEnabled = this.editor.isEnabled();
        if (isEnabled) {
            isComplete = this.editor.isComplete();
        }
        if (isComplete) {
            hasChanged = this.editor.hasChanged();
        }
        boolean state = isEnabled && isComplete && hasChanged;
        this.btnSet.setEnabled(state);
        this.btnReset.setEnabled(state);
        this.setCurrentSql(this.treeViewer.getLanguageObject());
        this.setEnabledStatus();
    }

    protected void handleResetSelected() {
        this.editor.reset();
        this.editor.acceptFocus();
    }

    protected void handleSetSelected() {
        this.editor.save();
        ILanguageObject langObj = this.editor.getLanguageObject();
        CoreArgCheck.isNotNull((Object)langObj, (String)Util.getString(String.valueOf(PREFIX) + "nullLangObj", new Object[]{"handleSetSelected"}));
        this.treeViewer.modifySelectedItem(langObj, false);
        this.setCurrentSql(this.treeViewer.getLanguageObject());
        this.editor.acceptFocus();
    }

    protected void handleTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object selectedObj = selection.getFirstElement();
        if (selectedObj == null) {
            this.savedSelection = null;
            if (this.editor.isEnabled()) {
                this.editor.setEnabled(false);
            }
        } else {
            this.savedSelection = selectedObj instanceof ILanguageObject ? (ILanguageObject)selectedObj : null;
        }
        this.setEditorLanguageObject(this.savedSelection);
        this.setEnabledStatus();
    }

    protected boolean isTreeSelectionRoot() {
        boolean isRoot = false;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() > 0) {
            Tree tree = this.treeViewer.getTree();
            TreeItem treeItem = tree.getSelection()[0];
            TreeItem parentItem = treeItem.getParentItem();
            isRoot = parentItem == null;
        }
        return isRoot;
    }

    protected void setCurrentSql(ILanguageObject theLangObj) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
        this.currentSql.setText(visitor.returnSQLString(theLangObj));
    }

    protected void setEditorLanguageObject(ILanguageObject theEditorLangObj) {
        this.getEditor().setLanguageObject(this.savedSelection);
        if (!this.editor.isEnabled()) {
            this.editor.setEnabled(true);
        }
    }

    protected void setEnabledStatus() {
        boolean canDelete = this.treeViewer.canDeleteSelection();
        if (canDelete) {
            if (!this.deleteAction.isEnabled()) {
                this.deleteAction.setEnabled(true);
            }
        } else if (this.deleteAction.isEnabled()) {
            this.deleteAction.setEnabled(false);
        }
        Button btnOk = this.getButton(0);
        boolean enable = this.treeViewer.isComplete();
        if (btnOk.isEnabled() != enable) {
            btnOk.setEnabled(enable);
        }
    }

    public void setLanguageObject(ILanguageObject theLangObj) {
        ILanguageObject langObj;
        this.savedLangObj = langObj = theLangObj == null ? null : theLangObj.clone();
        this.setOriginalSql(langObj);
        this.setCurrentSql(langObj);
        this.treeViewer.setLanguageObject(langObj);
        this.treeViewer.selectRoot();
        this.treeViewer.expandAll();
        String labelText = String.valueOf(Util.getString(String.valueOf(PREFIX) + "initialExpression", new Object[0])) + "  " + "  " + Util.getString(String.valueOf(PREFIX) + "undefined", new Object[0]);
        if (this.savedLangObj != null) {
            String loString = this.savedLangObj.toString();
            if (loString.length() > 50) {
                loString = String.valueOf(loString.substring(0, 50)) + "...";
            }
            labelText = String.valueOf(Util.getString(String.valueOf(PREFIX) + "initialExpression", new Object[0])) + "  " + "  " + loString;
        }
        if (this.originalLanguageObjLabel != null) {
            this.originalLanguageObjLabel.setText(labelText);
            this.originalLanguageObjLabel.getParent().layout();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractLanguageObjectBuilder.this.treeViewer.selectRoot();
            }
        });
    }

    protected void setOriginalSql(ILanguageObject theLangObj) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
        this.originalSql.setText(visitor.returnSQLString(theLangObj));
    }
}

