/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.builder.AbstractCompositeLanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.util.CompositeEditorMessagePanel;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.query.ui.builder.model.CompositeLanguageObjectEditorModel;

public abstract class AbstractCompositeExpressionEditor
extends AbstractCompositeLanguageObjectEditor {
    private List<Button> editorButtons;
    StackLayout stackLayout;
    private Composite pnlButtons;
    Composite pnlEditors;
    private CompositeEditorMessagePanel pnlMessages;

    protected AbstractCompositeExpressionEditor(Composite theParent, CompositeLanguageObjectEditorModel theModel) {
        super(theParent, IExpression.class, theModel);
    }

    private void createEditorButtons(List<ILanguageObjectEditor> theEditors) {
        CoreArgCheck.isNotEmpty(theEditors);
        int numEditors = theEditors.size();
        this.editorButtons = new ArrayList<Button>(numEditors);
        GridLayout gdlayout = (GridLayout)this.pnlButtons.getLayout();
        gdlayout.numColumns = numEditors;
        int i = 0;
        while (i < numEditors) {
            ILanguageObjectEditor editor = theEditors.get(i);
            String title = editor.getTitle();
            Button btn = new Button(this.pnlButtons, 16);
            btn.setText(title);
            btn.setToolTipText(editor.getToolTipText());
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    AbstractCompositeExpressionEditor.this.handleEditorSelected(theEvent);
                }
            });
            this.editorButtons.add(btn);
            this.pnlMessages.addEditor(btn, editor);
            ++i;
        }
    }

    @Override
    protected final List createEditors(Composite theParent) {
        this.pnlButtons = new Composite(theParent, 0);
        this.pnlButtons.setLayout((Layout)new GridLayout());
        this.pnlButtons.setLayoutData((Object)new GridData(768));
        this.pnlMessages = new CompositeEditorMessagePanel(theParent);
        ScrolledComposite scroller = new ScrolledComposite(theParent, 768);
        scroller.setLayout((Layout)new GridLayout());
        scroller.setLayoutData((Object)new GridData(1808));
        this.pnlEditors = new Composite((Composite)scroller, 0);
        this.pnlEditors.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.pnlEditors.setLayout((Layout)this.stackLayout);
        scroller.setContent((Control)this.pnlEditors);
        Point pt = scroller.getParent().computeSize(-1, -1);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        scroller.setMinWidth(pt.x);
        scroller.setMinHeight(pt.y);
        final List editors = this.createExpressionEditors(this.pnlEditors);
        this.createEditorButtons(editors);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ILanguageObjectEditor editor = (ILanguageObjectEditor)editors.get(0);
                AbstractCompositeExpressionEditor.this.stackLayout.topControl = editor.getUi();
                WidgetUtil.selectRadioButton((Button)AbstractCompositeExpressionEditor.this.getEditorButton(editor));
                AbstractCompositeExpressionEditor.this.pnlEditors.layout();
                AbstractCompositeExpressionEditor.this.getEditorForFocus().acceptFocus();
            }
        });
        return editors;
    }

    ILanguageObjectEditor getEditorForFocus() {
        return this.getCurrentEditor();
    }

    protected abstract List createExpressionEditors(Composite var1);

    protected ILanguageObjectEditor getEditor(Button theButton) {
        return (ILanguageObjectEditor)this.getEditors().get(this.editorButtons.indexOf(theButton));
    }

    protected Button getEditorButton(ILanguageObjectEditor theEditor) {
        return this.editorButtons.get(this.getEditors().indexOf(theEditor));
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract String getToolTipText();

    void handleEditorSelected(SelectionEvent theEvent) {
        Button btn = (Button)theEvent.getSource();
        if (btn.getSelection()) {
            int index = this.editorButtons.indexOf(theEvent.getSource());
            ILanguageObjectEditor editor = (ILanguageObjectEditor)this.getEditors().get(index);
            this.selectEditor(editor);
        }
    }

    protected void selectEditor(ILanguageObjectEditor editor) {
        this.stackLayout.topControl = editor.getUi();
        this.pnlEditors.layout();
        super.setCurrentEditor(editor);
    }

    @Override
    protected void setCurrentEditor(ILanguageObjectEditor theEditor) {
        super.setCurrentEditor(theEditor);
        WidgetUtil.selectRadioButton((Button)this.getEditorButton(theEditor));
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        super.setLanguageObject(theLanguageObject);
        this.pnlMessages.setLanguageObject(theLanguageObject);
    }

    protected void setEditorEnabled(ILanguageObjectEditor theEditor, boolean theEnableFlag) {
        theEditor.setEnabled(theEnableFlag);
        this.getEditorButton(theEditor).setEnabled(theEnableFlag);
    }
}

