/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalViewTable;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialog;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.TransformationDialogModel;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.actions.INewChildAction;
import org.teiid.designer.ui.actions.INewSiblingAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateViewTableAction
extends Action
implements INewChildAction,
INewSiblingAction {
    private IFile selectedModel;
    public static final String TITLE = Messages.createRelationalViewTableActionText;
    private Collection<String> datatypes;
    private Properties designerProperties;
    private EObject newViewTable;
    private RelationalViewTable relationalViewTable;

    public CreateViewTableAction() {
        super(TITLE);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-view-table.png"));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        this.datatypes = new ArrayList<String>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            this.datatypes.add((String)dType);
            ++n2;
        }
    }

    public CreateViewTableAction(Properties properties) {
        this();
        this.designerProperties = properties;
    }

    public boolean canCreateChild(EObject parent) {
        return false;
    }

    public boolean canCreateChild(IFile modelFile) {
        return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
    }

    public boolean canCreateSibling(EObject parent) {
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)parent);
        if (mr != null) {
            IFile modelFile = null;
            try {
                modelFile = (IFile)mr.getCorrespondingResource();
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log((Throwable)ex);
            }
            if (modelFile != null) {
                return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
            }
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        IResource iRes;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && ModelIdentifier.isRelationalViewModel((IResource)(iRes = (IResource)obj))) {
            this.selectedModel = (IFile)obj;
            result = true;
        }
        return result;
    }

    public void run() {
        IFile propsViewModel;
        if (this.designerProperties != null && (propsViewModel = DesignerPropertiesUtil.getViewModel((Properties)this.designerProperties)) != null) {
            this.selectedModel = propsViewModel;
        }
        if (this.selectedModel != null) {
            ModelResource mr = ModelUtilities.getModelResource((Object)this.selectedModel);
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            this.relationalViewTable = new RelationalViewTable();
            this.relationalViewTable.setSupportsUpdate(true);
            TransformationDialogModel dialogModel = new TransformationDialogModel((RelationalReference)this.relationalViewTable, this.selectedModel);
            EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, (EditRelationalObjectDialogModel)dialogModel);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.newViewTable = this.createViewTableInTxn(mr, this.relationalViewTable);
            } else {
                this.relationalViewTable = null;
                this.newViewTable = null;
            }
        }
    }

    private EObject createViewTableInTxn(ModelResource modelResource, RelationalViewTable viewTable) {
        EObject newTable;
        block13: {
            newTable = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalViewTableTitle, (Object)((Object)this));
            boolean succeeded = false;
            try {
                try {
                    ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                    if (editor == null) break block13;
                    boolean isDirty = editor.isDirty();
                    RelationalViewModelFactory factory = new RelationalViewModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)viewTable);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                    for (Object child : modelResource.getEObjects()) {
                        EObject eObj = (EObject)child;
                        if (!ModelerCore.getModelEditor().getName(eObj).equalsIgnoreCase(this.relationalViewTable.getName())) continue;
                        newTable = eObj;
                        break;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewTableExceptionMessage, (String)e.getMessage());
                    Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalViewTableExceptionMessage, (Throwable)e);
                    UiConstants.Util.log((IStatus)status);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    return null;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return newTable;
    }

    public EObject getNewViewTable() {
        return this.newViewTable;
    }
}

