/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationGlobalActionsManager;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CopyAction
extends TransformationAction
implements UiConstants {
    private static final String PROBLEM = "CopyAction.problem";

    public CopyAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        EObject obj;
        String objectString = null;
        List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        if (lstObjs.size() == 1) {
            obj = (EObject)lstObjs.get(0);
            ILabelProvider ilp = ModelUtilities.getEMFLabelProvider();
            objectString = ilp.getText((Object)obj);
        } else {
            objectString = "" + lstObjs.size();
        }
        try {
            if (lstObjs.size() == 1) {
                obj = (EObject)lstObjs.get(0);
                ModelerCore.getModelEditor().copyToClipboard(obj);
            } else {
                ModelerCore.getModelEditor().copyAllToClipboard((Collection)lstObjs);
            }
        }
        catch (ModelerCoreException err) {
            String msg = Util.getString(PROBLEM, (Object)objectString);
            this.getPluginUtils().log(4, (Throwable)err, msg);
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!this.isReadOnly() && this.areEObjectsSelected()) {
            List<Object> sourceEObjects = Collections.EMPTY_LIST;
            if (this.isEObjectSelected()) {
                sourceEObjects = new ArrayList(1);
                Object o = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
                sourceEObjects.add(o);
            } else if (this.areEObjectsSelected()) {
                sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            }
            enable = !sourceEObjects.isEmpty() ? TransformationGlobalActionsManager.canCopy(this.getTransformation(), sourceEObjects) : false;
        }
        this.setEnabled(enable);
    }
}

