/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.AbstractLdapContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.ConnectionNode;

public class LdapConnectionContentProvider
extends AbstractLdapContentProvider {
    public LdapConnectionContentProvider(LdapImportWizardManager manager) {
        super(manager);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof LdapImportWizardManager) {
            ConnectionNode node = new ConnectionNode((LdapImportWizardManager)inputElement);
            return new Object[]{node};
        }
        if (inputElement instanceof ILdapEntryNode) {
            return this.getChildren(inputElement);
        }
        return EMPTY_ARRAY;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ILdapEntryNode;
    }

    private List<ILdapEntryNode> findChildEntries(ILdapEntryNode contextNode) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> searchEnumeration = this.getLdapContext().search(contextNode.getSourceName(), "objectClass=*", searchControls);
        ArrayList<ILdapEntryNode> results = new ArrayList<ILdapEntryNode>();
        while (searchEnumeration != null && searchEnumeration.hasMore()) {
            SearchResult result = searchEnumeration.next();
            ILdapEntryNode node = this.getImportManager().newEntry(result, contextNode);
            results.add(node);
        }
        return results;
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof ILdapEntryNode)) {
            return EMPTY_ARRAY;
        }
        try {
            ILdapEntryNode parentNode = (ILdapEntryNode)parentElement;
            List<ILdapEntryNode> entries = this.findChildEntries(parentNode);
            return entries.toArray();
        }
        catch (NamingException ex) {
            this.getImportManager().notifyError(ex);
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)ex);
            return EMPTY_ARRAY;
        }
    }

    public Object getParent(Object element) {
        if (!(element instanceof ILdapEntryNode)) {
            return EMPTY_ARRAY;
        }
        ILdapEntryNode node = (ILdapEntryNode)element;
        return node.getParent();
    }
}

