/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class SAPArchive {
    private static final String TAR_EXTENTION = ".tar";
    private static final String TAR_GZ_EXTENTION = ".tar.gz";
    private static final String TGZ_EXTENTION = ".tgz";
    private static final String ZIP_EXTENTION = ".zip";
    private static final String END_OF_LINE = "\n";
    protected static final String MANIFEST_ENCODING = "UTF-8";
    public static final String MANIFEST_VERSION_VALUE = "1.0";
    public static final String BUNDLE_MANIFEST_VERSION_VALUE = "2";
    public static final String BUNDLE_ACTIVATION_POLICY_VALUE = "lazy";
    protected Map<String, byte[]> contents = new HashMap<String, byte[]>();

    protected void readArchiveFile(String filename, byte[] fileBytes) throws IOException {
        if (filename.toLowerCase().endsWith(ZIP_EXTENTION)) {
            this.readZIPFile(fileBytes);
        } else if (filename.toLowerCase().endsWith(TGZ_EXTENTION)) {
            this.readTGZFile(fileBytes);
        } else if (filename.toLowerCase().endsWith(TAR_GZ_EXTENTION)) {
            this.readTGZFile(fileBytes);
        } else if (filename.toLowerCase().endsWith(TAR_EXTENTION)) {
            this.readTarFile(fileBytes);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.contents.size() == 1) {
            filename = this.contents.keySet().iterator().next();
            fileBytes = this.contents.values().iterator().next();
            if (filename.toLowerCase().endsWith(ZIP_EXTENTION) || filename.toLowerCase().endsWith(TGZ_EXTENTION) || filename.toLowerCase().endsWith(TAR_GZ_EXTENTION) || filename.toLowerCase().endsWith(TAR_EXTENTION)) {
                this.readArchiveFile(filename, fileBytes);
            }
        }
    }

    protected void readZIPFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        byte[] buf = new byte[32768];
        ByteArrayInputStream fs = new ByteArrayInputStream(fileBytes);
        ZipInputStream zis = new ZipInputStream(fs);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            int numRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((numRead = zis.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, numRead);
            }
            os.close();
            this.contents.put(entry.getName(), os.toByteArray());
            entry = zis.getNextEntry();
        }
        zis.close();
    }

    protected void readTGZFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        TarInputStream tin = new TarInputStream((InputStream)new GZIPInputStream(new ByteArrayInputStream(fileBytes)));
        TarEntry tarEntry = tin.getNextEntry();
        while (tarEntry != null) {
            if (!tarEntry.isDirectory()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                tin.copyEntryContents((OutputStream)os);
                os.close();
                this.contents.put(tarEntry.getName(), os.toByteArray());
            }
            tarEntry = tin.getNextEntry();
        }
        tin.close();
    }

    protected void readTarFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        TarInputStream tin = new TarInputStream((InputStream)new ByteArrayInputStream(fileBytes));
        TarEntry tarEntry = tin.getNextEntry();
        while (tarEntry != null) {
            if (!tarEntry.isDirectory()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                tin.copyEntryContents((OutputStream)os);
                os.close();
                this.contents.put(tarEntry.getName(), os.toByteArray());
            }
            tarEntry = tin.getNextEntry();
        }
        tin.close();
    }

    protected void writeAttribute(StringBuilder manifest, String attributeName, String attributeValue) throws IOException {
        String line = String.valueOf(attributeName) + ": " + attributeValue;
        while (line.getBytes(MANIFEST_ENCODING).length > 70) {
            int index = 70;
            String section = line.substring(0, index >= line.length() ? line.length() - 1 : index);
            while (section.getBytes(MANIFEST_ENCODING).length > 70 && index > 0) {
                section = line.substring(0, --index);
            }
            if (index == 0) {
                throw new IOException();
            }
            manifest.append(String.valueOf(section) + END_OF_LINE);
            line = " " + line.substring(index);
        }
        manifest.append(String.valueOf(line) + END_OF_LINE);
    }

    public void readJARFile(byte[] fileBytes, Map<String, byte[]> contents) throws IOException {
        contents.clear();
        byte[] buf = new byte[32768];
        ByteArrayInputStream fs = new ByteArrayInputStream(fileBytes);
        JarInputStream jis = new JarInputStream(fs);
        ZipEntry entry = jis.getNextEntry();
        while (entry != null) {
            int numRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((numRead = jis.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, numRead);
            }
            os.close();
            contents.put(entry.getName(), os.toByteArray());
            entry = jis.getNextEntry();
        }
        jis.close();
    }

    protected void addJarEntry(JarOutputStream target, String jarEntryName, byte[] jarEntryContents, long lastModified) throws IOException {
        int numRead;
        byte[] buf = new byte[32768];
        JarEntry jarEntry = new JarEntry(jarEntryName);
        jarEntry.setTime(lastModified);
        target.putNextEntry(jarEntry);
        ByteArrayInputStream is = new ByteArrayInputStream(jarEntryContents);
        while ((numRead = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
            target.write(buf, 0, numRead);
        }
        target.closeEntry();
    }
}

