/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.metamodels.xsd.XsdConstants;
import org.teiid.designer.metamodels.xsd.XsdPlugin;
import org.teiid.designer.metamodels.xsd.aspects.sql.XsdSimpleTypeDefinitionAspect;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XsdUtil {
    public static final String BUILT_IN_DATATYPE_NAMESPACE_URI = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";

    protected XsdUtil() {
    }

    public static XSDModelGroup getCompositor(XSDComplexTypeDefinition complexType) {
        XSDComplexTypeContent content;
        if (complexType != null && (content = complexType.getContent()) instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)content;
            XSDParticleContent particleContent = particle.getContent();
            if (particleContent != null && particleContent instanceof XSDModelGroup) {
                return (XSDModelGroup)particleContent;
            }
            XSDTerm particleTerm = particle.getTerm();
            if (particleTerm != null && particleTerm instanceof XSDModelGroup) {
                return (XSDModelGroup)particleTerm;
            }
        }
        return null;
    }

    public static boolean hasUnresolvedSchemaDirectives(Resource eResource) {
        if (eResource instanceof XSDResourceImpl) {
            XSDResourceImpl xsdResource = (XSDResourceImpl)eResource;
            XSDSchemaImpl schema = (XSDSchemaImpl)xsdResource.getSchema();
            for (Object content : schema.eContents()) {
                XSDSchemaDirective directive;
                if (!(content instanceof XSDSchemaDirective) || (directive = (XSDSchemaDirective)content).getResolvedSchema() != null) continue;
                return true;
            }
        }
        return false;
    }

    public static void resolveSchemaDirectives(Resource eResource) {
        XSDResourceImpl xsdResource;
        ResourceSet rs;
        if (eResource instanceof XSDResourceImpl && XsdUtil.hasUnresolvedSchemaDirectives(eResource) && (rs = (xsdResource = (XSDResourceImpl)eResource).getResourceSet()) != null) {
            ArrayList<Resource> xsds = new ArrayList<Resource>(rs.getResources().size());
            for (Resource r : rs.getResources()) {
                if (!(r instanceof XSDResourceImpl) || !XsdUtil.hasUnresolvedSchemaDirectives(r)) continue;
                xsds.add(r);
            }
            for (Resource r : xsds) {
                r.unload();
                try {
                    r.load(rs.getLoadOptions());
                }
                catch (IOException e) {
                    XsdPlugin.Util.log((Throwable)e);
                }
            }
        }
    }

    public static String getUniqueQNamePrefix(XSDSchema schema) {
        if (schema == null) {
            return null;
        }
        Map qNameMap = schema.getQNamePrefixToNamespaceMap();
        int increment = 1;
        String val = "Z" + increment;
        boolean done = false;
        while (!done) {
            if (qNameMap.get(val) != null) {
                val = "Z" + ++increment;
                continue;
            }
            done = true;
        }
        return val;
    }

    public static void removeNamespaceRef(XSDSchema schema, String namespace) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        CoreArgCheck.isNotNull((Object)namespace);
        Map map = schema.getQNamePrefixToNamespaceMap();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : new ArrayList(entrySet)) {
            if (!namespace.equals(entry.getValue())) continue;
            try {
                ModelerCore.getModelEditor().removeMapValue((Object)schema, map, entry.getKey());
            }
            catch (ModelerCoreException mce) {
                String msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_remove_the_namespace_reference", (Object)namespace);
                XsdPlugin.Util.log(4, (Throwable)mce, msg);
            }
        }
    }

    public static void removeImport(XSDSchema schema, String namespace) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        CoreArgCheck.isNotNull((Object)namespace);
        for (Object content : new ArrayList(schema.getContents())) {
            if (!(content instanceof XSDImport) || !namespace.equals(((XSDImport)content).getNamespace())) continue;
            try {
                ModelerCore.getModelEditor().removeValue((Object)schema, content, schema.getContents());
            }
            catch (ModelerCoreException mce) {
                String msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_remove_the_xsd_import", (Object)namespace);
                XsdPlugin.Util.log(4, (Throwable)mce, msg);
            }
        }
    }

    public static void addImport(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        CoreArgCheck.isNotNull((Object)simpleType);
        XsdUtil.CoreArgCheckIsResolved((EObject)simpleType);
        CoreArgCheck.isNotNull((Object)baseType);
        XsdUtil.CoreArgCheckIsResolved((EObject)baseType);
        XSDSchema schema = simpleType.getSchema();
        String referencedNamespace = baseType.getTargetNamespace();
        if (!XsdUtil.containsNamespaceDeclaration(schema, referencedNamespace)) {
            XsdUtil.addNamespaceRef(schema, referencedNamespace);
        }
        XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
        xsdImport.setNamespace(referencedNamespace);
        if (!BUILT_IN_DATATYPE_NAMESPACE_URI.equals(referencedNamespace)) {
            URI schemaLocation = baseType.eResource().getURI().deresolve(simpleType.eResource().getURI());
            xsdImport.setSchemaLocation(schemaLocation.toString());
        }
        try {
            ModelerCore.getModelEditor().addValue((Object)schema, (Object)xsdImport, schema.getContents(), 0);
        }
        catch (ModelerCoreException mce) {
            Object[] params = new Object[]{referencedNamespace, xsdImport.getSchemaLocation()};
            String msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_add_the_xsd_import", params);
            XsdPlugin.Util.log(4, (Throwable)mce, msg);
        }
    }

    public static void addNamespaceRef(XSDSchema schema, String namespace) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        CoreArgCheck.isNotNull((Object)namespace);
        String prefix = XsdUtil.getUniqueQNamePrefix(schema);
        XsdUtil.addNamespaceRef(schema, prefix, namespace);
    }

    public static void addNamespaceRef(XSDSchema schema, String prefix, String namespace) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        CoreArgCheck.isNotNull((Object)namespace);
        Map map = schema.getQNamePrefixToNamespaceMap();
        try {
            ModelerCore.getModelEditor().addMapValue((Object)schema, map, (Object)prefix, (Object)namespace);
        }
        catch (ModelerCoreException mce) {
            Object[] params = new Object[]{prefix, namespace};
            String msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_add_the_namespace_reference", params);
            XsdPlugin.Util.log(4, (Throwable)mce, msg);
        }
    }

    public static boolean containsImport(XSDSchema schema, String namespace) {
        boolean containsImport = false;
        if (schema != null && namespace != null) {
            EList contents = schema.getContents();
            int i = 0;
            while (i < contents.size()) {
                Object content = contents.get(i);
                if (content instanceof XSDImport && namespace.equals(((XSDImport)content).getNamespace())) {
                    containsImport = true;
                    break;
                }
                ++i;
            }
        }
        return containsImport;
    }

    public static boolean containsReferenceToNamespace(XSDSchema schema, String namespace) {
        boolean containsReference = false;
        if (schema != null && !schema.eIsProxy() && namespace != null) {
            if (XSDConstants.isSchemaForSchemaNamespace((String)namespace)) {
                containsReference = true;
            } else {
                EList contents = schema.getContents();
                int i = 0;
                while (i < contents.size()) {
                    XSDSimpleTypeDefinition simpleType;
                    Object o = contents.get(i);
                    if (o instanceof XSDSimpleTypeDefinition && namespace.equals((simpleType = (XSDSimpleTypeDefinition)o).getBaseTypeDefinition().getTargetNamespace())) {
                        containsReference = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return containsReference;
    }

    public static boolean containsNamespaceDeclaration(XSDSchema schema, String namespace) {
        boolean containsNamespaceDeclaration = false;
        if (schema != null) {
            Map prefixesToNamespaces = schema.getQNamePrefixToNamespaceMap();
            containsNamespaceDeclaration = prefixesToNamespaces.containsValue(namespace);
        }
        return containsNamespaceDeclaration;
    }

    public static boolean isEnterpriseSchema(XSDSchema schema) {
        boolean success = false;
        if (schema != null && !schema.eIsProxy()) {
            String namespace = (String)schema.getQNamePrefixToNamespaceMap().get("mmedt");
            success = XsdConstants.isSchemaEnterpriseDatatypeNamespace(namespace);
        }
        return success;
    }

    public static void setTargetNamespace(XSDSchema schema, String namespace) {
        boolean assignDefaultReference;
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        CoreArgCheck.isNotNull((Object)namespace);
        String defaultNamespaceReference = (String)schema.getQNamePrefixToNamespaceMap().get(null);
        boolean bl = assignDefaultReference = defaultNamespaceReference == null || schema.getTargetNamespace().equals(defaultNamespaceReference);
        if (assignDefaultReference) {
            XsdUtil.addNamespaceRef(schema, null, namespace);
        } else {
            XsdUtil.addNamespaceRef(schema, namespace);
        }
        schema.setTargetNamespace(namespace);
    }

    public static void setAsEnterpriseSchema(XSDSchema schema) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        XsdUtil.addNamespaceRef(schema, "mmedt", "http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes");
        schema.eResource().setModified(true);
    }

    public static void unsetAsEnterpriseSchema(XSDSchema schema) {
        CoreArgCheck.isNotNull((Object)schema);
        XsdUtil.CoreArgCheckIsResolved((EObject)schema);
        schema.getQNamePrefixToNamespaceMap().remove("mmedt");
        schema.eResource().setModified(true);
    }

    public static void checkForEnterpriseConversion(XSDSchema schema) {
        if (schema != null && !XsdUtil.isEnterpriseSchema(schema)) {
            EList contents = schema.getContents();
            int i = 0;
            while (i < contents.size()) {
                Object o = contents.get(i);
                if (o instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)o;
                    XsdSimpleTypeDefinitionAspect aspect = (XsdSimpleTypeDefinitionAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect((EObject)simpleType, SqlAspect.class);
                    aspect.convertEnterpriseDatatype(simpleType);
                }
                ++i;
            }
        }
    }

    public static void checkForEnterpriseConversion(XSDSimpleTypeDefinition simpleType) {
        XsdSimpleTypeDefinitionAspect aspect;
        EnterpriseDatatypeInfo edtInfo;
        XSDSchema schema = simpleType.getSchema();
        if (schema != null && !XsdUtil.isEnterpriseSchema(schema) && (edtInfo = (aspect = (XsdSimpleTypeDefinitionAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect((EObject)simpleType, SqlAspect.class)).getEnterpriseAttributesFromAppInfo(simpleType)).isValid()) {
            XsdUtil.checkForEnterpriseConversion(schema);
        }
    }

    public static boolean canAnnotate(XSDConcreteComponent comp) {
        CoreArgCheck.isNotNull((Object)comp);
        return comp instanceof XSDSchema || comp instanceof XSDAnnotation || comp instanceof XSDAttributeDeclaration || comp instanceof XSDAttributeGroupDefinition || comp instanceof XSDElementDeclaration || comp instanceof XSDNotationDeclaration || comp instanceof XSDModelGroup || comp instanceof XSDModelGroupDefinition || comp instanceof XSDIdentityConstraintDefinition || comp instanceof XSDTypeDefinition || comp instanceof XSDWildcard || comp instanceof XSDFacet;
    }

    public static XSDAnnotation getAnnotation(XSDConcreteComponent comp) {
        XSDAnnotation annotation2 = null;
        if (comp instanceof XSDSchema) {
            EList annotations = ((XSDSchema)comp).getAnnotations();
            if (annotations != null) {
                for (XSDAnnotation annotation2 : annotations) {
                    if (annotation2 == null) {
                        continue;
                    }
                    break;
                }
            }
        } else if (comp instanceof XSDAttributeDeclaration) {
            annotation2 = ((XSDAttributeDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            annotation2 = ((XSDAttributeGroupDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDElementDeclaration) {
            annotation2 = ((XSDElementDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDNotationDeclaration) {
            annotation2 = ((XSDNotationDeclaration)comp).getAnnotation();
        } else if (comp instanceof XSDModelGroup) {
            annotation2 = ((XSDModelGroup)comp).getAnnotation();
        } else if (comp instanceof XSDModelGroupDefinition) {
            annotation2 = ((XSDModelGroupDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            annotation2 = ((XSDIdentityConstraintDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDTypeDefinition) {
            annotation2 = ((XSDTypeDefinition)comp).getAnnotation();
        } else if (comp instanceof XSDWildcard) {
            annotation2 = ((XSDWildcard)comp).getAnnotation();
        } else if (comp instanceof XSDFacet) {
            annotation2 = ((XSDFacet)comp).getAnnotation();
        } else if (comp instanceof XSDAnnotation) {
            annotation2 = (XSDAnnotation)comp;
        }
        return annotation2;
    }

    public static XSDAnnotation getAnnotation(XSDConcreteComponent comp, boolean createIfNull) {
        CoreArgCheck.isNotNull((Object)comp);
        if (!createIfNull) {
            return XsdUtil.getAnnotation(comp);
        }
        XSDAnnotation annotation2 = null;
        if (comp instanceof XSDSchema) {
            EList annotations = ((XSDSchema)comp).getAnnotations();
            if (annotations == null || annotations.isEmpty()) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDSchema)comp).getContents().add((Object)annotation2);
            } else {
                for (XSDAnnotation annotation2 : annotations) {
                    if (annotation2 == null) {
                        continue;
                    }
                    break;
                }
            }
        } else if (comp instanceof XSDAttributeDeclaration) {
            annotation2 = ((XSDAttributeDeclaration)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDAttributeDeclaration)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            annotation2 = ((XSDAttributeGroupDefinition)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDAttributeGroupDefinition)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDElementDeclaration) {
            annotation2 = ((XSDElementDeclaration)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDElementDeclaration)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDNotationDeclaration) {
            annotation2 = ((XSDNotationDeclaration)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDNotationDeclaration)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDModelGroup) {
            annotation2 = ((XSDModelGroup)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDModelGroup)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDModelGroupDefinition) {
            annotation2 = ((XSDModelGroupDefinition)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDModelGroupDefinition)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            annotation2 = ((XSDIdentityConstraintDefinition)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDIdentityConstraintDefinition)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDTypeDefinition) {
            annotation2 = ((XSDTypeDefinition)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDTypeDefinition)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDWildcard) {
            annotation2 = ((XSDWildcard)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDWildcard)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDFacet) {
            annotation2 = ((XSDFacet)comp).getAnnotation();
            if (annotation2 == null) {
                annotation2 = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDFacet)comp).setAnnotation(annotation2);
            }
        } else if (comp instanceof XSDAnnotation) {
            annotation2 = (XSDAnnotation)comp;
        }
        return annotation2;
    }

    public static void setAnnotation(XSDConcreteComponent comp, XSDAnnotation annotation) {
        CoreArgCheck.isNotNull((Object)comp);
        if (annotation == null) {
            return;
        }
        if (comp instanceof XSDSchema) {
            ((XSDSchema)comp).getContents().add((Object)annotation);
        } else if (comp instanceof XSDAttributeDeclaration) {
            ((XSDAttributeDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            ((XSDAttributeGroupDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDNotationDeclaration) {
            ((XSDNotationDeclaration)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDModelGroup) {
            ((XSDModelGroup)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDModelGroupDefinition) {
            ((XSDModelGroupDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            ((XSDIdentityConstraintDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDTypeDefinition) {
            ((XSDTypeDefinition)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDWildcard) {
            ((XSDWildcard)comp).setAnnotation(annotation);
        } else if (comp instanceof XSDFacet) {
            ((XSDFacet)comp).setAnnotation(annotation);
        }
    }

    public static void addUserInfoAttribute(XSDConcreteComponent comp, String text) {
        CoreArgCheck.isNotNull((Object)comp);
        CoreArgCheck.isNotZeroLength((String)text);
        if (!XsdUtil.canAnnotate(comp)) {
            return;
        }
        XSDAnnotation annotation = XsdUtil.getAnnotation(comp);
        if (annotation == null) {
            annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            XsdUtil.setAnnotation(comp, annotation);
        }
        XsdUtil.addUserInfoAttribute(annotation, text);
    }

    public static void addUserInfoAttribute(XSDAnnotation annotation, String text) {
        CoreArgCheck.isNotNull((Object)annotation);
        CoreArgCheck.isNotZeroLength((String)text);
        if (!annotation.getUserInformation().isEmpty()) {
            ArrayList<Element> nodesToRemove = new ArrayList<Element>();
            for (Element userInfo : annotation.getUserInformation()) {
                Node node = userInfo.getFirstChild();
                if (node != null) {
                    XsdUtil.accumulateTextNodes(node, nodesToRemove);
                    continue;
                }
                nodesToRemove.add(userInfo);
            }
            for (Node node : nodesToRemove) {
                try {
                    Node parent = node.getParentNode();
                    if (parent == null) continue;
                    parent.removeChild(node);
                    if (parent.hasChildNodes()) continue;
                    Node infoNode = parent.getParentNode();
                    infoNode.removeChild(parent);
                }
                catch (Exception e) {
                    XsdPlugin.Util.log((Throwable)e);
                }
            }
        }
        Element userInfo = annotation.createUserInformation(null);
        annotation.getElement().appendChild(userInfo);
        userInfo.appendChild(userInfo.getOwnerDocument().createTextNode(text));
    }

    public static void addApplicationInfoTag(XSDConcreteComponent comp, String propName, String propValue) {
        if (comp == null || propName == null) {
            return;
        }
        XSDAnnotation annotation = XsdUtil.getAnnotation(comp, true);
        Element appinfo = null;
        if (annotation.getApplicationInformation().isEmpty()) {
            appinfo = annotation.createApplicationInformation(null);
            annotation.getElement().appendChild(appinfo);
        } else {
            appinfo = (Element)annotation.getApplicationInformation().iterator().next();
        }
        Attr attr = appinfo.getOwnerDocument().createAttribute(propName);
        attr.setNodeValue(propValue);
        appinfo.getAttributes().setNamedItem(attr);
    }

    public static String getAppInfoAttributeValue(XSDConcreteComponent comp, String key) {
        XSDAnnotation annotation = XsdUtil.getAnnotation(comp);
        if (annotation == null || annotation.getApplicationInformation().isEmpty()) {
            return null;
        }
        for (Element next : annotation.getApplicationInformation()) {
            Attr attr = next.getAttributeNode(key);
            if (attr == null) continue;
            return attr.getValue();
        }
        return null;
    }

    public static XSDModelGroup getCompositor(XSDModelGroupDefinition group) {
        if (group != null) {
            return group.getModelGroup();
        }
        return null;
    }

    public static boolean isAttribute(XSDComponent component) {
        return component != null && component instanceof XSDAttributeDeclaration;
    }

    public static boolean isSequence(XSDModelGroup modelGroup) {
        if (modelGroup != null) {
            XSDCompositor compositor = modelGroup.getCompositor();
            return 2 == compositor.getValue();
        }
        return false;
    }

    public static boolean isChoice(XSDModelGroup modelGroup) {
        if (modelGroup != null) {
            XSDCompositor compositor = modelGroup.getCompositor();
            return 1 == compositor.getValue();
        }
        return false;
    }

    public static boolean isAll(XSDModelGroup modelGroup) {
        if (modelGroup != null) {
            XSDCompositor compositor = modelGroup.getCompositor();
            return compositor.getValue() == 0;
        }
        return false;
    }

    public static boolean isWritable(XSDComponent component) {
        if (component == null) {
            return false;
        }
        XSDResourceImpl rsrc = (XSDResourceImpl)component.eResource();
        return XsdUtil.isWritable(rsrc);
    }

    public static boolean isWritable(XSDResourceImpl rsrc) {
        File file;
        if (rsrc == null) {
            return false;
        }
        URI uri = rsrc.getURI();
        if (uri != null && uri.toFileString() != null && (file = new File(uri.toFileString())).exists()) {
            return file.canWrite();
        }
        return true;
    }

    public static boolean isGlobal(XSDComponent xsdComponent) {
        XSDConcreteComponent parent;
        return xsdComponent != null && (parent = xsdComponent.getContainer()) instanceof XSDSchema;
    }

    public static List getSupertypes(XSDComponent xsdComponent) {
        ArrayList<XSDComponent> superTypes = new ArrayList<XSDComponent>();
        while (xsdComponent != null) {
            XSDTypeDefinition type;
            if (xsdComponent instanceof XSDTypeDefinition) {
                superTypes.add(xsdComponent);
            }
            if ((type = XsdUtil.getTypeOrBaseType(xsdComponent)) == null || type == xsdComponent) {
                return superTypes;
            }
            xsdComponent = type;
        }
        return superTypes;
    }

    public static XSDTypeDefinition getCommonBaseTypeForContained(XSDComponent schemaComponent) {
        LinkedList childElements = new LinkedList();
        XsdUtil.addChildElements(schemaComponent, childElements, false);
        if (childElements.size() == 1) {
            return (XSDTypeDefinition)childElements.get(0);
        }
        ArrayList<List> supertypesLists = new ArrayList<List>();
        for (XSDComponent childElement : childElements) {
            List supertypes = XsdUtil.getSupertypes(childElement);
            supertypesLists.add(supertypes);
        }
        return (XSDTypeDefinition)XsdUtil.findFirstCommonObject(supertypesLists);
    }

    protected static Object findFirstCommonObject(List supertypesLists) {
        if (supertypesLists.size() == 0) {
            return null;
        }
        if (supertypesLists.size() == 1) {
            List supertypes = (List)supertypesLists.get(0);
            if (supertypes.size() != 0) {
                return supertypes.get(0);
            }
            return null;
        }
        List candiateList = (List)supertypesLists.remove(0);
        Iterator candidateIter = candiateList.iterator();
        while (candidateIter.hasNext()) {
            boolean failedToFindAnyMatch = false;
            Object candidateType = candidateIter.next();
            for (List supertypesOfAnotherChild : supertypesLists) {
                boolean foundMatch = false;
                for (Object superOfAnotherChild : supertypesOfAnotherChild) {
                    if (!candidateType.equals(superOfAnotherChild)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                failedToFindAnyMatch = true;
                break;
            }
            if (failedToFindAnyMatch) continue;
            return candidateType;
        }
        return null;
    }

    protected static void addChildElements(XSDComponent xsdComponent, List childElements, boolean includeSchemaComponent) {
        XSDModelGroupDefinition group;
        EList children;
        XSDModelGroup compositor;
        XSDParticle particle;
        XSDParticleContent content;
        if (xsdComponent instanceof XSDSimpleTypeDefinition) {
            return;
        }
        if (xsdComponent instanceof XSDAnnotation) {
            return;
        }
        if (xsdComponent instanceof XSDAttributeGroupDefinition) {
            return;
        }
        if (xsdComponent instanceof XSDParticle && (content = (particle = (XSDParticle)xsdComponent).getContent()) instanceof XSDComponent) {
            XsdUtil.addChildElements((XSDComponent)content, childElements, true);
        }
        if (xsdComponent instanceof XSDElementDeclaration) {
            XSDTypeDefinition type = XsdUtil.getTypeOrBaseType(xsdComponent);
            if (type != null) {
                if (includeSchemaComponent) {
                    childElements.add(type);
                } else {
                    XsdUtil.addChildElements((XSDComponent)type, childElements, true);
                }
            }
            return;
        }
        if (xsdComponent instanceof XSDComplexTypeDefinition) {
            XSDTypeDefinition superType;
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)xsdComponent;
            compositor = XsdUtil.getCompositor(complexType);
            if (compositor != null) {
                children = compositor.getContents();
                for (EObject child : children) {
                    if (!(child instanceof XSDComponent)) continue;
                    XsdUtil.addChildElements((XSDComponent)child, childElements, true);
                }
            }
            if ((superType = XsdUtil.getTypeOrBaseType(xsdComponent)) != null && superType != xsdComponent) {
                XsdUtil.addChildElements((XSDComponent)superType, childElements, true);
            }
        }
        if (xsdComponent instanceof XSDModelGroupDefinition && (compositor = XsdUtil.getCompositor(group = (XSDModelGroupDefinition)xsdComponent)) != null) {
            children = compositor.getContents();
            for (EObject child : children) {
                if (!(child instanceof XSDComponent)) continue;
                XsdUtil.addChildElements((XSDComponent)child, childElements, true);
            }
        }
    }

    public static XSDTypeDefinition getType(XSDElementDeclaration element) {
        XSDElementDeclaration resolvedElement = element.getResolvedElementDeclaration();
        while (resolvedElement != null && resolvedElement != element) {
            element = resolvedElement;
            resolvedElement = element.getResolvedElementDeclaration();
        }
        return resolvedElement == null ? null : resolvedElement.getTypeDefinition();
    }

    public static XSDTypeDefinition getType(XSDAttributeDeclaration attrib) {
        XSDAttributeDeclaration resolvedAttrib = attrib.getResolvedAttributeDeclaration();
        while (resolvedAttrib != null && resolvedAttrib != attrib) {
            attrib = resolvedAttrib;
            resolvedAttrib = attrib.getResolvedAttributeDeclaration();
        }
        return resolvedAttrib == null ? null : resolvedAttrib.getTypeDefinition();
    }

    public static XSDFeature getResolved(XSDFeature feature) {
        if (feature instanceof XSDElementDeclaration) {
            return XsdUtil.getResolved((XSDElementDeclaration)feature);
        }
        if (feature instanceof XSDAttributeDeclaration) {
            return XsdUtil.getResolved((XSDAttributeDeclaration)feature);
        }
        return null;
    }

    public static XSDElementDeclaration getResolved(XSDElementDeclaration element) {
        XSDElementDeclaration resolvedElement = element.getResolvedElementDeclaration();
        while (resolvedElement != null && resolvedElement != element) {
            element = resolvedElement;
            resolvedElement = element.getResolvedElementDeclaration();
        }
        return resolvedElement;
    }

    public static XSDAttributeDeclaration getResolved(XSDAttributeDeclaration attribute) {
        XSDAttributeDeclaration resolvedAttribute = attribute.getResolvedAttributeDeclaration();
        while (resolvedAttribute != null && resolvedAttribute != attribute) {
            attribute = resolvedAttribute;
            resolvedAttribute = attribute.getResolvedAttributeDeclaration();
        }
        return resolvedAttribute;
    }

    public static XSDSimpleTypeDefinition getSimpleType(XSDComponent xsdComponent) {
        XSDTypeDefinition xsdType = XsdUtil.getType(xsdComponent);
        if (xsdType != null) {
            return XsdUtil.getSimpleType(xsdType);
        }
        return null;
    }

    public static XSDSimpleTypeDefinition getSimpleType(XSDTypeDefinition xsdType) {
        XSDSimpleTypeDefinition simpleType = null;
        if (xsdType != null && xsdType instanceof XSDSimpleTypeDefinition) {
            simpleType = (XSDSimpleTypeDefinition)xsdType;
            return simpleType;
        }
        if (xsdType != null && xsdType instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType;
            XSDComplexTypeDefinition type = complexType = (XSDComplexTypeDefinition)xsdType;
            while (type != null) {
                XSDTypeDefinition baseType;
                if (XsdUtil.isAnySimpleType((XSDTypeDefinition)type)) {
                    simpleType = (XSDSimpleTypeDefinition)type;
                    break;
                }
                if (XsdUtil.isAnyType((XSDTypeDefinition)type)) break;
                if (type instanceof XSDSimpleTypeDefinition) {
                    simpleType = (XSDSimpleTypeDefinition)type;
                    break;
                }
                if (!(type instanceof XSDComplexTypeDefinition) || (baseType = type.getBaseTypeDefinition()) == type) break;
                type = baseType;
            }
            return simpleType;
        }
        return null;
    }

    public static XSDTypeDefinition getType(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDElementDeclaration) {
            return XsdUtil.getType((XSDElementDeclaration)xsdComponent);
        }
        if (xsdComponent instanceof XSDAttributeDeclaration) {
            return XsdUtil.getType((XSDAttributeDeclaration)xsdComponent);
        }
        if (xsdComponent instanceof XSDTypeDefinition) {
            return (XSDTypeDefinition)xsdComponent;
        }
        return null;
    }

    public static XSDSimpleTypeDefinition getBuiltInDatatype(XSDTypeDefinition type) {
        String msg;
        Object[] params;
        XSDSimpleTypeDefinition builtInType = null;
        if (type != null && type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
            try {
                builtInType = (XSDSimpleTypeDefinition)ModelerCore.getWorkspaceDatatypeManager().getDatatypeForXsdType((EObject)complexType);
            }
            catch (ModelerCoreException e) {
                params = new Object[]{type.getURI()};
                msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_get_the_MetaMatrix_built-in_datatype_for_1", params);
                XsdPlugin.Util.log(4, (Throwable)e, msg);
            }
        }
        if (type != null && type instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)type;
            try {
                builtInType = (XSDSimpleTypeDefinition)ModelerCore.getWorkspaceDatatypeManager().getDatatypeForXsdType((EObject)simpleType);
            }
            catch (ModelerCoreException e) {
                params = new Object[]{type.getURI()};
                msg = XsdPlugin.Util.getString("XsdUtil.Unable_to_get_the_MetaMatrix_built-in_datatype_for_2", params);
                XsdPlugin.Util.log(4, (Throwable)e, msg);
            }
        }
        return builtInType;
    }

    public static XSDSimpleTypeDefinition getBuiltInDatatype(XSDElementDeclaration element) {
        XSDTypeDefinition type = XsdUtil.getType(element);
        return XsdUtil.getBuiltInDatatype(type);
    }

    public static XSDSimpleTypeDefinition getBuiltInDatatype(XSDComponent xsdComponent) {
        XSDTypeDefinition type = XsdUtil.getType(xsdComponent);
        return XsdUtil.getBuiltInDatatype(type);
    }

    public static XSDTypeDefinition getTypeOrBaseType(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDElementDeclaration) {
            return XsdUtil.getType((XSDElementDeclaration)xsdComponent);
        }
        if (xsdComponent instanceof XSDTypeDefinition) {
            return ((XSDTypeDefinition)xsdComponent).getBaseType();
        }
        return null;
    }

    public static boolean isURType(XSDTypeDefinition xsdType) {
        if (xsdType != null) {
            return XSDConstants.isURType((XSDTypeDefinition)xsdType);
        }
        return false;
    }

    public static boolean isAnyType(XSDTypeDefinition xsdType) {
        if (xsdType != null) {
            return XSDConstants.isAnyType((XSDTypeDefinition)xsdType);
        }
        return false;
    }

    public static boolean isAnySimpleType(XSDTypeDefinition xsdType) {
        if (xsdType != null) {
            return XSDConstants.isAnySimpleType((XSDTypeDefinition)xsdType);
        }
        return false;
    }

    public static boolean isBuiltInDatatype(XSDComponent xsdComponent) {
        if (xsdComponent != null && xsdComponent instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)xsdComponent;
            return XsdUtil.isBuiltInDatatype(simpleType);
        }
        return false;
    }

    public static boolean isBuiltInDatatype(XSDSimpleTypeDefinition simpleType) {
        String namespaceUri = simpleType.getTargetNamespace();
        if (BUILT_IN_DATATYPE_NAMESPACE_URI.equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2000/10/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        return "http://www.w3.org/1999/XMLSchema".equals(namespaceUri);
    }

    public static boolean isNillable(XSDComponent component) {
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            return element.isNillable();
        }
        return false;
    }

    public static int getMinOccursLiteral(XSDComponent component) {
        XSDModelGroupDefinition group;
        XSDConcreteComponent container;
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            container = element.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroupDefinition) {
            group = (XSDModelGroupDefinition)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroup) {
            group = (XSDModelGroup)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDWildcard) {
            XSDWildcard any = (XSDWildcard)component;
            container = any.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)component;
            int minOccurs = particle.getMinOccurs();
            return minOccurs;
        }
        return 0;
    }

    public static int getMaxOccursLiteral(XSDComponent component) {
        XSDModelGroupDefinition group;
        XSDConcreteComponent container;
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            container = element.getContainer();
            if (container instanceof XSDSchema) {
                return -1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroupDefinition) {
            group = (XSDModelGroupDefinition)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return -1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroup) {
            group = (XSDModelGroup)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return -1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDWildcard) {
            XSDWildcard any = (XSDWildcard)component;
            container = any.getContainer();
            if (container instanceof XSDSchema) {
                return -1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccursLiteral((XSDComponent)particle);
            }
        }
        if (component instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)component;
            int maxOccurs = particle.getMaxOccurs();
            return maxOccurs;
        }
        return -1;
    }

    public static int getMinOccurs(XSDComponent component) {
        XSDModelGroupDefinition group;
        XSDConcreteComponent container;
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            container = element.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroupDefinition) {
            group = (XSDModelGroupDefinition)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroup) {
            group = (XSDModelGroup)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDWildcard) {
            XSDWildcard any = (XSDWildcard)component;
            container = any.getContainer();
            if (container instanceof XSDSchema) {
                return 0;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMinOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)component;
            int minOccurs = particle.getMinOccurs();
            if (minOccurs == 0) {
                return minOccurs;
            }
            XSDConcreteComponent particleParent = particle.getContainer();
            while (particleParent instanceof XSDModelGroup || particleParent instanceof XSDModelGroupDefinition) {
                if (particleParent instanceof XSDModelGroup && XsdUtil.isChoice((XSDModelGroup)particleParent)) {
                    return 0;
                }
                XSDConcreteComponent particleGrandparent = particleParent.getContainer();
                if (!(particleGrandparent instanceof XSDParticle)) break;
                XSDParticle modelGroupParticle = (XSDParticle)particleGrandparent;
                int groupOccurs = modelGroupParticle.getMinOccurs();
                particleParent = modelGroupParticle.getContainer();
                if ((minOccurs *= groupOccurs) == 0) break;
            }
            return minOccurs;
        }
        return 0;
    }

    public static int getMaxOccurs(XSDComponent component) {
        XSDModelGroupDefinition group;
        XSDConcreteComponent container;
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            container = element.getContainer();
            if (container instanceof XSDSchema) {
                return 1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroupDefinition) {
            group = (XSDModelGroupDefinition)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDModelGroup) {
            group = (XSDModelGroup)component;
            container = group.getContainer();
            if (container instanceof XSDSchema) {
                return 1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDWildcard) {
            XSDWildcard any = (XSDWildcard)component;
            container = any.getContainer();
            if (container instanceof XSDSchema) {
                return 1;
            }
            if (container instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)container;
                return XsdUtil.getMaxOccurs((XSDComponent)particle);
            }
        }
        if (component instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)component;
            int maxOccurs = particle.getMaxOccurs();
            if (maxOccurs == -1) {
                return maxOccurs;
            }
            XSDConcreteComponent particleParent = particle.getContainer();
            while (particleParent instanceof XSDModelGroup || particleParent instanceof XSDModelGroupDefinition) {
                XSDConcreteComponent particleGrandparent = particleParent.getContainer();
                if (!(particleGrandparent instanceof XSDParticle)) break;
                XSDParticle modelGroupParticle = (XSDParticle)particleGrandparent;
                int groupOccurs = modelGroupParticle.getMaxOccurs();
                if (groupOccurs == -1) {
                    return groupOccurs;
                }
                particleParent = modelGroupParticle.getContainer();
                if ((maxOccurs *= groupOccurs) == -1) break;
            }
            return maxOccurs;
        }
        return 1;
    }

    public static XSDAttributeUseCategory getUse(XSDComponent component) {
        XSDAttributeUse use = null;
        if (component instanceof XSDAttributeUse) {
            use = (XSDAttributeUse)component;
        } else {
            XSDConcreteComponent parent = component.getContainer();
            if (parent instanceof XSDAttributeUse) {
                use = (XSDAttributeUse)parent;
            }
        }
        return use == null ? XSDAttributeUseCategory.OPTIONAL_LITERAL : use.getUse();
    }

    public static String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
            } else if (type == 4) {
                str.append(XsdUtil.getChildText(child));
            }
            child = child.getNextSibling();
        }
        return str.toString();
    }

    public static String getAppInfoText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        str.append("<Application Information>");
        while (child != null) {
            short type = child.getNodeType();
            if (type == 1) {
                str.append("\n\t<");
                str.append(child.getNodeName());
                str.append(">");
                str.append(XsdUtil.getChildText(child));
                str.append("</");
                str.append(child.getNodeName());
                str.append(">");
            }
            child = child.getNextSibling();
        }
        int i = 0;
        while (i < node.getAttributes().getLength()) {
            Node next = node.getAttributes().item(i);
            str.append("\n\t<");
            str.append(next.getNodeName());
            str.append(">");
            str.append(XsdUtil.getChildText(next));
            str.append("</");
            str.append(next.getNodeName());
            ++i;
        }
        str.append("\n</Application Information>");
        return str.toString();
    }

    public static String getDescription(XSDConcreteComponent eObject) {
        XSDAnnotation annotation = null;
        annotation = eObject instanceof XSDAnnotation ? (XSDAnnotation)eObject : XsdUtil.getAnnotation(eObject);
        if (annotation != null) {
            for (Element userInfo : annotation.getUserInformation()) {
                String value = XsdUtil.getChildText(userInfo);
                if (value == null) continue;
                return value;
            }
            for (Element appInfo : annotation.getApplicationInformation()) {
                String value = XsdUtil.getAppInfoText(appInfo);
                if (value == null) continue;
                return value;
            }
        }
        return "";
    }

    private static void accumulateTextNodes(Node node, List collection) {
        while (node != null) {
            short type = node.getNodeType();
            if (type == 3) {
                collection.add(node);
            } else if (type == 4) {
                XsdUtil.accumulateTextNodes(node.getFirstChild(), collection);
            }
            node = node.getNextSibling();
        }
    }

    private static void CoreArgCheckIsResolved(EObject e) {
        if (e.eIsProxy()) {
            throw new IllegalArgumentException(XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_EObject_can_not_be_a_proxy", (Object)e.toString()));
        }
    }
}

