/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelInitializer;
import org.teiid.designer.metamodels.xsd.XsdPlugin;

public abstract class AbstractXsdInitializer
implements ModelInitializer {
    public static final String XSD_NS_PREFIX = "xsd";

    protected abstract String getXsdNamespace();

    public IStatus execute(Resource model) {
        CoreArgCheck.isNotNull((Object)model);
        if (!(model instanceof XSDResourceImpl)) {
            Object[] params = new Object[]{model.getClass().getName(), XSDResourceImpl.class.getName()};
            String msg = XsdPlugin.Util.getString("AbstractXsdInitializer.Unexpected_resource_type__{0}_(expected_{1})", params);
            return new Status(2, "org.teiid.designer.metamodels.xsd", 0, msg, null);
        }
        EList roots = model.getContents();
        EObject existingRoot = roots.isEmpty() ? null : (EObject)roots.get(0);
        XSDSchema xsdSchema = null;
        if (existingRoot == null) {
            xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            roots.add(xsdSchema);
        } else if (existingRoot instanceof XSDSchema) {
            xsdSchema = (XSDSchema)existingRoot;
        }
        if (xsdSchema != null) {
            xsdSchema.setSchemaForSchemaQNamePrefix(XSD_NS_PREFIX);
            Map qNamePrefixToNamespaceMap = xsdSchema.getQNamePrefixToNamespaceMap();
            String schemaOfSchemaNamespace = this.getXsdNamespace();
            qNamePrefixToNamespaceMap.put(xsdSchema.getSchemaForSchemaQNamePrefix(), schemaOfSchemaNamespace);
        }
        String msg = XsdPlugin.Util.getString("AbstractXsdInitializer.Initialized_the_schema", new Object[0]);
        return new Status(0, "org.teiid.designer.metamodels.xsd", 0, msg, null);
    }
}

