/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.ModelType;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ConcurrentModelVisitorProcessor;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.ddl.DdlOptions;
import org.teiid.designer.ddl.DdlPlugin;
import org.teiid.designer.ddl.ModelWrapper;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueKey;

public class IntermediateFormat {
    public static final String FALSE_VALUE = DdlPlugin.Util.getString("IntermediateFormat.falseValue", new Object[0]);
    public static final String TRUE_VALUE = DdlPlugin.Util.getString("IntermediateFormat.trueValue", new Object[0]);
    public static final String DATE_FORMAT = DdlPlugin.Util.getString("IntermediateFormat.DateFormat", new Object[0]);
    public static final String TIME_FORMAT = DdlPlugin.Util.getString("IntermediateFormat.TimeFormat", new Object[0]);
    private static final DateFormat DATE_FORMATTER;
    private static final DateFormat TIME_FORMATTER;
    final Map relationalEntities;
    private final List modelWrappers;
    private final DdlOptions options;
    private String exporterTool;
    private String exporterVersion;
    private final ModelEditor editor;

    static {
        TIME_FORMATTER = new SimpleDateFormat(TIME_FORMAT);
        TIME_FORMATTER.setLenient(false);
        DATE_FORMATTER = new SimpleDateFormat(DATE_FORMAT);
        DATE_FORMATTER.setLenient(false);
    }

    public IntermediateFormat(ModelWrapper modelWrapper, DdlOptions options, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)modelWrapper);
        CoreArgCheck.isNotNull((Object)options);
        this.modelWrappers = new ArrayList();
        this.modelWrappers.add(modelWrapper);
        this.options = options;
        this.editor = ModelerCore.getModelEditor();
        this.relationalEntities = new HashMap();
    }

    public IntermediateFormat(List modelWrappers, DdlOptions options, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)modelWrappers);
        CoreArgCheck.isNotNull((Object)options);
        this.modelWrappers = new ArrayList(modelWrappers);
        this.options = options;
        this.editor = ModelerCore.getModelEditor();
        this.relationalEntities = new HashMap();
    }

    protected ModelEditor getModelEditor() {
        return this.editor;
    }

    public String getExporterTool() {
        return this.exporterTool;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public void setExporterTool(String string) {
        this.exporterTool = string;
    }

    public void setExporterVersion(String string) {
        this.exporterVersion = string;
    }

    protected void setAttribute(Element element, String attributeName, String value) {
        if (value != null && value.trim().length() != 0) {
            Attribute attrib = new Attribute(attributeName, value);
            element.setAttribute(attrib);
        }
    }

    protected void setAttribute(Element element, String attributeName, Object value) {
        if (value != null) {
            Attribute attrib = new Attribute(attributeName, value.toString());
            element.setAttribute(attrib);
        }
    }

    protected void setAttribute(Element element, String attributeName, boolean value) {
        String strValue = value ? TRUE_VALUE : FALSE_VALUE;
        Attribute attrib = new Attribute(attributeName, strValue);
        element.setAttribute(attrib);
    }

    protected void setAttribute(Element element, String attributeName, int value) {
        String strValue = Integer.toString(value);
        Attribute attrib = new Attribute(attributeName, strValue);
        element.setAttribute(attrib);
    }

    public Document createDocument() {
        Element ddlElement = new Element("ddl");
        Document doc = new Document(ddlElement);
        Date now = new Date(System.currentTimeMillis());
        this.setAttribute(ddlElement, "generateInfoComments", this.options.isGenerateInfoComments());
        this.setAttribute(ddlElement, "generateTableComments", this.options.isGenerateTableComments());
        this.setAttribute(ddlElement, "generateColumnComments", this.options.isGenerateColumnComments());
        this.setAttribute(ddlElement, "generateDrops", this.options.isGenerateDropStatements());
        this.setAttribute(ddlElement, "exportTool", this.exporterTool);
        this.setAttribute(ddlElement, "exportToolVersion", this.exporterVersion);
        this.setAttribute(ddlElement, "exportDate", DATE_FORMATTER.format(now));
        this.setAttribute(ddlElement, "exportTime", TIME_FORMATTER.format(now));
        RelationalEntityUniquenessEnforcer visitor = new RelationalEntityUniquenessEnforcer();
        ConcurrentModelVisitorProcessor processor = new ConcurrentModelVisitorProcessor((ModelVisitor)visitor);
        for (ModelWrapper wrapper : this.modelWrappers) {
            try {
                processor.walk(wrapper.getEmfResource(), 2);
            }
            catch (ModelerCoreException modelerCoreException) {}
            this.create(ddlElement, wrapper);
        }
        return doc;
    }

    protected void create(Element parent, ModelWrapper wrapper) {
        Resource emfResource = wrapper.getEmfResource();
        ModelAnnotation modelAnnotation = wrapper.getContents().getModelAnnotation();
        ModelType modelTypeEnum = modelAnnotation.getModelType();
        ModelType.Type type = ModelType.Type.getType((int)modelTypeEnum.getValue());
        String modelType = null;
        switch (type) {
            case PHYSICAL: 
            case VIRTUAL: 
            case UNKNOWN: {
                modelType = type.getCamelCaseName();
                break;
            }
            default: {
                modelType = modelTypeEnum.getName();
            }
        }
        String primaryMetamodelUri = modelAnnotation.getPrimaryMetamodelUri();
        MetamodelDescriptor mmDesc = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(primaryMetamodelUri);
        String primaryMetamodel = mmDesc != null ? mmDesc.getName() : primaryMetamodelUri;
        Element modelElement = new Element("model");
        parent.addContent((Content)modelElement);
        this.setAttribute(modelElement, "name", wrapper.getModelName());
        this.setAttribute(modelElement, "uuid", this.getModelEditor().getObjectID((EObject)modelAnnotation));
        this.setAttribute(modelElement, "modelFilename", wrapper.getModelFilename());
        if (modelType != null) {
            this.setAttribute(modelElement, "modelType", modelType);
        }
        this.setAttribute(modelElement, "metaModel", primaryMetamodel);
        this.setAttribute(modelElement, "metaModelURL", primaryMetamodelUri);
        for (EObject eObj : emfResource.getContents()) {
            this.create(modelElement, eObj, wrapper);
        }
    }

    protected void create(Element parent, EObject eObj, ModelWrapper wrapper) {
        if (eObj instanceof Catalog) {
            this.create(parent, (Catalog)eObj, wrapper);
        } else if (eObj instanceof Schema) {
            this.create(parent, (Schema)eObj, wrapper);
        } else if (eObj instanceof Table) {
            this.create(parent, (Table)eObj, wrapper);
        } else if (eObj instanceof Index) {
            this.create(parent, (Index)eObj, wrapper);
        } else if (eObj instanceof Column) {
            this.create(parent, (Column)eObj, wrapper);
        } else if (eObj instanceof ForeignKey) {
            this.create(parent, (ForeignKey)eObj, wrapper);
        } else if (eObj instanceof PrimaryKey) {
            this.create(parent, (PrimaryKey)eObj, wrapper);
        } else if (eObj instanceof UniqueKey) {
            this.create(parent, (UniqueKey)eObj, wrapper);
        }
    }

    protected void create(Element parent, Catalog catalog, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)catalog);
        if (!wrapper.isSelected((EObject)catalog)) {
            return;
        }
        for (EObject eobj : catalog.eContents()) {
            this.create(parent, eobj, wrapper);
        }
    }

    protected void create(Element parent, Schema schema, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)schema);
        if (!wrapper.isSelected((EObject)schema)) {
            return;
        }
        Element parentOfNewElements = parent;
        if (this.options.isGenerateSchema()) {
            Element schemaElement = new Element("schema");
            parent.addContent((Content)schemaElement);
            this.setAttribute(schemaElement, "name", this.getObjectNameInDdl((RelationalEntity)schema));
            this.setAttribute(schemaElement, "uuid", this.editor.getObjectID((EObject)schema));
            this.setAttribute(schemaElement, "pathInModel", this.editor.getModelRelativePath((EObject)schema));
            parentOfNewElements = schemaElement;
        }
        for (EObject eobj : schema.eContents()) {
            this.create(parentOfNewElements, eobj, wrapper);
        }
    }

    protected void create(Element parent, Table table, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)table);
        if (!wrapper.isSelected((EObject)table)) {
            return;
        }
        Element tableElement = new Element("table");
        parent.addContent((Content)tableElement);
        this.setAttribute(tableElement, "name", this.getObjectNameInDdl((RelationalEntity)table));
        this.setAttribute(tableElement, "uuid", this.editor.getObjectID((EObject)table));
        this.setAttribute(tableElement, "pathInModel", this.editor.getModelRelativePath((EObject)table));
        Annotation annotation = wrapper.getContents().getAnnotation((EObject)table);
        if (annotation != null) {
            this.setAttribute(tableElement, "description", annotation.getDescription());
        }
        for (EObject eobj : table.getColumns()) {
            this.create(tableElement, eobj, wrapper);
        }
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            PrimaryKey pk = baseTable.getPrimaryKey();
            if (pk != null) {
                this.create(parent, pk, wrapper);
            }
            for (EObject fkey : baseTable.getForeignKeys()) {
                this.create(parent, fkey, wrapper);
            }
            for (EObject ukey : baseTable.getUniqueConstraints()) {
                this.create(parent, ukey, wrapper);
            }
        }
    }

    protected void create(Element parent, Column column, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)column);
        Element columnElement = new Element("column");
        parent.addContent((Content)columnElement);
        this.setAttribute(columnElement, "name", this.getObjectNameInDdl((RelationalEntity)column));
        this.setAttribute(columnElement, "uuid", this.editor.getObjectID((EObject)column));
        Annotation annotation = wrapper.getContents().getAnnotation((EObject)column);
        if (annotation != null) {
            this.setAttribute(columnElement, "description", annotation.getDescription());
        }
        this.setAttribute(columnElement, "type", this.getType(column));
        int precision = column.getPrecision();
        int scale = column.getScale();
        int length = column.getLength();
        if (precision != 0) {
            this.setAttribute(columnElement, "precision", precision);
        }
        if (length != 0) {
            this.setAttribute(columnElement, "length", length);
        }
        if (scale != 0) {
            this.setAttribute(columnElement, "scale", scale);
        }
        this.setAttribute(columnElement, "isLengthFixed", column.isFixedLength());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null && defaultValue.trim().length() != 0) {
            this.setAttribute(columnElement, "initialValue", defaultValue);
        }
        boolean isNullable = column.getNullable() != null && NullableType.NULLABLE_LITERAL.equals(column.getNullable());
        this.setAttribute(columnElement, "isNullable", isNullable);
        this.setAttribute(columnElement, "supportsSelect", column.isSelectable());
        this.setAttribute(columnElement, "supportsUpdate", column.isUpdateable());
        this.setAttribute(columnElement, "isCaseSensitive", column.isCaseSensitive());
        this.setAttribute(columnElement, "isSigned", column.isSigned());
        this.setAttribute(columnElement, "isCurrency", column.isCurrency());
        this.setAttribute(columnElement, "isAutoIncremented", column.isAutoIncremented());
        SearchabilityType searchType = column.getSearchability();
        this.setAttribute(columnElement, "searchType", null);
    }

    protected String getType(Column column) {
        String nativeType = column.getNativeType();
        if (nativeType != null && this.options.isNativeTypeUsed()) {
            return nativeType;
        }
        EObject dt = column.getType();
        if (dt != null) {
            return this.getType(column, dt);
        }
        return null;
    }

    protected String getType(Column column, EObject datatype) {
        DatatypeManager dtManager = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
        String runtimeType = dtManager.getRuntimeTypeName(datatype);
        if (runtimeType != null) {
            return runtimeType;
        }
        EObject builtin = datatype;
        while (builtin != null) {
            if ((builtin = dtManager.getBaseType(builtin)) == null) break;
            String builtinRuntimeType = dtManager.getRuntimeTypeName(builtin);
            if (builtinRuntimeType == null) continue;
            return builtinRuntimeType;
        }
        return dtManager.getName(datatype);
    }

    protected void create(Element parent, PrimaryKey pkey, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)pkey);
        Element pkElement = new Element("primaryKey");
        parent.addContent((Content)pkElement);
        this.setAttribute(pkElement, "name", this.getUniqueObjectName((RelationalEntity)pkey));
        this.setAttribute(pkElement, "uuid", this.editor.getObjectID((EObject)pkey));
        this.setAttribute(pkElement, "pathInModel", this.editor.getModelRelativePath((EObject)pkey));
        BaseTable pkTable = pkey.getTable();
        if (pkTable != null) {
            this.setAttribute(pkElement, "tableName", this.getObjectNameInDdl((RelationalEntity)pkTable));
        }
        EList columns = pkey.getColumns();
        for (Column column : columns) {
            Element pkColumnElement = new Element("column");
            this.setAttribute(pkColumnElement, "name", this.getObjectNameInDdl((RelationalEntity)column));
            this.setAttribute(pkColumnElement, "uuid", this.editor.getObjectID((EObject)column));
            pkElement.addContent((Content)pkColumnElement);
        }
    }

    protected void create(Element parent, UniqueKey ukey, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)ukey);
        Element pkElement = new Element("uniqueKey");
        parent.addContent((Content)pkElement);
        this.setAttribute(pkElement, "name", this.getUniqueObjectName((RelationalEntity)ukey));
        this.setAttribute(pkElement, "uuid", this.editor.getObjectID((EObject)ukey));
        this.setAttribute(pkElement, "pathInModel", this.editor.getModelRelativePath((EObject)ukey));
        BaseTable ukTable = ukey.getTable();
        if (ukTable != null) {
            this.setAttribute(pkElement, "tableName", this.getObjectNameInDdl((RelationalEntity)ukTable));
        }
        EList columns = ukey.getColumns();
        for (Column column : columns) {
            Element pkColumnElement = new Element("column");
            this.setAttribute(pkColumnElement, "name", this.getObjectNameInDdl((RelationalEntity)column));
            this.setAttribute(pkColumnElement, "uuid", this.editor.getObjectID((EObject)column));
            pkElement.addContent((Content)pkColumnElement);
        }
    }

    protected void create(Element parent, ForeignKey fkey, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)fkey);
        Element fkElement = new Element("foreignKey");
        parent.addContent((Content)fkElement);
        this.setAttribute(fkElement, "name", this.getUniqueObjectName((RelationalEntity)fkey));
        this.setAttribute(fkElement, "uuid", this.editor.getObjectID((EObject)fkey));
        this.setAttribute(fkElement, "pathInModel", this.editor.getModelRelativePath((EObject)fkey));
        BaseTable fkTable = fkey.getTable();
        if (fkTable != null) {
            this.setAttribute(fkElement, "tableName", this.getObjectNameInDdl((RelationalEntity)fkTable));
        }
        UniqueKey ukey = fkey.getUniqueKey();
        EList pkColumns = null;
        if (ukey != null) {
            BaseTable ukeyTable = ukey.getTable();
            if (ukeyTable != null) {
                this.setAttribute(fkElement, "pkTableName", this.getObjectNameInDdl((RelationalEntity)ukeyTable));
            }
            pkColumns = ukey.getColumns();
        }
        EList columns = fkey.getColumns();
        int index = 0;
        for (Column column : columns) {
            Element fkColumnElement = new Element("column");
            this.setAttribute(fkColumnElement, "name", this.getObjectNameInDdl((RelationalEntity)column));
            this.setAttribute(fkColumnElement, "uuid", this.editor.getObjectID((EObject)column));
            if (pkColumns != null && pkColumns.size() > index) {
                Column pkColumn = (Column)pkColumns.get(index);
                this.setAttribute(fkColumnElement, "pkColumnName", this.getObjectNameInDdl((RelationalEntity)pkColumn));
            }
            fkElement.addContent((Content)fkColumnElement);
            ++index;
        }
    }

    protected void create(Element parent, Index index, ModelWrapper wrapper) {
        CoreArgCheck.isNotNull((Object)parent);
        CoreArgCheck.isNotNull((Object)index);
        if (!wrapper.isSelected((EObject)index)) {
            return;
        }
        Element indexElement = new Element("index");
        parent.addContent((Content)indexElement);
        this.setAttribute(indexElement, "name", this.getUniqueObjectName((RelationalEntity)index));
        this.setAttribute(indexElement, "uuid", this.editor.getObjectID((EObject)index));
        this.setAttribute(indexElement, "pathInModel", this.editor.getModelRelativePath((EObject)index));
        EList columns = index.getColumns();
        Element indexColumnElement = new Element("indexColumn");
        indexElement.addContent((Content)indexColumnElement);
        Table indexedTable = null;
        for (Column column : columns) {
            Element indexedColumnElement = new Element("column");
            this.setAttribute(indexedColumnElement, "name", this.getObjectNameInDdl((RelationalEntity)column));
            this.setAttribute(indexedColumnElement, "uuid", this.editor.getObjectID((EObject)column));
            indexColumnElement.addContent((Content)indexedColumnElement);
            indexedTable = (Table)column.getOwner();
        }
        if (indexedTable != null) {
            this.setAttribute(indexElement, "tableName", this.getObjectNameInDdl((RelationalEntity)indexedTable));
        }
    }

    protected String getObjectNameInDdl(RelationalEntity entity) {
        if (this.options.isNameInSourceUsed()) {
            String name = entity.getNameInSource();
            if (name == null || name.trim().length() == 0) {
                name = entity.getName();
            }
            return name;
        }
        return entity.getName();
    }

    protected String getUniqueObjectName(RelationalEntity entity) {
        if (this.options.isUniqueNamesEnforced()) {
            Object name = this.relationalEntities.get(entity);
            if (name == null) {
                DdlPlugin.Util.log(2, DdlPlugin.Util.getString("IntermediateFormat.0", (Object)entity));
                return this.getObjectNameInDdl(entity);
            }
            name = this.getRealName((String)name);
            return (String)name;
        }
        return this.getObjectNameInDdl(entity);
    }

    private String getRealName(String value) {
        if (value.indexOf(34) == 0) {
            int lastQuoteIndex = value.lastIndexOf(34);
            return value.substring(0, lastQuoteIndex + 1);
        }
        return value;
    }

    public class RelationalEntityUniquenessEnforcer
    implements ModelVisitor {
        private final Set primaryKeys = new HashSet();
        private final Set foreignKeys = new HashSet();
        private final Set uniqueKeys = new HashSet();
        private final Set indexes = new HashSet();

        public boolean visit(EObject object) {
            if (object instanceof Catalog || object instanceof Schema || object instanceof Table) {
                return true;
            }
            if (object instanceof PrimaryKey) {
                this.found((RelationalEntity)((PrimaryKey)object), this.primaryKeys);
            } else if (object instanceof ForeignKey) {
                this.found((RelationalEntity)((ForeignKey)object), this.foreignKeys);
            } else if (object instanceof UniqueKey) {
                this.found((RelationalEntity)((UniqueKey)object), this.uniqueKeys);
            } else if (object instanceof Index) {
                this.found((RelationalEntity)((Index)object), this.indexes);
            }
            return false;
        }

        public boolean visit(Resource resource) {
            return true;
        }

        protected void found(RelationalEntity entity, Set uniqueEntities) {
            String name = IntermediateFormat.this.getObjectNameInDdl(entity);
            if (uniqueEntities.contains(name)) {
                boolean isNameUnique = false;
                int index = 1;
                while (!isNameUnique) {
                    String newName = String.valueOf(name) + String.valueOf(index);
                    if (!uniqueEntities.contains(newName)) {
                        name = newName;
                        break;
                    }
                    ++index;
                }
            }
            uniqueEntities.add(name);
            IntermediateFormat.this.relationalEntities.put(entity, name);
        }
    }

    public static class Xml {

        public static class Column {
            public static final String TAG = "column";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String ALIAS = "alias";
                public static final String UUID = "uuid";
                public static final String DESCRIPTION = "description";
                public static final String PATH_IN_MODEL = "pathInModel";
                public static final String TYPE = "type";
                public static final String DEFAULT_VALUE = "initialValue";
                public static final String LENGTH = "length";
                public static final String PRECISION = "precision";
                public static final String SCALE = "scale";
                public static final String IS_FIXED_LENGTH = "isLengthFixed";
                public static final String IS_NULLABLE = "isNullable";
                public static final String SUPPORTS_SELECT = "supportsSelect";
                public static final String SUPPORTS_UPDATE = "supportsUpdate";
                public static final String IS_CASE_SENSITIVE = "isCaseSensitive";
                public static final String IS_SIGNED = "isSigned";
                public static final String IS_CURRENCY = "isCurrency";
                public static final String IS_AUTOINCREMENTED = "isAutoIncremented";
                public static final String SEARCH_TYPE = "searchType";
            }
        }

        public static class Comment {
            public static final String TAG = "comment";
        }

        public static class DDL {
            public static final String TAG = "ddl";
        }

        public static class ForeignKey {
            public static final String TAG = "foreignKey";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String TABLE_NAME = "tableName";
                public static final String PK_TABLE_NAME = "pkTableName";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class ForignKeyColumn {
            public static final String TAG = "column";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String PK_COLUMN_NAME = "pkColumnName";
            }
        }

        public static class Index {
            public static final String TAG = "index";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String TABLE_NAME = "tableName";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class IndexColumn {
            public static final String TAG = "column";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
            }
        }

        public static class IndexColumns {
            public static final String TAG = "indexColumn";
        }

        public static class Model {
            public static final String TAG = "model";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String GENERATE_INFO_COMMENTS = "generateInfoComments";
                public static final String GENERATE_TABLE_COMMENTS = "generateTableComments";
                public static final String GENERATE_COLUMN_COMMENTS = "generateColumnComments";
                public static final String GENERATE_DROPS = "generateDrops";
                public static final String EXPORT_TOOL = "exportTool";
                public static final String EXPORT_VERSION = "exportToolVersion";
                public static final String EXPORT_DATE = "exportDate";
                public static final String EXPORT_TIME = "exportTime";
                public static final String MODEL_FILENAME = "modelFilename";
                public static final String MODEL_TYPE = "modelType";
                public static final String METAMODEL = "metaModel";
                public static final String METAMODEL_URL = "metaModelURL";
            }
        }

        public static class PrimaryKey {
            public static final String TAG = "primaryKey";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String TABLE_NAME = "tableName";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class PrimaryKeyColumn {
            public static final String TAG = "column";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
            }
        }

        public static class Schema {
            public static final String TAG = "schema";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class Table {
            public static final String TAG = "table";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String DESCRIPTION = "description";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class UniqueKey {
            public static final String TAG = "uniqueKey";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
                public static final String TABLE_NAME = "tableName";
                public static final String PATH_IN_MODEL = "pathInModel";
            }
        }

        public static class UniqueKeyColumn {
            public static final String TAG = "column";

            public static class Attributes {
                public static final String NAME = "name";
                public static final String UUID = "uuid";
            }
        }
    }
}

