/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.jboss.tools.modeshape.ui.actions.DisabledAction;

public class CndEditorActionBarContributor
extends EditorActionBarContributor {
    private final StatusField childNodeStatus;
    private final StatusField nodeTypeStatus;
    private final StatusField propertyStatus;
    private final StatusField readOnlyStatus = new StatusField(10, null, null);

    public CndEditorActionBarContributor() {
        this.nodeTypeStatus = new StatusField(-1, null, CndMessages.statusBarNodeTypeToolTip);
        this.propertyStatus = new StatusField(-1, null, CndMessages.statusBarPropertyToolTip);
        this.childNodeStatus = new StatusField(-1, null, CndMessages.statusBarChildNodeToolTip);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        statusLineManager.add((IContributionItem)this.readOnlyStatus);
        statusLineManager.add((IContributionItem)this.nodeTypeStatus);
        statusLineManager.add((IContributionItem)this.propertyStatus);
        statusLineManager.add((IContributionItem)this.childNodeStatus);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)DisabledAction.get());
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)DisabledAction.get());
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)DisabledAction.get());
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)DisabledAction.get());
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)DisabledAction.get());
        }
    }

    public void setChildNode(ChildNodeDefinition selectedChildNode) {
        this.childNodeStatus.setMessage(selectedChildNode == null ? null : selectedChildNode.getName());
        this.getActionBars().getStatusLineManager().update(true);
    }

    public void setChildNodeStatusDoubleClickAction(IAction newDoubleClickAction) {
        this.childNodeStatus.setDoubleClickAction(newDoubleClickAction);
    }

    public void setChildNodeStatusMenuManager(MenuManager newMenuManager) {
        this.childNodeStatus.setMenuManager(newMenuManager);
    }

    public void setEditableStatus(boolean newEditableState) {
        String newMessage = newEditableState ? "Writable" : "Read-Only";
        this.readOnlyStatus.setMessage(newMessage);
        this.getActionBars().getStatusLineManager().update(true);
    }

    public void setNodeType(NodeTypeDefinition selectedNodeType) {
        this.nodeTypeStatus.setMessage(selectedNodeType == null ? null : selectedNodeType.getName());
        this.getActionBars().getStatusLineManager().update(true);
    }

    public void setNodeTypeStatusDoubleClickAction(IAction newDoubleClickAction) {
        this.nodeTypeStatus.setDoubleClickAction(newDoubleClickAction);
    }

    public void setNodeTypeStatusMenuManager(MenuManager newMenuManager) {
        this.nodeTypeStatus.setMenuManager(newMenuManager);
    }

    public void setProperty(PropertyDefinition selectedProperty) {
        this.propertyStatus.setMessage(selectedProperty == null ? null : selectedProperty.getName());
        this.getActionBars().getStatusLineManager().update(true);
    }

    public void setPropertyStatusDoubleClickAction(IAction newDoubleClickAction) {
        this.propertyStatus.setDoubleClickAction(newDoubleClickAction);
    }

    public void setPropertyStatusMenuManager(MenuManager newMenuManager) {
        this.propertyStatus.setMenuManager(newMenuManager);
    }

    public void setReadOnlyStatusMenuManager(MenuManager newMenuManager) {
        this.readOnlyStatus.setMenuManager(newMenuManager);
    }

    static class StatusField
    extends ContributionItem {
        private static final int DEFAULT_WIDTH = 25;
        private IAction doubleClickAction;
        private CLabel label;
        private MenuManager menuManager;
        private String message;
        private final String toolTip;
        private final int widthInChars;

        StatusField(int widthInChars, String message, String toolTip) {
            this.widthInChars = widthInChars < 1 ? 25 : widthInChars;
            this.message = message;
            this.toolTip = toolTip;
        }

        public void fill(Composite parent) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            Label sep = new Label(parent, 2);
            sep.setLayoutData((Object)new StatusLineLayoutData());
            ((StatusLineLayoutData)sep.getLayoutData()).heightHint = gc.getFontMetrics().getHeight();
            this.label = new CLabel(parent, 32);
            this.label.setLayoutData((Object)new StatusLineLayoutData());
            ((StatusLineLayoutData)this.label.getLayoutData()).widthHint = gc.getFontMetrics().getAverageCharWidth() * this.widthInChars;
            gc.dispose();
            if (this.menuManager != null) {
                MenuManager mm = new MenuManager();
                IContributionItem[] iContributionItemArray = this.menuManager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    mm.add(item);
                    ++n2;
                }
                this.label.setMenu(mm.createContextMenu((Control)this.label));
            }
            if (this.doubleClickAction != null) {
                final CLabel accessLabel = this.label;
                this.label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        if (!CndMessages.statusBarNoSelection.equals(accessLabel.getText())) {
                            StatusField.this.handleDoubleClick();
                        }
                    }
                });
            }
            this.updateLabel();
        }

        void handleDoubleClick() {
            assert (this.doubleClickAction != null) : "double click action is null and action handler was called";
            this.doubleClickAction.run();
        }

        void setDoubleClickAction(IAction doubleClickAction) {
            this.doubleClickAction = doubleClickAction;
        }

        void setMenuManager(MenuManager newMenuManager) {
            this.menuManager = newMenuManager;
        }

        void setMessage(String newMessage) {
            this.message = newMessage;
            this.updateLabel();
        }

        private void updateLabel() {
            if (this.label != null && !this.label.isDisposed()) {
                String newToolTip;
                String newText;
                String string = newText = UiUtils.isEmpty((String)this.message) ? CndMessages.statusBarNoSelection : this.message;
                if (!newText.equals(this.label.getText())) {
                    this.label.setText(newText);
                }
                if (!(newToolTip = UiUtils.ensureNotNull((String)this.toolTip)).equals(this.label.getToolTipText())) {
                    this.label.setToolTipText(newToolTip);
                }
            }
        }
    }
}

