/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataTypeFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataTypeRegistry;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDException;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinition;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinitionImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class WIDHandler {
    public static void evaluateWorkDefinitions(Map<String, WorkItemDefinition> widDefinitions, IFile file) throws WIDException {
        String content = WIDHandler.getFile(file);
        WIDHandler.processWorkDefinitionsContent(widDefinitions, content);
        for (WorkItemDefinitionImpl workItemDefinitionImpl : widDefinitions.values()) {
            workItemDefinitionImpl.setDefinitionFile(file);
        }
    }

    public static void evaluateWorkDefinitions(Map<String, WorkItemDefinition> widDefinitions, String content) throws WIDException {
        WIDHandler.processWorkDefinitionsContent(widDefinitions, content);
    }

    private static String getFile(IFile resource) {
        String filepath = null;
        if (resource != null) {
            IPath path = resource.getLocation().makeAbsolute();
            filepath = path.toOSString();
        }
        StringBuilder text = new StringBuilder();
        String NL = System.getProperty("line.separator");
        Scanner scanner = null;
        try {
            scanner = new Scanner((InputStream)new FileInputStream(filepath), "UTF-8");
            while (scanner.hasNextLine()) {
                text.append(String.valueOf(scanner.nextLine()) + NL);
            }
            String string = text.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return null;
    }

    private static void processWorkDefinitionsContent(Map<String, WorkItemDefinition> widDefinitions, String content) throws WIDException {
        if (content == null) {
            WIDException widException = new WIDException("No data passed to WIDHandler.processWorkDefinitionsContent method");
            throw widException;
        }
        if (widDefinitions != null) {
            widDefinitions.clear();
        }
        String[] strings = content.split("[\n]+");
        int openBrackets = 0;
        WorkItemDefinitionImpl currentWid = new WorkItemDefinitionImpl();
        Section current = Section.PARAMETERS;
        int i = 0;
        while (i < strings.length) {
            String trim = strings[i].trim();
            if (trim.length() != 0) {
                String name;
                String[] nameValue;
                if (trim.startsWith("[") || trim.endsWith("[") || trim.endsWith(":")) {
                    if (trim.endsWith(":") && i < strings.length - 1) {
                        trim = String.valueOf(strings[i].trim()) + strings[i + 1].trim();
                    } else {
                        ++openBrackets;
                    }
                    nameValue = trim.split("[:]+");
                    if (nameValue.length == 2) {
                        name = nameValue[0].replace('\"', ' ').trim();
                        if (name.equalsIgnoreCase("parameters")) {
                            current = Section.PARAMETERS;
                        } else if (name.equalsIgnoreCase("results")) {
                            current = Section.RESULTS;
                        } else if (name.equalsIgnoreCase("dependencies")) {
                            current = Section.DEPENDENCIES;
                        }
                    }
                }
                if ((trim.startsWith("]") || trim.endsWith("]")) && --openBrackets == 1) {
                    if (currentWid != null && currentWid.getName() != null) {
                        widDefinitions.put(currentWid.getName(), currentWid);
                    }
                    currentWid = new WorkItemDefinitionImpl();
                }
                if (trim.contains(":") && ((nameValue = trim.split("[:]+")).length == 2 || nameValue.length == 3)) {
                    name = nameValue[0].replace('\"', ' ').trim();
                    int valueIndex = 1;
                    if (nameValue.length == 3) {
                        valueIndex = 2;
                        name = String.valueOf(name) + ':' + nameValue[1].replace('\"', ' ').trim();
                    }
                    String value = nameValue[valueIndex].replace('\"', ' ').replace(',', ' ').replace('[', ' ').trim();
                    if (openBrackets == 2 && value.trim().length() > 0) {
                        if (name.equalsIgnoreCase("name")) {
                            currentWid.setName(value);
                        } else if (name.equalsIgnoreCase("displayName")) {
                            currentWid.setDispalyName(value);
                        } else if (name.equalsIgnoreCase("description")) {
                            currentWid.setDescription(value);
                        } else if (name.equalsIgnoreCase("category")) {
                            currentWid.setCategory(value);
                        } else if (name.equalsIgnoreCase("icon")) {
                            currentWid.setIcon(value);
                        } else if (name.equalsIgnoreCase("customEditor")) {
                            currentWid.setCustomEditor(value);
                        } else if (name.equalsIgnoreCase("eclipse:customEditor")) {
                            currentWid.setEclipseCustomEditor(value);
                        }
                    } else if (openBrackets == 3 && value.trim().length() > 0) {
                        int index;
                        DataTypeFactory dtf;
                        if (value.startsWith("new") && value.indexOf("(") > 0 && (dtf = DataTypeRegistry.getFactory(value = value.substring(3, index = value.indexOf("(")).trim())) != null) {
                            DataType dt = dtf.createDataType();
                            value = dt.getStringType();
                        }
                        if (current == Section.PARAMETERS) {
                            currentWid.getParameters().put(name, value);
                        } else if (current == Section.RESULTS) {
                            currentWid.getResults().put(name, value);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static enum Section {
        PARAMETERS,
        RESULTS,
        DEPENDENCIES;

    }
}

